<?php if (!defined('OT_VERSION')) exit('No direct script access allowed');
/**
 * Input Option
 *
 * @access public
 * @since 1.0.0
 *
 * @param array $value
 * @param array $settings
 * @param int $int
 *
 * @return string
 */
function option_tree_input( $value, $settings, $int ) 
{ 
?>
  <div class="option option-input" id="<?php echo $value->item_id; ?>_div">
    <div class="lambda-opttitle">
        <div class="lambda-opttitle-pad">
		<?php echo htmlspecialchars_decode( $value->item_title ); ?>
		<span class="infoButton right">
				<img class="infoImage" src="<?php echo OT_PLUGIN_URL; ?>/assets/images/info.png" width="40px" height="20px" alt="Info" style="left: 0px;">
		</span>  
        </div>
    </div>   <div class="section">
      <div class="element">
        <input type="text" name="<?php echo $value->item_id; ?>" id="<?php echo $value->item_id; ?>" value="<?php if ( isset($settings[$value->item_id]) ) { echo htmlspecialchars( stripslashes( $settings[$value->item_id] ), ENT_QUOTES); } ?>" />
      </div> <?php if($value->item_desc) { ?>
      <div class="desc alert alert-neutral"><?php echo htmlspecialchars_decode( $value->item_desc ); ?></div>
	  <div class="clear"></div>
      <?php } ?>
    </div>
  </div>
<?php
}