DROP TABLE IF EXISTS `ahm_files`;

CREATE TABLE `ahm_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `category` text NOT NULL,
  `file` varchar(255) NOT NULL,
  `password` varchar(40) NOT NULL,
  `download_count` int(11) NOT NULL,
  `access` enum('guest','member') CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `show_counter` tinyint(1) NOT NULL,
  `quota` int(11) NOT NULL,
  `link_label` varchar(255) NOT NULL,
  `icon` varchar(256) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `ahm_files` VALUES("1","Visual Effects Resume","","N;","resume_v09_01.pdf","","2","guest","0","0","Download","file_extension_pdf.png");


DROP TABLE IF EXISTS `ts968ny_3_commentmeta`;

CREATE TABLE `ts968ny_3_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_comments`;

CREATE TABLE `ts968ny_3_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_comments` VALUES("1","1","Mr WordPress","","http://rubensteinarchitects.com/","","2013-01-04 22:34:52","2013-01-04 22:34:52","Hi, this is a comment.
To delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("2","93","yasduyyu","uyuyguygu@ojiaede.er","","109.104.187.198","2011-03-09 09:36:21","2011-03-09 09:36:21","ldkkjee","0","post-trashed","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("3","237","pipe","felipeg9006@gmail.com","","186.86.248.171","2011-11-01 02:26:42","2011-11-01 02:26:42","jola","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("4","237","armando","armando@gmail.com","","186.144.2.3","2011-11-05 21:22:40","2011-11-05 21:22:40","afdfsdfsadf fuck","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("5","237","feilipe","asfaf@hotmail.com","","186.146.129.212","2011-12-07 16:25:37","2011-12-07 16:25:37","afsfasdf","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("6","250","admin","office@kriesi.at","","127.0.0.1","2011-03-29 11:33:49","2011-03-29 11:33:49","asdfsadf","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("7","250","admin","office@kriesi.at","","127.0.0.1","2011-03-29 11:33:58","2011-03-29 11:33:58","Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("8","250","Mustisusti","max@asdfsdafsdf.de","","127.0.0.1","2011-03-29 11:34:02","2011-03-29 11:34:02","Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("9","250","John Do","johndo@gmail.com","http://www.johndo.com","85.110.186.110","2011-10-31 13:39:17","2011-10-31 13:39:17","Ve bu da cevap denemesi oluyor, bakalım nasıl görünecek.
Deneme bir ki üç...","0","0","","","6","0");
INSERT INTO `ts968ny_3_comments` VALUES("10","250","Stefan","windbrecher@gmx.de","","92.200.69.126","2011-11-27 11:45:27","2011-11-27 11:45:27","Test for a nested comment","0","0","","","7","0");
INSERT INTO `ts968ny_3_comments` VALUES("11","252","admin","office@kriesi.at","","127.0.0.1","2011-03-29 11:32:32","2011-03-29 11:32:32","This is a comment","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("12","252","appiano","appiano@gentile.com","http://www.iner.com","112.119.194.228","2011-11-29 03:52:46","2011-11-29 03:52:46","This template is amazing","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("13","252","Alex","sd@mail.ru","http://plugins.jquery.com","78.111.27.82","2012-05-21 19:34:30","2012-05-21 19:34:30","Test","0","0","","","11","0");
INSERT INTO `ts968ny_3_comments` VALUES("14","254","admin","office@kriesi.at","","127.0.0.1","2011-03-29 11:33:21","2011-03-29 11:33:21","Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("15","254","Marcus","office@asdsadeaede.de","","127.0.0.1","2011-03-29 12:02:54","2011-03-29 12:02:54","Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ri","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("16","254","admin","office@kriesi.at","","127.0.0.1","2011-03-31 11:49:48","2011-03-31 11:49:48","sadfsdafasdfasdfsa df sad f sdf sadf a sdf","0","1","","","15","0");
INSERT INTO `ts968ny_3_comments` VALUES("17","254","admin","office@kriesi.at","","127.0.0.1","2011-03-31 11:50:02","2011-03-31 11:50:02","sadfasdfsdfsdaf sad fsa df sad f sad f sadf sa df sa df sad fs adf sad fsadf","0","1","","","16","0");
INSERT INTO `ts968ny_3_comments` VALUES("18","254","admin","office@kriesi.at","","127.0.0.1","2011-03-31 11:53:27","2011-03-31 11:53:27","asdfsadfsadfsa","0","1","","","17","0");
INSERT INTO `ts968ny_3_comments` VALUES("19","254","admin","office@kriesi.at","","127.0.0.1","2011-03-31 11:53:32","2011-03-31 11:53:32","asdfsadfsadf","0","1","","","18","0");
INSERT INTO `ts968ny_3_comments` VALUES("20","254","admin","office@kriesi.at","","127.0.0.1","2011-03-31 11:53:52","2011-03-31 11:53:52","sdfasfsadfsadf","0","1","","","16","0");
INSERT INTO `ts968ny_3_comments` VALUES("21","254","Kriesi","office@kriesi.at","http://dfgsdfg","127.0.0.1","2011-03-31 12:08:52","2011-03-31 12:08:52","sfdgsgfdgdsg","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("22","254","Kriesi","office@kriesi.at","http://dfgsdfg","127.0.0.1","2011-03-31 12:09:08","2011-03-31 12:09:08","asdfasdf asdfkhljsdahfl askjdfhas dfjlhjasdhlfkashd hasldfjkash dfhjkasdf hsadfha sdjfhjksad fhasdbfjasdf","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("23","254","Kriesi","office@kriesi.at","http://dfgsdfg","127.0.0.1","2011-03-31 12:09:24","2011-03-31 12:09:24","sdfasdkjfsdahf sadjklf hasdjfk hsadfhsal dfjkasdhf kasjdfh askjdf lhsdafk ksadfj jsadfhjsafhk hksdjfsad fsad fasdf sa df sadfj sadf hsdfkasjfh sad f","0","1","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("24","254","fgfdf","sdf@fdfsd.com","http://aaa.com","173.8.106.1","2011-09-14 20:21:58","2011-09-14 20:21:58","supbrahuhanginghardlyleftwisetothetightwisemutahfukeh","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("25","254","Ghf","Fd@gh.lk","http://Fff.nh","75.74.125.127","2011-12-13 16:50:42","2011-12-13 16:50:42","Ttgfggfgg","0","0","","","21","0");
INSERT INTO `ts968ny_3_comments` VALUES("26","282","gokins","goik@rambler.ru","","91.103.25.230","2011-09-13 09:25:54","2011-09-13 09:25:54","Nice , lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.
Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi.","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("27","282","porzyk","ww@wp.pl","","213.238.106.226","2011-09-14 09:47:27","2011-09-14 09:47:27","Witaj","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("28","282","testman","testman@test.com","","78.131.190.212","2011-09-14 20:01:27","2011-09-14 20:01:27","Test comment","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("29","282","Javier","javierojuel@gmail.com","","62.37.83.133","2011-10-24 15:57:23","2011-10-24 15:57:23","Prueba","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("30","282","dfhsd","ana.rodrigues@grupoestado.com.br","http://dfhsad","200.185.30.31","2011-10-31 20:59:53","2011-10-31 20:59:53","fhdfh","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("31","282","test","test@test.de","","82.83.85.191","2011-11-14 23:16:36","2011-11-14 23:16:36","restoisafjphouspha","0","0","","","0","0");
INSERT INTO `ts968ny_3_comments` VALUES("32","282","test","test@do.de","","82.83.85.191","2011-11-14 23:16:52","2011-11-14 23:16:52","sa,khtrjydñ","0","0","","","0","0");


DROP TABLE IF EXISTS `ts968ny_3_links`;

CREATE TABLE `ts968ny_3_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_links_extrainfo`;

CREATE TABLE `ts968ny_3_links_extrainfo` (
  `link_id` bigint(20) NOT NULL DEFAULT '0',
  `link_second_url` varchar(255) CHARACTER SET utf8 DEFAULT NULL,
  `link_telephone` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `link_email` varchar(128) CHARACTER SET utf8 DEFAULT NULL,
  `link_visits` bigint(20) DEFAULT '0',
  `link_reciprocal` varchar(255) DEFAULT NULL,
  `link_submitter` varchar(255) DEFAULT NULL,
  `link_submitter_name` varchar(128) DEFAULT NULL,
  `link_submitter_email` varchar(128) DEFAULT NULL,
  `link_textfield` text,
  `link_no_follow` varchar(1) DEFAULT NULL,
  `link_featured` varchar(1) DEFAULT NULL,
  `link_manual_updated` varchar(1) DEFAULT NULL,
  UNIQUE KEY `link_id` (`link_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS `ts968ny_3_ngg_album`;

CREATE TABLE `ts968ny_3_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `albumdesc` mediumtext,
  `sortorder` longtext NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_ngg_gallery`;

CREATE TABLE `ts968ny_3_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `path` mediumtext,
  `title` mediumtext,
  `galdesc` mediumtext,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `author` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_ngg_pictures`;

CREATE TABLE `ts968ny_3_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT '0',
  `galleryid` bigint(20) NOT NULL DEFAULT '0',
  `filename` varchar(255) NOT NULL,
  `description` mediumtext,
  `alttext` mediumtext,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT '0',
  `sortorder` bigint(20) NOT NULL DEFAULT '0',
  `meta_data` longtext,
  PRIMARY KEY (`pid`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_options`;

CREATE TABLE `ts968ny_3_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=760 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_options` VALUES("1","siteurl","http://rubensteinarchitects.com/choices","yes");
INSERT INTO `ts968ny_3_options` VALUES("2","blogname","RA Choices","yes");
INSERT INTO `ts968ny_3_options` VALUES("3","blogdescription","Just another Rubenstein Architects site","yes");
INSERT INTO `ts968ny_3_options` VALUES("4","users_can_register","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("5","admin_email","neil@rubensteinarchitects.com","yes");
INSERT INTO `ts968ny_3_options` VALUES("6","start_of_week","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("7","use_balanceTags","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("8","use_smilies","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("9","require_name_email","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("10","comments_notify","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("11","posts_per_rss","10","yes");
INSERT INTO `ts968ny_3_options` VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO `ts968ny_3_options` VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO `ts968ny_3_options` VALUES("15","mailserver_pass","password","yes");
INSERT INTO `ts968ny_3_options` VALUES("16","mailserver_port","110","yes");
INSERT INTO `ts968ny_3_options` VALUES("17","default_category","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("18","default_comment_status","open","yes");
INSERT INTO `ts968ny_3_options` VALUES("19","default_ping_status","open","yes");
INSERT INTO `ts968ny_3_options` VALUES("20","default_pingback_flag","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("21","posts_per_page","10","yes");
INSERT INTO `ts968ny_3_options` VALUES("22","date_format","F j, Y","yes");
INSERT INTO `ts968ny_3_options` VALUES("23","time_format","g:i a","yes");
INSERT INTO `ts968ny_3_options` VALUES("24","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO `ts968ny_3_options` VALUES("25","links_recently_updated_prepend","<em>","yes");
INSERT INTO `ts968ny_3_options` VALUES("26","links_recently_updated_append","</em>","yes");
INSERT INTO `ts968ny_3_options` VALUES("27","links_recently_updated_time","120","yes");
INSERT INTO `ts968ny_3_options` VALUES("28","comment_moderation","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("29","moderation_notify","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO `ts968ny_3_options` VALUES("31","gzipcompression","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("32","hack_file","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO `ts968ny_3_options` VALUES("34","moderation_keys","","no");
INSERT INTO `ts968ny_3_options` VALUES("35","active_plugins","a:1:{i:0;s:19:\"bbpress/bbpress.php\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("36","home","http://rubensteinarchitects.com/choices","yes");
INSERT INTO `ts968ny_3_options` VALUES("37","category_base","","yes");
INSERT INTO `ts968ny_3_options` VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `ts968ny_3_options` VALUES("39","advanced_edit","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("40","comment_max_links","2","yes");
INSERT INTO `ts968ny_3_options` VALUES("41","gmt_offset","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("42","default_email_category","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("43","recently_edited","","no");
INSERT INTO `ts968ny_3_options` VALUES("44","template","choices","yes");
INSERT INTO `ts968ny_3_options` VALUES("45","stylesheet","choices","yes");
INSERT INTO `ts968ny_3_options` VALUES("46","comment_whitelist","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("47","blacklist_keys","","no");
INSERT INTO `ts968ny_3_options` VALUES("48","comment_registration","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("49","html_type","text/html","yes");
INSERT INTO `ts968ny_3_options` VALUES("50","use_trackback","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("51","default_role","subscriber","yes");
INSERT INTO `ts968ny_3_options` VALUES("52","db_version","24448","yes");
INSERT INTO `ts968ny_3_options` VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("54","upload_path","","yes");
INSERT INTO `ts968ny_3_options` VALUES("55","blog_public","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("56","default_link_category","2","yes");
INSERT INTO `ts968ny_3_options` VALUES("57","show_on_front","posts","yes");
INSERT INTO `ts968ny_3_options` VALUES("58","tag_base","","yes");
INSERT INTO `ts968ny_3_options` VALUES("59","show_avatars","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("60","avatar_rating","G","yes");
INSERT INTO `ts968ny_3_options` VALUES("61","upload_url_path","","yes");
INSERT INTO `ts968ny_3_options` VALUES("62","thumbnail_size_w","80","yes");
INSERT INTO `ts968ny_3_options` VALUES("63","thumbnail_size_h","80","yes");
INSERT INTO `ts968ny_3_options` VALUES("64","thumbnail_crop","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("65","medium_size_w","300","yes");
INSERT INTO `ts968ny_3_options` VALUES("66","medium_size_h","300","yes");
INSERT INTO `ts968ny_3_options` VALUES("67","avatar_default","mystery","yes");
INSERT INTO `ts968ny_3_options` VALUES("68","large_size_w","1024","yes");
INSERT INTO `ts968ny_3_options` VALUES("69","large_size_h","1024","yes");
INSERT INTO `ts968ny_3_options` VALUES("70","image_default_link_type","file","yes");
INSERT INTO `ts968ny_3_options` VALUES("71","image_default_size","","yes");
INSERT INTO `ts968ny_3_options` VALUES("72","image_default_align","","yes");
INSERT INTO `ts968ny_3_options` VALUES("73","close_comments_for_old_posts","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("74","close_comments_days_old","14","yes");
INSERT INTO `ts968ny_3_options` VALUES("75","thread_comments","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("76","thread_comments_depth","5","yes");
INSERT INTO `ts968ny_3_options` VALUES("77","page_comments","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("78","comments_per_page","50","yes");
INSERT INTO `ts968ny_3_options` VALUES("79","default_comments_page","newest","yes");
INSERT INTO `ts968ny_3_options` VALUES("80","comment_order","asc","yes");
INSERT INTO `ts968ny_3_options` VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("82","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("83","widget_text","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("84","widget_rss","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("85","uninstall_plugins","a:4:{s:27:\"pages-order/pages-order.php\";a:2:{i:0;s:11:\"pages_order\";i:1;s:20:\"uninstall_removedata\";}s:29:\"nextgen-gallery/nggallery.php\";a:2:{i:0;s:9:\"nggLoader\";i:1;s:9:\"uninstall\";}s:27:\"job-manager/job-manager.php\";s:16:\"jobman_uninstall\";s:43:\"email-address-protector/juiz-last-tweet.php\";s:20:\"juiz_ltw_uninstaller\";}","no");
INSERT INTO `ts968ny_3_options` VALUES("86","timezone_string","","yes");
INSERT INTO `ts968ny_3_options` VALUES("87","page_for_posts","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("88","page_on_front","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("89","default_post_format","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("90","link_manager_enabled","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("91","ts968ny_3_user_roles","a:10:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:76:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:24:\"NextGEN Gallery overview\";b:1;s:19:\"NextGEN Use TinyMCE\";b:1;s:21:\"NextGEN Upload images\";b:1;s:22:\"NextGEN Manage gallery\";b:1;s:19:\"NextGEN Manage tags\";b:1;s:29:\"NextGEN Manage others gallery\";b:1;s:18:\"NextGEN Edit album\";b:1;s:20:\"NextGEN Change style\";b:1;s:22:\"NextGEN Change options\";b:1;s:10:\"copy_posts\";b:1;s:18:\"wysija_newsletters\";b:1;s:18:\"wysija_subscribers\";b:1;s:20:\"wysija_subscriwidget\";b:1;s:13:\"wysija_config\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"bbp_keymaster\";a:2:{s:4:\"name\";s:9:\"Keymaster\";s:12:\"capabilities\";a:29:{s:9:\"keep_gate\";b:1;s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:1;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:1;s:13:\"delete_forums\";b:1;s:20:\"delete_others_forums\";b:1;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:13:\"bbp_spectator\";a:2:{s:4:\"name\";s:9:\"Spectator\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:1;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:11:\"bbp_blocked\";a:2:{s:4:\"name\";s:7:\"Blocked\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:0;s:11:\"participate\";b:0;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:0;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:0;s:11:\"edit_topics\";b:0;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:0;s:12:\"edit_replies\";b:0;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:0;}}s:13:\"bbp_moderator\";a:2:{s:4:\"name\";s:9:\"Moderator\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:1;s:8:\"throttle\";b:1;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:1;s:11:\"edit_forums\";b:1;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:1;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:1;s:13:\"delete_topics\";b:1;s:20:\"delete_others_topics\";b:1;s:19:\"read_private_topics\";b:1;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:1;s:14:\"delete_replies\";b:1;s:21:\"delete_others_replies\";b:1;s:20:\"read_private_replies\";b:1;s:17:\"manage_topic_tags\";b:1;s:15:\"edit_topic_tags\";b:1;s:17:\"delete_topic_tags\";b:1;s:17:\"assign_topic_tags\";b:1;}}s:15:\"bbp_participant\";a:2:{s:4:\"name\";s:11:\"Participant\";s:12:\"capabilities\";a:28:{s:8:\"spectate\";b:1;s:11:\"participate\";b:1;s:8:\"moderate\";b:0;s:8:\"throttle\";b:0;s:10:\"view_trash\";b:0;s:14:\"publish_forums\";b:0;s:11:\"edit_forums\";b:0;s:18:\"edit_others_forums\";b:0;s:13:\"delete_forums\";b:0;s:20:\"delete_others_forums\";b:0;s:19:\"read_private_forums\";b:1;s:18:\"read_hidden_forums\";b:0;s:14:\"publish_topics\";b:1;s:11:\"edit_topics\";b:1;s:18:\"edit_others_topics\";b:0;s:13:\"delete_topics\";b:0;s:20:\"delete_others_topics\";b:0;s:19:\"read_private_topics\";b:0;s:15:\"publish_replies\";b:1;s:12:\"edit_replies\";b:1;s:19:\"edit_others_replies\";b:0;s:14:\"delete_replies\";b:0;s:21:\"delete_others_replies\";b:0;s:20:\"read_private_replies\";b:0;s:17:\"manage_topic_tags\";b:0;s:15:\"edit_topic_tags\";b:0;s:17:\"delete_topic_tags\";b:0;s:17:\"assign_topic_tags\";b:1;}}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("92","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("93","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("94","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("95","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("96","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("97","sidebars_widgets","a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;s:9:\"sidebar-7\";N;s:13:\"array_version\";i:3;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("99","WPLANG","","yes");
INSERT INTO `ts968ny_3_options` VALUES("100","cron","a:7:{i:1376145673;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1376174508;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1376179200;a:1:{s:17:\"wysija_cron_queue\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1376188877;a:1:{s:17:\"wysija_cron_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1376192594;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1376231607;a:1:{s:14:\"yoast_tracking\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("101","dashboard_widget_options","a:4:{s:25:\"dashboard_recent_comments\";a:1:{s:5:\"items\";i:5;}s:24:\"dashboard_incoming_links\";a:5:{s:4:\"home\";s:39:\"http://rubensteinarchitects.com/choices\";s:4:\"link\";s:115:\"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://rubensteinarchitects.com/choices/\";s:3:\"url\";s:148:\"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://rubensteinarchitects.com/choices/\";s:5:\"items\";i:10;s:9:\"show_date\";b:0;}s:17:\"dashboard_primary\";a:7:{s:4:\"link\";s:26:\"http://wordpress.org/news/\";s:3:\"url\";s:31:\"http://wordpress.org/news/feed/\";s:5:\"title\";s:14:\"WordPress Blog\";s:5:\"items\";i:2;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;}s:19:\"dashboard_secondary\";a:7:{s:4:\"link\";s:28:\"http://planet.wordpress.org/\";s:3:\"url\";s:33:\"http://planet.wordpress.org/feed/\";s:5:\"title\";s:20:\"Other WordPress News\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:0;}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("121","theme_mods_twentytwelve","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1357339319;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("122","current_theme","Choices","yes");
INSERT INTO `ts968ny_3_options` VALUES("123","theme_mods_builder","a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1357339638;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";N;s:9:\"sidebar-5\";N;s:9:\"sidebar-6\";N;}}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("124","theme_switched","","yes");
INSERT INTO `ts968ny_3_options` VALUES("125","css3_grid_shortcode_settings_Table_t1_s1","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:11:\"style1_best\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_01.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_01.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_01.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_01.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:28:\"10 accounts under one domain\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:4:\"test\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:23:\"Hight priority support!\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("126","css3_grid_shortcode_settings_Table_t1_s2","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"2\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:1:\"1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:12:\"style2_heart\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_02.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_02.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_02.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_02.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:18:\"Your tooltip text!\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:51:\"You can have unlimited bandwidth for $10 surcharge!\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("127","css3_grid_shortcode_settings_Table_t1_s3","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"3\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:1:\"1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:12:\"style1_off30\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_03.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_03.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_03.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_03.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:48:\"Support only in standard and professional plans!\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("128","css3_grid_shortcode_settings_Table_t1_s4","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"4\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_04.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_04.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_04.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_04.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:11:\"Cool price!\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("129","css3_grid_shortcode_settings_Table_t1_s5","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"5\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:3:\"170\";i:1;s:3:\"125\";i:2;s:3:\"150\";i:3;s:3:\"180\";i:4;s:3:\"210\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:10:\"style2_new\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:2:\"55\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:2:\"40\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_05.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_05.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_05.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_05.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("130","css3_grid_shortcode_settings_Table_t1_s6","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"6\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_06.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_06.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_06.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_06.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("131","css3_grid_shortcode_settings_Table_t1_s7","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"7\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:1:\"1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:15:\"style1_top_caps\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_07.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_07.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_07.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_07.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("132","css3_grid_shortcode_settings_Table_t1_s8","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"8\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:10:\"style2_no1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_08.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_08.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_08.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_08.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("133","css3_grid_shortcode_settings_Table_t1_s9","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:1:\"9\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:15:\"style1_hot_caps\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_11.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_11.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_11.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_11.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("134","css3_grid_shortcode_settings_Table_t1_s10","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:2:\"10\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:12:\"style2_fresh\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_06.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_06.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_04.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_04.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("135","css3_grid_shortcode_settings_Table_t1_s11","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:2:\"11\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:1:\"1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:16:\"style1_save_caps\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_02.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_02.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_04.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_04.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("136","css3_grid_shortcode_settings_Table_t1_s12","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:1:\"9\";s:4:\"kind\";s:1:\"1\";s:14:\"styleForTable1\";s:2:\"12\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:1:\"1\";i:3;s:2:\"-1\";i:4;s:1:\"1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:12:\"style1_off25\";i:3;s:12:\"style1_off30\";i:4;s:12:\"style1_off40\";}s:7:\"heights\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:11:\"paddingsTop\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:14:\"paddingsBottom\";a:9:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";}s:5:\"texts\";a:45:{i:0;s:0:\"\";i:1;s:29:\"<h2 class=\"col1\">starter</h2>\";i:2;s:27:\"<h2 class=\"col2\">econo</h2>\";i:3;s:30:\"<h2 class=\"col1\">standard</h2>\";i:4;s:34:\"<h2 class=\"col1\">professional</h2>\";i:5;s:54:\"<h2 class=\"caption\">choose <span>your</span> plan</h2>\";i:6;s:69:\"<h1 class=\"col1\">$<span>10</span></h1><h3 class=\"col1\">per month</h3>\";i:7;s:69:\"<h1 class=\"col1\">$<span>30</span></h1><h3 class=\"col1\">per month</h3>\";i:8;s:69:\"<h1 class=\"col1\">$<span>59</span></h1><h3 class=\"col1\">per month</h3>\";i:9;s:69:\"<h1 class=\"col1\">$<span>99</span></h1><h3 class=\"col1\">per month</h3>\";i:10;s:15:\"Amount of space\";i:11;s:4:\"10GB\";i:12;s:4:\"30GB\";i:13;s:5:\"100GB\";i:14;s:9:\"Unlimited\";i:15;s:19:\"Bandwidth per month\";i:16;s:5:\"100GB\";i:17;s:5:\"200GB\";i:18;s:5:\"500GB\";i:19;s:6:\"1000GB\";i:20;s:22:\"No. of e-mail accounts\";i:21;s:1:\"1\";i:22;s:2:\"10\";i:23;s:2:\"50\";i:24;s:9:\"Unlimited\";i:25;s:22:\"No. of MySql databases\";i:26;s:1:\"1\";i:27;s:2:\"10\";i:28;s:2:\"50\";i:29;s:9:\"Unlimited\";i:30;s:11:\"24h support\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_07.png\" alt=\"no\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_07.png\" alt=\"no\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_07.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_07.png\" alt=\"yes\">\";i:35;s:23:\"Support tickets per mo.\";i:36;s:1:\"1\";i:37;s:1:\"3\";i:38;s:1:\"5\";i:39;s:2:\"10\";i:40;s:0:\"\";i:41;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=1\" class=\"sign_up radius3\">sign up!</a>\";i:42;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=2\" class=\"sign_up radius3\">sign up!</a>\";i:43;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=3\" class=\"sign_up radius3\">sign up!</a>\";i:44;s:93:\"<a href=\"http://rubensteinarchitects.com/choices?plan=4\" class=\"sign_up radius3\">sign up!</a>\";}s:8:\"tooltips\";a:45:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("137","css3_grid_shortcode_settings_Table_t2_s1","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"1\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:16:\"style1_gift_caps\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:38;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\"> 2 domains\";i:39;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\"> 3 domains\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:34:\"Every additional database cost $3!\";i:27;s:34:\"Every additional database cost $2!\";i:28;s:34:\"Every additional database cost $1!\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("138","css3_grid_shortcode_settings_Table_t2_s2","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"2\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:11:\"style2_sale\";i:4;s:2:\"-1\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_12.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:38;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\"> 2 domains\";i:39;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\"> 2 domains\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_12.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_12.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_12.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_12.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_12.png\" alt=\"no\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_12.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("139","css3_grid_shortcode_settings_Table_t2_s3","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"3\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:1:\"1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:11:\"style2_pack\";i:4;s:2:\"-1\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_18.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:38;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\"> 2 domains\";i:39;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\"> 3 domains\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_18.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_18.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_18.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_18.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_18.png\" alt=\"no\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_18.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("140","css3_grid_shortcode_settings_Table_t2_s4","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"4\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:38;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\"> 2 domains\";i:39;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\"> 3 domains\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("141","css3_grid_shortcode_settings_Table_t2_s5","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"5\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:15:\"style2_new_caps\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:38;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\"> 2 domains\";i:39;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\"> 3 domains\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("142","css3_grid_shortcode_settings_Table_t2_s6","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"6\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:15:\"style2_new_caps\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:2:\"35\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:2:\"20\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:38;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\"> 2 domains\";i:39;s:151:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\"> 3 domains\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_19.png\" alt=\"no\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_19.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("143","css3_grid_shortcode_settings_Table_t2_s7","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"7\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:10:\"style1_pro\";i:4;s:2:\"-1\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_16.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:38;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:39;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_16.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_16.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_16.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_16.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_16.png\" alt=\"no\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_16.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:0:\"\";i:12;s:0:\"\";i:13;s:0:\"\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:20:\"Sample tooltip text!\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:18:\"Your tooltip text!\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("144","css3_grid_shortcode_settings_Table_t2_s8","a:17:{s:7:\"columns\";s:1:\"5\";s:4:\"rows\";s:2:\"11\";s:4:\"kind\";s:1:\"2\";s:14:\"styleForTable1\";s:1:\"1\";s:14:\"styleForTable2\";s:1:\"8\";s:18:\"hoverTypeForTable1\";s:6:\"active\";s:18:\"hoverTypeForTable2\";s:6:\"active\";s:6:\"widths\";a:5:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";}s:9:\"aligments\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"actives\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:1:\"1\";}s:7:\"hiddens\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:2:\"-1\";}s:7:\"ribbons\";a:5:{i:0;s:2:\"-1\";i:1;s:2:\"-1\";i:2;s:2:\"-1\";i:3;s:2:\"-1\";i:4;s:12:\"style2_heart\";}s:7:\"heights\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:11:\"paddingsTop\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:14:\"paddingsBottom\";a:11:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";}s:5:\"texts\";a:55:{i:0;s:0:\"\";i:1;s:14:\"<h2>basic</h2>\";i:2;s:17:\"<h2>standard</h2>\";i:3;s:14:\"<h2>super</h2>\";i:4;s:17:\"<h2>ultimate</h2>\";i:5;s:51:\"<h1 class=\"caption\">Hosting <span>Plans</span></h1>\";i:6;s:32:\"<h1>$3.95</h1><h3>per month</h3>\";i:7;s:32:\"<h1>$5.95</h1><h3>per month</h3>\";i:8;s:32:\"<h1>$7.95</h1><h3>per month</h3>\";i:9;s:32:\"<h1>$9.95</h1><h3>per month</h3>\";i:10;s:12:\"Data Storage\";i:11;s:14:\"2GB Disk Space\";i:12;s:15:\"10GB Disk Space\";i:13;s:15:\"50GB Disk Space\";i:14;s:9:\"Unlimited\";i:15;s:15:\"Monthly Traffic\";i:16;s:14:\"10GB Bandwidth\";i:17;s:14:\"50GB Bandwidth\";i:18;s:15:\"100GB Bandwidth\";i:19;s:9:\"Unlimited\";i:20;s:14:\"Email Accounts\";i:21;s:10:\"5 Accounts\";i:22;s:11:\"10 Accounts\";i:23;s:9:\"Unlimited\";i:24;s:9:\"Unlimited\";i:25;s:15:\"MySQL Databases\";i:26;s:11:\"2 Databases\";i:27;s:12:\"10 Databases\";i:28;s:12:\"20 Databases\";i:29;s:9:\"Unlimited\";i:30;s:12:\"Daily Backup\";i:31;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:32;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:33;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:34;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:35;s:11:\"Free Domain\";i:36;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:37;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:38;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:39;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:40;s:18:\"Website Statistics\";i:41;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:42;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:43;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:44;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:45;s:14:\"Online Support\";i:46;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:47;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:48;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/cross_09.png\" alt=\"no\">\";i:49;s:141:\"<img src=\"http://rubensteinarchitects.com/choices/wp-content/themes/builder/plugins/css3_web_pricing_tables_grids/img/tick_09.png\" alt=\"yes\">\";i:50;s:0:\"\";i:51;s:93:\"<a class=\"button_1 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=1\">sign up</a>\";i:52;s:93:\"<a class=\"button_2 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=2\">sign up</a>\";i:53;s:93:\"<a class=\"button_3 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=3\">sign up</a>\";i:54;s:93:\"<a class=\"button_4 radius5\" href=\"http://rubensteinarchitects.com/choices?plan=4\">sign up</a>\";}s:8:\"tooltips\";a:55:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";i:7;s:0:\"\";i:8;s:0:\"\";i:9;s:0:\"\";i:10;s:0:\"\";i:11;s:37:\"Every additonal 1GB of space cost $2!\";i:12;s:37:\"Every additonal 1GB of space cost $2!\";i:13;s:37:\"Every additonal 1GB of space cost $2!\";i:14;s:0:\"\";i:15;s:0:\"\";i:16;s:0:\"\";i:17;s:0:\"\";i:18;s:0:\"\";i:19;s:0:\"\";i:20;s:0:\"\";i:21;s:0:\"\";i:22;s:0:\"\";i:23;s:0:\"\";i:24;s:0:\"\";i:25;s:0:\"\";i:26;s:0:\"\";i:27;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:30;s:0:\"\";i:31;s:0:\"\";i:32;s:0:\"\";i:33;s:0:\"\";i:34;s:0:\"\";i:35;s:0:\"\";i:36;s:0:\"\";i:37;s:0:\"\";i:38;s:0:\"\";i:39;s:0:\"\";i:40;s:0:\"\";i:41;s:0:\"\";i:42;s:0:\"\";i:43;s:0:\"\";i:44;s:0:\"\";i:45;s:0:\"\";i:46;s:0:\"\";i:47;s:0:\"\";i:48;s:0:\"\";i:49;s:0:\"\";i:50;s:0:\"\";i:51;s:0:\"\";i:52;s:0:\"\";i:53;s:0:\"\";i:54;s:0:\"\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("146","theme_mods_choices","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:4:\"avia\";s:2:\"14\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("147","avia_options_choices_dynamic_elements","a:43:{s:28:\"frontpagedynamic_page_layout\";a:8:{s:4:\"slug\";s:9:\"frontpage\";s:4:\"name\";s:28:\"Dynamic Template Page Layout\";s:4:\"desc\";s:110:\"Choose the default page layout here. You can change the setting of each individual page when editing that page\";s:2:\"id\";s:28:\"frontpagedynamic_page_layout\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:12:\"sidebar_left\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:12:\"left sidebar\";s:12:\"sidebar_left\";s:13:\"right sidebar\";s:13:\"sidebar_right\";s:9:\"Fullwidth\";s:8:\"fullsize\";}}s:28:\"frontpageadd_template_option\";a:7:{s:4:\"type\";s:22:\"dynamical_add_elements\";s:4:\"slug\";s:9:\"frontpage\";s:4:\"name\";s:12:\"Add Elements\";s:4:\"desc\";s:151:\"Select an Element and hit the \'Add Element\' Button.<br/>The Element will be added to the template and you will be able to position it via drag and drop\";s:3:\"std\";s:0:\"\";s:2:\"id\";s:28:\"frontpageadd_template_option\";s:12:\"options_file\";s:49:\"includes/admin/register-admin-dynamic-options.php\";}s:26:\"frontpagedynamic_slideshow\";a:9:{s:7:\"dynamic\";s:9:\"slideshow\";s:4:\"name\";s:9:\"Slideshow\";s:4:\"desc\";s:190:\"The slideshow settings of the post or page that are used to display this template will be applied with all its options. You can modify the slideshow for each post/page when editing that post\";s:2:\"id\";s:26:\"frontpagedynamic_slideshow\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:9:\"frontpage\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:2:{i:0;a:8:{s:4:\"name\";s:16:\"Which Slideshow?\";s:4:\"desc\";s:307:\"By default the theme will display the slideshow of the entry which got the this template applied. However you can choose a different page as well.<br/> The slideshow settings of the entry you choose will be applied with all its options. You can modify the slideshow for each post/page when editing that post\";s:2:\"id\";s:33:\"dynamic_slideshow_which_post_page\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:35:\"Display the slideshow of this entry\";s:4:\"self\";s:13:\"Choose a Page\";s:4:\"page\";}}i:1;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Page\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:25:\"dynamic_slideshow_page_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:33:\"dynamic_slideshow_which_post_page\";i:1;s:4:\"page\";}}}}s:27:\"frontpagedynamic_page_split\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:27:\"frontpagedynamic_page_split\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:9:\"frontpage\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:26:\"frontpagedynamic_text_area\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:9:\"frontpage\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:26:\"frontpagedynamic_text_area\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:28:\"frontpagedynamic_page_split1\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:28:\"frontpagedynamic_page_split1\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:9:\"frontpage\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:26:\"frontpagedynamic_post_page\";a:9:{s:7:\"dynamic\";s:9:\"post_page\";s:4:\"name\";s:17:\"Post/Page Content\";s:4:\"slug\";s:9:\"frontpage\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:26:\"frontpagedynamic_post_page\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:4:{i:0;a:8:{s:4:\"name\";s:14:\"Which Content?\";s:4:\"desc\";s:176:\"Chosose a page or post. The content of that entry will be displayed. By default it will display the content of the current post or page that has the this template aplied to it.\";s:2:\"id\";s:23:\"dynamic_which_post_page\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:37:\"Display the content of this post/page\";s:4:\"self\";s:13:\"Choose a post\";s:4:\"post\";s:13:\"Choose a Page\";s:4:\"page\";}}i:1;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Page\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_page_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"page\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Post\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_post_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"post\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"post\";}}i:3;a:8:{s:4:\"name\";s:14:\"Display Title?\";s:4:\"desc\";s:51:\"Should the title of the entry be displayed as well?\";s:2:\"id\";s:29:\"dynamic_which_post_page_title\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:3:\"yes\";s:3:\"yes\";s:2:\"no\";s:2:\"no\";}}}}s:26:\"frontpagedynamic_hr_group1\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:26:\"frontpagedynamic_hr_group1\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:9:\"frontpage\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}s:25:\"frontpagedynamic_hr_group\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:25:\"frontpagedynamic_hr_group\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:9:\"frontpage\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}s:18:\"frontpagedynamic_l\";a:12:{s:7:\"dynamic\";s:4:\"logo\";s:4:\"name\";s:17:\"Logo/Partner List\";s:5:\"class\";s:12:\"avia_logobar\";s:4:\"slug\";s:9:\"frontpage\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:18:\"frontpagedynamic_l\";s:8:\"linktext\";s:17:\"Add another Slide\";s:10:\"deletetext\";s:12:\"Remove Slide\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:11:{i:0;a:8:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Image hovers effects\";s:4:\"desc\";s:87:\"Do you want to apply a mouse over effect for your images? Default is greyscale overlay.\";s:2:\"id\";s:10:\"logo_hover\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:16:\"greyscale-active\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:4:\"None\";s:0:\"\";s:9:\"Greyscale\";s:16:\"greyscale-active\";}}i:1;a:9:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:6:\"Logo 1\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:10:\"logo_img_1\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"class\";s:20:\"av_2columns av_col_1\";s:5:\"label\";s:11:\"Use as logo\";}i:2;a:8:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:10:\"Image Link\";s:4:\"desc\";s:0:\"\";s:5:\"class\";s:20:\"av_2columns av_col_2\";s:2:\"id\";s:15:\"logo_img_1_link\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:7:\"http://\";s:8:\"no_first\";b:1;}i:3;a:9:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:6:\"Logo 2\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:10:\"logo_img_2\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"class\";s:20:\"av_2columns av_col_1\";s:5:\"label\";s:11:\"Use as logo\";}i:4;a:8:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:10:\"Image Link\";s:4:\"desc\";s:0:\"\";s:5:\"class\";s:20:\"av_2columns av_col_2\";s:2:\"id\";s:15:\"logo_img_2_link\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:7:\"http://\";s:8:\"no_first\";b:1;}i:5;a:9:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:6:\"Logo 3\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:10:\"logo_img_3\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"class\";s:20:\"av_2columns av_col_1\";s:5:\"label\";s:11:\"Use as logo\";}i:6;a:8:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:10:\"Image Link\";s:4:\"desc\";s:0:\"\";s:5:\"class\";s:20:\"av_2columns av_col_2\";s:2:\"id\";s:15:\"logo_img_3_link\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:7:\"http://\";s:8:\"no_first\";b:1;}i:7;a:9:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:6:\"Logo 4\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:10:\"logo_img_4\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"class\";s:20:\"av_2columns av_col_1\";s:5:\"label\";s:11:\"Use as logo\";}i:8;a:8:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:10:\"Image Link\";s:4:\"desc\";s:0:\"\";s:5:\"class\";s:20:\"av_2columns av_col_2\";s:2:\"id\";s:15:\"logo_img_4_link\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:7:\"http://\";s:8:\"no_first\";b:1;}i:9;a:9:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:6:\"Logo 5\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:10:\"logo_img_5\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"class\";s:20:\"av_2columns av_col_1\";s:5:\"label\";s:11:\"Use as logo\";}i:10;a:8:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:10:\"Image Link\";s:4:\"desc\";s:0:\"\";s:5:\"class\";s:20:\"av_2columns av_col_2\";s:2:\"id\";s:15:\"logo_img_5_link\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:7:\"http://\";s:8:\"no_first\";b:1;}}}s:43:\"frontpage_with_portfoliodynamic_page_layout\";a:8:{s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:4:\"name\";s:28:\"Dynamic Template Page Layout\";s:4:\"desc\";s:110:\"Choose the default page layout here. You can change the setting of each individual page when editing that page\";s:2:\"id\";s:43:\"frontpage_with_portfoliodynamic_page_layout\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:8:\"fullsize\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:12:\"left sidebar\";s:12:\"sidebar_left\";s:13:\"right sidebar\";s:13:\"sidebar_right\";s:10:\"no sidebar\";s:8:\"fullsize\";}}s:43:\"frontpage_with_portfolioadd_template_option\";a:7:{s:4:\"type\";s:22:\"dynamical_add_elements\";s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:4:\"name\";s:12:\"Add Elements\";s:4:\"desc\";s:151:\"Select an Element and hit the \'Add Element\' Button.<br/>The Element will be added to the template and you will be able to position it via drag and drop\";s:3:\"std\";s:0:\"\";s:2:\"id\";s:43:\"frontpage_with_portfolioadd_template_option\";s:12:\"options_file\";s:49:\"includes/admin/register-admin-dynamic-options.php\";}s:41:\"frontpage_with_portfoliodynamic_slideshow\";a:9:{s:7:\"dynamic\";s:9:\"slideshow\";s:4:\"name\";s:9:\"Slideshow\";s:4:\"desc\";s:190:\"The slideshow settings of the post or page that are used to display this template will be applied with all its options. You can modify the slideshow for each post/page when editing that post\";s:2:\"id\";s:41:\"frontpage_with_portfoliodynamic_slideshow\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:2:{i:0;a:8:{s:4:\"name\";s:16:\"Which Slideshow?\";s:4:\"desc\";s:307:\"By default the theme will display the slideshow of the entry which got the this template applied. However you can choose a different page as well.<br/> The slideshow settings of the entry you choose will be applied with all its options. You can modify the slideshow for each post/page when editing that post\";s:2:\"id\";s:33:\"dynamic_slideshow_which_post_page\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:35:\"Display the slideshow of this entry\";s:4:\"self\";s:13:\"Choose a Page\";s:4:\"page\";}}i:1;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Page\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:25:\"dynamic_slideshow_page_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:33:\"dynamic_slideshow_which_post_page\";i:1;s:4:\"page\";}}}}s:42:\"frontpage_with_portfoliodynamic_page_split\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:42:\"frontpage_with_portfoliodynamic_page_split\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:41:\"frontpage_with_portfoliodynamic_text_area\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:41:\"frontpage_with_portfoliodynamic_text_area\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:43:\"frontpage_with_portfoliodynamic_page_split1\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:43:\"frontpage_with_portfoliodynamic_page_split1\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:41:\"frontpage_with_portfoliodynamic_portfolio\";a:11:{s:7:\"dynamic\";s:9:\"portfolio\";s:4:\"name\";s:9:\"Portfolio\";s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:41:\"frontpage_with_portfoliodynamic_portfolio\";s:8:\"linktext\";s:17:\"Add another Slide\";s:10:\"deletetext\";s:12:\"Remove Slide\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:7:{i:0;a:8:{s:4:\"name\";s:50:\"Which categories should be used for the portfolio?\";s:4:\"desc\";s:173:\"You can select multiple categories here. The Portfolio Page that you choose below will then show all posts from those categories, along with a sort option for each category.\";s:2:\"id\";s:14:\"portfolio_cats\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:9:\"portfolio\";s:8:\"multiple\";i:6;s:8:\"taxonomy\";s:17:\"portfolio_entries\";s:7:\"subtype\";s:3:\"cat\";}i:1;a:9:{s:4:\"slug\";s:9:\"portfolio\";s:4:\"name\";s:18:\"Portfolio Details?\";s:4:\"desc\";s:103:\"Should the portfolio details be opened on the same page when someone clicks a portfolio item?<br/><br/>\";s:2:\"id\";s:20:\"portfolio_ajax_class\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:24:\"ajax_portfolio_container\";s:8:\"no_first\";b:1;s:5:\"class\";s:20:\"av_2columns av_col_1\";s:7:\"subtype\";a:2:{s:47:\"Yes, on the same page - known as AJAX Portfolio\";s:24:\"ajax_portfolio_container\";s:33:\"No, open entries on a single page\";s:0:\"\";}}i:2;a:9:{s:4:\"slug\";s:9:\"portfolio\";s:4:\"name\";s:17:\"Portfolio Columns\";s:4:\"desc\";s:86:\"How many columns should be displayed? Should a sidebar be displayed as well?<br/><br/>\";s:2:\"id\";s:17:\"portfolio_columns\";s:4:\"type\";s:6:\"select\";s:5:\"class\";s:20:\"av_2columns av_col_2\";s:8:\"no_first\";b:1;s:3:\"std\";s:1:\"4\";s:7:\"subtype\";a:4:{s:8:\"1 Column\";s:1:\"1\";s:9:\"2 Columns\";s:1:\"2\";s:9:\"3 Columns\";s:1:\"3\";s:9:\"4 Columns\";s:1:\"4\";}}i:3;a:9:{s:4:\"slug\";s:9:\"portfolio\";s:4:\"name\";s:21:\"Portfolio Post Number\";s:4:\"desc\";s:54:\"How many items should be displayed per page?<br/><br/>\";s:2:\"id\";s:20:\"portfolio_item_count\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:2:\"16\";s:8:\"no_first\";b:1;s:5:\"class\";s:20:\"av_2columns av_col_1\";s:7:\"subtype\";a:101:{s:3:\"All\";s:2:\"-1\";i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:7;i:7;i:8;i:8;i:9;i:9;i:10;i:10;i:11;i:11;i:12;i:12;i:13;i:13;i:14;i:14;i:15;i:15;i:16;i:16;i:17;i:17;i:18;i:18;i:19;i:19;i:20;i:20;i:21;i:21;i:22;i:22;i:23;i:23;i:24;i:24;i:25;i:25;i:26;i:26;i:27;i:27;i:28;i:28;i:29;i:29;i:30;i:30;i:31;i:31;i:32;i:32;i:33;i:33;i:34;i:34;i:35;i:35;i:36;i:36;i:37;i:37;i:38;i:38;i:39;i:39;i:40;i:40;i:41;i:41;i:42;i:42;i:43;i:43;i:44;i:44;i:45;i:45;i:46;i:46;i:47;i:47;i:48;i:48;i:49;i:49;i:50;i:50;i:51;i:51;i:52;i:52;i:53;i:53;i:54;i:54;i:55;i:55;i:56;i:56;i:57;i:57;i:58;i:58;i:59;i:59;i:60;i:60;i:61;i:61;i:62;i:62;i:63;i:63;i:64;i:64;i:65;i:65;i:66;i:66;i:67;i:67;i:68;i:68;i:69;i:69;i:70;i:70;i:71;i:71;i:72;i:72;i:73;i:73;i:74;i:74;i:75;i:75;i:76;i:76;i:77;i:77;i:78;i:78;i:79;i:79;i:80;i:80;i:81;i:81;i:82;i:82;i:83;i:83;i:84;i:84;i:85;i:85;i:86;i:86;i:87;i:87;i:88;i:88;i:89;i:89;i:90;i:90;i:91;i:91;i:92;i:92;i:93;i:93;i:94;i:94;i:95;i:95;i:96;i:96;i:97;i:97;i:98;i:98;i:99;i:99;i:100;i:100;}}i:4;a:9:{s:4:\"slug\";s:9:\"portfolio\";s:4:\"name\";s:15:\"Portfolio Title\";s:4:\"desc\";s:33:\"Display Title of entry?<br/><br/>\";s:2:\"id\";s:14:\"portfolio_text\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:5:\"class\";s:20:\"av_2columns av_col_2\";s:7:\"subtype\";a:2:{s:3:\"yes\";s:3:\"yes\";s:2:\"no\";s:2:\"no\";}}i:5;a:9:{s:4:\"slug\";s:9:\"portfolio\";s:4:\"name\";s:19:\"Portfolio Sortable?\";s:4:\"desc\";s:70:\"Should the sorting options based on categories be displayed?<br/><br/>\";s:2:\"id\";s:17:\"portfolio_sorting\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:5:\"class\";s:20:\"av_2columns av_col_1\";s:7:\"subtype\";a:2:{s:3:\"yes\";s:3:\"yes\";s:2:\"no\";s:2:\"no\";}}i:6;a:9:{s:4:\"slug\";s:9:\"portfolio\";s:4:\"name\";s:20:\"Portfolio Pagination\";s:4:\"desc\";s:58:\"Should a portfolio pagination be displayed?<br/><br/><br/>\";s:2:\"id\";s:20:\"portfolio_pagination\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:5:\"class\";s:20:\"av_2columns av_col_2\";s:7:\"subtype\";a:2:{s:3:\"yes\";s:3:\"yes\";s:2:\"no\";s:2:\"no\";}}}}s:41:\"frontpage_with_portfoliodynamic_post_page\";a:9:{s:7:\"dynamic\";s:9:\"post_page\";s:4:\"name\";s:17:\"Post/Page Content\";s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:41:\"frontpage_with_portfoliodynamic_post_page\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:4:{i:0;a:8:{s:4:\"name\";s:14:\"Which Content?\";s:4:\"desc\";s:176:\"Chosose a page or post. The content of that entry will be displayed. By default it will display the content of the current post or page that has the this template aplied to it.\";s:2:\"id\";s:23:\"dynamic_which_post_page\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:37:\"Display the content of this post/page\";s:4:\"self\";s:13:\"Choose a post\";s:4:\"post\";s:13:\"Choose a Page\";s:4:\"page\";}}i:1;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Page\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_page_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"page\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Post\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_post_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"post\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"post\";}}i:3;a:8:{s:4:\"name\";s:14:\"Display Title?\";s:4:\"desc\";s:51:\"Should the title of the entry be displayed as well?\";s:2:\"id\";s:29:\"dynamic_which_post_page_title\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:3:\"yes\";s:3:\"yes\";s:2:\"no\";s:2:\"no\";}}}}s:23:\"teamdynamic_page_layout\";a:8:{s:4:\"slug\";s:4:\"team\";s:4:\"name\";s:28:\"Dynamic Template Page Layout\";s:4:\"desc\";s:110:\"Choose the default page layout here. You can change the setting of each individual page when editing that page\";s:2:\"id\";s:23:\"teamdynamic_page_layout\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:8:\"fullsize\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:12:\"left sidebar\";s:12:\"sidebar_left\";s:13:\"right sidebar\";s:13:\"sidebar_right\";s:10:\"no sidebar\";s:8:\"fullsize\";}}s:23:\"teamadd_template_option\";a:7:{s:4:\"type\";s:22:\"dynamical_add_elements\";s:4:\"slug\";s:4:\"team\";s:4:\"name\";s:12:\"Add Elements\";s:4:\"desc\";s:151:\"Select an Element and hit the \'Add Element\' Button.<br/>The Element will be added to the template and you will be able to position it via drag and drop\";s:3:\"std\";s:0:\"\";s:2:\"id\";s:23:\"teamadd_template_option\";s:12:\"options_file\";s:49:\"includes/admin/register-admin-dynamic-options.php\";}s:22:\"teamdynamic_page_split\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:22:\"teamdynamic_page_split\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:4:\"team\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:19:\"teamdynamic_heading\";a:9:{s:7:\"dynamic\";s:7:\"heading\";s:4:\"name\";s:24:\"Heading  ( + Breadcrumb)\";s:4:\"slug\";s:4:\"team\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:19:\"teamdynamic_heading\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:3:{i:0;a:8:{s:4:\"name\";s:16:\"Set a Page title\";s:4:\"desc\";s:94:\"By default the theme will display the page title of the entry which got this template applied.\";s:2:\"id\";s:20:\"dynamic_heading_type\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:28:\"Display this entries heading\";s:4:\"self\";s:14:\"Custom Heading\";s:6:\"custom\";}}i:1;a:7:{s:4:\"name\";s:14:\"Custom Heading\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:22:\"dynamic_heading_custom\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:20:\"dynamic_heading_type\";i:1;s:6:\"custom\";}}i:2;a:8:{s:4:\"name\";s:30:\"Display breadcrumb navigation?\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:20:\"dynamic_heading_meta\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:3:\"Yes\";s:3:\"yes\";s:2:\"No\";s:2:\"no\";}}}}s:23:\"teamdynamic_page_split1\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:23:\"teamdynamic_page_split1\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:4:\"team\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:21:\"teamdynamic_text_area\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:4:\"team\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:21:\"teamdynamic_text_area\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:20:\"teamdynamic_hr_group\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:20:\"teamdynamic_hr_group\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:4:\"team\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}s:21:\"teamdynamic_post_page\";a:9:{s:7:\"dynamic\";s:9:\"post_page\";s:4:\"name\";s:17:\"Post/Page Content\";s:4:\"slug\";s:4:\"team\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:21:\"teamdynamic_post_page\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:4:{i:0;a:8:{s:4:\"name\";s:14:\"Which Content?\";s:4:\"desc\";s:176:\"Chosose a page or post. The content of that entry will be displayed. By default it will display the content of the current post or page that has the this template aplied to it.\";s:2:\"id\";s:23:\"dynamic_which_post_page\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:37:\"Display the content of this post/page\";s:4:\"self\";s:13:\"Choose a post\";s:4:\"post\";s:13:\"Choose a Page\";s:4:\"page\";}}i:1;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Page\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_page_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"page\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Post\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_post_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"post\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"post\";}}i:3;a:8:{s:4:\"name\";s:14:\"Display Title?\";s:4:\"desc\";s:51:\"Should the title of the entry be displayed as well?\";s:2:\"id\";s:29:\"dynamic_which_post_page_title\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:3:\"yes\";s:3:\"yes\";s:2:\"no\";s:2:\"no\";}}}}s:31:\"landing_pagedynamic_page_layout\";a:8:{s:4:\"slug\";s:12:\"landing_page\";s:4:\"name\";s:28:\"Dynamic Template Page Layout\";s:4:\"desc\";s:110:\"Choose the default page layout here. You can change the setting of each individual page when editing that page\";s:2:\"id\";s:31:\"landing_pagedynamic_page_layout\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:8:\"fullsize\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:12:\"left sidebar\";s:12:\"sidebar_left\";s:13:\"right sidebar\";s:13:\"sidebar_right\";s:10:\"no sidebar\";s:8:\"fullsize\";}}s:31:\"landing_pageadd_template_option\";a:7:{s:4:\"type\";s:22:\"dynamical_add_elements\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"name\";s:12:\"Add Elements\";s:4:\"desc\";s:151:\"Select an Element and hit the \'Add Element\' Button.<br/>The Element will be added to the template and you will be able to position it via drag and drop\";s:3:\"std\";s:0:\"\";s:2:\"id\";s:31:\"landing_pageadd_template_option\";s:12:\"options_file\";s:49:\"includes/admin/register-admin-dynamic-options.php\";}s:29:\"landing_pagedynamic_slideshow\";a:9:{s:7:\"dynamic\";s:9:\"slideshow\";s:4:\"name\";s:9:\"Slideshow\";s:4:\"desc\";s:190:\"The slideshow settings of the post or page that are used to display this template will be applied with all its options. You can modify the slideshow for each post/page when editing that post\";s:2:\"id\";s:29:\"landing_pagedynamic_slideshow\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:2:{i:0;a:8:{s:4:\"name\";s:16:\"Which Slideshow?\";s:4:\"desc\";s:307:\"By default the theme will display the slideshow of the entry which got the this template applied. However you can choose a different page as well.<br/> The slideshow settings of the entry you choose will be applied with all its options. You can modify the slideshow for each post/page when editing that post\";s:2:\"id\";s:33:\"dynamic_slideshow_which_post_page\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:35:\"Display the slideshow of this entry\";s:4:\"self\";s:13:\"Choose a Page\";s:4:\"page\";}}i:1;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Page\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:25:\"dynamic_slideshow_page_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:33:\"dynamic_slideshow_which_post_page\";i:1;s:4:\"page\";}}}}s:30:\"landing_pagedynamic_page_split\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:30:\"landing_pagedynamic_page_split\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:29:\"landing_pagedynamic_text_area\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:29:\"landing_pagedynamic_text_area\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:31:\"landing_pagedynamic_page_split1\";a:9:{s:7:\"dynamic\";s:10:\"page_split\";s:4:\"name\";s:10:\"Page Split\";s:4:\"desc\";s:102:\"Creates a Page Split that allows to select a new color scheme for the content following the page split\";s:2:\"id\";s:31:\"landing_pagedynamic_page_split1\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:112:\"Creates a Page Split that allows to select a new color scheme for the content following the page split<br/><br/>\";s:2:\"id\";s:18:\"page_split_heading\";s:4:\"type\";s:7:\"heading\";s:3:\"std\";s:7:\"default\";s:4:\"slug\";s:0:\"\";s:13:\"nodescription\";b:1;}i:1;a:8:{s:4:\"name\";s:18:\"Page Split Styling\";s:4:\"desc\";s:148:\"Select a new color scheme for the content following the page split. You can <a href=\'admin.php?page=avia#goto_styling\'>define color schemes here</a>\";s:2:\"id\";s:16:\"page_split_style\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:10:\"main_color\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:6:{s:6:\"Header\";s:12:\"header_color\";s:18:\"Big Slideshow Area\";s:15:\"slideshow_color\";s:12:\"Main Content\";s:10:\"main_color\";s:17:\"Alternate Content\";s:15:\"alternate_color\";s:6:\"Footer\";s:12:\"footer_color\";s:6:\"Socket\";s:12:\"socket_color\";}}i:2;a:8:{s:4:\"name\";s:17:\"Page Split Shadow\";s:4:\"desc\";s:53:\"Display a shadow at the end of this content area?</a>\";s:2:\"id\";s:17:\"page_split_shadow\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"active\";s:8:\"no_first\";b:1;s:4:\"slug\";s:0:\"\";s:7:\"subtype\";a:2:{s:3:\"Yes\";s:6:\"active\";s:2:\"No\";s:9:\"no_shadow\";}}}}s:29:\"landing_pagedynamic_post_page\";a:9:{s:7:\"dynamic\";s:9:\"post_page\";s:4:\"name\";s:17:\"Post/Page Content\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:29:\"landing_pagedynamic_post_page\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:4:{i:0;a:8:{s:4:\"name\";s:14:\"Which Content?\";s:4:\"desc\";s:176:\"Chosose a page or post. The content of that entry will be displayed. By default it will display the content of the current post or page that has the this template aplied to it.\";s:2:\"id\";s:23:\"dynamic_which_post_page\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:37:\"Display the content of this post/page\";s:4:\"self\";s:13:\"Choose a post\";s:4:\"post\";s:13:\"Choose a Page\";s:4:\"page\";}}i:1;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Page\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_page_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"page\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:11:\"Select Post\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_post_id\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"post\";s:8:\"required\";a:2:{i:0;s:23:\"dynamic_which_post_page\";i:1;s:4:\"post\";}}i:3;a:8:{s:4:\"name\";s:14:\"Display Title?\";s:4:\"desc\";s:51:\"Should the title of the entry be displayed as well?\";s:2:\"id\";s:29:\"dynamic_which_post_page_title\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:3:\"yes\";s:3:\"yes\";s:2:\"no\";s:2:\"no\";}}}}s:27:\"landing_pagedynamic_heading\";a:9:{s:7:\"dynamic\";s:7:\"heading\";s:4:\"name\";s:24:\"Heading  ( + Breadcrumb)\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:27:\"landing_pagedynamic_heading\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:3:{i:0;a:8:{s:4:\"name\";s:16:\"Set a Page title\";s:4:\"desc\";s:94:\"By default the theme will display the page title of the entry which got this template applied.\";s:2:\"id\";s:20:\"dynamic_heading_type\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:4:\"self\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:28:\"Display this entries heading\";s:4:\"self\";s:14:\"Custom Heading\";s:6:\"custom\";}}i:1;a:7:{s:4:\"name\";s:14:\"Custom Heading\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:22:\"dynamic_heading_custom\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:20:\"dynamic_heading_type\";i:1;s:6:\"custom\";}}i:2;a:8:{s:4:\"name\";s:30:\"Display breadcrumb navigation?\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:20:\"dynamic_heading_meta\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:3:\"yes\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:2:{s:3:\"Yes\";s:3:\"yes\";s:2:\"No\";s:2:\"no\";}}}}s:30:\"landing_pagedynamic_text_area2\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:30:\"landing_pagedynamic_text_area2\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:29:\"landing_pagedynamic_hr_group2\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:29:\"landing_pagedynamic_hr_group2\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}s:30:\"landing_pagedynamic_text_area3\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:30:\"landing_pagedynamic_text_area3\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:29:\"landing_pagedynamic_hr_group3\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:29:\"landing_pagedynamic_hr_group3\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}s:30:\"landing_pagedynamic_text_area4\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:30:\"landing_pagedynamic_text_area4\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:29:\"landing_pagedynamic_hr_group4\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:29:\"landing_pagedynamic_hr_group4\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}s:28:\"landing_pagedynamic_hr_group\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:28:\"landing_pagedynamic_hr_group\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}s:30:\"landing_pagedynamic_text_area1\";a:9:{s:7:\"dynamic\";s:8:\"textarea\";s:4:\"name\";s:28:\"Text Area / Callout / Quotes\";s:4:\"slug\";s:12:\"landing_page\";s:4:\"type\";s:5:\"group\";s:2:\"id\";s:30:\"landing_pagedynamic_text_area1\";s:9:\"removable\";s:14:\"remove element\";s:5:\"blank\";b:1;s:13:\"nodescription\";b:1;s:11:\"subelements\";a:9:{i:0;a:8:{s:4:\"name\";s:12:\"Text Styling\";s:4:\"desc\";s:101:\"Chosose which text styling should be applied. You can either add a default paragraph or callout style\";s:2:\"id\";s:20:\"dynamic_text_styling\";s:4:\"type\";s:6:\"select\";s:4:\"slug\";s:0:\"\";s:3:\"std\";s:1:\"p\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:3:{s:15:\"Paragraph Style\";s:1:\"p\";s:16:\"Blockquote Style\";s:10:\"blockquote\";s:13:\"Callout Style\";s:7:\"callout\";}}i:1;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:18:\"visual_group_start\";s:2:\"id\";s:24:\"visual_group_dyn_callout\";s:13:\"nodescription\";b:1;s:8:\"required\";a:2:{i:0;s:20:\"dynamic_text_styling\";i:1;s:7:\"callout\";}}i:2;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:20:\"Callout Button Label\";s:4:\"desc\";s:90:\"Add the label text of the call to action button. If left empty no button will be displayed\";s:2:\"id\";s:19:\"dynamic_text_button\";s:4:\"type\";s:4:\"text\";}i:3;a:7:{s:4:\"name\";s:19:\"Callout Button link\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:24:\"dynamic_text_button_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:13:\"Link manually\";s:3:\"url\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";}}i:4;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"url\";}}i:5;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:29:\"dynamic_text_button_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:4:\"page\";}}i:6;a:7:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:4:\"slug\";s:0:\"\";s:2:\"id\";s:28:\"dynamic_text_button_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:24:\"dynamic_text_button_link\";i:1;s:3:\"cat\";}}i:7;a:4:{s:4:\"slug\";s:0:\"\";s:4:\"type\";s:16:\"visual_group_end\";s:2:\"id\";s:28:\"visual_group_dyn_callout_end\";s:13:\"nodescription\";b:1;}i:8;a:5:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:41:\"The text message that should be displayed\";s:4:\"desc\";s:72:\"Your message to the world :)<br/>(Wordpress shortcodes and HTML allowed)\";s:2:\"id\";s:12:\"dynamic_text\";s:4:\"type\";s:8:\"textarea\";}}}s:29:\"landing_pagedynamic_hr_group1\";a:9:{s:7:\"dynamic\";s:2:\"hr\";s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:29:\"landing_pagedynamic_hr_group1\";s:4:\"type\";s:5:\"group\";s:13:\"nodescription\";b:1;s:4:\"slug\";s:12:\"landing_page\";s:9:\"removable\";s:14:\"remove element\";s:11:\"subelements\";a:3:{i:0;a:9:{s:4:\"name\";s:16:\"Horizontal Ruler\";s:4:\"desc\";s:216:\"Adds a horizontal ruler to the template. You can either choose the default styling, the default styling with less padding at the top and bottom, a ruler with \'top\' link or an invisible ruler that just adds whitespace\";s:2:\"id\";s:10:\"dynamic_hr\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:7:\"default\";s:8:\"no_first\";b:1;s:7:\"subtype\";a:4:{s:13:\"Default Ruler\";s:7:\"default\";s:11:\"Small Ruler\";s:13:\"default_small\";s:15:\"Ruler with Text\";s:6:\"custom\";s:10:\"Whitespace\";s:10:\"whitespace\";}s:4:\"slug\";s:0:\"\";s:9:\"removable\";s:14:\"remove element\";}i:1;a:6:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:14:\"Enter the text\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:15:\"dynamic_hr_text\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:6:\"custom\";}}i:2;a:7:{s:4:\"slug\";s:0:\"\";s:4:\"name\";s:17:\"Whitespace Amount\";s:4:\"desc\";s:42:\"Enter the amount of whitespace in px or em\";s:2:\"id\";s:21:\"dynamic_hr_whitespace\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"30px\";s:8:\"required\";a:2:{i:0;s:10:\"dynamic_hr\";i:1;s:10:\"whitespace\";}}}}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("148","avia_options_choices","a:2:{s:4:\"avia\";a:105:{s:17:\"avia-nonce-import\";s:10:\"75038ab1ef\";s:9:\"frontpage\";s:2:\"28\";s:9:\"undefined\";s:12:\"type::select\";s:8:\"blogpage\";s:2:\"31\";s:4:\"logo\";s:0:\"\";s:7:\"favicon\";s:0:\"\";s:12:\"social_icons\";a:3:{i:0;a:2:{s:11:\"social_icon\";s:7:\"twitter\";s:16:\"social_icon_link\";s:25:\"http://twitter.com/kriesi\";}i:1;a:2:{s:11:\"social_icon\";s:8:\"dribbble\";s:16:\"social_icon_link\";s:26:\"http://dribbble.com/kriesi\";}i:2;a:2:{s:11:\"social_icon\";s:3:\"rss\";s:16:\"social_icon_link\";s:0:\"\";}}s:12:\"small_header\";s:35:\"Support Hotline: (555) 343 456 7891\";s:6:\"banner\";s:100:\"Welcome to the Choices WordPress Theme - a theme that allows you to build unique skins in no time...\";s:9:\"analytics\";s:0:\"\";s:12:\"color_scheme\";s:11:\"Dark Orange\";s:14:\"google_webfont\";s:9:\"Open Sans\";s:12:\"default_font\";s:9:\"Open Sans\";s:24:\"colorset-header_color-bg\";s:7:\"#ffffff\";s:25:\"colorset-header_color-bg2\";s:7:\"#f8f8f8\";s:29:\"colorset-header_color-primary\";s:7:\"#f05a1a\";s:31:\"colorset-header_color-secondary\";s:7:\"#ff7337\";s:27:\"colorset-header_color-color\";s:7:\"#333333\";s:28:\"colorset-header_color-border\";s:7:\"#e1e1e1\";s:25:\"colorset-header_color-img\";s:0:\"\";s:33:\"colorset-header_color-customimage\";s:0:\"\";s:25:\"colorset-header_color-pos\";s:13:\"center center\";s:28:\"colorset-header_color-repeat\";s:6:\"repeat\";s:28:\"colorset-header_color-attach\";s:6:\"scroll\";s:27:\"colorset-slideshow_color-bg\";s:7:\"#333333\";s:28:\"colorset-slideshow_color-bg2\";s:7:\"#f8f8f8\";s:32:\"colorset-slideshow_color-primary\";s:7:\"#f05a1a\";s:34:\"colorset-slideshow_color-secondary\";s:7:\"#f05a1a\";s:30:\"colorset-slideshow_color-color\";s:7:\"#ffffff\";s:31:\"colorset-slideshow_color-border\";s:7:\"#e1e1e1\";s:28:\"colorset-slideshow_color-img\";s:107:\"http://rubensteinarchitects.com/choices/wp-content/themes/choices/images/background-images/grain_bottom.png\";s:36:\"colorset-slideshow_color-customimage\";s:0:\"\";s:28:\"colorset-slideshow_color-pos\";s:13:\"bottom center\";s:31:\"colorset-slideshow_color-repeat\";s:8:\"repeat-x\";s:31:\"colorset-slideshow_color-attach\";s:6:\"scroll\";s:22:\"colorset-main_color-bg\";s:7:\"#ffffff\";s:23:\"colorset-main_color-bg2\";s:7:\"#f8f8f8\";s:27:\"colorset-main_color-primary\";s:7:\"#f05a1a\";s:29:\"colorset-main_color-secondary\";s:7:\"#f05a1a\";s:25:\"colorset-main_color-color\";s:7:\"#666666\";s:26:\"colorset-main_color-border\";s:7:\"#e1e1e1\";s:23:\"colorset-main_color-img\";s:0:\"\";s:31:\"colorset-main_color-customimage\";s:0:\"\";s:23:\"colorset-main_color-pos\";s:13:\"center center\";s:26:\"colorset-main_color-repeat\";s:6:\"repeat\";s:26:\"colorset-main_color-attach\";s:6:\"scroll\";s:27:\"colorset-alternate_color-bg\";s:7:\"#f8f8f8\";s:28:\"colorset-alternate_color-bg2\";s:7:\"#ffffff\";s:32:\"colorset-alternate_color-primary\";s:7:\"#f05a1a\";s:34:\"colorset-alternate_color-secondary\";s:7:\"#f05a1a\";s:30:\"colorset-alternate_color-color\";s:7:\"#888888\";s:31:\"colorset-alternate_color-border\";s:7:\"#e1e1e1\";s:28:\"colorset-alternate_color-img\";s:0:\"\";s:36:\"colorset-alternate_color-customimage\";s:0:\"\";s:28:\"colorset-alternate_color-pos\";s:13:\"center center\";s:31:\"colorset-alternate_color-repeat\";s:6:\"repeat\";s:31:\"colorset-alternate_color-attach\";s:6:\"scroll\";s:24:\"colorset-footer_color-bg\";s:7:\"#333333\";s:25:\"colorset-footer_color-bg2\";s:7:\"#222222\";s:29:\"colorset-footer_color-primary\";s:7:\"#f05a1a\";s:31:\"colorset-footer_color-secondary\";s:7:\"#f05a1a\";s:27:\"colorset-footer_color-color\";s:7:\"#aaaaaa\";s:28:\"colorset-footer_color-border\";s:7:\"#555555\";s:25:\"colorset-footer_color-img\";s:104:\"http://rubensteinarchitects.com/choices/wp-content/themes/choices/images/background-images/grain_top.png\";s:33:\"colorset-footer_color-customimage\";s:0:\"\";s:25:\"colorset-footer_color-pos\";s:10:\"top center\";s:28:\"colorset-footer_color-repeat\";s:8:\"repeat-x\";s:28:\"colorset-footer_color-attach\";s:6:\"scroll\";s:24:\"colorset-socket_color-bg\";s:7:\"#111111\";s:25:\"colorset-socket_color-bg2\";s:7:\"#000000\";s:29:\"colorset-socket_color-primary\";s:7:\"#ffffff\";s:31:\"colorset-socket_color-secondary\";s:7:\"#eeeeee\";s:27:\"colorset-socket_color-color\";s:7:\"#eeeeee\";s:28:\"colorset-socket_color-border\";s:7:\"#161616\";s:25:\"colorset-socket_color-img\";s:0:\"\";s:33:\"colorset-socket_color-customimage\";s:0:\"\";s:25:\"colorset-socket_color-pos\";s:13:\"center center\";s:28:\"colorset-socket_color-repeat\";s:6:\"repeat\";s:28:\"colorset-socket_color-attach\";s:6:\"scroll\";s:16:\"color-body_style\";s:9:\"stretched\";s:16:\"color-body_color\";s:7:\"#ebebeb\";s:14:\"color-body_img\";s:0:\"\";s:22:\"color-body_customimage\";s:0:\"\";s:14:\"color-body_pos\";s:13:\"center center\";s:17:\"color-body_repeat\";s:6:\"repeat\";s:17:\"color-body_attach\";s:6:\"scroll\";s:9:\"quick_css\";s:770:\"/* BEGIN - changes the circles to squares in the blog pages */
/* Code for the day circle */
#top .side-container-inner .day {
-webkit-border-radius: 0px;
-moz-border-radius: 0px;
border-radius: 0px;
}

/* Code for the date_group circle */
#top .side-container-inner .date_group {
-webkit-border-radius: 0px;
-moz-border-radius: 0px;
border-radius: 0px;
}
/* END - changes the circles to squares in the blog pages */

/* BEGIN - Remove shadows from Horizontal and sidebar lines */
/* Code to remove from horizontal lines */
.bottom_shadow {
display: none;
}

/* Code to remove from sidebar */
.sidebar_bg_top.sidebar_bg, .sidebar_bg_bottom, .sidebar_bg_center {
background: none;
border-left: 1px solid red;
}
/* END - Remove shadows from Horizontal and sidebar lines */\";s:17:\"responsive_layout\";s:10:\"responsive\";s:15:\"websave_windows\";s:6:\"active\";s:11:\"blog_layout\";s:13:\"sidebar_right\";s:11:\"page_layout\";s:13:\"sidebar_right\";s:16:\"page_nesting_nav\";s:4:\"true\";s:16:\"slideshow_poster\";s:6:\"single\";s:14:\"portfolio-slug\";s:14:\"portfolio-item\";s:14:\"portfolio-meta\";a:3:{i:0;a:1:{s:4:\"meta\";s:13:\"Skills Needed\";}i:1;a:1:{s:4:\"meta\";s:6:\"Client\";}i:2;a:1:{s:4:\"meta\";s:11:\"Project URL\";}}s:9:\"portfolio\";a:5:{i:0;a:10:{s:14:\"portfolio_cats\";s:4:\"null\";s:14:\"portfolio_page\";s:2:\"75\";s:20:\"portfolio_ajax_class\";s:24:\"ajax_portfolio_container\";s:17:\"portfolio_columns\";s:1:\"4\";s:16:\"portfolio_layout\";s:8:\"fullsize\";s:20:\"portfolio_item_count\";s:2:\"16\";s:14:\"portfolio_text\";s:3:\"yes\";s:17:\"portfolio_sorting\";s:3:\"yes\";s:20:\"portfolio_pagination\";s:2:\"no\";s:19:\"portfolio_greyscale\";s:3:\"yes\";}i:1;a:10:{s:14:\"portfolio_cats\";s:4:\"null\";s:14:\"portfolio_page\";s:2:\"78\";s:20:\"portfolio_ajax_class\";s:0:\"\";s:17:\"portfolio_columns\";s:1:\"3\";s:16:\"portfolio_layout\";s:8:\"fullsize\";s:20:\"portfolio_item_count\";s:2:\"12\";s:14:\"portfolio_text\";s:3:\"yes\";s:17:\"portfolio_sorting\";s:3:\"yes\";s:20:\"portfolio_pagination\";s:2:\"no\";s:19:\"portfolio_greyscale\";s:3:\"yes\";}i:2;a:10:{s:14:\"portfolio_cats\";s:4:\"null\";s:14:\"portfolio_page\";s:2:\"80\";s:20:\"portfolio_ajax_class\";s:24:\"ajax_portfolio_container\";s:17:\"portfolio_columns\";s:1:\"2\";s:16:\"portfolio_layout\";s:8:\"fullsize\";s:20:\"portfolio_item_count\";s:1:\"8\";s:14:\"portfolio_text\";s:3:\"yes\";s:17:\"portfolio_sorting\";s:3:\"yes\";s:20:\"portfolio_pagination\";s:3:\"yes\";s:19:\"portfolio_greyscale\";s:3:\"yes\";}i:3;a:10:{s:14:\"portfolio_cats\";s:4:\"null\";s:14:\"portfolio_page\";s:2:\"82\";s:20:\"portfolio_ajax_class\";s:24:\"ajax_portfolio_container\";s:17:\"portfolio_columns\";s:1:\"1\";s:16:\"portfolio_layout\";s:8:\"fullsize\";s:20:\"portfolio_item_count\";s:1:\"7\";s:14:\"portfolio_text\";s:3:\"yes\";s:17:\"portfolio_sorting\";s:2:\"no\";s:20:\"portfolio_pagination\";s:3:\"yes\";s:19:\"portfolio_greyscale\";s:3:\"yes\";}i:4;a:10:{s:14:\"portfolio_cats\";s:4:\"null\";s:14:\"portfolio_page\";s:2:\"84\";s:20:\"portfolio_ajax_class\";s:0:\"\";s:17:\"portfolio_columns\";s:1:\"2\";s:16:\"portfolio_layout\";s:13:\"sidebar_right\";s:20:\"portfolio_item_count\";s:1:\"8\";s:14:\"portfolio_text\";s:3:\"yes\";s:17:\"portfolio_sorting\";s:2:\"no\";s:20:\"portfolio_pagination\";s:3:\"yes\";s:19:\"portfolio_greyscale\";s:3:\"yes\";}}s:10:\"email_page\";s:2:\"86\";s:5:\"email\";s:0:\"\";s:13:\"autoresponder\";s:118:\"This is an autoresponder text, set in the wordpress backend of the coherence theme...

We have received your message! \";s:15:\"feedback_button\";s:8:\"Feedback\";s:20:\"contact-form-captcha\";s:6:\"active\";s:21:\"contact-form-elements\";a:6:{i:0;a:4:{s:5:\"label\";s:4:\"Name\";s:4:\"type\";s:4:\"text\";s:5:\"check\";s:8:\"is_empty\";s:7:\"options\";s:0:\"\";}i:1;a:4:{s:5:\"label\";s:6:\"E-Mail\";s:4:\"type\";s:4:\"text\";s:5:\"check\";s:8:\"is_email\";s:7:\"options\";s:0:\"\";}i:2;a:4:{s:5:\"label\";s:7:\"Subject\";s:4:\"type\";s:4:\"text\";s:5:\"check\";s:8:\"is_empty\";s:7:\"options\";s:0:\"\";}i:3;a:4:{s:5:\"label\";s:8:\"Priority\";s:4:\"type\";s:6:\"select\";s:5:\"check\";s:0:\"\";s:7:\"options\";s:47:\"Low, Medium, High, Urgent as Hell, ASAP DUDE!!!\";}i:4;a:4:{s:5:\"label\";s:7:\"Message\";s:4:\"type\";s:8:\"textarea\";s:5:\"check\";s:8:\"is_empty\";s:7:\"options\";s:0:\"\";}i:5;a:4:{s:5:\"label\";s:57:\"I have read the general terms and conditions and I agree!\";s:4:\"type\";s:8:\"checkbox\";s:5:\"check\";s:8:\"is_empty\";s:7:\"options\";s:0:\"\";}}s:12:\"widget_pages\";a:1:{i:0;a:1:{s:11:\"widget_page\";s:0:\"\";}}s:17:\"widget_categories\";a:1:{i:0;a:1:{s:10:\"widget_cat\";s:0:\"\";}}s:14:\"footer_columns\";s:1:\"4\";}s:9:\"templates\";a:40:{s:16:\"template_builder\";s:0:\"\";s:28:\"frontpagedynamic_page_layout\";s:8:\"fullsize\";s:26:\"frontpagedynamic_slideshow\";a:1:{i:0;a:1:{s:33:\"dynamic_slideshow_which_post_page\";s:4:\"self\";}}s:27:\"frontpagedynamic_page_split\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:15:\"alternate_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:26:\"frontpagedynamic_text_area\";a:1:{i:0;a:6:{s:20:\"dynamic_text_styling\";s:7:\"callout\";s:19:\"dynamic_text_button\";s:17:\"Plans and Pricing\";s:24:\"dynamic_text_button_link\";s:4:\"page\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:29:\"dynamic_text_button_link_page\";i:53;s:12:\"dynamic_text\";s:67:\"Welcome to Choices, a bold &amp;amp; super flexible business theme!\";}}s:28:\"frontpagedynamic_page_split1\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:10:\"main_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:26:\"frontpagedynamic_post_page\";a:1:{i:0;a:2:{s:23:\"dynamic_which_post_page\";s:4:\"self\";s:29:\"dynamic_which_post_page_title\";s:2:\"no\";}}s:26:\"frontpagedynamic_hr_group1\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:10:\"whitespace\";s:15:\"dynamic_hr_text\";s:0:\"\";s:21:\"dynamic_hr_whitespace\";s:4:\"30px\";}}s:25:\"frontpagedynamic_hr_group\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:6:\"custom\";s:15:\"dynamic_hr_text\";s:12:\"Our Partners\";s:21:\"dynamic_hr_whitespace\";s:4:\"30px\";}}s:18:\"frontpagedynamic_l\";a:1:{i:0;a:6:{s:10:\"logo_hover\";s:16:\"greyscale-active\";s:15:\"logo_img_1_link\";s:7:\"http://\";s:15:\"logo_img_2_link\";s:7:\"http://\";s:15:\"logo_img_3_link\";s:7:\"http://\";s:15:\"logo_img_4_link\";s:7:\"http://\";s:15:\"logo_img_5_link\";s:7:\"http://\";}}s:43:\"frontpage_with_portfoliodynamic_page_layout\";s:8:\"fullsize\";s:41:\"frontpage_with_portfoliodynamic_slideshow\";a:1:{i:0;a:1:{s:33:\"dynamic_slideshow_which_post_page\";s:4:\"self\";}}s:42:\"frontpage_with_portfoliodynamic_page_split\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:15:\"alternate_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:41:\"frontpage_with_portfoliodynamic_text_area\";a:1:{i:0;a:5:{s:20:\"dynamic_text_styling\";s:1:\"p\";s:19:\"dynamic_text_button\";s:0:\"\";s:24:\"dynamic_text_button_link\";s:0:\"\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:12:\"dynamic_text\";s:474:\"[one_third first]

&lt;h3&gt;FLEXIBLY TEMPLATES&lt;/h3&gt;

[dropcap2]1[/dropcap2]Lorem ipsum dolor sit amet, consectetur adipisicinod tempor

[/one_third]

[one_third]

&lt;h3&gt;HTML Template Brodscope&lt;/h3&gt;

[dropcap3]2[/dropcap3]Lor amet, consectetur adipisicing elit, ed do eiusmod tempor

[/one_third]

[one_third]

&lt;h3&gt;Superfunky CSS 3 Features&lt;/h3&gt;

[dropcap3]3[/dropcap3]Lorem ipsum dolor sit amet, consectetur ad ed do eiusmod tempor

[/one_third]\";}}s:43:\"frontpage_with_portfoliodynamic_page_split1\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:10:\"main_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:41:\"frontpage_with_portfoliodynamic_portfolio\";a:1:{i:0;a:6:{s:20:\"portfolio_ajax_class\";s:24:\"ajax_portfolio_container\";s:17:\"portfolio_columns\";s:1:\"4\";s:20:\"portfolio_item_count\";s:1:\"8\";s:14:\"portfolio_text\";s:3:\"yes\";s:17:\"portfolio_sorting\";s:2:\"no\";s:20:\"portfolio_pagination\";s:2:\"no\";}}s:41:\"frontpage_with_portfoliodynamic_post_page\";a:1:{i:0;a:2:{s:23:\"dynamic_which_post_page\";s:4:\"self\";s:29:\"dynamic_which_post_page_title\";s:2:\"no\";}}s:23:\"teamdynamic_page_layout\";s:8:\"fullsize\";s:22:\"teamdynamic_page_split\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:15:\"alternate_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:19:\"teamdynamic_heading\";a:1:{i:0;a:3:{s:20:\"dynamic_heading_type\";s:4:\"self\";s:22:\"dynamic_heading_custom\";s:0:\"\";s:20:\"dynamic_heading_meta\";s:3:\"yes\";}}s:23:\"teamdynamic_page_split1\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:10:\"main_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:21:\"teamdynamic_text_area\";a:1:{i:0;a:6:{s:20:\"dynamic_text_styling\";s:7:\"callout\";s:19:\"dynamic_text_button\";s:12:\"Get in Touch\";s:24:\"dynamic_text_button_link\";s:4:\"page\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:29:\"dynamic_text_button_link_page\";i:86;s:12:\"dynamic_text\";s:93:\"We are a devoted team of professionals, dedicating every second of our work day to perfection\";}}s:20:\"teamdynamic_hr_group\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:6:\"custom\";s:15:\"dynamic_hr_text\";s:13:\"Meet the team\";s:21:\"dynamic_hr_whitespace\";s:4:\"30px\";}}s:21:\"teamdynamic_post_page\";a:1:{i:0;a:2:{s:23:\"dynamic_which_post_page\";s:4:\"self\";s:29:\"dynamic_which_post_page_title\";s:2:\"no\";}}s:31:\"landing_pagedynamic_page_layout\";s:8:\"fullsize\";s:29:\"landing_pagedynamic_slideshow\";a:1:{i:0;a:1:{s:33:\"dynamic_slideshow_which_post_page\";s:4:\"self\";}}s:30:\"landing_pagedynamic_page_split\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:15:\"alternate_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:29:\"landing_pagedynamic_text_area\";a:1:{i:0;a:6:{s:20:\"dynamic_text_styling\";s:7:\"callout\";s:19:\"dynamic_text_button\";s:21:\"See Plans and Pricing\";s:24:\"dynamic_text_button_link\";s:4:\"page\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:29:\"dynamic_text_button_link_page\";i:67;s:12:\"dynamic_text\";s:47:\"Welcome to our Landing Page. Want to know more?\";}}s:31:\"landing_pagedynamic_page_split1\";a:1:{i:0;a:2:{s:16:\"page_split_style\";s:10:\"main_color\";s:17:\"page_split_shadow\";s:6:\"active\";}}s:29:\"landing_pagedynamic_post_page\";a:1:{i:0;a:2:{s:23:\"dynamic_which_post_page\";s:4:\"self\";s:29:\"dynamic_which_post_page_title\";s:2:\"no\";}}s:27:\"landing_pagedynamic_heading\";a:1:{i:0;a:3:{s:20:\"dynamic_heading_type\";s:6:\"custom\";s:22:\"dynamic_heading_custom\";s:39:\"Testimonials - what others say about us\";s:20:\"dynamic_heading_meta\";s:2:\"no\";}}s:30:\"landing_pagedynamic_text_area2\";a:1:{i:0;a:5:{s:20:\"dynamic_text_styling\";s:10:\"blockquote\";s:19:\"dynamic_text_button\";s:0:\"\";s:24:\"dynamic_text_button_link\";s:0:\"\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:12:\"dynamic_text\";s:216:\"Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Fusce id purus. Ut varius tincidunt libero. Phasellus dolor. Maecenas vestibulum mollis - &lt;strong&gt;Max Payne&lt;/strong&gt;\";}}s:29:\"landing_pagedynamic_hr_group2\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:10:\"whitespace\";s:15:\"dynamic_hr_text\";s:0:\"\";s:21:\"dynamic_hr_whitespace\";s:4:\"10px\";}}s:30:\"landing_pagedynamic_text_area3\";a:1:{i:0;a:5:{s:20:\"dynamic_text_styling\";s:10:\"blockquote\";s:19:\"dynamic_text_button\";s:0:\"\";s:24:\"dynamic_text_button_link\";s:0:\"\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:12:\"dynamic_text\";s:235:\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. - &lt;strong&gt;Marky Marcus&lt;/strong&gt;\";}}s:29:\"landing_pagedynamic_hr_group3\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:10:\"whitespace\";s:15:\"dynamic_hr_text\";s:0:\"\";s:21:\"dynamic_hr_whitespace\";s:4:\"10px\";}}s:30:\"landing_pagedynamic_text_area4\";a:1:{i:0;a:5:{s:20:\"dynamic_text_styling\";s:10:\"blockquote\";s:19:\"dynamic_text_button\";s:0:\"\";s:24:\"dynamic_text_button_link\";s:0:\"\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:12:\"dynamic_text\";s:280:\"Ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Fusce id purus. Ut varius tincidunt libero. Phases posuere cubilia Curae; Fusce id purus. Ut varius tincidunt libero. ellus dolor. Maecenas vestibulum mollis - &lt;strong&gt;Melinda Meyers&lt;/strong&gt;\";}}s:29:\"landing_pagedynamic_hr_group4\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:10:\"whitespace\";s:15:\"dynamic_hr_text\";s:0:\"\";s:21:\"dynamic_hr_whitespace\";s:4:\"30px\";}}s:28:\"landing_pagedynamic_hr_group\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:6:\"custom\";s:15:\"dynamic_hr_text\";s:33:\"Know everything you need to know?\";s:21:\"dynamic_hr_whitespace\";s:4:\"30px\";}}s:30:\"landing_pagedynamic_text_area1\";a:1:{i:0;a:6:{s:20:\"dynamic_text_styling\";s:7:\"callout\";s:19:\"dynamic_text_button\";s:22:\"Download Trial Version\";s:24:\"dynamic_text_button_link\";s:4:\"page\";s:28:\"dynamic_text_button_link_url\";s:7:\"http://\";s:29:\"dynamic_text_button_link_page\";i:67;s:12:\"dynamic_text\";s:83:\"Guess by now you have a good idea about our service.
Now its time to give it a try!\";}}s:29:\"landing_pagedynamic_hr_group1\";a:1:{i:0;a:3:{s:10:\"dynamic_hr\";s:7:\"default\";s:15:\"dynamic_hr_text\";s:0:\"\";s:21:\"dynamic_hr_whitespace\";s:4:\"30px\";}}}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("151","_transient_timeout_plugin_slugs","1357431175","no");
INSERT INTO `ts968ny_3_options` VALUES("152","_transient_plugin_slugs","a:3:{i:0;s:19:\"akismet/akismet.php\";i:1;s:19:\"bbpress/bbpress.php\";i:2;s:41:\"password-protected/password-protected.php\";}","no");
INSERT INTO `ts968ny_3_options` VALUES("153","recently_activated","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("156","_bbp_private_forums","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("157","_bbp_hidden_forums","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("158","_bbp_db_version","230","yes");
INSERT INTO `ts968ny_3_options` VALUES("166","post_count","11","yes");
INSERT INTO `ts968ny_3_options` VALUES("167","category_children","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("168","portfolio_entries_children","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("169","avia_options_choices_dynamic_pages","a:3:{i:0;a:6:{s:4:\"slug\";s:24:\"frontpage_with_portfolio\";s:6:\"parent\";s:9:\"templates\";s:4:\"icon\";s:30:\"layout_header_footer_3_mix.png\";s:5:\"title\";s:24:\"Frontpage with Portfolio\";s:9:\"removable\";s:20:\"remove this template\";s:8:\"sortable\";s:13:\"avia_sortable\";}i:1;a:6:{s:4:\"slug\";s:4:\"team\";s:6:\"parent\";s:9:\"templates\";s:4:\"icon\";s:30:\"layout_header_footer_3_mix.png\";s:5:\"title\";s:4:\"Team\";s:9:\"removable\";s:20:\"remove this template\";s:8:\"sortable\";s:13:\"avia_sortable\";}i:2;a:6:{s:4:\"slug\";s:12:\"landing_page\";s:6:\"parent\";s:9:\"templates\";s:4:\"icon\";s:30:\"layout_header_footer_3_mix.png\";s:5:\"title\";s:12:\"Landing Page\";s:9:\"removable\";s:20:\"remove this template\";s:8:\"sortable\";s:13:\"avia_sortable\";}}","yes");
INSERT INTO `ts968ny_3_options` VALUES("173","password_protected_status","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("174","password_protected_feeds","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("175","password_protected_administrators","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("178","password_protected_password","9b21d5d345944577ffe4a690e4e0c849","yes");
INSERT INTO `ts968ny_3_options` VALUES("255","blog_upload_space","","yes");
INSERT INTO `ts968ny_3_options` VALUES("303","ngg_options","a:68:{s:11:\"gallerypath\";s:29:\"wp-content/blogs.dir/3/files/\";s:9:\"deleteImg\";b:1;s:9:\"swfUpload\";b:1;s:13:\"usePermalinks\";b:0;s:13:\"permalinkSlug\";s:9:\"nggallery\";s:14:\"graphicLibrary\";s:2:\"gd\";s:14:\"imageMagickDir\";s:15:\"/usr/local/bin/\";s:11:\"useMediaRSS\";b:0;s:10:\"usePicLens\";b:0;s:12:\"activateTags\";b:0;s:10:\"appendType\";s:4:\"tags\";s:9:\"maxImages\";i:7;s:10:\"thumbwidth\";i:100;s:11:\"thumbheight\";i:75;s:8:\"thumbfix\";b:1;s:12:\"thumbquality\";i:100;s:8:\"imgWidth\";i:800;s:9:\"imgHeight\";i:600;s:10:\"imgQuality\";i:85;s:9:\"imgBackup\";b:1;s:13:\"imgAutoResize\";b:0;s:9:\"galImages\";s:2:\"20\";s:17:\"galPagedGalleries\";i:0;s:10:\"galColumns\";i:0;s:12:\"galShowSlide\";b:1;s:12:\"galTextSlide\";s:19:\"[Show as slideshow]\";s:14:\"galTextGallery\";s:19:\"[Show picture list]\";s:12:\"galShowOrder\";s:7:\"gallery\";s:7:\"galSort\";s:9:\"sortorder\";s:10:\"galSortDir\";s:3:\"ASC\";s:10:\"galNoPages\";b:1;s:13:\"galImgBrowser\";b:0;s:12:\"galHiddenImg\";b:0;s:10:\"galAjaxNav\";b:0;s:11:\"thumbEffect\";s:7:\"shutter\";s:9:\"thumbCode\";s:33:\"class=\"shutterset_%GALLERY_NAME%\"\";s:5:\"wmPos\";s:8:\"botRight\";s:6:\"wmXpos\";i:5;s:6:\"wmYpos\";i:5;s:6:\"wmType\";s:4:\"text\";s:6:\"wmPath\";s:0:\"\";s:6:\"wmFont\";s:9:\"arial.ttf\";s:6:\"wmSize\";i:10;s:6:\"wmText\";s:10:\"RA Choices\";s:7:\"wmColor\";s:6:\"000000\";s:8:\"wmOpaque\";s:3:\"100\";s:8:\"enableIR\";b:0;s:7:\"slideFx\";s:4:\"fade\";s:5:\"irURL\";s:83:\"http://rubensteinarchitects.com/wp-content/plugins/nextgen-gallery/imagerotator.swf\";s:12:\"irXHTMLvalid\";b:0;s:7:\"irAudio\";s:0:\"\";s:7:\"irWidth\";i:320;s:8:\"irHeight\";i:240;s:9:\"irShuffle\";b:1;s:17:\"irLinkfromdisplay\";b:1;s:16:\"irShownavigation\";b:0;s:11:\"irShowicons\";b:0;s:11:\"irWatermark\";b:0;s:13:\"irOverstretch\";s:4:\"true\";s:12:\"irRotatetime\";i:10;s:12:\"irTransition\";s:6:\"random\";s:10:\"irKenburns\";b:0;s:11:\"irBackcolor\";s:6:\"000000\";s:12:\"irFrontcolor\";s:6:\"FFFFFF\";s:12:\"irLightcolor\";s:6:\"CC0000\";s:13:\"irScreencolor\";s:6:\"000000\";s:11:\"activateCSS\";b:1;s:7:\"CSSfile\";s:13:\"nggallery.css\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("304","ngg_db_version","1.8.1","yes");
INSERT INTO `ts968ny_3_options` VALUES("323","_transient_random_seed","44318e636d618a960fdf7a4d6a7306c8","yes");
INSERT INTO `ts968ny_3_options` VALUES("385","duplicate_post_copyexcerpt","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("386","duplicate_post_copyattachments","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("387","duplicate_post_copychildren","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("388","duplicate_post_copystatus","0","yes");
INSERT INTO `ts968ny_3_options` VALUES("389","duplicate_post_taxonomies_blacklist","a:0:{}","yes");
INSERT INTO `ts968ny_3_options` VALUES("390","duplicate_post_show_row","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("391","duplicate_post_show_adminbar","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("392","duplicate_post_show_submitbox","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("393","duplicate_post_version","2.4.1","yes");
INSERT INTO `ts968ny_3_options` VALUES("435","mg-notifier-cache","<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<notifier>
	<latest>2.21</latest>
	
	<updateinfo>
		<![CDATA[
		
		<ol>
			<li>To update the plugin, login to <a href=\"http://www.codecanyon.net/\">CodeCanyon</a>, head over to your <strong>downloads</strong> section and re-download the plugin like you did when you bought it.</li>
			
			<li>Delete the previous version of the plugin from the wordpress plugin panel</li>
			
			<li>install the new version as explained in the documentation</li>
		</ol>
		
		]]>
	</updateinfo>
	
	<changelog>
	
		<![CDATA[
		
		<p>Check the changelog <a href=\"http://www.projects.lcweb.it/media-grid/changelog\" target=\"_blank\">here</a></p>
		
		]]>

	</changelog>
</notifier>","yes");
INSERT INTO `ts968ny_3_options` VALUES("436","mg-notifier-cache-last-updated","1372378207","yes");
INSERT INTO `ts968ny_3_options` VALUES("456","cms_tpv_version","1.2.4","yes");
INSERT INTO `ts968ny_3_options` VALUES("457","cms_tpv_show_annoying_little_box","1","yes");
INSERT INTO `ts968ny_3_options` VALUES("459","wysija_post_type_updated","1359427273","yes");
INSERT INTO `ts968ny_3_options` VALUES("461","wysija_post_type_created","1359427273","yes");
INSERT INTO `ts968ny_3_options` VALUES("462","wysija","YToxNzp7czoxNzoidG90YWxfc3Vic2NyaWJlcnMiO3M6MToiMiI7czo5OiJmcm9tX25hbWUiO3M6NDoibmVpbCI7czoxMjoicmVwbHl0b19uYW1lIjtzOjQ6Im5laWwiO3M6MTA6ImZyb21fZW1haWwiO3M6Mjk6Im5laWxAcnViZW5zdGVpbmFyY2hpdGVjdHMuY29tIjtzOjEzOiJyZXBseXRvX2VtYWlsIjtzOjI5OiJuZWlsQHJ1YmVuc3RlaW5hcmNoaXRlY3RzLmNvbSI7czoxNToiZW1haWxzX25vdGlmaWVkIjtzOjI5OiJuZWlsQHJ1YmVuc3RlaW5hcmNoaXRlY3RzLmNvbSI7czoxNToiZGVmYXVsdF9saXN0X2lkIjtpOjE7czoxNjoiaW1wb3J0d3BfbGlzdF9pZCI7aToyO3M6MTg6ImNvbmZpcm1fZW1haWxfbGluayI7aTo2NzQ7czoxMjoidXBsb2FkZm9sZGVyIjtzOjYwOiIvaG9tZS9ydWJlbnM3L3B1YmxpY19odG1sL3dwLWNvbnRlbnQvdXBsb2Fkcy9zaXRlcy8zL3d5c2lqYS8iO3M6OToidXBsb2FkdXJsIjtzOjc0OiJodHRwOi8vcnViZW5zdGVpbmFyY2hpdGVjdHMuY29tL2Nob2ljZXMvd3AtY29udGVudC91cGxvYWRzL3NpdGVzLzMvd3lzaWphLyI7czoxNjoiY29uZmlybV9lbWFpbF9pZCI7aToyO3M6OToiaW5zdGFsbGVkIjtiOjE7czoyMDoibWFuYWdlX3N1YnNjcmlwdGlvbnMiO2I6MTtzOjE0OiJpbnN0YWxsZWRfdGltZSI7aToxMzU5NDI3Mjc2O3M6MTc6Ind5c2lqYV9kYl92ZXJzaW9uIjtzOjU6IjIuMi4zIjtzOjExOiJka2ltX2RvbWFpbiI7czoyNDoicnViZW5zdGVpbmFyY2hpdGVjdHMuY29tIjt9","yes");
INSERT INTO `ts968ny_3_options` VALUES("464","wysija_reinstall","0","no");
INSERT INTO `ts968ny_3_options` VALUES("465","wpcf7","a:1:{s:7:\"version\";s:5:\"3.5.2\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("466","jetpack_activated","2","yes");
INSERT INTO `ts968ny_3_options` VALUES("467","jetpack_options","a:2:{s:7:\"version\";s:16:\"2.1.1:1359427276\";s:11:\"old_version\";s:16:\"2.1.1:1359427276\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("488","_transient_timeout_facebookcount-cache-45","1359430921","no");
INSERT INTO `ts968ny_3_options` VALUES("489","_transient_facebookcount-cache-45","1","no");
INSERT INTO `ts968ny_3_options` VALUES("490","_transient_timeout_twittercount-cache-45","1359430921","no");
INSERT INTO `ts968ny_3_options` VALUES("491","_transient_twittercount-cache-45","1","no");
INSERT INTO `ts968ny_3_options` VALUES("508","coreSLframework_options","a:3:{s:11:\"debug_level\";i:3;s:10:\"deprecated\";b:0;s:4:\"lang\";s:0:\"\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("524","jobman_options","a:37:{s:14:\"app_cat_select\";s:0:\"\";s:14:\"app_job_select\";s:0:\"\";s:22:\"application_email_from\";i:4;s:29:\"application_email_from_fields\";a:2:{i:0;i:2;i:1;i:3;}s:30:\"application_email_subject_text\";s:16:\"Job Application:\";s:32:\"application_email_subject_fields\";a:2:{i:0;i:2;i:1;i:3;}s:11:\"date_format\";s:0:\"\";s:13:\"default_email\";s:29:\"neil@rubensteinarchitects.com\";s:21:\"highlighted_behaviour\";s:6:\"sticky\";s:10:\"interviews\";i:1;s:22:\"interview_default_view\";s:5:\"month\";s:20:\"interview_title_text\";s:0:\"\";s:22:\"interview_title_fields\";a:2:{i:0;i:2;i:1;i:3;}s:13:\"jobs_per_page\";i:0;s:15:\"loginform_apply\";i:1;s:18:\"loginform_category\";i:1;s:13:\"loginform_job\";i:1;s:14:\"loginform_main\";i:1;s:18:\"multi_applications\";i:0;s:7:\"plugins\";a:2:{s:3:\"gxs\";i:1;s:9:\"sicaptcha\";i:0;}s:10:\"promo_link\";i:1;s:18:\"related_categories\";i:1;s:13:\"rewrite_rules\";a:5:{s:22:\"jobs/?(page/(\\d+)/?)?$\";s:45:\"index.php?jobman_root_id=676&page=$matches[2]\";s:24:\"jobs/apply(/([^/]+))?/?$\";s:70:\"index.php?jobman_root_id=676&jobman_page=apply&jobman_data=$matches[2]\";s:27:\"jobs/register(/([^/]+))?/?$\";s:73:\"index.php?jobman_root_id=676&jobman_page=register&jobman_data=$matches[2]\";s:12:\"jobs/feed/?$\";s:21:\"index.php?feed=jobman\";s:30:\"jobs/([^/]+)/?(page/(\\d+)/?)?$\";s:50:\"index.php?jobman_data=$matches[1]&page=$matches[3]\";}s:7:\"sort_by\";s:0:\"\";s:10:\"sort_order\";s:0:\"\";s:9:\"templates\";a:3:{s:16:\"application_form\";s:0:\"\";s:3:\"job\";s:558:\"<table class=\"job-table[if_job_highlighted] highlighted[/if_job_highlighted]\">
  <tr>
    <th scope=\"row\">Title</th>
    <td>[job_icon] [job_title]</td>
  </tr>
[if_job_categories]
  <tr>
     <th scope=\"row\">Categories</th>
     <td>[job_category_links]</td>
  </tr>
[/if_job_categories]
[job_field_loop]
  [if_job_field]
  <tr>
    <th scope=\"row\">[job_field_label]</th>
    <td>[job_field]</td>
  </tr>
  [/if_job_field]
[/job_field_loop]
  <tr>
    <td></td>
    <td class=\"jobs-applynow\">[job_apply_link]Apply Now[/job_apply_link]</td>
  </tr>
</table>	\";s:8:\"job_list\";s:1037:\"[job_loop]
<div class=\"job[job_row_number] job[job_id] [job_odd_even]\">
<table class=\"job-table[if_job_highlighted] highlighted[/if_job_highlighted]\">
  <tr>
    <th scope=\"row\">Title</th>
    <td>[job_icon] [job_link][job_title][/job_link]</td>
  </tr>
[if_job_categories]
  <tr>
     <th scope=\"row\">Categories</th>
     <td>[job_category_links]</td>
  </tr>
[/if_job_categories]
[job_field_loop]
  [if_job_field]
  <tr>
    <th scope=\"row\">[job_field_label]</th>
    <td>[job_field]</td>
  </tr>
  [/if_job_field]
[/job_field_loop]
  <tr>
    <td></td>
    <td class=\"jobs-applynow\">[job_apply_link]Apply Now[/job_apply_link]</td>
  </tr>
</table>
</div><br/><br/>
[/job_loop]

[if_job_page_count]
<div class=\"job-nav\">
	<div class=\"previous\">[job_page_previous_link]Page [job_page_previous_number][/job_page_previous_link]</div>
	<div class=\"this\">Jobs [job_page_minimum]-[job_page_maximum] of [job_total]</div>
	<div class=\"next\">[job_page_next_link]Page [job_page_next_number][/job_page_next_link]</div>
</div>
[/if_job_page_count]\";}s:4:\"text\";a:12:{s:11:\"main_before\";s:0:\"\";s:10:\"main_after\";s:0:\"\";s:15:\"category_before\";s:0:\"\";s:14:\"category_after\";s:0:\"\";s:10:\"job_before\";s:0:\"\";s:9:\"job_after\";s:0:\"\";s:12:\"apply_before\";s:0:\"\";s:11:\"apply_after\";s:0:\"\";s:19:\"registration_before\";s:0:\"\";s:18:\"registration_after\";s:0:\"\";s:16:\"job_title_prefix\";s:5:\"Job: \";s:22:\"application_acceptance\";s:77:\"Thank you for your application! We\'ll check it out, and get back to you soon!\";}s:9:\"uninstall\";a:4:{s:7:\"options\";i:1;s:4:\"jobs\";i:1;s:12:\"applications\";i:1;s:10:\"categories\";i:1;}s:17:\"user_registration\";i:0;s:26:\"user_registration_required\";i:0;s:5:\"icons\";a:0:{}s:6:\"fields\";a:18:{i:1;a:9:{s:5:\"label\";s:16:\"Personal Details\";s:4:\"type\";s:7:\"heading\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:0;s:10:\"categories\";a:0:{}}i:2;a:9:{s:5:\"label\";s:4:\"Name\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:1;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:1;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:1;s:10:\"categories\";a:0:{}}i:3;a:9:{s:5:\"label\";s:7:\"Surname\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:1;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:1;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:2;s:10:\"categories\";a:0:{}}i:4;a:9:{s:5:\"label\";s:13:\"Email Address\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:1;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:3;s:10:\"categories\";a:0:{}}i:5;a:9:{s:5:\"label\";s:15:\"Contact Details\";s:4:\"type\";s:7:\"heading\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:4;s:10:\"categories\";a:0:{}}i:6;a:9:{s:5:\"label\";s:7:\"Address\";s:4:\"type\";s:8:\"textarea\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:5;s:10:\"categories\";a:0:{}}i:7;a:9:{s:5:\"label\";s:4:\"City\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:6;s:10:\"categories\";a:0:{}}i:8;a:9:{s:5:\"label\";s:9:\"Post code\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:7;s:10:\"categories\";a:0:{}}i:9;a:9:{s:5:\"label\";s:7:\"Country\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:1;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:8;s:10:\"categories\";a:0:{}}i:10;a:9:{s:5:\"label\";s:9:\"Telephone\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:9;s:10:\"categories\";a:0:{}}i:11;a:9:{s:5:\"label\";s:10:\"Cell phone\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:10;s:10:\"categories\";a:0:{}}i:12;a:9:{s:5:\"label\";s:14:\"Qualifications\";s:4:\"type\";s:7:\"heading\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:11;s:10:\"categories\";a:0:{}}i:13;a:9:{s:5:\"label\";s:21:\"Do you have a degree?\";s:4:\"type\";s:5:\"radio\";s:11:\"listdisplay\";i:1;s:4:\"data\";s:7:\"Yes
No\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:12;s:10:\"categories\";a:0:{}}i:14;a:9:{s:5:\"label\";s:35:\"Where did you complete your degree?\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:13;s:10:\"categories\";a:0:{}}i:15;a:9:{s:5:\"label\";s:20:\"Title of your degree\";s:4:\"type\";s:4:\"text\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:14;s:10:\"categories\";a:0:{}}i:16;a:9:{s:5:\"label\";s:14:\"Upload your CV\";s:4:\"type\";s:4:\"file\";s:11:\"listdisplay\";i:1;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:15;s:10:\"categories\";a:0:{}}i:17;a:9:{s:5:\"label\";s:0:\"\";s:4:\"type\";s:5:\"blank\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:0:\"\";s:9:\"mandatory\";i:0;s:6:\"filter\";s:0:\"\";s:5:\"error\";s:0:\"\";s:9:\"sortorder\";i:16;s:10:\"categories\";a:0:{}}i:18;a:9:{s:5:\"label\";s:0:\"\";s:4:\"type\";s:8:\"checkbox\";s:11:\"listdisplay\";i:0;s:4:\"data\";s:46:\"I have read and understood the privacy policy.\";s:9:\"mandatory\";i:1;s:6:\"filter\";s:46:\"I have read and understood the privacy policy.\";s:5:\"error\";s:189:\"You need to read and agree to our privacy policy before we can accept your application. Please click the \'Back\' button in your browser, read our privacy policy, and confirm that you accept.\";s:9:\"sortorder\";i:17;s:10:\"categories\";a:0:{}}}s:10:\"job_fields\";a:5:{i:1;a:5:{s:5:\"label\";s:6:\"Salary\";s:4:\"type\";s:4:\"text\";s:4:\"data\";s:0:\"\";s:9:\"sortorder\";i:0;s:11:\"description\";s:0:\"\";}i:2;a:5:{s:5:\"label\";s:10:\"Start Date\";s:4:\"type\";s:4:\"date\";s:4:\"data\";s:0:\"\";s:9:\"sortorder\";i:1;s:11:\"description\";s:79:\"The date that the job starts. For positions available immediately, leave blank.\";}i:3;a:5:{s:5:\"label\";s:8:\"End Date\";s:4:\"type\";s:4:\"date\";s:4:\"data\";s:0:\"\";s:9:\"sortorder\";i:2;s:11:\"description\";s:67:\"The date that the job finishes. For ongoing positions, leave blank.\";}i:4;a:5:{s:5:\"label\";s:8:\"Location\";s:4:\"type\";s:4:\"text\";s:4:\"data\";s:0:\"\";s:9:\"sortorder\";i:3;s:11:\"description\";s:0:\"\";}i:5;a:5:{s:5:\"label\";s:15:\"Job Information\";s:4:\"type\";s:8:\"textarea\";s:4:\"data\";s:0:\"\";s:9:\"sortorder\";i:4;s:11:\"description\";s:0:\"\";}}s:9:\"main_page\";i:676;s:13:\"register_page\";i:678;s:7:\"version\";s:6:\"0.7.20\";s:10:\"db_version\";i:19;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("534","wpseo","a:6:{s:15:\"ms_defaults_set\";b:1;s:7:\"version\";s:6:\"1.4.15\";s:14:\"tracking_popup\";s:4:\"done\";s:14:\"yoast_tracking\";b:1;s:11:\"theme_check\";a:1:{s:11:\"description\";b:1;}s:11:\"ignore_tour\";s:6:\"ignore\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("537","wpseo_xml","a:1:{s:36:\"post_types-attachment-not_in_sitemap\";b:1;}","yes");
INSERT INTO `ts968ny_3_options` VALUES("539","wpseo_social","a:3:{s:9:\"opengraph\";s:0:\"\";s:10:\"fb_adminid\";s:0:\"\";s:8:\"fb_appid\";s:0:\"\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("540","wpseo_titles","a:11:{s:14:\"noindex-author\";s:0:\"\";s:14:\"disable-author\";s:0:\"\";s:15:\"noindex-archive\";s:0:\"\";s:16:\"noindex-category\";s:0:\"\";s:16:\"noindex-post_tag\";s:0:\"\";s:19:\"noindex-post_format\";s:0:\"\";s:16:\"noindex-subpages\";s:0:\"\";s:12:\"hide-rsdlink\";s:0:\"\";s:14:\"hide-feedlinks\";s:0:\"\";s:16:\"hide-wlwmanifest\";s:0:\"\";s:14:\"hide-shortlink\";s:0:\"\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("636","_transient_timeout_facebookcount-cache-46","1367358534","no");
INSERT INTO `ts968ny_3_options` VALUES("637","_transient_facebookcount-cache-46","1","no");
INSERT INTO `ts968ny_3_options` VALUES("638","_transient_timeout_twittercount-cache-46","1367358534","no");
INSERT INTO `ts968ny_3_options` VALUES("639","_transient_twittercount-cache-46","1","no");
INSERT INTO `ts968ny_3_options` VALUES("662","db_upgraded","","yes");
INSERT INTO `ts968ny_3_options` VALUES("684","_transient_timeout_facebookcount-cache-44","1372382692","no");
INSERT INTO `ts968ny_3_options` VALUES("685","_transient_facebookcount-cache-44","1","no");
INSERT INTO `ts968ny_3_options` VALUES("686","_transient_timeout_twittercount-cache-44","1372382692","no");
INSERT INTO `ts968ny_3_options` VALUES("687","_transient_twittercount-cache-44","1","no");
INSERT INTO `ts968ny_3_options` VALUES("688","_transient_timeout_facebookcount-cache-41","1372382716","no");
INSERT INTO `ts968ny_3_options` VALUES("689","_transient_facebookcount-cache-41","1","no");
INSERT INTO `ts968ny_3_options` VALUES("690","_transient_timeout_twittercount-cache-41","1372382716","no");
INSERT INTO `ts968ny_3_options` VALUES("691","_transient_twittercount-cache-41","1","no");
INSERT INTO `ts968ny_3_options` VALUES("692","_transient_timeout_facebookcount-cache-1","1372382854","no");
INSERT INTO `ts968ny_3_options` VALUES("693","_transient_facebookcount-cache-1","1","no");
INSERT INTO `ts968ny_3_options` VALUES("694","_transient_timeout_twittercount-cache-1","1372382854","no");
INSERT INTO `ts968ny_3_options` VALUES("695","_transient_twittercount-cache-1","1","no");
INSERT INTO `ts968ny_3_options` VALUES("696","_transient_timeout_facebookcount-cache-296","1372382854","no");
INSERT INTO `ts968ny_3_options` VALUES("697","_transient_facebookcount-cache-296","1","no");
INSERT INTO `ts968ny_3_options` VALUES("698","_transient_timeout_twittercount-cache-296","1372382854","no");
INSERT INTO `ts968ny_3_options` VALUES("699","_transient_twittercount-cache-296","1","no");
INSERT INTO `ts968ny_3_options` VALUES("700","_transient_timeout_facebookcount-cache-282","1372382855","no");
INSERT INTO `ts968ny_3_options` VALUES("701","_transient_facebookcount-cache-282","1","no");
INSERT INTO `ts968ny_3_options` VALUES("702","_transient_timeout_twittercount-cache-282","1372382855","no");
INSERT INTO `ts968ny_3_options` VALUES("703","_transient_twittercount-cache-282","1","no");
INSERT INTO `ts968ny_3_options` VALUES("704","_transient_timeout_facebookcount-cache-254","1372382855","no");
INSERT INTO `ts968ny_3_options` VALUES("705","_transient_facebookcount-cache-254","1","no");
INSERT INTO `ts968ny_3_options` VALUES("706","_transient_timeout_twittercount-cache-254","1372382855","no");
INSERT INTO `ts968ny_3_options` VALUES("707","_transient_twittercount-cache-254","1","no");
INSERT INTO `ts968ny_3_options` VALUES("708","_transient_timeout_facebookcount-cache-252","1372382855","no");
INSERT INTO `ts968ny_3_options` VALUES("709","_transient_facebookcount-cache-252","1","no");
INSERT INTO `ts968ny_3_options` VALUES("710","_transient_timeout_twittercount-cache-252","1372382856","no");
INSERT INTO `ts968ny_3_options` VALUES("711","_transient_twittercount-cache-252","1","no");
INSERT INTO `ts968ny_3_options` VALUES("712","_transient_timeout_facebookcount-cache-250","1372382856","no");
INSERT INTO `ts968ny_3_options` VALUES("713","_transient_facebookcount-cache-250","1","no");
INSERT INTO `ts968ny_3_options` VALUES("714","_transient_timeout_twittercount-cache-250","1372382856","no");
INSERT INTO `ts968ny_3_options` VALUES("715","_transient_twittercount-cache-250","1","no");
INSERT INTO `ts968ny_3_options` VALUES("716","_transient_timeout_facebookcount-cache-246","1372382857","no");
INSERT INTO `ts968ny_3_options` VALUES("717","_transient_facebookcount-cache-246","1","no");
INSERT INTO `ts968ny_3_options` VALUES("718","_transient_timeout_twittercount-cache-246","1372382857","no");
INSERT INTO `ts968ny_3_options` VALUES("719","_transient_twittercount-cache-246","1","no");
INSERT INTO `ts968ny_3_options` VALUES("720","_transient_timeout_facebookcount-cache-237","1372382857","no");
INSERT INTO `ts968ny_3_options` VALUES("721","_transient_facebookcount-cache-237","1","no");
INSERT INTO `ts968ny_3_options` VALUES("722","_transient_timeout_twittercount-cache-237","1372382857","no");
INSERT INTO `ts968ny_3_options` VALUES("723","_transient_twittercount-cache-237","1","no");
INSERT INTO `ts968ny_3_options` VALUES("724","_transient_timeout_facebookcount-cache-95","1372382857","no");
INSERT INTO `ts968ny_3_options` VALUES("725","_transient_facebookcount-cache-95","1","no");
INSERT INTO `ts968ny_3_options` VALUES("726","_transient_timeout_twittercount-cache-95","1372382861","no");
INSERT INTO `ts968ny_3_options` VALUES("727","_transient_twittercount-cache-95","1","no");
INSERT INTO `ts968ny_3_options` VALUES("728","_transient_timeout_facebookcount-cache-94","1372382862","no");
INSERT INTO `ts968ny_3_options` VALUES("729","_transient_facebookcount-cache-94","1","no");
INSERT INTO `ts968ny_3_options` VALUES("730","_transient_timeout_twittercount-cache-94","1372382862","no");
INSERT INTO `ts968ny_3_options` VALUES("731","_transient_twittercount-cache-94","1","no");
INSERT INTO `ts968ny_3_options` VALUES("735","_transient_timeout_jetpack_https_test","1375506383","no");
INSERT INTO `ts968ny_3_options` VALUES("736","_transient_jetpack_https_test","1","no");
INSERT INTO `ts968ny_3_options` VALUES("739","_transient_doing_cron","1378124550.7209649085998535156250","yes");
INSERT INTO `ts968ny_3_options` VALUES("740","rewrite_rules","a:282:{s:28:\"forums/forum/([^/]+)/edit/?$\";s:34:\"index.php?forum=$matches[1]&edit=1\";s:28:\"forums/topic/([^/]+)/edit/?$\";s:34:\"index.php?topic=$matches[1]&edit=1\";s:28:\"forums/reply/([^/]+)/edit/?$\";s:34:\"index.php?reply=$matches[1]&edit=1\";s:32:\"forums/topic-tag/([^/]+)/edit/?$\";s:38:\"index.php?topic-tag=$matches[1]&edit=1\";s:47:\"forums/user/([^/]+)/topics/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_tops=1&paged=$matches[2]\";s:48:\"forums/user/([^/]+)/replies/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_reps=1&paged=$matches[2]\";s:50:\"forums/user/([^/]+)/favorites/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_favs=1&paged=$matches[2]\";s:54:\"forums/user/([^/]+)/subscriptions/page/?([0-9]{1,})/?$\";s:59:\"index.php?bbp_user=$matches[1]&bbp_subs=1&paged=$matches[2]\";s:29:\"forums/user/([^/]+)/topics/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_tops=1\";s:30:\"forums/user/([^/]+)/replies/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_reps=1\";s:32:\"forums/user/([^/]+)/favorites/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_favs=1\";s:36:\"forums/user/([^/]+)/subscriptions/?$\";s:41:\"index.php?bbp_user=$matches[1]&bbp_subs=1\";s:27:\"forums/user/([^/]+)/edit/?$\";s:37:\"index.php?bbp_user=$matches[1]&edit=1\";s:22:\"forums/user/([^/]+)/?$\";s:30:\"index.php?bbp_user=$matches[1]\";s:40:\"forums/view/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?bbp_view=$matches[1]&paged=$matches[2]\";s:27:\"forums/view/([^/]+)/feed/?$\";s:47:\"index.php?bbp_view=$matches[1]&feed=$matches[2]\";s:22:\"forums/view/([^/]+)/?$\";s:30:\"index.php?bbp_view=$matches[1]\";s:34:\"forums/search/page/?([0-9]{1,})/?$\";s:27:\"index.php?paged=$matches[1]\";s:16:\"forums/search/?$\";s:20:\"index.php?bbp_search\";s:22:\"jobs/?(page/(\\d+)/?)?$\";s:45:\"index.php?jobman_root_id=676&page=$matches[2]\";s:24:\"jobs/apply(/([^/]+))?/?$\";s:70:\"index.php?jobman_root_id=676&jobman_page=apply&jobman_data=$matches[2]\";s:27:\"jobs/register(/([^/]+))?/?$\";s:73:\"index.php?jobman_root_id=676&jobman_page=register&jobman_data=$matches[2]\";s:12:\"jobs/feed/?$\";s:21:\"index.php?feed=jobman\";s:30:\"jobs/([^/]+)/?(page/(\\d+)/?)?$\";s:50:\"index.php?jobman_data=$matches[1]&page=$matches[3]\";s:9:\"forums/?$\";s:25:\"index.php?post_type=forum\";s:39:\"forums/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:34:\"forums/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=forum&feed=$matches[1]\";s:26:\"forums/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=forum&paged=$matches[1]\";s:9:\"topics/?$\";s:25:\"index.php?post_type=topic\";s:39:\"topics/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:34:\"topics/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?post_type=topic&feed=$matches[1]\";s:26:\"topics/page/([0-9]{1,})/?$\";s:43:\"index.php?post_type=topic&paged=$matches[1]\";s:54:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:49:\"category/(.+?)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:51:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:46:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:52:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:47:\"type/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:38:\"forums/forum/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"forums/forum/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"forums/forum/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"forums/forum/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"forums/forum/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"forums/forum/(.+?)/trackback/?$\";s:32:\"index.php?forum=$matches[1]&tb=1\";s:58:\"forums/forum/(.+?)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:53:\"forums/forum/(.+?)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:44:\"index.php?forum=$matches[1]&feed=$matches[2]\";s:39:\"forums/forum/(.+?)/page/?([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&paged=$matches[2]\";s:46:\"forums/forum/(.+?)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?forum=$matches[1]&cpage=$matches[2]\";s:31:\"forums/forum/(.+?)(/[0-9]+)?/?$\";s:44:\"index.php?forum=$matches[1]&page=$matches[2]\";s:40:\"forums/topic/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/topic/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"forums/topic/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"forums/topic/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/topic/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"forums/topic/([^/]+)/trackback/?$\";s:32:\"index.php?topic=$matches[1]&tb=1\";s:60:\"forums/topic/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:55:\"forums/topic/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:44:\"index.php?topic=$matches[1]&feed=$matches[2]\";s:41:\"forums/topic/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&paged=$matches[2]\";s:48:\"forums/topic/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?topic=$matches[1]&cpage=$matches[2]\";s:33:\"forums/topic/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?topic=$matches[1]&page=$matches[2]\";s:29:\"forums/topic/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/topic/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"forums/topic/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"forums/topic/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/topic/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"forums/reply/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"forums/reply/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"forums/reply/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"forums/reply/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"forums/reply/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"forums/reply/([^/]+)/trackback/?$\";s:32:\"index.php?reply=$matches[1]&tb=1\";s:60:\"forums/reply/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:44:\"index.php?reply=$matches[1]&feed=$matches[2]\";s:55:\"forums/reply/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:44:\"index.php?reply=$matches[1]&feed=$matches[2]\";s:41:\"forums/reply/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&paged=$matches[2]\";s:48:\"forums/reply/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?reply=$matches[1]&cpage=$matches[2]\";s:33:\"forums/reply/([^/]+)(/[0-9]+)?/?$\";s:44:\"index.php?reply=$matches[1]&page=$matches[2]\";s:29:\"forums/reply/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"forums/reply/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"forums/reply/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"forums/reply/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"forums/reply/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"forums/topic-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:59:\"forums/topic-tag/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:48:\"index.php?topic-tag=$matches[1]&feed=$matches[2]\";s:45:\"forums/topic-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?topic-tag=$matches[1]&paged=$matches[2]\";s:27:\"forums/topic-tag/([^/]+)/?$\";s:31:\"index.php?topic-tag=$matches[1]\";s:38:\"jobman_job/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"jobman_job/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"jobman_job/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"jobman_job/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"jobman_job/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"jobman_job/([^/]+)/trackback/?$\";s:37:\"index.php?jobman_job=$matches[1]&tb=1\";s:58:\"jobman_job/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?jobman_job=$matches[1]&feed=$matches[2]\";s:53:\"jobman_job/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?jobman_job=$matches[1]&feed=$matches[2]\";s:39:\"jobman_job/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?jobman_job=$matches[1]&paged=$matches[2]\";s:46:\"jobman_job/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?jobman_job=$matches[1]&cpage=$matches[2]\";s:31:\"jobman_job/([^/]+)(/[0-9]+)?/?$\";s:49:\"index.php?jobman_job=$matches[1]&page=$matches[2]\";s:27:\"jobman_job/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"jobman_job/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"jobman_job/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"jobman_job/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"jobman_job/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"jobman_joblist/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"jobman_joblist/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:79:\"jobman_joblist/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:74:\"jobman_joblist/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"jobman_joblist/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"jobman_joblist/([^/]+)/trackback/?$\";s:41:\"index.php?jobman_joblist=$matches[1]&tb=1\";s:62:\"jobman_joblist/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:53:\"index.php?jobman_joblist=$matches[1]&feed=$matches[2]\";s:57:\"jobman_joblist/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:53:\"index.php?jobman_joblist=$matches[1]&feed=$matches[2]\";s:43:\"jobman_joblist/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?jobman_joblist=$matches[1]&paged=$matches[2]\";s:50:\"jobman_joblist/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?jobman_joblist=$matches[1]&cpage=$matches[2]\";s:35:\"jobman_joblist/([^/]+)(/[0-9]+)?/?$\";s:53:\"index.php?jobman_joblist=$matches[1]&page=$matches[2]\";s:31:\"jobman_joblist/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"jobman_joblist/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"jobman_joblist/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"jobman_joblist/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"jobman_joblist/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"jobman_app_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"jobman_app_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"jobman_app_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"jobman_app_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"jobman_app_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"jobman_app_form/([^/]+)/trackback/?$\";s:42:\"index.php?jobman_app_form=$matches[1]&tb=1\";s:63:\"jobman_app_form/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:54:\"index.php?jobman_app_form=$matches[1]&feed=$matches[2]\";s:58:\"jobman_app_form/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:54:\"index.php?jobman_app_form=$matches[1]&feed=$matches[2]\";s:44:\"jobman_app_form/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?jobman_app_form=$matches[1]&paged=$matches[2]\";s:51:\"jobman_app_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?jobman_app_form=$matches[1]&cpage=$matches[2]\";s:36:\"jobman_app_form/([^/]+)(/[0-9]+)?/?$\";s:54:\"index.php?jobman_app_form=$matches[1]&page=$matches[2]\";s:32:\"jobman_app_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"jobman_app_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"jobman_app_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"jobman_app_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"jobman_app_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"jobman_app/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"jobman_app/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"jobman_app/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"jobman_app/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"jobman_app/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"jobman_app/([^/]+)/trackback/?$\";s:37:\"index.php?jobman_app=$matches[1]&tb=1\";s:58:\"jobman_app/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?jobman_app=$matches[1]&feed=$matches[2]\";s:53:\"jobman_app/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?jobman_app=$matches[1]&feed=$matches[2]\";s:39:\"jobman_app/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?jobman_app=$matches[1]&paged=$matches[2]\";s:46:\"jobman_app/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?jobman_app=$matches[1]&cpage=$matches[2]\";s:31:\"jobman_app/([^/]+)(/[0-9]+)?/?$\";s:49:\"index.php?jobman_app=$matches[1]&page=$matches[2]\";s:27:\"jobman_app/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"jobman_app/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"jobman_app/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"jobman_app/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"jobman_app/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"jobman_register/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"jobman_register/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"jobman_register/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"jobman_register/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"jobman_register/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"jobman_register/([^/]+)/trackback/?$\";s:42:\"index.php?jobman_register=$matches[1]&tb=1\";s:63:\"jobman_register/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:54:\"index.php?jobman_register=$matches[1]&feed=$matches[2]\";s:58:\"jobman_register/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:54:\"index.php?jobman_register=$matches[1]&feed=$matches[2]\";s:44:\"jobman_register/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?jobman_register=$matches[1]&paged=$matches[2]\";s:51:\"jobman_register/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?jobman_register=$matches[1]&cpage=$matches[2]\";s:36:\"jobman_register/([^/]+)(/[0-9]+)?/?$\";s:54:\"index.php?jobman_register=$matches[1]&page=$matches[2]\";s:32:\"jobman_register/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"jobman_register/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"jobman_register/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"jobman_register/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"jobman_register/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"jobman_email/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"jobman_email/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"jobman_email/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"jobman_email/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"jobman_email/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"jobman_email/([^/]+)/trackback/?$\";s:39:\"index.php?jobman_email=$matches[1]&tb=1\";s:60:\"jobman_email/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:51:\"index.php?jobman_email=$matches[1]&feed=$matches[2]\";s:55:\"jobman_email/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:51:\"index.php?jobman_email=$matches[1]&feed=$matches[2]\";s:41:\"jobman_email/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?jobman_email=$matches[1]&paged=$matches[2]\";s:48:\"jobman_email/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?jobman_email=$matches[1]&cpage=$matches[2]\";s:33:\"jobman_email/([^/]+)(/[0-9]+)?/?$\";s:51:\"index.php?jobman_email=$matches[1]&page=$matches[2]\";s:29:\"jobman_email/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"jobman_email/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"jobman_email/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"jobman_email/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"jobman_email/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"jobman_interview/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"jobman_interview/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:81:\"jobman_interview/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:76:\"jobman_interview/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"jobman_interview/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"jobman_interview/([^/]+)/trackback/?$\";s:43:\"index.php?jobman_interview=$matches[1]&tb=1\";s:64:\"jobman_interview/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:55:\"index.php?jobman_interview=$matches[1]&feed=$matches[2]\";s:59:\"jobman_interview/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:55:\"index.php?jobman_interview=$matches[1]&feed=$matches[2]\";s:45:\"jobman_interview/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?jobman_interview=$matches[1]&paged=$matches[2]\";s:52:\"jobman_interview/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?jobman_interview=$matches[1]&cpage=$matches[2]\";s:37:\"jobman_interview/([^/]+)(/[0-9]+)?/?$\";s:55:\"index.php?jobman_interview=$matches[1]&page=$matches[2]\";s:33:\"jobman_interview/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"jobman_interview/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"jobman_interview/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"jobman_interview/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"jobman_interview/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"jobs/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:43:\"index.php?jcat=$matches[1]&feed=$matches[2]\";s:47:\"jobs/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:43:\"index.php?jcat=$matches[1]&feed=$matches[2]\";s:33:\"jobs/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?jcat=$matches[1]&paged=$matches[2]\";s:15:\"jobs/([^/]+)/?$\";s:26:\"index.php?jcat=$matches[1]\";s:42:\"portfolio-item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"portfolio-item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:79:\"portfolio-item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:74:\"portfolio-item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"portfolio-item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:62:\"portfolio-item/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-item/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:43:\"portfolio-item/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:50:\"portfolio-item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:35:\"portfolio-item/([^/]+)(/[0-9]+)?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:31:\"portfolio-item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"portfolio-item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"portfolio-item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"portfolio-item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"portfolio-item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:65:\"portfolio_entries/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:60:\"portfolio_entries/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:56:\"index.php?portfolio_entries=$matches[1]&feed=$matches[2]\";s:46:\"portfolio_entries/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?portfolio_entries=$matches[1]&paged=$matches[2]\";s:28:\"portfolio_entries/([^/]+)/?$\";s:39:\"index.php?portfolio_entries=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:39:\"feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:34:\"(feed|rdf|rss|rss2|atom|jobman)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:48:\"comments/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:43:\"comments/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:51:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:46:\"search/(.+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:54:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:49:\"author/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:76:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:71:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:63:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:58:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:50:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:45:\"([0-9]{4})/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:47:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:42:\"(.?.+?)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:47:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:42:\"([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:20:\"([^/]+)(/[0-9]+)?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom|jobman)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";}","yes");
INSERT INTO `ts968ny_3_options` VALUES("741","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("742","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:50:\"
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Aug 2013 21:49:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://wordpress.org/?v=3.7-alpha-25157\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"WordPress 3.6 “Oscar”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"http://wordpress.org/news/2013/08/oscar/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wordpress.org/news/2013/08/oscar/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Aug 2013 21:43:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2661\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:368:\"The latest and greatest WordPress, version 3.6, is now live to the world and includes a beautiful new blog-centric theme, bullet-proof autosave and post locking, a revamped revision browser, native support for audio and video embeds, and improved integrations with Spotify, Rdio, and SoundCloud. Here&#8217;s a video that shows off some of the features using [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:18626:\"<p>The latest and greatest WordPress, version 3.6, is now <a href=\"http://wordpress.org/download/\">live to the world</a> and includes a beautiful new blog-centric theme, bullet-proof autosave and post locking, a revamped revision browser, native support for audio and video embeds, and improved integrations with Spotify, Rdio, and SoundCloud. Here&#8217;s a video that shows off some of the features using our cast of professional actors:</p>
<div id=\"v-UmhwbWJH-1\" class=\"video-player\"><embed id=\"v-UmhwbWJH-1-video\" src=\"http://s0.videopress.com/player.swf?v=1.03&amp;guid=UmhwbWJH&amp;isDynamicSeeking=true\" type=\"application/x-shockwave-flash\" width=\"692\" height=\"388\" title=\"Introducing WordPress 3.6 &quot;Oscar&quot;\" wmode=\"direct\" seamlesstabbing=\"true\" allowfullscreen=\"true\" allowscriptaccess=\"always\" overstretch=\"true\"></embed></div>
<p>We&#8217;re calling this release &#8220;Oscar&#8221; in honor of the great jazz pianist <a href=\"http://en.wikipedia.org/wiki/Oscar_Peterson\">Oscar Peterson</a>. Here&#8217;s a bit more about some of the new features, which you can also find on the about page in your dashboard after you upgrade.</p>
<h3>User Features</h3>
<p><img class=\"alignright\" alt=\"\" src=\"https://wordpress.org/images/core/3.6/twentythirteen.png\" width=\"300\" /></p>
<ul>
<li>The <strong>new Twenty Thirteen theme</strong> inspired by modern art puts focus on your content with a colorful, single-column design made for media-rich blogging.</li>
<li><strong>Revamped Revisions</strong> save every change and the new interface allows you to scroll easily through changes to see line-by-line who changed what and when.</li>
<li><strong>Post Locking</strong> and <strong>Augmented Autosave</strong> will especially be a boon to sites where more than a single author is working on a post. Each author now has their own autosave stream, which stores things locally as well as on the server (so much harder to lose something) and there&#8217;s an interface for taking over editing of a post, as demonstrated beautifully by our bearded buddies in the video above.</li>
<li><strong>Built-in HTML5 media player</strong> for native audio and video embeds with no reliance on external services.</li>
<li>The <strong>Menu Editor</strong> is now much easier to understand and use.</li>
</ul>
<h3>Developer features</h3>
<ul>
<li>A new audio/video API gives you access to metadata like ID3 tags.</li>
<li>You can now choose HTML5 markup for things like comment and search forms, and comment lists.</li>
<li>Better filters for how revisions work, so you can store a different amount of history for different post types.</li>
<li>Tons more <a href=\"http://codex.wordpress.org/Version_3.6\">listed on the Codex</a>, and of course you can always <a href=\"http://core.trac.wordpress.org/query?status=closed&amp;group=resolution&amp;milestone=3.6\">browse the over 700 closed tickets</a>.</li>
</ul>
<h3>The Band</h3>
<p>This release was led by <a href=\"http://markjaquith.com/\">Mark Jaquith</a> and <a href=\"http://geekreprieve.com/\">Aaron Campbell</a>, and included contributions from the following fine folks. Pull up some Oscar Peterson on your music service of choice, or vinyl if you have it, and check out some of their profiles:</p>
<p><a href=\"http://profiles.wordpress.org/technosailor\">Aaron Brazell</a>, <a href=\"http://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"http://profiles.wordpress.org/aaronholbrook\">Aaron Holbrook</a>, <a href=\"http://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"http://profiles.wordpress.org/kawauso\">Adam Harley</a>, <a href=\"http://profiles.wordpress.org/adamsilverstein\">adamsilverstein</a>, <a href=\"http://profiles.wordpress.org/akted\">AK Ted</a>, <a href=\"http://profiles.wordpress.org/xknown\">Alex Concha</a>, <a href=\"http://profiles.wordpress.org/alexkingorg\">Alex King</a>, <a href=\"http://profiles.wordpress.org/viper007bond\">Alex Mills (Viper007Bond)</a>, <a href=\"http://profiles.wordpress.org/momo360modena\">Amaury Balmer</a>, <a href=\"http://profiles.wordpress.org/sabreuse\">Amy Hendrix (sabreuse)</a>, <a href=\"http://profiles.wordpress.org/anatolbroder\">Anatol Broder</a>, <a href=\"http://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"http://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"http://profiles.wordpress.org/andrewryno\">Andrew Ryno</a>, <a href=\"http://profiles.wordpress.org/andy\">Andy Skelton</a>, <a href=\"http://profiles.wordpress.org/gorgoglionemeister\">Antonio</a>, <a href=\"http://profiles.wordpress.org/apimlott\">apimlott</a>, <a href=\"http://profiles.wordpress.org/awellis13\">awellis13</a>, <a href=\"http://profiles.wordpress.org/barry\">Barry</a>, <a href=\"http://profiles.wordpress.org/beaulebens\">Beau Lebens</a>, <a href=\"http://profiles.wordpress.org/belloswan\">BelloSwan</a>, <a href=\"http://profiles.wordpress.org/bilalcoder\">bilalcoder</a>, <a href=\"http://profiles.wordpress.org/bananastalktome\">Billy (bananastalktome)</a>, <a href=\"http://profiles.wordpress.org/bobbingwide\">bobbingwide</a>, <a href=\"http://profiles.wordpress.org/bobbravo2\">Bob Gregor</a>, <a href=\"http://profiles.wordpress.org/bradparbs\">bradparbs</a>, <a href=\"http://profiles.wordpress.org/bradyvercher\">Brady Vercher</a>, <a href=\"http://profiles.wordpress.org/kraftbj\">Brandon Kraft</a>, <a href=\"http://profiles.wordpress.org/brianlayman\">Brian Layman</a>, <a href=\"http://profiles.wordpress.org/beezeee\">Brian Zeligson</a>, <a href=\"http://profiles.wordpress.org/bpetty\">Bryan Petty</a>, <a href=\"http://profiles.wordpress.org/chmac\">Callum Macdonald</a>, <a href=\"http://profiles.wordpress.org/carldanley\">Carl Danley</a>, <a href=\"http://profiles.wordpress.org/caspie\">Caspie</a>, <a href=\"http://profiles.wordpress.org/charlestonsw\">Charleston Software Associates</a>, <a href=\"http://profiles.wordpress.org/cheeserolls\">cheeserolls</a>, <a href=\"http://profiles.wordpress.org/chipbennett\">Chip Bennett</a>, <a href=\"http://profiles.wordpress.org/c3mdigital\">Chris Olbekson</a>, <a href=\"http://profiles.wordpress.org/cochran\">Christopher Cochran</a>, <a href=\"http://profiles.wordpress.org/cfinke\">Christopher Finke</a>, <a href=\"http://profiles.wordpress.org/chriswallace\">Chris Wallace</a>, <a href=\"http://profiles.wordpress.org/corvannoorloos\">Cor van Noorloos</a>, <a href=\"http://profiles.wordpress.org/crazycoders\">crazycoders</a>, <a href=\"http://profiles.wordpress.org/danielbachhuber\">Daniel Bachhuber</a>, <a href=\"http://profiles.wordpress.org/mzaweb\">Daniel Dvorkin (MZAWeb)</a>, <a href=\"http://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"http://profiles.wordpress.org/daniloercoli\">daniloercoli</a>, <a href=\"http://profiles.wordpress.org/dannydehaan\">Danny de Haan</a>, <a href=\"http://profiles.wordpress.org/csixty4\">Dave Ross</a>, <a href=\"http://profiles.wordpress.org/dfavor\">David Favor</a>, <a href=\"http://profiles.wordpress.org/jdtrower\">David Trower</a>, <a href=\"http://profiles.wordpress.org/davidwilliamson\">David Williamson</a>, <a href=\"http://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"http://profiles.wordpress.org/dllh\">dllh</a>, <a href=\"http://profiles.wordpress.org/ocean90\">Dominik Schilling (ocean90)</a>, <a href=\"http://profiles.wordpress.org/dovyp\">dovyp</a>, <a href=\"http://profiles.wordpress.org/drewapicture\">Drew Jaynes (DrewAPicture)</a>, <a href=\"http://profiles.wordpress.org/dvarga\">dvarga</a>, <a href=\"http://profiles.wordpress.org/cais\">Edward Caissie</a>, <a href=\"http://profiles.wordpress.org/elfin\">elfin</a>, <a href=\"http://profiles.wordpress.org/empireoflight\">Empireoflight</a>, <a href=\"http://profiles.wordpress.org/ericlewis\">Eric Andrew Lewis</a>, <a href=\"http://profiles.wordpress.org/ethitter\">Erick Hitter</a>, <a href=\"http://profiles.wordpress.org/ericmann\">Eric Mann</a>, <a href=\"http://profiles.wordpress.org/evansolomon\">Evan Solomon</a>, <a href=\"http://profiles.wordpress.org/faishal\">faishal</a>, <a href=\"http://profiles.wordpress.org/feedmeastraycat\">feedmeastraycat</a>, <a href=\"http://profiles.wordpress.org/frank-klein\">Frank Klein</a>, <a href=\"http://profiles.wordpress.org/f-j-kaiser\">Franz Josef Kaiser</a>, <a href=\"http://profiles.wordpress.org/fstop\">FStop</a>, <a href=\"http://profiles.wordpress.org/mintindeed\">Gabriel Koen</a>, <a href=\"http://profiles.wordpress.org/garyc40\">Gary Cao</a>, <a href=\"http://profiles.wordpress.org/garyj\">Gary Jones</a>, <a href=\"http://profiles.wordpress.org/gcorne\">gcorne</a>, <a href=\"http://profiles.wordpress.org/geertdd\">GeertDD</a>, <a href=\"http://profiles.wordpress.org/soulseekah\">Gennady Kovshenin</a>, <a href=\"http://profiles.wordpress.org/georgestephanis\">George Stephanis</a>, <a href=\"http://profiles.wordpress.org/gish\">gish</a>, <a href=\"http://profiles.wordpress.org/tivnet\">Gregory Karpinsky</a>, <a href=\"http://profiles.wordpress.org/hakre\">hakre</a>, <a href=\"http://profiles.wordpress.org/hbanken\">hbanken</a>, <a href=\"http://profiles.wordpress.org/hebbet\">hebbet</a>, <a href=\"http://profiles.wordpress.org/helen\">Helen Hou-Sandi</a>, <a href=\"http://profiles.wordpress.org/helgatheviking\">helgatheviking</a>, <a href=\"http://profiles.wordpress.org/hirozed\">hirozed</a>, <a href=\"http://profiles.wordpress.org/hurtige\">hurtige</a>, <a href=\"http://profiles.wordpress.org/hypertextranch\">hypertextranch</a>, <a href=\"http://profiles.wordpress.org/iandunn\">Ian Dunn</a>, <a href=\"http://profiles.wordpress.org/ipstenu\">Ipstenu (Mika Epstein)</a>, <a href=\"http://profiles.wordpress.org/jakub\">jakub</a>, <a href=\"http://profiles.wordpress.org/h4ck3rm1k3\">James Michael DuPont</a>, <a href=\"http://profiles.wordpress.org/jbutkus\">jbutkus</a>, <a href=\"http://profiles.wordpress.org/jeremyfelt\">Jeremy Felt</a>, <a href=\"http://profiles.wordpress.org/jerrysarcastic\">Jerry Bates (JerrySarcastic)</a>, <a href=\"http://profiles.wordpress.org/jayjdk\">Jesper Johansen (Jayjdk)</a>, <a href=\"http://profiles.wordpress.org/joehoyle\">Joe Hoyle</a>, <a href=\"http://profiles.wordpress.org/joen\">Joen Asmussen</a>, <a href=\"http://profiles.wordpress.org/jkudish\">Joey Kudish</a>, <a href=\"http://profiles.wordpress.org/johnbillion\">John Blackbourn (johnbillion)</a>, <a href=\"http://profiles.wordpress.org/johnjamesjacoby\">John James Jacoby</a>, <a href=\"http://profiles.wordpress.org/jond3r\">Jonas Bolinder (jond3r)</a>, <a href=\"http://profiles.wordpress.org/desrosj\">Jonathan Desrosiers</a>, <a href=\"http://profiles.wordpress.org/jonbishop\">Jon Bishop</a>, <a href=\"http://profiles.wordpress.org/duck_\">Jon Cave</a>, <a href=\"http://profiles.wordpress.org/jcastaneda\">Jose Castaneda</a>, <a href=\"http://profiles.wordpress.org/josephscott\">Joseph Scott</a>, <a href=\"http://profiles.wordpress.org/jvisick77\">Josh Visick</a>, <a href=\"http://profiles.wordpress.org/jrbeilke\">jrbeilke</a>, <a href=\"http://profiles.wordpress.org/jrf\">jrf</a>, <a href=\"http://profiles.wordpress.org/devesine\">Justin de Vesine</a>, <a href=\"http://profiles.wordpress.org/justinsainton\">Justin Sainton</a>, <a href=\"http://profiles.wordpress.org/kadamwhite\">kadamwhite</a>, <a href=\"http://profiles.wordpress.org/trepmal\">Kailey (trepmal)</a>, <a href=\"http://profiles.wordpress.org/karmatosed\">karmatosed</a>, <a href=\"http://profiles.wordpress.org/ryelle\">Kelly Dwan</a>, <a href=\"http://profiles.wordpress.org/keoshi\">keoshi</a>, <a href=\"http://profiles.wordpress.org/kovshenin\">Konstantin Kovshenin</a>, <a href=\"http://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"http://profiles.wordpress.org/ktdreyer\">ktdreyer</a>, <a href=\"http://profiles.wordpress.org/kurtpayne\">Kurt Payne</a>, <a href=\"http://profiles.wordpress.org/kwight\">kwight</a>, <a href=\"http://profiles.wordpress.org/lancewillett\">Lance Willett</a>, <a href=\"http://profiles.wordpress.org/leewillis77\">Lee Willis (leewillis77)</a>, <a href=\"http://profiles.wordpress.org/lessbloat\">lessbloat</a>, <a href=\"http://profiles.wordpress.org/settle\">Mantas Malcius</a>, <a href=\"http://profiles.wordpress.org/maor\">Maor Chasen</a>, <a href=\"http://profiles.wordpress.org/macbrink\">Marcel Brinkkemper</a>, <a href=\"http://profiles.wordpress.org/marcuspope\">MarcusPope</a>, <a href=\"http://profiles.wordpress.org/mark-k\">Mark-k</a>, <a href=\"http://profiles.wordpress.org/markjaquith\">Mark Jaquith</a>, <a href=\"http://profiles.wordpress.org/markmcwilliams\">Mark McWilliams</a>, <a href=\"http://profiles.wordpress.org/markoheijnen\">Marko Heijnen</a>, <a href=\"http://profiles.wordpress.org/mjbanks\">Matt Banks</a>, <a href=\"http://profiles.wordpress.org/mboynes\">Matthew Boynes</a>, <a href=\"http://profiles.wordpress.org/matthewruddy\">MatthewRuddy</a>, <a href=\"http://profiles.wordpress.org/mattwiebe\">Matt Wiebe</a>, <a href=\"http://profiles.wordpress.org/maxcutler\">Max Cutler</a>, <a href=\"http://profiles.wordpress.org/melchoyce\">Mel Choyce</a>, <a href=\"http://profiles.wordpress.org/mgibbs189\">mgibbs189</a>, <a href=\"http://profiles.wordpress.org/fanquake\">Michael</a>, <a href=\"http://profiles.wordpress.org/mdawaffe\">Michael Adams (mdawaffe)</a>, <a href=\"http://profiles.wordpress.org/tw2113\">Michael Beckwith</a>, <a href=\"http://profiles.wordpress.org/mfields\">Michael Fields</a>, <a href=\"http://profiles.wordpress.org/mikehansenme\">Mike Hansen</a>, <a href=\"http://profiles.wordpress.org/dh-shredder\">Mike Schroder</a>, <a href=\"http://profiles.wordpress.org/dimadin\">Milan Dinic</a>, <a href=\"http://profiles.wordpress.org/mitchoyoshitaka\">mitcho (Michael Yoshitaka Erlewine)</a>, <a href=\"http://profiles.wordpress.org/batmoo\">Mohammad Jangda</a>, <a href=\"http://profiles.wordpress.org/najamelan\">najamelan</a>, <a href=\"http://profiles.wordpress.org/Nao\">Naoko Takano</a>, <a href=\"http://profiles.wordpress.org/alex-ye\">Nashwan Doaqan</a>, <a href=\"http://profiles.wordpress.org/niallkennedy\">Niall Kennedy</a>, <a href=\"http://profiles.wordpress.org/nickdaugherty\">Nick Daugherty</a>, <a href=\"http://profiles.wordpress.org/celloexpressions\">Nick Halsey</a>, <a href=\"http://profiles.wordpress.org/ninnypants\">ninnypants</a>, <a href=\"http://profiles.wordpress.org/norcross\">norcross</a>, <a href=\"http://profiles.wordpress.org/paradiseporridge\">ParadisePorridge</a>, <a href=\"http://profiles.wordpress.org/pauldewouters\">Paul</a>, <a href=\"http://profiles.wordpress.org/pdclark\">Paul Clark</a>, <a href=\"http://profiles.wordpress.org/pavelevap\">pavelevap</a>, <a href=\"http://profiles.wordpress.org/petemall\">Pete Mall</a>, <a href=\"http://profiles.wordpress.org/westi\">Peter Westwood</a>, <a href=\"http://profiles.wordpress.org/phill_brown\">Phill Brown</a>, <a href=\"http://profiles.wordpress.org/mordauk\">Pippin Williamson</a>, <a href=\"http://profiles.wordpress.org/pollett\">Pollett</a>, <a href=\"http://profiles.wordpress.org/nprasath002\">Prasath Nadarajah</a>, <a href=\"http://profiles.wordpress.org/programmin\">programmin</a>, <a href=\"http://profiles.wordpress.org/rachelbaker\">rachelbaker</a>, <a href=\"http://profiles.wordpress.org/ramiy\">Rami Yushuvaev</a>, <a href=\"http://profiles.wordpress.org/redpixelstudios\">redpixelstudios</a>, <a href=\"http://profiles.wordpress.org/reidburke\">reidburke</a>, <a href=\"http://profiles.wordpress.org/retlehs\">retlehs</a>, <a href=\"http://profiles.wordpress.org/greuben\">Reuben Gunday</a>, <a href=\"http://profiles.wordpress.org/rlerdorf\">rlerdorf</a>, <a href=\"http://profiles.wordpress.org/rodrigosprimo\">Rodrigo Primo</a>, <a href=\"http://profiles.wordpress.org/roulandf\">roulandf</a>, <a href=\"http://profiles.wordpress.org/rovo89\">rovo89</a>, <a href=\"http://profiles.wordpress.org/ryanduff\">Ryan Duff</a>, <a href=\"http://profiles.wordpress.org/ryanhellyer\">Ryan Hellyer</a>, <a href=\"http://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"http://profiles.wordpress.org/zeo\">Safirul Alredha</a>, <a href=\"http://profiles.wordpress.org/saracannon\">sara cannon</a>, <a href=\"http://profiles.wordpress.org/scholesmafia\">scholesmafia</a>, <a href=\"http://profiles.wordpress.org/sc0ttkclark\">Scott Kingsley Clark</a>, <a href=\"http://profiles.wordpress.org/coffee2code\">Scott Reilly</a>, <a href=\"http://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"http://profiles.wordpress.org/scribu\">scribu</a>, <a href=\"http://profiles.wordpress.org/tenpura\">Seisuke Kuraishi (tenpura)</a>, <a href=\"http://profiles.wordpress.org/sergej\">Sergej</a>, <a href=\"http://profiles.wordpress.org/sergeybiryukov\">Sergey Biryukov</a>, <a href=\"http://profiles.wordpress.org/sim\">Simon Hampel</a>, <a href=\"http://profiles.wordpress.org/simonwheatley\">Simon Wheatley</a>, <a href=\"http://profiles.wordpress.org/siobhan\">Siobhan</a>, <a href=\"http://profiles.wordpress.org/sirzooro\">sirzooro</a>, <a href=\"http://profiles.wordpress.org/slene\">slene</a>, <a href=\"http://profiles.wordpress.org/solarissmoke\">solarissmoke</a>, <a href=\"http://profiles.wordpress.org/srinig\">SriniG</a>, <a href=\"http://profiles.wordpress.org/stephenh1988\">Stephen Harris</a>, <a href=\"http://profiles.wordpress.org/storkontheroof\">storkontheroof</a>, <a href=\"http://profiles.wordpress.org/sunnyratilal\">Sunny Ratilal</a>, <a href=\"http://profiles.wordpress.org/sweetie089\">sweetie089</a>, <a href=\"http://profiles.wordpress.org/tar\">Tar</a>, <a href=\"http://profiles.wordpress.org/tlovett1\">Taylor Lovett</a>, <a href=\"http://profiles.wordpress.org/thomasvanderbeek\">Thomas van der Beek</a>, <a href=\"http://profiles.wordpress.org/n7studios\">Tim Carr</a>, <a href=\"http://profiles.wordpress.org/tjsingleton\">tjsingleton</a>, <a href=\"http://profiles.wordpress.org/tobiasbg\">TobiasBg</a>, <a href=\"http://profiles.wordpress.org/toscho\">toscho</a>, <a href=\"http://profiles.wordpress.org/taupecat\">Tracy Rotton</a>, <a href=\"http://profiles.wordpress.org/travishoffman\">TravisHoffman</a>, <a href=\"http://profiles.wordpress.org/uuf6429\">uuf6429</a>, <a href=\"http://profiles.wordpress.org/lightningspirit\">Vitor Carvalho</a>, <a href=\"http://profiles.wordpress.org/wojtek\">wojtek</a>, <a href=\"http://profiles.wordpress.org/wpewill\">wpewill</a>, <a href=\"http://profiles.wordpress.org/wraithkenny\">WraithKenny</a>, <a href=\"http://profiles.wordpress.org/wycks\">wycks</a>, <a href=\"http://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"http://profiles.wordpress.org/yoavf\">Yoav Farhi</a>, <a href=\"http://profiles.wordpress.org/thelastcicada\">Zachary Brown</a>, <a href=\"http://profiles.wordpress.org/tollmanz\">Zack Tollman</a>, <a href=\"http://profiles.wordpress.org/zekeweeks\">zekeweeks</a>, <a href=\"http://profiles.wordpress.org/ziegenberg\">ziegenberg</a>, and <a href=\"http://profiles.wordpress.org/viniciusmassuchetto\">viniciusmassuchetto</a>.</p>
<p>Time to upgrade!</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"http://wordpress.org/news/2013/08/oscar/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:45:\"
		
		
		
		
		
				
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WordPress 3.6 Release Candidate 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wordpress.org/news/2013/07/wordpress-3-6-release-candidate-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wordpress.org/news/2013/07/wordpress-3-6-release-candidate-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Jul 2013 07:25:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2649\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:341:\"The second release candidate for WordPress 3.6 is now available for download and testing. We&#8217;re down to only a few remaining issues, and the final release should be available in a matter of days. In RC2, we&#8217;ve tightened up some aspects of revisions, autosave, and the media player, and fixed some bugs that were spotted [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mark Jaquith\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1325:\"<p>The second release candidate for WordPress 3.6 is now available for download and testing.</p>
<p>We&#8217;re down to only a few remaining issues, and the final release should be available in a matter of days. In RC2, we&#8217;ve tightened up some aspects of revisions, autosave, and the media player, and fixed some bugs that were spotted in RC1. Please test this release candidate as much as you can, so we can deliver a smooth final release!</p>
<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"http://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area in the support forums</a>.</p>
<p><strong>Developers,</strong> please continue to test your plugins and themes, so that if there is a compatibility issue, we can figure it out before the final release. You can find our <a href=\"http://core.trac.wordpress.org/report/6\">list of known issues here</a>.</p>
<p>To test WordPress 3.6, try the <a href=\"http://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"http://wordpress.org/wordpress-3.6-RC2.zip\">download the release candidate here (zip)</a>.</p>
<p><em>Revisions so smooth</em><br />
<em>We autosave your changes</em><br />
<em>Data loss begone!</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wordpress.org/news/2013/07/wordpress-3-6-release-candidate-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:45:\"
		
		
		
		
		
				
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 3.6 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wordpress.org/news/2013/07/wordpress-3-6-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"http://wordpress.org/news/2013/07/wordpress-3-6-release-candidate/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 13 Jul 2013 03:23:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2639\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"The first release candidate for WordPress 3.6 is now available. We hope to ship WordPress 3.6 in a couple weeks. But to do that, we really need your help! If you haven&#8217;t tested 3.6 yet, there&#8217;s no time like the present. (But please: not on a live production site, unless you&#8217;re feeling especially adventurous.) Think [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mark Jaquith\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1504:\"<p>The first release candidate for WordPress 3.6 is now available.</p>
<p>We hope to ship WordPress 3.6 in a couple weeks. But to do that, we really need your help! If you haven&#8217;t tested 3.6 yet, there&#8217;s no time like the present. (But please: not on a live production site, unless you&#8217;re feeling especially adventurous.)</p>
<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"http://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area in the support forums</a>. If any known issues come up, you’ll be able to <a href=\"http://core.trac.wordpress.org/report/6\">find them here</a>. <strong>Developers,</strong> please test your plugins and themes, so that if there is a compatibility issue, we can sort it out before the final release.</p>
<p>To test WordPress 3.6, try the <a href=\"http://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you&#8217;ll want &#8220;bleeding edge nightlies&#8221;). Or you can <a href=\"http://wordpress.org/wordpress-3.6-RC1.zip\">download the release candidate here (zip)</a>.</p>
<p>As you may have heard, we backed the Post Format UI feature out of the release. On the other hand, our slick new revisions browser had some extra time to develop. You should see it with 200+ revisions loaded — scrubbing back and forth at lightning speed is a thing of beauty.</p>
<p><em>Delayed, but still loved</em><br />
<em>The release will be out soon</em><br />
<em>Test it, por favor</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"http://wordpress.org/news/2013/07/wordpress-3-6-release-candidate/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:45:\"
		
		
		
		
		
				
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Annual WordPress Survey &amp; WCSF\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://wordpress.org/news/2013/07/annual-wordpress-survey-wcsf/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wordpress.org/news/2013/07/annual-wordpress-survey-wcsf/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 09 Jul 2013 23:50:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2625\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"It&#8217;s time for our third annual user and developer survey! If you&#8217;re a WordPress user, developer, or business, we want your feedback. Just like previous years, we&#8217;ll share the data at the upcoming WordCamp San Francisco (WCSF). Results will also be sent to each survey respondent. It only takes a few minutes to fill out [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1242:\"<p><img class=\"alignright\" alt=\"\" align=\"right\" src=\"http://wpdotorg.files.wordpress.com/2013/07/wcsf-2013.jpg\" width=\"278\" height=\"185\" />It&#8217;s time for our third annual user and developer survey! If you&#8217;re a WordPress user, developer, or business, we want your feedback. Just like previous years, we&#8217;ll share the data at the upcoming <a href=\"http://2013.sf.wordcamp.org/\">WordCamp San Francisco</a> (WCSF). Results will also be sent to each survey respondent.</p>
<p>It only takes a few minutes to <a href=\"http://wp-survey.polldaddy.com/s/wp-2013\">fill out the survey</a>, which will provide an overview of how people use WordPress.</p>
<p>If you missed past State of the Word keynotes, be sure to check out them out for survey results from <a href=\"http://wordpress.org/news/2011/08/state-of-the-word/\">2011</a> and <a href=\"http://ma.tt/2012/08/state-of-the-word-2012/\">2012</a>.</p>
<p>Speaking of WCSF, if you didn&#8217;t get a ticket or are too far away to attend, you can still <a href=\"http://2013.sf.wordcamp.org/tickets/\">get a ticket for the live stream</a>! Watch the live video stream from the comfort of your home on July 26 and 27; WCSF t-shirt, or any shirt, optional.</p>
<p>I hope to see you there.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wordpress.org/news/2013/07/annual-wordpress-survey-wcsf/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:45:\"
		
		
		
		
		
				
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 3.5.2 Maintenance and Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"http://wordpress.org/news/2013/06/wordpress-3-5-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"http://wordpress.org/news/2013/06/wordpress-3-5-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Jun 2013 19:54:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2612\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:380:\"WordPress 3.5.2 is now available. This is the second maintenance release of 3.5, fixing 12 bugs. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. The WordPress security team resolved seven security issues, and this release also contains some additional security hardening. The security fixes included: [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Andrew Nacin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2549:\"<p>WordPress 3.5.2 is now available. This is the second maintenance release of 3.5, fixing <a href=\"http://core.trac.wordpress.org/query?status=closed&amp;group=resolution&amp;milestone=3.5.2\">12 bugs</a>. <strong>This is a security release for all previous versions and we strongly encourage you to update your sites immediately.</strong> The WordPress security team resolved seven security issues, and this release also contains some additional security hardening.</p>
<p>The security fixes included:</p>
<ul>
<li>Blocking server-side request forgery attacks, which could potentially enable an attacker to gain access to a site.</li>
<li>Disallow contributors from improperly publishing posts, reported by <a href=\"http://kovshenin.com/\">Konstantin Kovshenin</a>, or reassigning the post&#8217;s authorship, reported by <a href=\"http://www.sharefaith.com/\">Luke Bryan</a>.</li>
<li>An update to the SWFUpload external library to fix cross-site scripting vulnerabilities. Reported by <a href=\"http://ma.la\">mala</a> and <a href=\"http://mars.iti.pk.edu.pl/~grucha/\">Szymon Gruszecki</a>. (Developers: More on SWFUpload <a href=\"http://make.wordpress.org/core/2013/06/21/secure-swfupload/\">here</a>.)</li>
<li>Prevention of a denial of service attack, affecting sites using password-protected posts.</li>
<li>An update to an external TinyMCE library to fix a cross-site scripting vulnerability. Reported by <a href=\"http://twitter.com/rinakikun\">Wan Ikram</a>.</li>
<li>Multiple fixes for cross-site scripting. Reported by <a href=\"http://webapplicationsecurity.altervista.org/\">Andrea Santese</a> and Rodrigo.</li>
<li>Avoid disclosing a full file path when a upload fails. Reported by <a href=\"http://hauntit.blogspot.de/\">Jakub Galczyk</a>.</li>
</ul>
<p>We appreciated <a href=\"http://codex.wordpress.org/FAQ_Security\">responsible disclosure</a> of these issues directly to our security team. For more information on the changes, see the <a href=\"http://codex.wordpress.org/Version_3.5.2\">release notes</a> or consult <a href=\"http://core.trac.wordpress.org/log/branches/3.5?rev=24498&amp;stop_rev=23347\">the list of changes</a>.</p>
<p><a href=\"http://wordpress.org/wordpress-3.5.2.zip\">Download WordPress 3.5.2</a> or update now from the Dashboard → Updates menu in your site’s admin area.</p>
<p><em>Also:</em> <strong>WordPress 3.6 Beta 4:</strong> If you are testing WordPress 3.6, please note that <a href=\"http://wordpress.org/wordpress-3.6-beta4.zip\">WordPress 3.6 Beta 4</a> (zip) includes fixes for these security issues.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2013/06/wordpress-3-5-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Ten Good Years\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wordpress.org/news/2013/05/ten-good-years/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://wordpress.org/news/2013/05/ten-good-years/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 May 2013 17:54:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Meta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2606\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:343:\"It&#8217;s been ten years since we started this thing, and what a long way we&#8217;ve come. From a discussion between myself and Mike Little about forking our favorite blogging software, to powering 18% of the web. It&#8217;s been a crazy, exciting, journey, and one that won&#8217;t stop any time soon. At ten years, it&#8217;s fun [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9852:\"<p><img class=\"alignright\" alt=\"\" align=\"right\" src=\"http://wpdotorg.files.wordpress.com/2013/05/wp10.jpg\" width=\"316\" height=\"164\" />It&#8217;s been ten years since we started this thing, and what a long way we&#8217;ve come. From a discussion between myself and <a href=\"http://mikelittle.org/\">Mike Little</a> about <a href=\"http://ma.tt/2003/01/the-blogging-software-dilemma/\">forking our favorite blogging software</a>, to powering 18% of the web. It&#8217;s been a crazy, exciting, journey, and one that won&#8217;t stop any time soon.</p>
<p>At ten years, it&#8217;s fun to reflect on our beginnings. We launched WordPress on 27th May 2003, but that wasn&#8217;t inception. Go back far enough, and you can <a href=\"http://zengun.org/weblog/archives/2001/06/post1958/\">read a post by Michel Valdrighi</a> who, frustrated by the self-hosted blogging platforms available, decided to write his own software; &#8220;b2, a PHP+MySQL alternative to Blogger and GreyMatter.&#8221; b2 was easy to install, easy to configure, and easy for developers to extend. Of all the blogging platforms out there, <a href=\"http://cafelog.com\">b2</a> was the right one for me: I could write my content and get it on the web quickly and painlessly.</p>
<p>Sometimes, however, life gets in the way. In 2002, Michel stopped maintaining b2. Over time, security flaws became apparent and updates were needed and, while the b2 community could write patches and fixes, no one was driving the software forward. We were lucky that Michel decided to release b2 under the GPL; the software may have been abandoned, but we weren&#8217;t without options. A fork was always a possibility. That was where it stood in January 2003, when <a href=\"http://ma.tt/2003/01/the-blogging-software-dilemma/\">I posted about forking b2</a> and <a href=\"http://ma.tt/2003/01/the-blogging-software-dilemma/#comment-445\">Mike responded</a>. The rest, as they say, is history.</p>
<p>From the very beginning to the present day, I&#8217;ve been impressed by the thought, care, and dedication that WordPress&#8217; developers have demonstrated. Each one has brought his or her unique perspective, each individual has strengthened the whole. It would be impossible to thank each of them here individually, but their achievements speak for themselves. In WordPress 1.2 the new Plugin API made it easy for developers to extend WordPress. In the same release <code>gettext()</code> internationalization opened WordPress up to every language (hat tip: <a href=\"http://ryan.boren.me/\">Ryan Boren</a> for spending hours wrapping strings with gettext). In WordPress 1.5 our Theme system made it possible for WordPress users to quickly change their site&#8217;s design: there was huge resistance to the theme system from the wider community at the time, but can you imagine WordPress without it? Versions 2.7, 2.8, and 2.9 saw improvements that let users install and update their plugins and themes with one click. WordPress has seen a redesign by <a href=\"http://v2.happycog.com/create/wordpress/?p=design/wordpress/\">happycog</a> (2.3) and gone under extensive user testing and redesign (<a href=\"http://www.slideshare.net/edanzico/riding-the-crazyhorse-future-generation-wordpress-presentation\">Crazyhorse</a>, Liz Danzico and Jen Mylo, WordPress 2.5). In WordPress 3.0 we merged WordPress MU with WordPress &#8212; a huge job but 100% worth it. And in WordPress 3.5 we revamped the media uploader to make it easier for people to get their images, video, and media online.</p>
<p>In sticking to our commitment to user experience, we&#8217;ve done a few things that have made us unpopular. The <a href=\"http://tech.gaeatimes.com/index.php/archive/wordpress-wysiwyg-editor-is-a-disaster/\">WYSIWYG editor</a> was hated by many, especially those who felt that if you have a blog you should know HTML. Some developers hated that we stuck with our code, refusing to rewrite, but it&#8217;s always been the users that matter: better a developer lose sleep than a site break for a user. Our code isn&#8217;t always beautiful, after all, when WordPress was created most of us were still learning PHP, but we try to make a flawless experience for users.</p>
<p>It&#8217;s not all about developers. WordPress&#8217; strength lies in the diversity of its community. From the start, we wanted a low barrier to entry and we came up with our &#8220;famous 5 minute install&#8221;. This brought on board users from varied technical background: people who didn&#8217;t write code wanted to help make WordPress better. If you couldn&#8217;t write code, it didn&#8217;t matter: you could answer a question in the support forums, write documentation, translate WordPress, or build your friends and family a WordPress website. There is <a href=\"https://make.wordpress.org/\">space in the community</a> for anyone with a passion for WordPress.</p>
<p>It&#8217;s been wonderful to see all of the people who have used WordPress to build their home on the internet. Early on <a href=\"http://wordpress.org/news/2004/04/switchers/\">we got excited</a> by <a href=\"http://wordpress.org/news/2004/04/more-switchers/\">switchers</a>. From a community of tinkerers we grew, as writers such as <a href=\"http://ma.tt/2004/05/om-malik/\">Om Malik</a>, <a href=\"http://dougal.gunters.org/blog/2004/05/15/mark-pilgrim-switches/\">Mark Pilgrim</a>, and <a href=\"http://ma.tt/2004/07/mollycom-switches/\">Molly Holzschlag</a> made the switch to WordPress. Our commitment to effortless publishing quickly paid off and has continued to do so: <strong>the WordPress 1.2 release saw 822 downloads per day, our latest release, WordPress 3.5, has seen 145,692 per day.</strong></p>
<p>I&#8217;m continually amazed by what people have built with WordPress. I&#8217;ve seen <a href=\"http://justintimberlake.com/main/\">musicians</a> and <a href=\"http://ma.tt/2013/01/neil-leifer-on-wordpress/\">photographers</a>, magazines such as <a href=\"http://life.time.com/\">Life</a>, <a href=\"http://boingboing.net/\">BoingBoing</a>, and the <a href=\"http://observer.com/\">New York Observer</a>, <a href=\"http://www.compliance.gov/\">government websites</a>, a <a href=\"http://josephscott.org/archives/2011/05/pressfs-a-wordpress-filesystem/\">filesystem</a>, <a href=\"http://www.ymcanyc.org/association/pages/y-mvp\"> mobile applications</a>, and even <a href=\"http://www.viper007bond.com/2010/06/12/so-apparently-wordpress-can-guide-missiles/\">seen WordPress guide missiles</a>.</p>
<p>As the web evolves, WordPress evolves. Factors outside of our control will always influence WordPress&#8217; development: today it&#8217;s mobile devices and retina display, tomorrow it could be Google Glass or technology not yet conceived. A lot can happen in ten years! As technology changes and advances, WordPress has to change with it while remaining true to its core values: making publishing online easy for everyone. How we rise to these challenges will be what defines WordPress over the coming ten years.</p>
<p><strong>To celebrate ten years of WordPress, we&#8217;re working on a book about our history.</strong> We&#8217;re carrying out interviews with people who have involved with the community from the very beginning, those who are still around, and those who have left. It&#8217;s a huge project, but we wanted to have something to share with you on the 10th anniversary. To learn about the very early days of WordPress, just after Mike and I forked b2 <a href=\"http://wordpress.org/about/history/\">you can download Chapter 3 right here</a>. We&#8217;ll be releasing the rest of the book serially, so watch out as the story of the last ten years emerges.</p>
<p>In the meantime, <a href=\"http://ma.tt/2013/05/dear-wordpress/\"> I penned my own letter to WordPress</a> and other community members have been sharing their thoughts:</p>
<ul>
<li><a href=\"http://zed1.com/journalized/archives/2013/01/25/wordpress-a-10-year-journey/\">Mike Little on our Ten Year Journey</a>.</li>
<li>Core contributor Helen Hou-Sandi <a href=\"http://helen.wordpress.com/2013/05/27/happy-10th-wordpress-and-thanks-from-my-little-family/\">wishes WordPress happy birthday</a>.</li>
<li>Peter Westwood on <a href=\"http://blog.ftwr.co.uk/archives/2013/05/27/a-decade-gone-more-to-come/\">a decade gone</a>.</li>
<li>Support rep Mika Epstein <a href=\"http://ipstenu.org/2013/you-me-and-wp/\">on her WordPress journey</a>.</li>
<li>Dougal Campbell <a href=\"http://dougal.gunters.org/blog/2013/05/27/instagram-my-wife-suzecampbell-and-i-celebrating-the-wordpress-10th-anniversary-with-bbq-in-our-wordpress-shirts-wp10/\">celebrating with his wife, Suze</a>.</li>
<li>Otto on <a href=\"http://ottodestruct.com/blog/2013/how-wp-affected-me/\">how WordPress affected him</a>.</li>
</ul>
<p>You can see how WordPress&#8217; 10th Anniversary was celebrated all over the world <a href=\"http://wp10.wordpress.net/\">by visiting the wp10 website</a>, according to Meetup we had 4,999 celebrators.</p>
<p>To finish, I just want to say thank you to everyone: to the developers who write the code, to the designers who make WordPress sing, to the worldwide community translating WordPress into so many languages, to volunteers who answer support questions, to those who make WordPress accessible, to the systems team and the plugin and theme reviewers, to documentation writers, event organisers, evangelists, detractors, supporters and friends. Thanks to the jazzers whose music inspired us and whose names are at the heart of WordPress. Thanks to everyone who uses WordPress to power their blog or website, and to everyone who will in the future. Thanks to WordPress and its community that I&#8217;m proud to be part of.</p>
<p>Thank you. I can&#8217;t wait to see what the next ten years bring.</p>
<p><em>Final thanks to <a href=\"http://siobhanmckeown.com/\">Siobhan McKeown</a> for help with this post.</em></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"http://wordpress.org/news/2013/05/ten-good-years/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"The Next 10 Starts Now\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"http://wordpress.org/news/2013/05/the-next-10-starts-now/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wordpress.org/news/2013/05/the-next-10-starts-now/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 May 2013 20:47:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2594\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:365:\"All around the globe today, people are celebrating the 10th anniversary of the first WordPress release, affectionately known as #wp10. Watching the feed of photos, tweets, and posts from Auckland to Zambia is incredible; from first-time bloggers to successful WordPress-based business owners, people are coming out in droves to raise a glass and share the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Jen Mylo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3901:\"<p>All around the globe today, people are celebrating the 10th anniversary of the first WordPress release, affectionately known as #wp10. <a href=\"http://wp10.wordpress.net\">Watching the feed</a> of photos, tweets, and posts from Auckland to Zambia is incredible; from first-time bloggers to successful WordPress-based business owners, people are coming out in droves to raise a glass and share the &#8220;holiday&#8221; with their local communities. With hundreds of parties going on today, it&#8217;s more visible than ever just how popular WordPress has become.</p>
<p><strong>Thank you to everyone who has ever contributed to this project: your labors of love made this day possible.</strong></p>
<p>But today isn&#8217;t just about reflecting on how we got this far (though I thought <a href=\"http://ma.tt/2013/05/dear-wordpress/\">Matt&#8217;s reflection on the first ten years</a> was lovely). We are constantly moving forward. As each release cycle begins and ends (3.6 will be here soon, promise!), we always see an ebb and flow in the contributor pool. Part of ensuring the longevity of WordPress means mentoring new contributors, continually bringing new talent and fresh points of view to our family table.</p>
<p>I am beyond pleased to announce that this summer we will be mentoring 8 interns, most of them new contributors, through <a href=\"http://www.google-melange.com/gsoc/homepage/google/gsoc2013\">Google Summer of Code</a> and the <a href=\"https://live.gnome.org/OutreachProgramForWomen/2013/JuneSeptember\">Gnome Outreach Program for Women</a>. Current contributors, who already volunteer their time working on WordPress, will provide the guidance and oversight for a variety of exciting projects  this summer. Here are the people/projects involved in the summer internships:</p>
<ul>
<li><strong><strong>Ryan McCue</strong>, </strong>from Australia, working on a JSON-based REST API. Mentors will be Bryan Petty and Eric Mann, with a reviewer assist from Andrew Norcross.</li>
<li><strong>Kat Hagan</strong>, from the United States, working on a Post by Email plugin to replace the core function. Mentors will be Justin Shreve and George Stephanis, with an assist from Peter Westwood.</li>
<li><strong>Siobhan Bamber</strong>, from Wales, working on a support (forums, training, documentation) internship. Mentors will be Mika Epstein and Hanni Ross.</li>
<li><strong>Frederick Ding</strong>, from the United States, working on improving portability. Mentors will be Andrew Nacin and Mike Schroder.</li>
<li><strong>Sayak Sakar</strong>, from India, working on porting WordPress for WebOS to Firefox OS. Mentor will be Eric Johnson.</li>
<li><strong>Alex Höreth</strong>, from Germany, working on  adding WordPress native revisions to the theme and plugin code editors. Mentors will be Dominik Schilling and Aaron Campbell, with a reviewer assist from Daniel Bachhuber.</li>
<li><strong>Mert Yazicioglu</strong>, from Turkey, working on ways to improve our community profiles at profiles.wordpress.org. Mentors will be Scott Reilly and Boone Gorges.</li>
<li><strong>Daniele Maio</strong>, from Italy, working on a native WordPress app for Blackberry 10. Mentor will be Danilo Ercoli.</li>
</ul>
<p>Did you notice that our summer cohort is as international as the #wp10 parties going on today? I can only think that this is a good sign.</p>
<p>It&#8217;s always a difficult process to decide which projects to mentor through these programs. There are always more applicants with interesting ideas with whom we&#8217;d like to work than there are opportunities. Luckily, WordPress is a free/libre open source software project, and anyone can begin contributing at any time. Is this the year for you? We&#8217;d love for you to join us as we work toward #wp20. <img src=\'http://wordpress.org/news/wp-includes/images/smilies/icon_wink.gif\' alt=\';)\' class=\'wp-smiley\' /> </p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://wordpress.org/news/2013/05/the-next-10-starts-now/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 3.6 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2013/05/wordpress-3-6-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wordpress.org/news/2013/05/wordpress-3-6-beta-3/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 May 2013 03:44:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2584\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:374:\"WordPress 3.6 Beta 3 is now available! This is software still in development and we really don’t recommend that you run it on a production site — set up a test site just to play with the new version. To test WordPress 3.6, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can download the beta here (zip). Beta [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mark Jaquith\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2452:\"<p>WordPress 3.6 Beta 3 is now available!</p>
<p>This is software still in development and <strong>we <em>really</em> don’t recommend that you run it on a production site</strong> — set up a test site just to play with the new version. To test WordPress 3.6, try the <a href=\"http://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"http://wordpress.org/wordpress-3.6-beta3.zip\">download the beta here</a> (zip).</p>
<p>Beta 3 contains about a hundred changes, including improvements to the image Post Format flow (yay, drag-and-drop image upload!), a more polished revision comparison screen, and a more quote-like quote format for Twenty Thirteen.</p>
<p>As a bonus, we now have oEmbed support for the popular music-streaming services <a href=\"http://www.rdio.com/\">Rdio</a> and <a href=\"http://www.spotify.com/\">Spotify</a> (the latter of which kindly created an oEmbed endpoint a mere 24 hours after we lamented their lack of one). Here&#8217;s an album that&#8217;s been getting a lot of play as I&#8217;ve been working on WordPress 3.6:</p>
<p><iframe width=\"500\" height=\"250\" src=\"https://rd.io/i/Qj5r8SE//?source=oembed\" frameborder=\"0\"></iframe></p>
<p><iframe src=\"https://embed.spotify.com/?uri=spotify:album:6dJZDZMNdBPZrJcNv57bEq\" width=\"300\" height=\"380\" frameborder=\"0\" allowtransparency=\"true\"></iframe></p>
<p>Plugin developers, theme developers, and WordPress hosts should be testing beta 3 extensively. The more you test the beta, the more stable our release candidates and our final release will be.</p>
<p>As always, if you think you’ve found a bug, you can post to the <a href=\"http://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a reproducible bug report, <a href=\"http://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"http://core.trac.wordpress.org/report/5\">a list of known bugs</a> and <a href=\"http://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=3.6\">everything we&#8217;ve fixed</a> so far.</p>
<p>We&#8217;re looking forward to your feedback. If you find a bug, please report it, and if you’re a developer, try to help us fix it. We&#8217;ve already had more than 150 contributors to version 3.6 — it&#8217;s not too late to join in!</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wordpress.org/news/2013/05/wordpress-3-6-beta-3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 3.6 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"http://wordpress.org/news/2013/04/wordpress-3-6-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://wordpress.org/news/2013/04/wordpress-3-6-beta-2/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Apr 2013 22:48:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2579\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"WordPress 3.6 Beta 2 is now available! This is software still in development and we really don’t recommend that you run it on a production site — set up a test site just to play with the new version. To test WordPress 3.6, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can download the beta here (zip). The [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Mark Jaquith\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2057:\"<p>WordPress 3.6 Beta 2 is now available!</p>
<p>This is software still in development and <strong>we <em>really</em> don’t recommend that you run it on a production site</strong> — set up a test site just to play with the new version. To test WordPress 3.6, try the <a href=\"http://wordpress.org/extend/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"http://wordpress.org/wordpress-3.6-beta2.zip\">download the beta here</a> (zip).</p>
<p>The longer-than-usual delay between beta 1 and beta 2 was due to poor user testing results with the Post Formats UI. Beta 2 contains a modified approach for format choosing and switching, which has done well in user testing. We&#8217;ve also made the Post Formats UI hide-able via Screen Options, and set a reasonable default based on what your theme supports.</p>
<p>There were a lot of bug fixes and polishing tweaks done for beta 2 as well, so definitely check it out if you had an issues with beta 1.</p>
<p>Plugin developers, theme developers, and WordPress hosts should be testing beta 2 extensively. The more you test the beta, the more stable our release candidates and our final release will be.</p>
<p>As always, if you think you’ve found a bug, you can post to the <a href=\"http://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. Or, if you’re comfortable writing a reproducible bug report, <a href=\"http://core.trac.wordpress.org/\">file one on the WordPress Trac</a>. There, you can also find <a href=\"http://core.trac.wordpress.org/report/5\">a list of known bugs</a> and <a href=\"http://core.trac.wordpress.org/query?status=closed&amp;group=component&amp;milestone=3.6\">everything we&#8217;ve fixed</a> so far.</p>
<p>We&#8217;re looking forward to your feedback. If you find a bug, please report it, and if you’re a developer, try to help us fix it. We&#8217;ve already had more than 150 contributors to version 3.6 — it&#8217;s not too late to join in!</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wordpress.org/news/2013/04/wordpress-3-6-beta-2/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:45:\"
		
		
		
		
		
				
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Summer Mentorship Programs: GSoC and Gnome\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://wordpress.org/news/2013/04/summer-mentorship-programs-gsoc-and-gnome/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wordpress.org/news/2013/04/summer-mentorship-programs-gsoc-and-gnome/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Apr 2013 03:18:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://wordpress.org/news/?p=2573\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"As an open source, free software project, WordPress depends on the contributions of hundreds of people from around the globe &#8212; contributions in areas like core code, documentation, answering questions in the support forums, translation, and all the other things it takes to make WordPress the best publishing platform it can be, with the most [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Jen Mylo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5071:\"<p>As an open source, free software project, WordPress depends on the contributions of hundreds of people from around the globe &#8212; contributions in areas like core code, documentation, answering questions in the support forums, translation, and all the other things it takes to make WordPress the best publishing platform it can be, with the most supportive community. This year, we&#8217;re happy to be participating as a mentoring organization with two respected summer internship programs: <a href=\"http://www.google-melange.com/gsoc/homepage/google/gsoc2013\">Google Summer of Code (GSoC)</a> and the Gnome Outreach Program for Women.</p>
<h3>Google Summer of Code</h3>
<p>GSoC is a summer internship program funded by Google specifically for college/university student developers to work on open source coding projects. We have participated in the Google Summer of Code program in the past, and have enjoyed the opportunity to work with students in this way. Some of our best core developers were GSoC students once upon a time!</p>
<p><a href=\"http://codex.wordpress.org/GSoC2013#Mentors\">Our mentors</a>, almost 30 talented developers with experience developing WordPress, will provide students with guidance and feedback over the course of the summer, culminating in the release of finished projects at the end of the program if all goes well.</p>
<p>Students who successfully complete the program earn $5,000 for their summer efforts. Interested, or know a college student (newly accepted to college counts, too) who should be? All the information you need about our participation in the program, projects, mentors, and the application process is available on the <a href=\"http://codex.wordpress.org/GSoC2013\">GSoC 2013 page in the Codex</a>.</p>
<h3>Gnome Outreach Program for Women</h3>
<p>It&#8217;s not news that women form a low percentage of contributors in most open source projects, and WordPress is no different. We have great women in the contributor community, including some in fairly visible roles, but we still have a lot of work to do to get a representative gender balance on par with our user base.</p>
<p>The Gnome Outreach Program for Women aims to provide opportunities for women to participate in open source projects, and offers a similar stipend, but there are three key differences between GSoC and Gnome aside from the gender requirement for Gnome.</p>
<ol>
<li><span style=\"font-size: 13px;line-height: 19px\">The Gnome program allows intern projects in many areas of contribution, not just code. In other words, interns can propose projects like documentation, community management, design, translation, or pretty much any area in which we have people contributing (including code).</span></li>
<li><span style=\"font-size: 13px;line-height: 19px\">The Gnome Outreach Program for Women doesn&#8217;t require interns to be college students, though students are definitely welcome to participate. This means that women in all stages of life and career can take the opportunity to try working with open source communities for the summer.</span></li>
<li><span style=\"font-size: 13px;line-height: 19px\">We have to help raise the money to pay the interns. Google funds GSoC on its own, and we only have to provide our mentors&#8217; time. Gnome doesn&#8217;t have the same funding, so we need to pitch in to raise the money to cover our interns. If your company is interested in helping with this, please check out the program&#8217;s </span><a style=\"font-size: 13px;line-height: 19px\" href=\"https://live.gnome.org/OutreachProgramForWomen#For_Organizations_and_Companies\">sponsorship information</a><span style=\"font-size: 13px;line-height: 19px\"> and follow the contact instructions to get involved. You can earmark donations to support WordPress interns, or to support the program in general. (Pick us, pick us! <img src=\'http://wordpress.org/news/wp-includes/images/smilies/icon_smile.gif\' alt=\':)\' class=\'wp-smiley\' />  )</span></li>
</ol>
<p>The summer installment of the Gnome Outreach Program for Women follows the same schedule and general application format as GSoC, though there are more potential projects since it covers more areas of contribution. Women college students interested in doing a coding project are encouraged to apply for both programs to increase the odds of acceptance. All the information you need about our participation in the program, projects, mentors, and the application process is available on the <a href=\"http://codex.wordpress.org/Gnome_Summer_Program_for_Women\">Gnome Outreach Program for Women page in the Codex</a>.</p>
<p>The application period just started, and it lasts another week (May 1 for Gnome, May 3 for GSoC), so if you think you qualify and are interested in getting involved, check out the information pages, get in touch, and apply… Good luck!</p>
<p><a href=\"http://codex.wordpress.org/GSoC2013\">Google Summer of Code 2013 Information</a><br />
<a href=\"http://codex.wordpress.org/Gnome_Summer_Program_for_Women\">Gnome Summer Outreach Program for Women 2013 Information</a></p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"http://wordpress.org/news/2013/04/summer-mentorship-programs-gsoc-and-gnome/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:31:\"http://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 28 Aug 2013 21:47:40 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:10:\"x-pingback\";s:36:\"http://wordpress.org/news/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Thu, 01 Aug 2013 21:49:34 GMT\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20130802050543\";}","no");
INSERT INTO `ts968ny_3_options` VALUES("743","_transient_timeout_feed_867bd5c64f85878d03a060509cd2f92c","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("744","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("745","_transient_timeout_feed_5c3e09a77e404a313a0cbb9a67dae2c2","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("746","_transient_feed_5c3e09a77e404a313a0cbb9a67dae2c2","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:4:\"
  
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:33:\"
    
    
    
    
    
    
  \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:3:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"link:http://rubensteinarchitects.com/choices/ - Google Blog Search\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://www.google.com/search?ie=utf-8&q=link:http://rubensteinarchitects.com/choices/&tbm=blg&tbs=sbd:1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"Your search - <b>link:http://rubensteinarchitects.com/choices/</b> - did not match any documents.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://a9.com/-/spec/opensearch/1.1/\";a:3:{s:12:\"totalResults\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:10:\"startIndex\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:12:\"itemsPerPage\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:12:\"content-type\";s:28:\"text/xml; charset=ISO-8859-1\";s:4:\"date\";s:29:\"Wed, 28 Aug 2013 21:47:40 GMT\";s:7:\"expires\";s:2:\"-1\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:10:\"set-cookie\";a:2:{i:0;s:143:\"PREF=ID=d4206b662ae9b0a8:FF=0:TM=1377726460:LM=1377726460:S=_oGVv9GtHLpeFemJ; expires=Fri, 28-Aug-2015 21:47:40 GMT; path=/; domain=.google.com\";i:1;s:212:\"NID=67=B98Hm36y1yQiYoB_W_pWfDWx8AXNZGfHGbH-Y2GEL29LqGRfXmut-V9ybsHOzvs8ZLtZF_9UVdEksJz1Ne9pdEFTomVkLFgpMX-nrQ2MltyQMtYx_Fg7Xe-4DZK9wM2N; expires=Thu, 27-Feb-2014 21:47:40 GMT; path=/; domain=.google.com; HttpOnly\";}s:3:\"p3p\";s:122:\"CP=\"This is not a P3P policy! See http://www.google.com/support/accounts/bin/answer.py?hl=en&answer=151657 for more info.\"\";s:6:\"server\";s:3:\"gws\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:18:\"alternate-protocol\";s:7:\"80:quic\";}s:5:\"build\";s:14:\"20130802050543\";}","no");
INSERT INTO `ts968ny_3_options` VALUES("747","_transient_timeout_feed_mod_5c3e09a77e404a313a0cbb9a67dae2c2","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("748","_transient_feed_mod_5c3e09a77e404a313a0cbb9a67dae2c2","1377726459","no");
INSERT INTO `ts968ny_3_options` VALUES("749","_transient_timeout_dash_20494a3d90a6669585674ed0eb8dcd8f","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("750","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1377726459","no");
INSERT INTO `ts968ny_3_options` VALUES("751","_transient_dash_20494a3d90a6669585674ed0eb8dcd8f","<p>This dashboard widget queries <a href=\"http://blogsearch.google.com/\">Google Blog Search</a> so that when another blog links to your site it will show up here. It has found no incoming links&hellip; yet. It&#8217;s okay &#8212; there is no rush.</p>
","no");
INSERT INTO `ts968ny_3_options` VALUES("752","_transient_feed_867bd5c64f85878d03a060509cd2f92c","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"
	
	
	
	




















































\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WordPress.tv: Al Caldarone: Create Your Own Member Access Templates with Custom Sidebar Widgets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21694\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"http://wordpress.tv/2013/08/28/al-caldarone-create-your-own-member-access-templates-with-custom-sidebar-widgets/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:767:\"<div id=\"v-A8ddRkgy-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21694/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21694/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21694&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/28/al-caldarone-create-your-own-member-access-templates-with-custom-sidebar-widgets/\"><img alt=\"Al Caldarone: Create Your Own Member Access Templates with Custom Sidebar Widgets\" src=\"http://videos.videopress.com/A8ddRkgy/create-member-access-templates-with-widgets_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Aug 2013 11:01:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WordPress.tv: Andrew Nacin: WordPress in Transition\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21732\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wordpress.tv/2013/08/28/andrew-nacin-wordpress-in-transition/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:675:\"<div id=\"v-5GG16zuu-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21732/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21732/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21732&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/28/andrew-nacin-wordpress-in-transition/\"><img alt=\"Andrew Nacin: WordPress in Transition WordPress\" src=\"http://videos.videopress.com/5GG16zuu/anything-everything-wordpress_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 28 Aug 2013 10:37:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"WPTavern: Mollom Security Breach\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8706\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://feedproxy.google.com/~r/WordpressTavern/~3/SeNQaf5t6Yo/mollom-security-breach\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2792:\"<p><a href=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/Screen-Shot-2013-08-06-at-3.50.46-PM.png\" rel=\"thumbnail\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/Screen-Shot-2013-08-06-at-3.50.46-PM.png?resize=300%2C85\" alt=\"Mollom Logo\" class=\"alignright size-medium wp-image-8327\" /></a>Over the week-end, I received an email from Mollom notifying me that they had discovered a security breach. According to their <a href=\"http://mollom.com/blog/security-notice-august-2013\" title=\"http://mollom.com/blog/security-notice-august-2013\">official blog post</a> on the matter, the breach was discovered on August 21st. Mollom is a service managed by Acquia, a commercial open source software company providing products, services, and technical support for the open source Drupal social publishing system. The service works in a similar fashion to Akismet in that it scans messages such as comments to determine whether or not they are spam. <span id=\"more-8706\"></span></p>
<blockquote><p>This is an important security notice from the Mollom team. On August 21, we identified a breach of one of our Mollom servers. Our subsequent investigation showed that unauthorized users gained access to Mollom servers and were potentially able to access Mollom data. Today we have closed the security loophole used to gain access and taken measures designed to prevent future breaches.</p>
<p>Data that may have been compromised includes usernames, account contact information, passwords, Mollom public and private keys, and billing transaction logs. PayPal account information was NOT stored on the affected servers.</p>
<p>At this time, we have no evidence that any malicious activity took place with customer data. To help assure this continues to be the case, in addition to the measures described above, we have changed all Mollom user account passwords. </p></blockquote>
<p>Mollom has automatically reset all user account passwords to access the administrative interface. This means you&#8217;ll need to access the <a href=\"http://mollom.com/user/password\" title=\"http://mollom.com/user/password\">following URL</a> in order to reset your password. </p>
<p>The bottom line is if you signed up to use Mollom free or as a paid customer, you should reset your password and keep a close eye on your financial records, especially if you have or had a paid account even though credit card information was not stored on the affected server. The unauthorized access was <strong>NOT</strong> a direct result of a vulnerability within Drupal. If any additional information is discovered during their investigation, the Mollom team will continue to update the blog post.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/SeNQaf5t6Yo\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Aug 2013 18:45:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Matt: Harder, Slower, Less Secure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=42965\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"http://ma.tt/2013/08/harder-slower-less-secure/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:352:\"<p>Jay Rosen (and Barry Eisler) on the surveillance state&#8217;s efforts <a href=\"http://pressthink.org/2013/08/to-make-journalism-harder-slower-less-secure/\">to make journalism harder, slower, less secure</a>. The gist: why would they destroy hard drives they know there are copies of, and detain couriers they know they&#8217;ll have to release?</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Aug 2013 17:16:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: The Full Story Behind WP-Wallpaper\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8568\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://feedproxy.google.com/~r/WordpressTavern/~3/3luWcT9hGW8/the-full-story-behind-wp-wallpaper\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6406:\"<p>If you&#8217;ve been scouring the web for WordPress specific images to use as your desktop background, have a look at <a href=\"http://wp-wallpaper.com/\" title=\"http://wp-wallpaper.com/\">WP-Wallpaper</a>. The site doesn&#8217;t have a huge variety of images to choose from now but over the course of the next few months, I think that will change. I reached out to Alison Barrett who manages the site to find out about its history and what plans if any she has for the site. <span id=\"more-8568\"></span></p>
<div id=\"attachment_8569\" class=\"wp-caption aligncenter\"><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WordPressLights.jpg\" rel=\"thumbnail\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WordPressLights.jpg?resize=439%2C275\" alt=\"WordPress Lights by Alison Barrett \" class=\"size-full wp-image-8569\" /></a><p class=\"wp-caption-text\">WordPress Lights by Alison Barrett</p></div>
<p><strong>Can you provide a brief history of the domain, considering it existed before you purchased it?</strong></p>
<p>I don&#8217;t know much about the previous owner of the domain. The original site was my main source of desktop wallpapers for a long time, and I had referred dozens of people to it. I was bummed when I learned the site was down. I went searching for the owner, and I didn&#8217;t realize the domain had expired until the whois search turned up empty.</p>
<p><strong>Do you know of any other sites that have an abundant amount of WordPress desktop wallpapers?</strong></p>
<p>I can&#8217;t think of any other dedicated WP wallpaper sites off the top of my head, though a Google search might turn up one or two. I didn&#8217;t come across any when I was searching for the creators of the wallpapers on the original site.</p>
<p>My initial reason for buying the domain was that I felt bad for referring friends to something that wasn&#8217;t even live anymore. Now I&#8217;m enjoying running the site, and I love seeing all the excitement around it. The community&#8217;s response to it is driving me to keep making it even better. I would love to find the creators of the wallpapers from the original site, because there were a lot of gorgeous images up there. I don&#8217;t want to republish them without attribution and permission.</p>
<p><strong>Any chance of getting this site linked to from the Fan Art section of WordPress.org or having a small dedicated section showing 3-6 wallpapers?</strong></p>
<p>I hadn&#8217;t thought about getting this site linked under the Fan Art section on .org—that&#8217;s a great idea! I&#8217;ll see what I can do.</p>
<p><strong>Any chance of adding a ratings system, reviews, or any other social aspects to the images similar to DeviantArt?</strong></p>
<p>I do plan on implementing a ratings system eventually, though my priority right now is supporting multiple resolutions for each wallpaper (including mobile). I will probably add some sharing tools in the near future as well.</p>
<p><strong>How can people submit images to the site and how should the submissions be licensed? </strong></p>
<p>Wallpapers can be submitted through the form on the submit page: <a href=\"http://wp-wallpaper.com/submit/\" title=\"http://wp-wallpaper.com/submit/\">http://wp-wallpaper.com/submit/</a> . Technical requirements are laid out there (and will be updated once I get mobile resolution support in place). Images must be released under the Creative Commons Attribution Share-Alike license, as that is what they are distributed under on the site.</p>
<h2>Oops: After The Launch</h2>
<p>After this interview was conducted with Alison, I did some research into the history of the domain since she didn&#8217;t know too much about it. I plugged the domain into the Wayback machine and didn&#8217;t see any results. For a site that Alison pointed to over the years for WordPress wallpapers, it stands to reason it would have some history behind it. Just for experimentation, I added an S to the end of the domain so it was <a href=\"http://wp-wallpapers.com/\" title=\"http://wp-wallpapers.com/\">http://wp-wallpapers.com/</a> and while that particular domain has expired, it did show up with quite a few results in the Wayback machine.</p>
<p>The first record on the internet archive is for <a href=\"http://web.archive.org/web/20111017210657/http://wp-wallpapers.com/\" title=\"http://web.archive.org/web/20111017210657/http://wp-wallpapers.com/\">October 17th 2011</a>. This entry tells us that WP-Wallpapers.com used the Expose theme from ThemeForest to show off the content of the site. That theme is still available for sale but is not 100% GPL licensed. </p>
<p><a href=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPWallPapers.jpg\" rel=\"thumbnail\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPWallPapers.jpg?resize=500%2C359\" alt=\"WP Wallpapers\" class=\"aligncenter size-large wp-image-8699\" /></a></p>
<p>The next entry was a WordPress maintenance page. However, <a href=\"http://web.archive.org/web/20120331034901/http://wp-wallpapers.com/\" title=\"http://web.archive.org/web/20120331034901/http://wp-wallpapers.com/?\">On March 31st 2012</a>, the site had a few pages of Wallpapers available. It&#8217;s also during this time that we discover the site was owned and operated by the Envato network. The last working entry is on <a href=\"http://web.archive.org/web/20130323233732/http://wp-wallpapers.com/\" title=\"http://web.archive.org/web/20130323233732/http://wp-wallpapers.com/\">March 23rd, 2013</a> with at least 5 pages worth of wallpaper images. </p>
<h2>Conclusions</h2>
<p>So not only has Alison pointed people to the wrong domain over the years, she also purchased the wrong domain. She missed it by one letter. I reached out to Envato to find out what their plans are for the domain:</p>
<blockquote><p>We&#8217;re always trying to streamline our processes and focus more on the projects that really matter to us, which is why we decided to discontinue WP-Wallpapers.com. But we&#8217;re really happy to see WP-Wallpaper spring up to fill the gap! There are definitely some beautiful, creative WordPress wallpapers around.</p></blockquote>
<p>Despite everything that&#8217;s happened up to this point with WP-Wallpaper.com, Alison is still excited to see the site grow. </p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/3luWcT9hGW8\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Aug 2013 04:45:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: My Experience – WordCamp Grand Rapids 2013\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8635\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://feedproxy.google.com/~r/WordpressTavern/~3/Tu_vAh6bwrA/my-experience-wordcamp-grand-rapids-2013\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15414:\"<h2>Things I Learned About The City</h2>
<p>This event marks the first time I&#8217;ve visited Grand Rapids, Michigan. I can say without any doubt that Grand Rapids is a beautiful city. I got the impression while being downtown that I was in a large city but it wasn&#8217;t large enough to feel inundated like New York or San Francisco. The skyline has large buildings but you can still see the horizon in some parts of downtown. The city also has a wide river that flows through and around the city which from what I&#8217;ve read, is the origin of the city&#8217;s name. However, I saw the river as wide, shallow, and nothing rapid about it. There is talk in the local community around the idea of placing large boulders back into the river to generate rapids but I&#8217;m unsure of that progress. <span id=\"more-8635\"></span></p>
<p>The other thing I learned while in Grand Rapids was the number of local breweries in the region. I had the pleasure of eating at two of these breweries. One was called <a href=\"http://foundersbrewing.com/\" title=\"http://foundersbrewing.com/\">Founders</a>, the other was <a href=\"http://www.grbrewingcompany.com/\" title=\"http://www.grbrewingcompany.com/\">Grand Rapids Brewing Company</a>. The food was excellent in both locations and although I didn&#8217;t drink any beer since I&#8217;m not a hoppy kind of guy, the WordCamp attendees I was surrounded by couldn&#8217;t stop raving about some of the beers they tasted at each place. The third place I ate at in which I did try a beer (Brouwerij Lindeman Vlezenbeek, Belgium a raspberry flavored beer) was <a href=\"http://hopcatgr.com/main/About.aspx\" title=\"http://hopcatgr.com/main/About.aspx\">HopCat</a>. A place with something called &#8216;<strong>Crack Fries</strong>&#8216;. These crack fries are considered famous in the area because of the unique blend of spices applied to them. After eating them, you&#8217;ll understand why they have their name.</p>
<h2>The Event Itself</h2>
<p>The event was held at the <a href=\"http://www.gvsu.edu/\" title=\"http://www.gvsu.edu/\">DeVos Center on Grand Valley State University’s Pew Campus</a> in downtown Grand Rapids. Out of all the WordCamps I&#8217;ve attended, those that are at some sort of college campus location have gone smoothly. This one was no exception. Although I didn&#8217;t attend very many sessions, I did manage to catch up with quite a few people to talk shop and other interesting things going on in the world of WordPress. At this particular WordCamp, I moderated a panel discussion on the topic of Commercial Themes and Plugins with Pippin Williamson, Adam Pickering, Daniel Espinoza, and Jake Caputo. I think the session went over rather well and we covered a lot of information. The one thing that kept coming up multiple times during the talk was support. It&#8217;s expensive but it&#8217;s also the most valuable and potentially the most vital aspect of any business. We also discussed various methods to handle support as forums are great at the early stage but something like ZenDesk and tickets make sense for larger volumes of support requests. I definitely took some feedback to heart concerning my delivery and approach on stage during the session and if I ever moderate a panel like this again, the second one will be 10 times better than the first. Thanks to Brian Richards, one of the event organizers for giving me the opportunity to moderate the panel.</p>
<p>The session that opened my eyes was <a href=\"http://2013.grandrapids.wordcamp.org/session/scoping-projects-a-therapy-session-for-those-who-do-client-work/\" title=\"http://2013.grandrapids.wordcamp.org/session/scoping-projects-a-therapy-session-for-those-who-do-client-work/\">Scoping Projects</a> – A Therapy Session For Those Who Do Client Work Lisa Sabin-Wilson. Not so much from the perspective of the consultant but from the perspective of a client, realizing everything the consultant has to go through to get the job done. Her idea of scoping and how important it is to get everything on the table before starting work was key. She also discussed why having assumptions can costs you big bucks, wasted time, and make you look bad in front of the client. There should be 0 assumptions from both parties in a project. As a future client myself, I realized that I could make the process go a lot easier for both parties if I scoped out everything I wanted, every nuance, provided documentation, references for ideas and inspiration, etc. The more information I can provide the consultant about my needs, the better off we&#8217;ll both be. It was a session that I didn&#8217;t think would appeal to me but it was the most eye-opening one I&#8217;ve attended in a long time. It was an interesting experience being in a room full of people and seeing/hearing their reaction when Lisa mentioned that <a href=\"http://lisasabin-wilson.com/tighten-up-those-terms-and-keep-copies-of-everything-forever/\" title=\"http://lisasabin-wilson.com/tighten-up-those-terms-and-keep-copies-of-everything-forever/\">she had been investigated by the FBI</a> and to perform a Google search to read about it. I won&#8217;t spoil it for you, you&#8217;ll just have to read her post. </p>
<h2>Conclusion</h2>
<p>Most of the time during the week-end I was involved in multiple conversations with all sorts of people doing awesome things with WordPress. Overall, it was a fantastic event. The organizers as well as the volunteers should be proud of themselves. I had such a good experience within Grand Rapids that I&#8217;m thinking of taking my wife there to experience more of the city. While contributor day was awesome at WordCamp San Francisco, it was nowhere near as effective at WordCamp Grand Rapids. I think a lot of that has to do with the right people not being in attendance such as core contributors, project managers, etc. With that said, those who did show up to contributor day were working with other people on WordPress or were taking the knowledge and ideas they gained the past two days to improve their own sites or projects. This has me wondering if any other WordCamp will be able to have a contributor day as beneficial as the one held at WordCamp San Francisco 2013? </p>

<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/565\" title=\"CedarPoint From The Sky\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/565.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"CedarPoint From The Sky\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/570\" title=\"Sandwich From Grand Rapids Brewery\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/570.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Sandwich From Grand Rapids Brewery\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/571\" title=\"View From The Amway Grand\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/571.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"View From The Amway Grand\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/572\" title=\"Van Andel Arena\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/572.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Van Andel Arena\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/573\" title=\"Van Andel Statue\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/573.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Van Andel Statue\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/574\" title=\"GR Brewing Company\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/574.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"GR Brewing Company\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/575\" title=\"GR Brewing Company Sign\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/575.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"GR Brewing Company Sign\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/576\" title=\"J Gardellas Sign\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/576.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"J Gardellas Sign\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/577\" title=\"Albert Einstein\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/577.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Albert Einstein\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/580\" title=\"Blue Bridge Skyline\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/580.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Blue Bridge Skyline\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/582\" title=\"Peace Sign In The Grand River\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/582.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Peace Sign In The Grand River\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/584\" title=\"River With Skyline\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/584.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"River With Skyline\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/588\" title=\"Large Bridge\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/588.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Large Bridge\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/589\" title=\"Sign About Pew Campus\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/589.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Sign About Pew Campus\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/590\" title=\"Front Of DeVos Center\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/590.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Front Of DeVos Center\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/591\" title=\"DeVos Clock Tower\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/591.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"DeVos Clock Tower\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/592\" title=\"DeVos Campus\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/592.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"DeVos Campus\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/593\" title=\"WCGR Badge 1\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/593.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"WCGR Badge 1\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/594\" title=\"WCGR Badge 2\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/594.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"WCGR Badge 2\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/595\" title=\"WCGR Badge 3\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/595.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"WCGR Badge 3\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/596\" title=\"WCGR Badge 4\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/596.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"WCGR Badge 4\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/597\" title=\"WCGR Badge 5\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/597.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"WCGR Badge 5\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/598\" title=\"Grand Rapids Night Shot 1\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/598.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Grand Rapids Night Shot 1\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/599\" title=\"Grand Rapids Night Shot 2\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/599.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Grand Rapids Night Shot 2\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/600\" title=\"Grand Rapids Night Shot 3\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/600.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Grand Rapids Night Shot 3\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/601\" title=\"Grand Rapids Night Shot 4\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/601.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Grand Rapids Night Shot 4\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/604\" title=\"Grand Rapids Night Shot 5\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/604.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Grand Rapids Night Shot 5\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/605\" title=\"Amway Grand Hotel\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/605.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Amway Grand Hotel\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/606\" title=\"Front Of The Amway\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/606.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Front Of The Amway\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/608\" title=\"Hop Cat Menu\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/608.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Hop Cat Menu\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/609\" title=\"Hop Cat Bruschetta\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/609.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Hop Cat Bruschetta\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/610\" title=\"Crack Fries 1\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/610.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Crack Fries 1\" /></a>
<a href=\"http://www.wptavern.com/my-experience-wordcamp-grand-rapids-2013/attachment/611\" title=\"Crack Fries 2\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/611.png?resize=150%2C150\" class=\"attachment-thumbnail\" alt=\"Crack Fries 2\" /></a>

<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/Tu_vAh6bwrA\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 27 Aug 2013 03:34:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"WordPress.tv: Al Davis: After the Install\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21549\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wordpress.tv/2013/08/26/al-davis-after-the-install-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:634:\"<div id=\"v-OTMvdJ53-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21549/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21549/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21549&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/26/al-davis-after-the-install-3/\"><img alt=\"Al Davis: After the Install\" src=\"http://videos.videopress.com/OTMvdJ53/video-37ea15f1d5_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Aug 2013 17:09:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WordPress.tv: Brewster Kahle: Internet Archive and Preserving WordPress Blogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21510\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wordpress.tv/2013/08/26/brewster-kahle-internet-archive-and-preserving-wordpress-blogs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:752:\"<div id=\"v-WPFuoh55-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21510/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21510/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21510&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/26/brewster-kahle-internet-archive-and-preserving-wordpress-blogs/\"><img alt=\"Brewster Kahle: Internet Archive and Preserving WordPress Blogs\" src=\"http://videos.videopress.com/WPFuoh55/4-brewster-kahle-internet-archive-and-preserving-wordpress-blogs_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Aug 2013 16:20:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Joseph: Salt Lake City WordPress Meetup This Wednesday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://josephscott.org/?p=8983\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://josephscott.org/archives/2013/08/salt-lake-city-wordpress-meetup-this-wednesday/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:460:\"<p>The <a href=\"http://wpslc.com/\">Salt Lake City WordPress Meetup</a> is happening this Wednesday, August 28th.  <a href=\"http://wpslc.com/blog/2013/08/21/august-28th-meetup-brian-petty-i-found-a-bug-what-next/\">Brian Petty is going to talk</a> about how to report bugs and submit patches back to the WordPress project.</p>
<p>It will be at the MoJo Themes office in Draper at 7pm.  Check out <a href=\"http://wpslc.com/\">wpslc.com</a> for all the details.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Aug 2013 13:15:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Joseph Scott\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WordPress.tv: Александр Станкевич: Инфраструктура сети WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21472\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"http://wordpress.tv/2013/08/25/aleksandr-stankevic-wordpress-dot-com-infrastructure/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:727:\"<div id=\"v-Jkxvy85K-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21472/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21472/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21472&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/25/aleksandr-stankevic-wordpress-dot-com-infrastructure/\"><img alt=\"Александр Станкевич: Инфраструктура сети WordPress.com\" src=\"http://videos.videopress.com/Jkxvy85K/video-7e2bb0c01c_scruberthumbnail_7.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 Aug 2013 06:54:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WordPress.tv: Andy Hayes: Website Critiques: How To Decide What Works And What To Ditch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21520\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"http://wordpress.tv/2013/08/25/andy-hayes-website-critiques-how-to-decide-what-works-and-what-to-ditch/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:780:\"<div id=\"v-9KgldZEa-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21520/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21520/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21520&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/25/andy-hayes-website-critiques-how-to-decide-what-works-and-what-to-ditch/\"><img alt=\"Andy Hayes: Website Critiques: How To Decide What Works And What To Ditch\" src=\"http://videos.videopress.com/9KgldZEa/6-andy-hayes-website-critiques-how-to-decide-what-works-and-what-to-ditch_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 25 Aug 2013 15:25:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WordPress.tv: Zachary Brown: WordPress DevOps Power Hour\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21524\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wordpress.tv/2013/08/25/zachary-brown-wordpress-devops-power-hour/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:696:\"<div id=\"v-7OzGJqil-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21524/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21524/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21524&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/25/zachary-brown-wordpress-devops-power-hour/\"><img alt=\"Zachary Brown: WordPress DevOps Power Hour\" src=\"http://videos.videopress.com/7OzGJqil/03-zachary-brown-wordpress-devops-power-hour_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 25 Aug 2013 13:50:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WordPress.tv: Matt Boynes: Rewrite Recipes: Exploring Advanced Permalink Structures By Example\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21522\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://wordpress.tv/2013/08/24/matt-boynes-rewrite-recipes-exploring-advanced-permalink-structures-by-example/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:808:\"<div id=\"v-PKP1IgNR-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21522/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21522/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21522&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/24/matt-boynes-rewrite-recipes-exploring-advanced-permalink-structures-by-example/\"><img alt=\"Matt Boynes: Rewrite Recipes: Exploring Advanced Permalink Structures By Example\" src=\"http://videos.videopress.com/PKP1IgNR/02-matt-boynes-rewrite-recipes-exploring-advanced-permalink-structures-by-example_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Aug 2013 22:50:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WordPress.tv: Kronda Adair: WordPress DevOps Power Hour\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21523\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"http://wordpress.tv/2013/08/24/kronda-adair-wordpress-devops-power-hour/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:687:\"<div id=\"v-MnWo1hjG-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21523/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21523/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21523&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/24/kronda-adair-wordpress-devops-power-hour/\"><img alt=\"Kronda Adair: WordPress DevOps Power Hour\" src=\"http://videos.videopress.com/MnWo1hjG/04-kronda-adair-wordpress-devops-power-hour_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 Aug 2013 13:28:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WordPress.tv: Maria Erb: How WordPressCan Save Higher Education\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21536\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://wordpress.tv/2013/08/23/maria-erb-how-wordpresscan-save-higher-education/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:711:\"<div id=\"v-R49U9Qeb-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21536/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21536/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21536&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/23/maria-erb-how-wordpresscan-save-higher-education/\"><img alt=\"Maria Erb: How WordPressCan Save Higher Education\" src=\"http://videos.videopress.com/R49U9Qeb/03-maria-erb-how-wordpresscan-save-higher-education_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Aug 2013 21:13:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Open Discussion On Guidelines Pertaining To Non WordCamp Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8618\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"http://feedproxy.google.com/~r/WordpressTavern/~3/hTBOFW6LoLo/open-discussion-on-guidelines-pertaining-to-non-wordcamp-events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1662:\"<p>There has been a new post published on the WordPress Events site that <a href=\"http://make.wordpress.org/events/2013/08/20/organizing-a-non-wordcamp/\" title=\"http://make.wordpress.org/events/2013/08/20/organizing-a-non-wordcamp/\">outlines a set of proposed guidelines</a> for non-WordCamp events that are created by previous WordCamp organizers. With at least two previous WordCamp organizers putting on their own events this year outside of the WordCamp name, these guidelines are necessary to make sure both events can coexist peacefully without causing confusion to WordCamp attendees. </p>
<p>First of all, I commend Andrea Middleton and the WordPress.org Events team for putting the proposal out into the open for discussion. Not too long ago, changes like the ones presented in the proposal would have just happened with no discussion and we&#8217;ve seen in the past that this is a recipe for disaster which ends up causing a rift in the community. So far, the discussion surrounding the guidelines has been calm and level-headed. Even Matt Mullenweg has participated in the conversation. </p>
<p>The proposed guidelines come across as a bunch of common sense to me. I especially like the fact that videos from non WordCamp events are encouraged to be shared on WordPress.tv as long as they meet the <a href=\"http://blog.wordpress.tv/submission-guidelines/\" title=\"http://blog.wordpress.tv/submission-guidelines/\">submission guidelines</a>. If you are a current, past, or future WordCamp organizer, be sure to give the guidelines a read and weigh in. </p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/hTBOFW6LoLo\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Aug 2013 20:22:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WordPress.tv: Christina Elmore: From URL To ISBN: Making Books From Blogs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21534\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wordpress.tv/2013/08/23/christina-elmore-from-url-to-isbn-making-books-from-blogs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:745:\"<div id=\"v-b3mX5BqG-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21534/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21534/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21534&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/23/christina-elmore-from-url-to-isbn-making-books-from-blogs/\"><img alt=\"Christina Elmore: From URL To ISBN: Making Books From Blogs\" src=\"http://videos.videopress.com/b3mX5BqG/01-christina-elmore-from-url-to-isbn-making-books-from-blogs_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 23 Aug 2013 19:43:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WPTavern: Details Behind The WordPress Jobs Board Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8606\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"http://feedproxy.google.com/~r/WordpressTavern/~3/bfFRfLUm4VM/details-behind-the-wordpress-jobs-board-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7472:\"<p>The official <a href=\"http://jobs.wordpress.net/\" title=\"http://jobs.wordpress.net/\">WordPress Job board</a> was <a href=\"http://make.wordpress.org/meta/2013/07/17/seeking-2-moderators-for-jobs-wordpress-net/\" title=\"http://make.wordpress.org/meta/2013/07/17/seeking-2-moderators-for-jobs-wordpress-net/\">recently relaunched</a> with a brand new design. Considering the <a href=\"http://weblogtoolscollection.com/archives/2007/07/27/wordpress-jobs/\" title=\"http://weblogtoolscollection.com/archives/2007/07/27/wordpress-jobs/\">site has existed since 2007</a> and has not seen very much in the way of upgrades since then, I thought it would be interesting to hear from Scott Reilly and Mel Choyce if there were any difficulties upgrading the site. Mel was involved in the discussions and design portions of the project while Scott did much of the implementation. <span id=\"more-8606\"></span></p>
<p><strong>What were some of the challenges upgrading from the previous design?</strong></p>
<p><strong>Mel Choyce</strong> &#8211; I think one of the biggest challenges we faced was trying to bring the site up to standards with the evolving WordPress.org branding. The old site just didn&#8217;t feel like it was officially sanctioned, which I think caused some trust issues. When I looked at it, I didn&#8217;t really see WordPress. I really approached the design with the concept of, how can we make this feel more like WordPress? How can we make this look more official?</p>
<p>Another part we struggled with was updating the categories. The old categories were a little vague and generic, so we tried to tighten those up to make it easier for job posters to appropriately categorize their jobs. </p>
<div id=\"attachment_8607\" class=\"wp-caption aligncenter\"><a href=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPJobsBoardVersion1.jpg\" rel=\"thumbnail\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPJobsBoardVersion1.jpg?resize=500%2C236\" alt=\"WordPress Jobs Board Old Design\" class=\"size-large wp-image-8607\" /></a><p class=\"wp-caption-text\">The Old Jobs Board Design</p></div>
<div id=\"attachment_8608\" class=\"wp-caption aligncenter\"><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPJobsBoardVersion2.jpg\" rel=\"thumbnail\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPJobsBoardVersion2.jpg?resize=500%2C287\" alt=\"WordPress Jobs Board New Design\" class=\"size-large wp-image-8608\" /></a><p class=\"wp-caption-text\">New Jobs Board Design</p></div>
<p><strong>Scott Reilly</strong> &#8211; From the technical side of things, for the most part we reimplemented the entire site, keeping mostly just the data. Even then, we migrated and massaged some of the data in the process. But all in all, the technical implementation was fairly straightforward. The biggest challenges were mostly in coming up with a design (Mel) and then forming a team around the project. Heretofore, Mark Ghosh had been pretty much running the site singlehandedly, which was a monumental effort. This included the custom code to run the site as well as the daily moderation of job postings. So we put out the call for volunteer moderators and began to formalize the guidelines.</p>
<p><strong>One of the biggest differences between the two designs is the addition of a sidebar of icons that symbolize different position types. By the way, those icons look familiar. Was this approach considered the best way to easily dig into all of the jobs openings available or is this just one method you&#8217;re trying?</strong></p>
<p><strong>Mel Choyce</strong> &#8211; I&#8217;m not totally sure what you&#8217;re asking? We chose a vertical navigation bar to make it easier to scan for categories. The previous design had a horizontal navigation bar, and there were so many categories that it was just kind of hard to quickly look through it. </p>
<p>We ended up borrowing heavily from the MP6 aesthetic, so the inclusion of icons not only helped reinforce the brand, but also subtly reinforced the meaning of each category. I had made some icons, but they lacked finesse and polish, so I asked Ben Dunkle (lead icon designer for WordPress.org) to play around with some different ideas for each category. I think they ended up pretty slick.</p>
<div id=\"attachment_8610\" class=\"wp-caption aligncenter\"><a href=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/DashIcons.jpg\" rel=\"thumbnail\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/DashIcons.jpg?resize=462%2C268\" alt=\"Dashicons\" class=\"size-full wp-image-8610\" /></a><p class=\"wp-caption-text\">Dashicons &#8211; Which One Is The Hamburger Menu Icon?</p></div>
<p><strong>Scott Reilly</strong> &#8211; The icons are Dashicons: <a href=\"http://melchoyce.github.io/dashicons/\" title=\"http://melchoyce.github.io/dashicons/\">http://melchoyce.github.io/dashicons/</a>, some of which were tweaked or custom-made for the site. While I wasn&#8217;t involved in the primary design itself, the sidebar of job types is a better presentation than the block of links that appeared at the top of the page. As Mel said, the use of the icons help reinforce the job types and branding, and it gives the site some graphical pizzazz.</p>
<p><strong>Was the site ever powered by bbPress, or is it entirely driven by WordPress?</strong></p>
<p><strong>Scott Reilly</strong> &#8211; I can only speak definitively to the previous and current incarnations of the site, but there isn&#8217;t any current use of bbPress nor have I seen any indication that bbPress ever powered any part of the site. The site is currently solely powered by WordPress.</p>
<p><strong>What other enhancements do you have in store for the site in the near future?</strong></p>
<p><strong>Mel Choyce</strong></p>
<p>The mantra for stage one of the redesign was get something done and ship it. Now that we&#8217;ve pushed version one out the door, we&#8217;ve started discussing and working on future enhancements. One of the first things we&#8217;re doing is working on applying better responsive styles. We&#8217;ve also talked about throwing new jobs into a single table on the homepage, instead of listing per category, but we haven&#8217;t really decided on anything yet. It&#8217;s an ongoing WIP.</p>
<p><strong>Scott Reilly</strong> &#8211; Our primary goal and focus has been to get the new design launched. We managed just about everything we wanted to include and then some, having kept our goals modest. We still need to make a few tweaks to get it fully mobile-friendly. We&#8217;ll be releasing the theme soon via the meta.svn repository (also viewable at: <a href=\"http://meta.trac.wordpress.org/browser/\" title=\"http://meta.trac.wordpress.org/browser/\">http://meta.trac.wordpress.org/browser/</a>) as part of our efforts to open source the code of dotorg. We&#8217;re actually open to community requests via trac tickets at <a href=\"http://meta.trac.wordpress.org/report/1\" title=\"http://meta.trac.wordpress.org/report/1\">http://meta.trac.wordpress.org/report/1</a> (there&#8217;s a jobs.wordpress.net component) and eventually community patches.</p>
<h2>What Does Mark Think?</h2>
<p>After the announcement was published of the redesign, I sent an email to Mark Ghosh to get his thoughts. He approved of the new look and considered it a worthy upgrade. </p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/bfFRfLUm4VM\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Aug 2013 22:57:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WordPress.tv: Grant Landram: Creating a Better WordPress Admin Experience for Clients\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:102:\"http://wordpress.tv/2013/08/22/grant-landram-creating-a-better-wordpress-admin-experience-for-clients/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:777:\"<div id=\"v-FyUM9x2l-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21521/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21521/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21521&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/22/grant-landram-creating-a-better-wordpress-admin-experience-for-clients/\"><img alt=\"Grant Landram: Creating a Better WordPress Admin Experience for Clients\" src=\"http://videos.videopress.com/FyUM9x2l/01-grant-landram-creating-a-better-wordpress-admin-experience-for-clients_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Aug 2013 18:50:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WordPress.tv: Matthew Eppelsheimer: Checklists: A Path To Mistake-Free Development And Publishing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"http://wordpress.tv/2013/08/22/matthew-eppelsheimer-checklists-a-path-to-mistake-free-development-and-publishing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:810:\"<div id=\"v-shw9WAXO-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21509/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21509/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21509&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/22/matthew-eppelsheimer-checklists-a-path-to-mistake-free-development-and-publishing/\"><img alt=\"Matthew Eppelsheimer: Checklists: A Path To Mistake-Free Development And Publishing\" src=\"http://videos.videopress.com/shw9WAXO/2-matthew-eppelsheimer-checklists-a-path-to-mistake-free-development-and-publishing_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Aug 2013 18:39:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: Dashboard Usage Survey Results Now Available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8591\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"http://feedproxy.google.com/~r/WordpressTavern/~3/zu6Ufr1o9yQ/dashboard-usage-survey-results-now-available\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6768:\"<p>Dave Martin also known as Lessbloat has <a title=\"http://make.wordpress.org/ui/2013/08/21/3-8-dashboard-plugin/\" href=\"http://make.wordpress.org/ui/2013/08/21/3-8-dashboard-plugin/\">published the results</a> from the Dashboard survey. There were 438 responses which is a good sample to start from but Dave mentions that the survey has biased results as most of the people who participated were developers. Knowing that the majority of responses were from the developer community, the results don&#8217;t surprise me one bit.</p>
<p>Out of 416 answers, when asked <em>Which sections of the Dashboard do you never use (and think should go away?)</em> Other WordPress News took first place with 79% of the vote with QuickPress a very close second at 78% they were within 3 votes of each other. WordPress Blog, Plugins, and Incoming Links were generally close to taking the third spot. I would have thought that the Welcome Screen would have the least amount of votes to be removed but the Recent Comments widget claimed that position. <span id=\"more-8591\"></span></p>
<p><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/DashboardSurveyQuestion2Results.jpg\" rel=\"thumbnail\"><img class=\"aligncenter size-large wp-image-8592\" alt=\"Question 2 Results For Dashboard Survey\" src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/DashboardSurveyQuestion2Results.jpg?resize=500%2C217\" /></a></p>
<p><strong>Question 3</strong> asked, <em>How often do you post with QuickPress</em>? it&#8217;s almost comical to see the response of <strong>Never</strong> take 92% of the vote.</p>
<p><a href=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/DashboardSurveyQuestion3Results.jpg\" rel=\"thumbnail\"><img class=\"aligncenter size-large wp-image-8593\" alt=\"Question 3 Results\" src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/DashboardSurveyQuestion3Results.jpg?resize=500%2C120\" /></a></p>
<p><strong>Question 4</strong> asked <em>What sort of modifications do you typically make to the Dashboard (for yourself or for clients), and why?</em> There is no illustration since the results are text-based but the CSV containing the responses is <a title=\"http://cl.ly/3f2y1e0T1o09\" href=\"http://cl.ly/3f2y1e0T1o09\">publicly available</a>. I browsed through the document and was not surprised at the amount of people who remove most of the Dashboard widgets or completely redesign the Dashboard to fit their project.</p>
<p><strong>Question 5</strong> asked <em>If you could wave a magic wand, what types of things would you show on the Dashboard?</em> These answers are also <a title=\"http://cl.ly/1H1b391L3N3Y\" href=\"http://cl.ly/1H1b391L3N3Y\">publicly available</a> as a CSV file and I thought were interesting. The majority of answers revolve around the idea of creating a Quicklinks Dashboard widget that would enable a quick way to accomplish common tasks. For example: <em>A widget called &#8220;I would like to&#8230;&#8221; with a list of common tasks (add new post/page/media/theme/plugin, moderate comments, etc.) that would take the user straight to that section of wp-admin;&#8221;</em> While you can&#8217;t access all tasks within the Dashboard, the Admin Bar already facilitates a quick way to create a new Post, Media, Page, User, Role, and if you have GravityForms installed, Forms. I wonder if the Admin bar is not being seen, is not being used, or simply isn&#8217;t the answer.</p>
<p>Stats were another popular suggestion for the Dashboard whether it was the stats that come with Jetpack or Google Analytics, a lot of people just want to see stats right on the Dashboard.</p>
<h2>My Thoughts:</h2>
<p>Taking into consideration that many of the survey respondents are developers and consultants, many of their answers correlate with what they commonly experience with clients. The issue I take with those responses is that I&#8217;m not a client. Reading over the survey responses, I get the feeling that people need a ton of hand holding to get anything done or to navigate anywhere within the WordPress back-end. Maybe that&#8217;s the case but not for me. Some people even suggested to just get rid of the entire Dashboard concept and just forward people to the post creation screen or the settings screen depending on the user role.</p>
<p>Personally, I think the Dashboard concept needs to be completely rethought. Not only thinking about how the current implementation can be improved, but also what is the Dashboard really supposed to accomplish? Let&#8217;s also dedicate some time and discussion in creating an all new Dashboard concept just to see where it goes.</p>
<p>The more I think about it, the more I&#8217;d like to see the Dashboard function just like the Dashboard in my car. Give me warnings or caution signs of things that don&#8217;t seem right such as a page or link that is causing 404 errors for people, the average page load on the site increasing to an unacceptable level, etc. The Right Now box in the current implementation is the most important meta box for me. I feel that if information such as what I see in the Unpublished Content meta box from Edit Flow and the Site Stats was combined into the Right Now box, it would be much more useful and cut down the number of metaboxes on the screen. I&#8217;d like to be able to use the Right Now box to view trends on the site as well as be able to act on those trends. In fact, let&#8217;s get rid of the Right Now box and just call the whole thing Dashboard. One metabox filled with all kinds of information. Not sure how well tabs would work here because one box would quickly get cluttered with <strong>TOO MUCH</strong> information. As a site administrator, I want to see all of the information I can. This wouldn&#8217;t work for other user roles. I&#8217;d like to see user roles with fewer capabilities get a slimmed down version of what&#8217;s presented on the Dashboard. I think this already occurs to an extent where certain links are inaccessible based on capabilities.</p>
<h2>Time To Get Involved:</h2>
<p>The Dashboard revamp will take place as a plugin similar to how MP6 was developed. If you are interested in working on this plugin, you&#8217;re encouraged to leave a comment on the <a title=\"http://make.wordpress.org/ui/2013/08/21/3-8-dashboard-plugin/\" href=\"http://make.wordpress.org/ui/2013/08/21/3-8-dashboard-plugin/\">announcement post</a>. I love the fact that there is a discussion taking place about a major facet of WordPress and furthermore, that development will take place in a plugin rather than in core itself. I&#8217;m really digging these changes in the development approach of WordPress.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/zu6Ufr1o9yQ\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 22 Aug 2013 11:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Photocrati Hires A Lead Happiness Engineer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8573\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"http://feedproxy.google.com/~r/WordpressTavern/~3/wSWHHF_bTiI/photocrati-hires-a-lead-happiness-engineer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3881:\"<p><a href=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/PhotocratiLogo.jpg\" rel=\"thumbnail\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/PhotocratiLogo.jpg?resize=164%2C39\" alt=\"Photocrati Logo\" class=\"alignright size-full wp-image-8588\" /></a>Photocrati, the company behind NextGen Gallery has hired on a lead happiness engineer. Edward Caissie who is better known throughout the WordPress community as <a href=\"http://profiles.wordpress.org/cais\" title=\"http://profiles.wordpress.org/cais\">JellyBeen</a> was the person hired into the position. The hiring couldn&#8217;t have come at a better time considering how many people have <strong>NOT</strong> been happy with the latest version of the plugin which lead to the company <a href=\"http://www.wptavern.com/nextgen-gallery-creator-publishes-open-letter\" title=\"http://www.wptavern.com/nextgen-gallery-creator-publishes-open-letter\">publishing an open letter</a> to the community. I reached out to Edward to find out why he applied for the job and what his responsibilities will be. <span id=\"more-8573\"></span></p>
<p><strong>Why did I decide to take on a job with Photocrati?</strong></p>
<p>Well, to be honest, I had been looking for a position with a WordPress-related company for some time and kept my eyes open for promising opportunities. The position as the Lead Happiness Engineer &#8211; NextGEN Gallery pretty much was made for me. I have over 20 years of Customer Service, 10+ years in web development, and I&#8217;ve spent the last five years or so honing my WordPress skills to a point where I was able to not only write themes and plugins but also help others to do the same. The job description just seem to hit all the points I was looking for as well.</p>
<p>I get to work online, which basically means I get to work from home, or the cottage, or a coffee shop &#8230; anywhere there is decent Internet. There is also opportunity to grow with Photocrati.</p>
<p><strong>In the midst of all the hoopla surrounding the latest release of NextGen Gallery, what will you be doing to calm down all of the upset people who have broken sites due to the update?</strong></p>
<p>The thing is, we started talking back in February; long before any of the recent issues with NextGEN 2.0.x came to light. So I am on board with Photocrati to primarily help with Support. Mostly for paying customers but also for support (to a certain extent) of the free version of the NextGEN Gallery plugin as well. The opportunity to work with the developers is always there and as Photocrati grows more opportunities may become available as well.</p>
<p>Most of my primary goals and fairly much most of my first days/weeks will be supporting customers and helping to get NextGEN to a much more stable release. I&#8217;ll be doing whatever I can to help out the customers, but to be quite honest NextGEN Gallery is a very large and quite complex plugin and when I am not helping customers I am delving into the code to learn its workings as well as offer any assistance and/or enhancements/improvements I find.</p>
<p><strong>Is the position equal to that of the Automattic happiness engineer where your primary goal is to make customers happy?</strong></p>
<p>Essentially, the &#8220;Happiness Engineer&#8221; part of the title is derived from Automattic&#8217;s ideals but being a much smaller organization the role definition is probably a bit more encompassing than what Automattic&#8217;s might be.</p>
<p><strong>Edward has been a long-standing member of not only the WordPress community but of the WPTavern community as well. I congratulate him on getting a job he is happy with. If the lead happiness engineer is not happy, how would he be able to spread happiness to customers?</strong></p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/wSWHHF_bTiI\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2013 21:44:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"WPTavern: The Daily Plugin – System Snapshots, Folder Slider, Harmonia, Content Blocks, String Locator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8511\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"http://feedproxy.google.com/~r/WordpressTavern/~3/SAAiZagoHq0/the-daily-plugin-system-snapshots-folder-slider-harmonia-content-blocks-string-locator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5996:\"<p>It&#8217;s Wednesday which means it&#8217;s hump day and the week-end is in sight! Today, we&#8217;ll take a look at plugins like <strong>System Snapshot Report, Folder Slider, Harmonia, Content Blocks, String Locator and Export User Data</strong>. As always, make sure you backup and test on a staging site before taking any of these plugins live. We highlight these plugins as applications of interest and not an endorsement or official review. Let&#8217;s get plugged in!<br />
<span id=\"more-8511\"></span></p>
<p><!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->
<a href=\"http://www.wptavern.com/wp-content/uploads/2013/08/DailyPlugin-08212013.mp3\">http://www.wptavern.com/wp-content/uploads/2013/08/DailyPlugin-08212013.mp3</a><br />
<br /><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/systeminfo.png\" rel=\"thumbnail\"><img class=\"alignleft size-thumbnail wp-image-8528\" alt=\"System Snapshot\" src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/systeminfo.png?resize=150%2C150\" /></a><a title=\"System Snapshot Report\" href=\"http://wordpress.org/plugins/system-snapshot-report/\" target=\"_blank\">System Snapshot Report</a> is a simple admin only plugin that provides a boatload of data about the server and related diagnostics. It provides you with quick-glance data that you can use to troubleshoot any issues you may be having with a WordPress installation. Data output includes version information for WordPress, PHP info, how your posts are displayed, how many users are active, etc. Essentially this is an all in one diagnostic and auditing tool that provides an entire snapshot of your entire WordPress operating environment. I&#8217;ve had plugins that provide some of this data, but this is the most comprehensive solution to show me all of the data I could possibly need to learn all about the internal structure of a unique WordPress installation.</p>
<p><a title=\"Folder Slider\" href=\"http://wordpress.org/plugins/folder-slider/\" target=\"_blank\">Folder Slider</a> presents an alternative to the standard slider input. Generally sliders operate as being fed from either the Featured Image or as a separate slide management area within the slider plugin settings. This particular plugin is unique in that it instead pulls from a folder of images stored online to create the sliders. A basic set of transitions and options apply that allow you to present the images in a clean and aesthetically pleasing way. I&#8217;ve grown to appreciate plugins that feed directly from folders. Sometimes you just don&#8217;t need the extra management or setup that&#8217;s required when you simply want to display a slider of images without all the bells and whistles. This is a good no-frills option that can be updated simply by replacing the files in a folder via FTP.</p>
<p><a title=\"Harmonia Inline MP3 Player\" href=\"http://wordpress.org/plugins/harmonia/\" target=\"_blank\">Harmonia</a> is a very interesting plugin that takes the new 3.6 inline player a bit further. This plugin finds all mp3 links in your content area and replaces the links with an inline audio player, allowing for instant listening. I like plugins that take all of the coding out of the post process, even if the coding is just a shortcode. When plugins like this come along, it makes it so much easier for WordPress novices to expand their content reach without requiring a speck of code. The player is in need of some more customization options, but it worked well for me in my staging tests thus far.</p>
<p><a title=\"Content Blocks\" href=\"http://wordpress.org/plugins/wp-content-blocks/\" target=\"_blank\">Content Blocks</a> is a mystery plugin from the wordpressdotorg team that is labeled as &#8220;<em>exploratory</em>&#8220;. This has me intrigued as I hope it does for you as well. I have no idea what it does or how it will work, but I&#8217;m going to find out. I can&#8217;t wait to see what&#8217;s inside the black box.</p>
<p><a title=\"String Locator\" href=\"http://wordpress.org/plugins/string-locator/\" target=\"_blank\">String Locator</a> is something that I&#8217;ve been waiting for, for a long time. It performs a site-wide search of your themes and plugins for a specific string. I can&#8217;t tell you how many times I&#8217;ve been editing a theme or CSS file and missed at least one other instance that I needed to change, but could not locate. This plugin solves that problem by providing an easy to use search function to find all those needles in your theme&#8217;s haystack. It&#8217;s also good for spotting altered or malicious code that may appear from nowhere.</p>
<p><a title=\"Export User Data\" href=\"http://wordpress.org/plugins/export-user-data/\" target=\"_blank\">Export User Data</a> gives you the option to export all of your user data into an Excel sheet for offline viewing. It includes options for exporting your users by role, a range of registration dates and usermeta options. It can export in both CSV and Excel formats. Data that can be exported also includes BuddyPress and bbPress profile data. I recently exported the BuddyPress profile data on a membership site run by a client. We then took the data to invite everyone on the site to connect to the site author on LinkedIn. Though it&#8217;s just one simple use, it is nice to have a full export capability that is not a full database.</p>
<p>That&#8217;ll do &#8216;er for today&#8217;s plugin bonanza. Make sure you stop back here tomorrow for more of the plugins that could change your life, or at least your reading habits. As always you can contact me on Twitter <a title=\"Marcus Couch on Twitter\" href=\"https://twitter.com/marcuscouch\">@marcuscouch</a> or here on <a title=\"The Daily Plugin for 08-19-2013\" href=\"http://wptavern.com/the-daily-plugin-wordpress-radio-system-snapshots-folder-slider-harmonia-content-blocks-string-locator\">WPTavern</a>.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/SAAiZagoHq0\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2013 20:34:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marcus Couch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WordPress.tv: Bob Dunn: Making Your WordPress Knowledge Stick\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21511\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wordpress.tv/2013/08/21/bob-dunn-making-your-wordpress-knowledge-stick/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:704:\"<div id=\"v-EL0Y8QKK-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21511/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21511/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21511&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/21/bob-dunn-making-your-wordpress-knowledge-stick/\"><img alt=\"Bob Dunn: Making Your WordPress Knowledge Stick\" src=\"http://videos.videopress.com/EL0Y8QKK/5-bob-dunn-making-your-wordpress-knowledge-stick_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2013 17:29:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"WordPress.tv: Геннадий Ковшенин: Автоматизация тестирования в WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://wordpress.tv/2013/08/21/gennady-kovshenin-automated-testing-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:733:\"<div id=\"v-PEeFKRNG-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21562/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21562/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21562&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/21/gennady-kovshenin-automated-testing-in-wordpress/\"><img alt=\"Геннадий Ковшенин: Автоматизация тестирования в WordPress\" src=\"http://videos.videopress.com/PEeFKRNG/video-693a0a2bb0_scruberthumbnail_27.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2013 07:15:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Matt: Using Publishing To Push Change\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=42957\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"http://ma.tt/2013/08/using-publishing-to-push-change/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:260:\"<p>Rachael Chong has an article on Fast Company Co.exist <a href=\"http://www.fastcoexist.com/3015907/generosity-series/the-cofounder-of-wordpress-on-using-publishing-to-push-change\">that includes my thoughts on giving, charity, and impact in the world</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2013 07:05:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"WordPress.tv: Austin Gunter: Lean Product Development – 4 Steps to Build Something Your Customers Want to Buy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"http://wordpress.tv/2013/08/20/austin-gunter-lean-product-development-4-steps-to-build-something-your-customers-want-to-buy/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:854:\"<div id=\"v-fRmJ98kA-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21535/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21535/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21535&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/20/austin-gunter-lean-product-development-4-steps-to-build-something-your-customers-want-to-buy/\"><img alt=\"Austin Gunter: Lean Product Development – 4 Steps to Build Something Your Customers Want to Buy\" src=\"http://videos.videopress.com/fRmJ98kA/02-austin-gunter-lean-product-development-e28093-4-steps-to-build-something-your-customers-want-to-buy_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 19:30:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WordPress.tv: Jen Mylo: The Only Constant Is Change\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21508\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wordpress.tv/2013/08/20/jen-mylo-the-only-constant-is-change/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:674:\"<div id=\"v-kQANrLn2-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21508/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21508/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21508&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/20/jen-mylo-the-only-constant-is-change/\"><img alt=\"Jen Mylo: The Only Constant Is Change\" src=\"http://videos.videopress.com/kQANrLn2/1-jen-mylo-the-only-constant-is-change_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 17:37:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Jen Mylo: Automatticians at WordCamps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"http://jenmylo.com/?p=1900\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://jenmylo.com/2013/08/20/automatticians-at-wordcamps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4732:\"<p>Automattic is getting pretty big, almost 200 folks now, spread all over the world. That&#8217;s a lot of people we can send to WordCamps. I remember when it was mostly Matt and I splitting up who&#8217;d go to which events &#8212; how times have changed in five years!</p>
<p>Since we&#8217;re <a href=\"http://automattic.com/work-with-us/\">hiring so enthusiastically</a>, my team is putting together a little guide for Automatticians on how to be an awesome Automattic representative at a WordCamp. I have a pretty giant list of tips and advice at the ready (you&#8217;d never have guessed, I know), but it occurs to me that non-Automatticians are probably the best people to ask about what we can do better when we pop in to a local WordCamp.</p>
<p>Here are some of the things from my giant list so far:</p>
<ul>
<li><strong>Don&#8217;t travel in packs.</strong> When there are a few or a bunch of Automatticians at an event, we tend to cluster together because we so rarely get to see each other &#8212; and we like each other &#8212; but it makes it less likely that we&#8217;ll meet new community members. 1. Because we&#8217;re too busy talking to each other to reach out to new people. 2. Because it&#8217;s intimidating for someone new to break into that group.</li>
<li><strong>Ask questions.</strong> A lot of WordCamp attendees will already know about Automattic, so while we should definitely be a resource for anyone interested in the company, the better use of time is getting to know the community members: who are they, how are they using WordPress, what would help them make their community more vibrant, who are the local independent consultants/themers/developers that we should know about?</li>
<li><strong>Help out.</strong> WordCamps are a lot of work. Automatticians aren&#8217;t visiting dignitaries &#8212; we&#8217;re getting paid to be there &#8212; and we should help out along with the locals, whether that&#8217;s taking a shift on the help desk, moving chairs, or passing out shirts.</li>
<li><strong>Be identifiable.</strong> Wearing the same WordPress t-shirt as everyone else is cool and all, but wearing a shirt that identifies the wearer as an Automattic employee, or a lanyard for the badge or something, would make it easier for people interested in talking about Automattic (especially people interested in jobs!) to find the Automatticians in the crowd.</li>
<li><strong>Carry cards.</strong> Saying &#8220;email me later&#8221; works better when the card with an email address is handed over at the same time. That said, getting community member contact info so the burden of follow-up isn&#8217;t on them is even better.</li>
<li><strong>Tweet It.</strong>  Using Twitter to let local followers know Automatticians are there is helpful. They might love to meet in person and talk about working at Automattic or contributing to the .org project and may not realize we&#8217;re there, especially if we&#8217;re not on the speaker list.</li>
<li><strong>Don&#8217;t hog the speaker slots.</strong> Yes, Automatticians are speakers you can rely on, and we do employ a lot of seriously smart people, but if the speaker roster is filled up with Automatticians, that doesn&#8217;t do a lot to help grow the experience of local folks, which is part of what WordCamps are about.</li>
<li><strong>Don&#8217;t be exclusionary.</strong> If planning to go off to an Automattician dinner or something after a long day of not traveling as a pack, don&#8217;t make those plans in front of other people, who will feel excluded (or might not understand what&#8217;s happening and might inadvertently show up later and crash the dinner); make <em>private</em> plans in <em>private</em> via Automattic channels. Even better, don&#8217;t go to private dinners, go to dinner with members of the local community.</li>
<li><strong>Be present.</strong> In sessions, don&#8217;t work on the laptop, just pay attention to the speaker. In the crowd, don&#8217;t focus on the phone, smile and meet new people. Be there for the whole event, don&#8217;t take off early or skip the second day. Show the local community that Automatticians are respectful and want to be there.</li>
</ul>
<p>What would you add? In the comments (or in an email to me at jenmylo/wordpress.org if you don&#8217;t want people to see what you think) make suggestions for what Automatticians can do to be awesome at WordCamps. It&#8217;s also okay to give examples of times when we have not been awesome. Learning from our mistakes is good, too. Thanks in advance for your help!</p>
<br />  <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=jenmylo.com&blog=45389656&post=1900&subd=jenmylo&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 16:24:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Jen Mylo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WordPress Category Now Available On Microlancer.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8516\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"http://feedproxy.google.com/~r/WordpressTavern/~3/W9xZwKqbsZU/wordpress-category-now-available-on-microlancer-com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6972:\"<p><a href=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/microlancerlogo.jpg\" rel=\"thumbnail\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/microlancerlogo.jpg?resize=247%2C48\" alt=\"MicrolancerLogo\" class=\"alignright size-full wp-image-8517\" /></a>Microlancer, an Envato owned company has <a href=\"http://www.microlancer.com/explore/wordpress\" title=\"http://www.microlancer.com/explore/wordpress\">recently added a WordPress category</a> for users needing work done to their WordPress site. The site has been in private beta since April of 2013 and helps build a bridge between freelancers and clients. The site currently has three different WordPress service categories available, <a href=\"http://www.microlancer.com/explore/website-to-wordpress\" title=\"http://www.microlancer.com/explore/website-to-wordpress\">Website to WordPress</a>, <a href=\"http://www.microlancer.com/explore/wordpress-customization\" title=\"http://www.microlancer.com/explore/wordpress-customization\">WordPress Customization</a>, <a href=\"http://www.microlancer.com/explore/wordpress-plug-ins\" title=\"http://www.microlancer.com/explore/wordpress-plug-ins\">WordPress Plug-ins</a>. Service Providers (freelancers who list their services and provide them for buyers) can choose a fixed price for their services, as well as a turnaround time that suits them. Buyers pay upfront. Any disputes are resolved fairly by Microlancer staff. Skellie was nice enough to answer two questions I had concerning the site. <span id=\"more-8516\"></span></p>
<p><a href=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/MicrolancerWPServices.jpg\" rel=\"thumbnail\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/MicrolancerWPServices.jpg?resize=500%2C360\" alt=\"WordPress Services On Microlancer\" class=\"aligncenter size-large wp-image-8518\" /></a></p>
<p><strong>What&#8217;s the biggest difference between using a job board and something like Microlancer?</strong></p>
<p>You can find someone great much more quickly and with much less back and forth than you can using a job board. On Microlancer, prices are fixed and clearly visible, and each job states a turnaround time that the service provider must meet. Every listing includes visual examples of previous work, and a description of what is included in the service. There&#8217;s no time spent on trawling through copy and paste job bids, endless back and forth communication, trying to get a clear quote. Everything you need to know is stated upfront before you&#8217;ve paid a cent.</p>
<p><strong>How will consumers be protected from people trying to rip them off?</strong></p>
<p>When a buyer purchases a service on Microlancer, the funds don&#8217;t go straight to the service provider. Instead, they are kept in holding and only released when a job is successfully completed. If at any point during the job the client is unhappy with the work, they can start a dispute. Disputes are fairly resolved by Microlancer staff. A client will never be forced to pay for bad quality work, or bad service.</p>
<div class=\"aligncenter\"></div>
<p>One thing I noticed on their <a href=\"http://www.microlancer.com/how-it-works\" title=\"http://www.microlancer.com/how-it-works\">How It Works</a> page is that clients receive a set number of revisions so you better know what you want before doing business. When asked who controls the number of revisions clients/customers receive, I was told that the seller controls the number of revisions as well as the turnaround time but the revisions were capped at 3. I was also curious to know whether customers can provide feedback through ratings or reviews and yes they can. Although not all services have reviews as they are optional from the buyer, <a href=\"https://www.microlancer.com/explore/business-card-design/588-creative-profession-business-card-designs\" title=\"https://www.microlancer.com/explore/business-card-design/588-creative-profession-business-card-designs\">here is an example</a> of a service that has both a recommendation percentage on the right-hand side and at least one review below the service description. </p>
<h2>A Service Providers Perspective:</h2>
<p>Microlancer is in its infancy but I was able to get in touch with at least one service provider to try to get their thoughts on using the service. They have only used it for a week or so but this is what they had to say:</p>
<p><em>I&#8217;ve had one project so far but I don&#8217;t see myself using it in the future unless I really spend some time prepackaging everything I do into little one-off services.</p>
<p>The whole interface just doesn&#8217;t fit into a good mechanism for working with code. Perhaps my viewpoint is skewed as I do so much freelancing for WordPress on <a href=\"https://codeable.io/\" title=\"https://codeable.io/\">Codeable.io</a> (which is amazing for WordPress freelancing).</em></p>
<p><strong>How would you rate the experience of dealing with clients via Microlancer?</strong></p>
<p>Poor. No live chat so the back and forth is slow. My single experience with a project so far has been that the client didn&#8217;t actually read the description of the service and instead just read the title and went off that. So while my description said &#8216;<em>12 specific style changes</em>&#8216;, what he wanted was something different. As of right now the project status is unknown to me. We had a bit of back and forth to clarify what he wanted, I agreed and now have not heard anything. The project was &#8220;<em>started</em>&#8221; but I assume I&#8217;ll need to contact support to have the project cancelled.</p>
<p><strong>What is your general observation of the service?</strong></p>
<p>Very mixed feelings. It&#8217;s nice to have another option for freelancing and one at which I can just list my services and wait for clients to pick them is enticing. However it doesn&#8217;t seem to have a good mechanism in place for scope creep, additional feature/service requests or a good client interaction.</p>
<h2>My Thoughts:</h2>
<p>Cruising around the site looking over the various services being provided, I think Microlancer is a great idea. There seems to be a WordPress service for everything such as customizing the WordPress login screen to modifying an existing design into a responsive layout. However, it will only be as good as the work clients receive. Collis Ta’eed CEO of Envato has had an abundant amount of success with the likes of <a href=\"http://themeforest.net/\" title=\"http://themeforest.net/\">ThemeForest</a> and <a href=\"http://codecanyon.net/\" title=\"http://codecanyon.net/\">CodeCanyon</a>. Will Microlancer be another feather in his cap?</p>
<p>If you have any questions, concerns, or general feedback for Microlancer, feel free to share it in the comments as representatives will be monitoring the comment section. </p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/W9xZwKqbsZU\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 16:00:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WordPress Radio – WPR.FM – Get Involved\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8543\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://feedproxy.google.com/~r/WordpressTavern/~3/FUVmCnHe2JM/wordpress-radio-wpr-fm-get-involved\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5229:\"<p>Since my involvement in WordPress some 9 years ago, I followed the various audio and video productions pertaining to WordPress with great interest. As the technology of podcasting became more prevalent and easier to produce, there were many new productions about WordPress that came and went. Recently though, there have been a lot of really good shows that have been released on a regular basis that have provided a well-rounded set of listening choices. I believe the time has come to engage in a community based strategic alliance of these shows in the form of a 24/7 streaming audio station. <span id=\"more-8543\"></span></p>
<p><strong>Thus, the formation of <a title=\"WordPress Radio\" href=\"http://wpr.fm\">WPR.FM</a>. WordPress Radio.</strong></p>
<p><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPRFM.jpg\" rel=\"thumbnail\"><img class=\"alignleft size-medium wp-image-8550\" alt=\"WordPress Radio\" src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPRFM.jpg?resize=300%2C168\" /></a>At first, I was unsure how to go about starting a streaming radio station. As a podcaster of 8+ years, streaming was always viewed as the &#8220;old&#8221; way of doing things. This was more commonly profiled due to lack of bandwidth or mobile portability. Nowadays with modern carrier technology able to stream anywhere we are, I feel the stars have aligned to create an audio channel that&#8217;s all ours. I approached my friend &#8220;Mr. Oil&#8221; who runs <a title=\"Fralnet\" href=\"http://fralnet.com\">FralNet</a>, a UK-based host provider and he liked the idea so much that he graciously offered to help get us up and running at no cost! He helped me with the setup, and in 10 minutes, we were streaming to the world!</p>
<p>Now that the connections were made and the &#8220;on-air light&#8221; has been illuminated, it&#8217;s time to get the DJ&#8217;s in their proper rotation. Ideally we would like to see the following shows in the programming lineup: <a title=\"WordPress Weekly\" href=\"http://www.wptavern.com/wordpress-weekly\">WordPress Weekly</a> with Jeff Chandler, <a title=\"Wordpress Plugins A-Z Podcast\" href=\"http://wppluginsatoz.com\">WordPress Plugins A-Z</a> with John Overall and Marcus Couch, <a title=\"Your Website Engineer\" href=\"http://yourwebsiteengineer.com/\">Your Website Engineer</a> with Dustin Hartzler, <a title=\"The WordPress Chick\" href=\"http://thewpchick.com\">The WordPress Chick</a> with Kim Doyal, <a title=\"WP Water Cooler\" href=\"http://www.wpwatercooler.com/\">WP Watercooler</a> with Chris Lema, Jeff Tucker and cast, <a title=\"DradCast\" href=\"http://dradcast.com/\">DradCast</a> with Brad Williams and Dre Armeda, <a title=\"Matt Report\" href=\"http://mattreport.com/\">Matt Report</a> with Matt Medeiros, <a title=\"Weekly Web Tools\" href=\"http://weeklywebtools.com\">Weekly Web Tools</a> with Dave Jackson and others like <a title=\"WP Bacon\" href=\"http://wpbacon.com/\">WP Bacon</a>, <a title=\"Apply Filters\" href=\"http://applyfilters.fm/\">Apply Filters</a> and my own 3 minute news segment of The Daily Plugin. And that&#8217;s just who I listen to. There are probably tons more that I am missing.</p>
<p>From an additional content perspective, how cool would it be to get Q&amp;A segments from WordCamps or Meetup Groups? How about a monthly &#8220;Industry Night&#8221; show where <strong>EVERYONE</strong> who produces a show all gets on a call and goes around the table talking WordPress? I think our community would get a lot of benefit from this. We also have the ability to stream live, so the possibilities are only limited by what content is available to us.</p>
<h2>So we have a WordPress stream, now what?</h2>
<p><strong>Site Design and Development</strong><br />
The next phase will be site builds and profiles for all the content, shows and presenters. This is where I am looking for the community for help. If this is a project that you believe has merit and you&#8217;d like to volunteer to help with the site build, please let me know.</p>
<p><strong>App Creation</strong><br />
If you have experience in APP development for both Android and iOS and would like to work on the APP project with us, we welcome your participation there as well. Our goal is to create a free stream companion app that can be played on the go and have all the appropriate show information about both content and hosts.</p>
<p><strong>Content Programming</strong><br />
We&#8217;re looking for help with programming the station as well. As we start receiving more submitted content from the WordPress Community, it will be important to keep a high standard with regards to the production elements. We&#8217;d like to make this a professional station with station IDs, show introductions/lead-ins and fresh WP news content every day. If you are an experienced audio editor, we would enjoy your participation as well.</p>
<p>For everyone else, I invite you to tune in! The stream is already live and can be listened to on our splash page one any device, in any format.</p>
<p>So what do you think of the concept? Let me know what ideas you have and what I may have missed.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/FUVmCnHe2JM\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 11:00:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marcus Couch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"WordPress.tv: Анна Ладошкина: Адаптивный контент в WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21497\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"http://wordpress.tv/2013/08/20/anna-ladoshkina-responsive-content-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:709:\"<div id=\"v-ywKdvX3M-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21497/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21497/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21497&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/20/anna-ladoshkina-responsive-content-in-wordpress/\"><img alt=\"Анна Ладошкина: Адаптивный контент в WordPress\" src=\"http://videos.videopress.com/ywKdvX3M/video-1a1cc42cfc_scruberthumbnail_1.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 09:17:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: Better Wording Needed For After The Deadline Prompt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8562\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"http://feedproxy.google.com/~r/WordpressTavern/~3/axRljp_6i7M/better-wording-needed-for-after-the-deadline-prompt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1814:\"<p>I&#8217;ve used the After The Deadline service for a long time. In fact, I think I&#8217;ve been using it ever since <a href=\"http://blog.afterthedeadline.com/2009/09/08/after-the-deadline-acquired/\" title=\"http://blog.afterthedeadline.com/2009/09/08/after-the-deadline-acquired/\">Automattic acquired it</a> in 2009. I proofread almost every post before it&#8217;s published. However, I&#8217;ve recently been struck by the wording of the AtD prompt once I schedule or publish a post. If you don&#8217;t use AtD, here is what it looks like.</p>
<p><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/ATDPrompt.jpg\" rel=\"thumbnail\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/ATDPrompt.jpg?resize=444%2C144\" alt=\"After The Deadline Prompt\" class=\"aligncenter size-full wp-image-8563\" /></a></p>
<p>The wording in this prompt is all wrong. There have been at least a couple of instances where I have pressed OK thinking that the After The Deadline spell checker would Update my post with the necessary corrections or, allow me to actually update the errors in the post but instead, end up publishing the post. I think the most important wording that needs to be changed is the part that says &#8220;<em>Press OK To Update Your Post</em>&#8220;.  So I&#8217;m throwing this out to everyone else to not only see how many people have mistakenly pressed OK only to have their post be published or scheduled, but also ask what do you think the wording of this prompt should be changed to? While were at it, perhaps I&#8217;m the only one screwing things up around here and it&#8217;s not really a problem. After all, I believe the prompt has been this way for a long time.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/axRljp_6i7M\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 05:09:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Lorelle on WP: Fall 2013 WordPress College Courses\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"http://lorelle.wordpress.com/?p=10115\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"http://lorelle.wordpress.com/2013/08/19/fall-2013-wordpress-college-courses/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:521:\"Registration is now open for the two WordPress college courses I teach at Clark College in Vancouver, Washington, and Portland Community College at Rock Creek in Beaverton, just west of Portland, Oregon. See Classes and Workshops for details. I&#8217;ve been working with Robert Hughes of the Computer Technology Department at Clark College for almost two [&#8230;]<img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=lorelle.wordpress.com&blog=72&post=10115&subd=lorelle&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 20 Aug 2013 03:40:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Lorelle VanFossen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: WP-ABTesting – Split Testing As A Service\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://feedproxy.google.com/~r/WordpressTavern/~3/n96enm9M4zU/wp-abtesting-split-testing-as-a-service\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8019:\"<p>There is a new up and coming AB Split testing service for WordPress called <a title=\"http://wp-abtesting.com/\" href=\"http://wp-abtesting.com/\">WP-ABTesting</a> that aims to help you optimize websites based on data, not opinions. Anytime I&#8217;ve heard of anyone wanting an A/B testing plugin, I&#8217;ve referred them to <a title=\"http://wordpress.org/plugins/shrimptest/\" href=\"http://wordpress.org/plugins/shrimptest/\">ShrimpTest</a> by Mitcho and Automattic however, it appears that development on that plugin has ceased as it hasn&#8217;t been updated in over 2 years. There is also a plugin <a title=\"http://poststat.us/a-b-testing-wordpress/\" href=\"http://poststat.us/a-b-testing-wordpress/\">mentioned by PostStat.us</a> called AB Press Optimizer. WP-ABTesting took some time out to answer a few questions I had about their service. <span id=\"more-8521\"></span></p>
<p><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPABTestingLogo.jpg\" rel=\"thumbnail\"><img class=\"aligncenter size-full wp-image-8531\" alt=\"WP AB Testing Logo\" src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPABTestingLogo.jpg?resize=435%2C75\" /></a></p>
<p><strong>Tell us a bit about the WP AB Testing service.</strong></p>
<p>We provide a <span>native</span> conversion optimization service for WordPress sites. Our aim is to increase your conversion rates (whatever your conversion goal is: more sign-ups, sales, visitors,&#8230;) in a systematic and scientific way. Opinions are great but only if they are used to start a data-driven experiment to (dis)prove them before deciding on whether to implement them or not. Nobody (not even you) is good enough to predict what will work for your site.</p>
<p>At the core of our service you have an A/B testing (also known as split testing) mechanism. In its simplest form, A/B testing works by predefining two or more alternatives for a given post or page and the conversion goal you want to achieve with them, and then randomly showing those alternatives to your visitors to check which one works better, i.e. which one has a higher conversion rate. For instance, you may want to create two alternative versions of your landing page, show 50% of the time each alternative and monitor which one makes more of your visitors to sign-up for your mailing list. Once the results are statistically significant (don’t be scared, we will hide all the math from you, just keep reading!) you consolidate the winning alternative and start again with a new test.</p>
<p><strong>What will WP AB Testing have that may not be found in plugins or other similar services?</strong></p>
<p>Most tools focus on the classic AB testing: you define the tests and the tools report on the number of conversions of each alternative. We believe this is just the tip of the iceberg.</p>
<p>Our service goes beyond this in two main directions:</p>
<ul>
<li> <strong>-</strong> Technical level. We don’t want to restrict people to test only posts / pages with a standard AB Testing algorithm. Since our service is a native WordPress solution we can offer fine-grained tests in which other WordPress components (like menus, widgets or the theme itself) can be tested as well. Then, the plug-in automatically evolves the site based on the results of those tests (obviously, only if you want the plug-in to do that for you). We’ll also complement A/B testing with other testing / optimization strategies like greedy algorithms and heat maps to offer a better picture of what’s going on in the site. Another example we have in our future roadmap is to enable the use of social metrics as conversion goals (i.e. an alternative post is better if it gets reshared more times) which we believe can be interesting for some sites.</li>
</ul>
<ul>
<li> <strong>-</strong> Personalization level. Raw data on the percentage of improvement of an alternative may be enough for math savvy users but won’t do much for the rest. We believe in A/B testing for everybody which means that our service will help people to understand the meaning of the numbers they see to make an informed decision. And, more importantly, for those that want a more hassle-free experience, we will offer a personalized service where one of our company experts will suggest possible tests for your site (e.g. based on ours and the community experience on what has worked in other sites in the same domain) and even create and monitor the tests for you.</li>
</ul>
<p><strong>Why is AB Testing an important practice to conduct on websites from time to time?</strong></p>
<p>First, I&#8217;d like to “challenge” the fact that AB Testing should be done “from time to time”. In our opinion, you should always be optimizing your site. Even if some optimizations may only bring a small improvement, they add up so the overall effect may well surprise you!.</p>
<p>A second reason, which is not usually mentioned, is that you are going to learn a lot about your site and your business when doing A/B tests. Many  people regard A/B tests as mere small changes on the look and feel of your site (e.g. changing the color of a button here, increasing the size of an image there,&#8230;) but they can be much more powerful than that. I regard them as a learning tool for the business owner. Just thinking about possible tests gives you a perfect excuse to reconsider your business assumptions and offers a low-risk approach to test alternative approaches that otherwise you would have never dared to try. And if the test fails (meaning that your current version doesn’t need to be changed) you should even be happier. Failed tests are as useful as successful ones. They allow you to get rid of possible scenarios that now you know for sure wouldn’t work.</p>
<p><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPABTesting1.jpg\" rel=\"thumbnail\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/WPABTesting1.jpg?resize=500%2C171\" alt=\"WP ABTesting Service\" class=\"aligncenter size-large wp-image-8539\" /></a></p>
<p><strong>Why the decision to turn WP AB Testing into a dedicated service instead of a fully featured plugin?</strong></p>
<p>We try to combine the best of both worlds: a WP plug-in on the “client” side that the user can install to define the tests, see the graphics with the results, consolidate the winning alternative,&#8230; all without leaving the WordPress environment (meaning there is no need to learn a new tool) plus an external back-end that takes care of recording and processing all the relevant data to evaluate the performance of the alternatives tested.</p>
<p>We believe this makes a lot of sense, again both at the technical and business level. On the technical side we lift all the processing load from your own server so that the tests do not slow down your site or interfere with your hosting provider limits. On the business side, because an ongoing relationship is needed to be able to advise you on your best testing strategy (by checking what has worked and what hasn’t worked so far for you), on new tests that we believe could be specially useful for you, etc. </p>
<p>Don’t forget that A/B Testing is only the means to an end (optimize your conversions) and not the end itself. Our mission is to make sure you bring your site to the next level, not just to provide you with a tool to do all the work on your own.</p>
<p><strong>How can people be notified and participate in the beta?</strong></p>
<p>Just go to our <a href=\"http://wp-abtesting.com/\" title=\"http://wp-abtesting.com/\">website</a> and join our <a href=\"http://wp-abtesting.com/sign-up-for-our-free-beta/\" title=\"http://wp-abtesting.com/sign-up-for-our-free-beta/\">mailing list</a> in less than 30 seconds. We’ll immediately contact you to get to know you better (what are your needs, expectations, etc) and give you more details about the beta program.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/n96enm9M4zU\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Aug 2013 21:42:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"BuddyPress: The BuddyPress Codex Survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://buddypress.org/?p=170004\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://buddypress.org/2013/08/the-buddypress-codex-survey/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1010:\"<p><a href=\"http://bpdevel.wordpress.com/2013/08/01/buddypress-1-9-dev-cycle-plans/\">As part of the work on the upcoming 1.9 release</a>, we&#8217;re putting effort into improving the BuddyPress documentation. There have been many great new features and improvements to BuddyPress over the last few releases and we need to bring the documentation up to date.</p>
<p>We&#8217;ve launched the <a href=\"http://mercime.polldaddy.com/s/2013-buddypress-codex-survey\">Buddypress Codex Survey</a>. The survey is already providing useful feedback and it will be used to finalise the structure of the Codex and help put together a plan to improve the documentation over the next few releases.</p>
<p>If you haven&#8217;t already taken the survey, we encourage you to add your feedback on what matters to you. We especially value any comments you care to leave on what pages you would find useful that might not exist at present.</p>
<p>Thanks for helping BuddyPress grow; we really appreciate your responses! Thanks!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Aug 2013 19:13:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Hugo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WP Android: More Control over Mobile Posting: Excerpts and Picasa Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"http://android.wordpress.org/?p=890\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"http://android.wordpress.org/2013/08/19/more-control-over-mobile-posting-excerpts-and-picasa-support/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2295:\"<div id=\"attachment_893\" class=\"wp-caption alignright\"><a href=\"http://wpandroid.files.wordpress.com/2013/08/post-excerpt.png\"><img class=\"size-medium wp-image-893 \" alt=\"\" src=\"http://wpandroid.files.wordpress.com/2013/08/post-excerpt.png?w=200&h=353\" width=\"200\" height=\"353\" /></a><p class=\"wp-caption-text\">New excerpt field added to the post editor.</p></div>
<p>The latest update to WordPress for Android includes some small yet very handy new features:</p>
<ul>
<li><strong>Post Excerpt:</strong> Just below the content area in the post editor you&#8217;ll now see a <a href=\"http://codex.wordpress.org/Excerpt\">post excerpt</a> field. Use it to add a post summary to your post. <em>(Note: Your theme will need to support post excerpts in order for this feature to work).</em></li>
<li><strong>Picasa and Google+ Image Support:</strong> You can now add Picasa/Google+ images from the Android Gallery to posts or pages. Just tap the camera icon in the formatting toolbar then select an image to add it to the post. You&#8217;ll need to be online so that the image can be downloaded. You can also select multiple images in the gallery and share them to the app for quicker posting!</li>
</ul>
<p>We&#8217;ve also fixed up a few bugs in this release that improve the reliability of the app.</p>
<p><span>What&#8217;s next?</span></p>
<p>We are very close to having a beta release of the new Media Library management and Theme Selection features! Make sure to follow <a href=\"http://make.wordpress.org/mobile\" rel=\"nofollow\">http://make.wordpress.org/mobile</a> if you are interested in trying the beta.</p>
<p>A big thanks to all of the contributors that made this release happen: <a href=\"http://wordpress.org/support/profile/aagam94\">aagam94</a>, <a href=\"http://wordpress.org/support/profile/mrroundhill\">mrroundhill</a>, <a href=\"http://wordpress.org/support/profile/daniloercoli\">daniloercoli</a> and <a href=\"http://wordpress.org/support/profile/mbiais\">mbias</a>!</p>
<p>Any thoughts on the new update? Drop a comment here or follow us <a href=\"http://twitter.com/wpandroid\">@WPAndroid</a> to let us know!</p>
<br />  <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=android.wordpress.org&blog=9426921&post=890&subd=wpandroid&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Aug 2013 17:43:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Dan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"WordPress.tv: Константин Ковшенин: Как повысить скорость сайта на WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21491\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"http://wordpress.tv/2013/08/19/konstantin-kovshenin-wordpress-site-speed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:732:\"<div id=\"v-P6fXNUXD-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21491/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21491/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21491&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/19/konstantin-kovshenin-wordpress-site-speed/\"><img alt=\"Константин Ковшенин: Как повысить скорость сайта на WordPress\" src=\"http://videos.videopress.com/P6fXNUXD/video-6c23e5b638_scruberthumbnail_82.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Aug 2013 14:31:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:163:\"WordPress.tv: Николай Миронов: Сайт-портфолио на WordPress — эффективный инструмент для фрилансера\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21449\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://wordpress.tv/2013/08/19/nikolay-mironov-wordpress-portfolio/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:742:\"<div id=\"v-xEFsxgWR-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21449/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21449/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21449&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/19/nikolay-mironov-wordpress-portfolio/\"><img alt=\"Сайт-портфолио на WordPress &#8211; эффективный инструмент для фрилансера\" src=\"http://videos.videopress.com/xEFsxgWR/video-d73a104fac_scruberthumbnail_5.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Aug 2013 14:07:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: WPWeekly Episode 118 – Hey Get Flywheel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8504\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://feedproxy.google.com/~r/WordpressTavern/~3/lG5qhD0IUwA/wpweekly-episode-118-hey-get-flywheel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2234:\"<p><img class=\"alignright size-full wp-image-436\" title=\"wordpressweekly1\" alt=\"wordpressweekly1\" src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2009/02/wordpressweekly1.png?resize=120%2C120\" />In this episode, we covered the headlines of the week, most notable is the open letter published to the NextGen Gallery community. Most of the show was dedicated to an interview with Dusty Davidson of <a title=\"http://getflywheel.com/\" href=\"http://getflywheel.com/\">Flywheel.com</a>, a WordPress hosting company catering to designers, freelancers, and creative agencies. What does that all mean? You&#8217;ll have to tune in to figure it out.</p>
<h2>Stories Discussed:</h2>
<p><a title=\"http://www.wptavern.com/the-return-of-wordpress-weekly\" href=\"http://www.wptavern.com/the-return-of-wordpress-weekly\">The Return Of WordPress Weekly</a><br />
<a title=\"http://www.wptavern.com/survey-how-do-you-use-the-dashboard\" href=\"http://www.wptavern.com/survey-how-do-you-use-the-dashboard\">How Do You Use The Dashboard?</a><br />
<a title=\"http://www.wptavern.com/nextgen-gallery-creator-publishes-open-letter\" href=\"http://www.wptavern.com/nextgen-gallery-creator-publishes-open-letter\">NextGEN Gallery Publishes Open Letter To Their Community</a><br />
<a title=\"http://www.wptavern.com/ill-be-at-wordcamp-grand-rapids-2013\" href=\"http://www.wptavern.com/ill-be-at-wordcamp-grand-rapids-2013\">I’ll Be At WordCamp Grand Rapids 2013</a><br />
<a title=\"http://www.wptavern.com/revamping-the-content-creation-experience-in-wordpress\" href=\"http://www.wptavern.com/revamping-the-content-creation-experience-in-wordpress\">Revamping The Content Creation Experience In WordPress</a><br />
<a href=\"http://jobs.wordpress.net/\" title=\"http://jobs.wordpress.net/\">WordPress Jobs Board Gets A Facelift</a></p>
<h2>WPWeekly Meta:</h2>
<p><strong>Length Of Episode:</strong> 1 Hour 13 Minutes</p>
<p><strong>Download The Show:</strong> <a href=\"http://recordings.talkshoe.com/TC-34224/TS-776534.mp3\" title=\"http://recordings.talkshoe.com/TC-34224/TS-776534.mp3\">Download Episode 118</a></p>
<p><strong>Listen To Episode #118:</strong><br />
</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/lG5qhD0IUwA\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Aug 2013 06:01:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WordPress.tv: Nikolay Bachiyski: Writing Code as User Experience Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=20996\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wordpress.tv/2013/08/15/nikolay-bachiyski-writing-code-as-user-experience-design/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:694:\"<div id=\"v-IvRCRZ1m-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/20996/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/20996/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=20996&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/15/nikolay-bachiyski-writing-code-as-user-experience-design/\"><img alt=\"Nikolay Bachiyski: Writing Code as User Experience Design\" src=\"http://videos.videopress.com/IvRCRZ1m/01-bachiyski_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Aug 2013 04:51:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WordPress.tv: George Stephanis: The Seven Deadly Theming Sins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21380\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"http://wordpress.tv/2013/08/15/george-stephanis-the-seven-deadly-theming-sins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:672:\"<div id=\"v-KSRX3jPw-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21380/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21380/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21380&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/15/george-stephanis-the-seven-deadly-theming-sins/\"><img alt=\"George Stephanis: The Seven Deadly Theming Sins\" src=\"http://videos.videopress.com/KSRX3jPw/video-acbaa5e497_std.original.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Aug 2013 22:24:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"WPTavern: The Return Of WordPress Weekly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8493\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://feedproxy.google.com/~r/WordpressTavern/~3/HvlU1KguFpY/the-return-of-wordpress-weekly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2888:\"<p><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2009/02/wordpressweekly1.png\" rel=\"thumbnail\"><img src=\"http://i0.wp.com/www.wptavern.com/wp-content/uploads/2009/02/wordpressweekly1.png?resize=120%2C120\" alt=\"WordPress Weekly Logo\" class=\"alignright size-full wp-image-436\" /></a>Beginning this <strong>Friday at 9P.M. Eastern</strong>, I&#8217;ll be back behind the microphone providing you with the news of the week around the WordPress ecosystem. I&#8217;ll also be interviewing some of the smartest people in the WordPress community that are making things happen. Unlike the previous episodes which were all <a href=\"http://tinyurl.com/wpweekly\" title=\"http://tinyurl.com/wpweekly\">conducted on Talkshoe.com</a>, these will be recorded live via Google Hangout. I&#8217;m not so much interested in the video portion of the show as I am the audio. I&#8217;ve reconfigured the <a href=\"http://www.wptavern.com/wordpress-weekly\" title=\"http://www.wptavern.com/wordpress-weekly\">Podcast page</a> so that folks can chat and listen/watch the show on the website. Thanks to using Google Hangout, the audio quality should be better for everyone participating on the show. I decoded to use the embeddable IRC client via Freenode to power the chatroom as it gives users the chance to use their favorite client, is not powered by flash, and updates in real-time. The only downside is the captcha on the form which I can&#8217;t do anything about but I haven&#8217;t come across any images that were impossible to read. </p>
<p>This weeks episode will feature an interview with the folks behind WordPress hosting company <a href=\"http://getflywheel.com/\" title=\"http://getflywheel.com/\">Flywheel</a>. We&#8217;ll talk about their beta process, what is it they are trying to accomplish and how their service is different from the large amount of competition that already exists in the managed WP hosting market. If you have any questions you&#8217;d like me to ask, just leave them in the comments and I&#8217;ll add them to my list.</p>
<p>One thing I&#8217;m still unsure of is how I&#8217;m going to continue using the iTunes feed that was hooked up to Talkshoe or if I should start a brand new one from scratch. I need to find out if I can upload MP3 files to a specific iTunes link without needing the file to go through Talkshoe. I may end up using the <a href=\"http://wordpress.org/plugins/powerpress/\" title=\"http://wordpress.org/plugins/powerpress/\">Blubrry PowerPress</a> plugin to automate the process of sending the podcast to iTunes. </p>
<p>Next Friday there will not be a live show as I&#8217;ll be in Grand Rapids, Michigan for WordCamp. However, I&#8217;m already lining up guests for August 30th and beyond. I&#8217;m looking forward to talking WordPress again. </p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/HvlU1KguFpY\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Aug 2013 17:50:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: Survey – How Do You Use The Dashboard?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8440\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"http://feedproxy.google.com/~r/WordpressTavern/~3/QjrBY23HiVQ/survey-how-do-you-use-the-dashboard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2353:\"<p>Amidst all of the conversation taking place on improving the WordPress back-end user interface, there is now a <a title=\"http://wp-survey.polldaddy.com/s/wp-dashboard-questionnaire\" href=\"http://wp-survey.polldaddy.com/s/wp-dashboard-questionnaire\">public survey</a> you are encouraged to participate in that will help determine how people use the dashboard and where improvements need to take place. The survey is only 5 questions long but should provide enough information to determine a direction of travel for improvements. For a moment, let&#8217;s take a look at the proposed dashboard for the Ghost platform.</p>
<div id=\"attachment_8456\" class=\"wp-caption aligncenter\"><a href=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/TryGhostDashboard.jpg\" rel=\"thumbnail\"><img src=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/TryGhostDashboard.jpg?resize=500%2C321\" alt=\"Try Ghost Dashboard\" class=\"size-large wp-image-8456\" /></a><p class=\"wp-caption-text\">Preview Of The Proposed Ghost Dashboard</p></div>
<p>I think a few people, including myself became enamored over the dashboard concept for Ghost but upon looking at it more closely, it&#8217;s just a bunch of numbers in my face. Hard to judge something I haven&#8217;t been able to play around with but it was nice to see a refreshing take on the entire dashboard concept. In the WordPress Dashboard Survey, I was reminded just how much I don&#8217;t use the Dashboard for anything other than getting at-a-glance information. I also realized that if the  <strong>Right Now</strong> meta box included information from some other dashboard widgets like recent comments, recent drafts, etc, that the Right Now box would be more beneficial to me and provide less widgets to be displayed on the screen at one time. </p>
<p>I&#8217;m opening up the conversation by asking what is it that would make the dashboard super useful for you? There is an intricate balance that needs to be observed on the type and amount of data that is shown to the user before it becomes information overload or just a bunch of numbers in front of the users face. There is also the problem of creating a dashboard that&#8217;s useful to everyone, not just specific use cases of WordPress.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/QjrBY23HiVQ\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Aug 2013 15:20:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"bbPress: bbPress 2.4 – Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://bbpress.org/?p=135968\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"http://bbpress.org/blog/2013/08/bbpress-2-4-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1209:\"<p>Today the bbPress team is happy to tell you about <a href=\"http://downloads.wordpress.org/plugin/bbpress.zip\">bbPress 2.4, release candidate 1</a>.</p>
<p>bbPress 2.4 introduces hierarchical replies, allowing you to pick between paginated topics or a hierarchy (similar to WordPress&#8217;s comments.) There are a few smaller improvements all around, including: pretty URL&#8217;s for search results pages, code posting, an Akismet admin UI, BuddyPress Group Forum integration, general query improvements, PHP 5.4 E_STRICT notices, theme compatibility, author metaboxes, some settings API changes, <a href=\"http://bbpress.trac.wordpress.org/query?group=status&milestone=2.4\">and more</a>!</p>
<p>Please give <a href=\"http://downloads.wordpress.org/plugin/bbpress.zip\">bbPress 2.4 RC 1</a> a try a test site &#8212; or wherever you feel comfortable running it &#8212; and <a href=\"http://bbpress.trac.wordpress.org\">let us know if you run into any issues</a>. If all goes well, we&#8217;re going to release 2.4 next week.</p>
<p>(Don&#8217;t forget&#8230; to get easy access to pre-releases, install the <a href=\"http://wordpress.org/extend/plugins/bbpress-beta-tester/\">bbPress Beta Tester</a> plugin.)</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Aug 2013 01:06:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"John James Jacoby\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: NextGEN Gallery Creator Publishes Open Letter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://www.wptavern.com/?p=8444\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"http://feedproxy.google.com/~r/WordpressTavern/~3/8prZ5wa1bCw/nextgen-gallery-creator-publishes-open-letter\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3808:\"<p><a href=\"http://i1.wp.com/www.wptavern.com/wp-content/uploads/2013/08/Screen-Shot-2013-08-14-at-4.46.36-PM.png\" rel=\"thumbnail\"><img src=\"http://i2.wp.com/www.wptavern.com/wp-content/uploads/2013/08/Screen-Shot-2013-08-14-at-4.46.36-PM.png?resize=300%2C101\" alt=\"NextGen Gallery Logo\" class=\"alignright size-medium wp-image-8449\" /></a>NextGEN Gallery is one of the most popular WordPress plugins in the repository and has been for a long time. The last time I checked, it was closing in on over 8 million downloads. However, the latest release of the plugin has caused grief for many people as evidenced by the <a href=\"http://wordpress.org/support/plugin/nextgen-gallery\" title=\"http://wordpress.org/support/plugin/nextgen-gallery\">plugin&#8217;s support forum</a>. This has caused Erick Danzer one of the core developers for the plugin to <a href=\"http://www.nextgen-gallery.com/open-letter-to-the-nextgen-community-from-erick-danzer/\" title=\"http://www.nextgen-gallery.com/open-letter-to-the-nextgen-community-from-erick-danzer/\">publish an open letter to the NextGEN Gallery Community</a> admitting that the latest version has serious issues and they are working day and night to try to resolve them. </p>
<blockquote><p>I want to start by simply recognizing that, yes, there are many and very serious issues with this update. No doubt about it. We’ve been caught very off guard. Those of you experiencing these problems are entirely justified to feel angry and ask hard questions.</p>
<p>For us, it’s not a question of not caring. It’s a question of what’s the best way to respond under immense pressure from many directions.</p>
<p>We are working ourselves to our physical and emotional breaking points trying to respond to users and solve issues as fast as we can because we do care. I’m honestly not kidding about this.</p></blockquote>
<p>I love how Erick and team have grabbed the bull by the horns and are using their blog to control and manage the conversation around their plugin. This open letter reminds me of a post I wrote in 2008 on WeblogToolsCollection.com where I told people to <a href=\"http://weblogtoolscollection.com/archives/2008/08/24/stop-blaming-the-wordpress-team/\" title=\"http://weblogtoolscollection.com/archives/2008/08/24/stop-blaming-the-wordpress-team/\">stop blaming the WordPress Team.</a> It&#8217;s a bit different with NextGEN but the message is the same. As outlined in the letter, the team did everything they could to make sure this was a good release but no matter how well they tested, the results would have never come close to the actual environments used by thousands of plugin users. </p>
<p>What that open letter really means is that Erick Danzer and the rest of the NextGEN Gallery team are committed to the project and are doing everything they can to turn wrongs into rights. I commend him for publishing the letter and addressing all of the noted concerns in one post. Anytime a company or author of a major plugin or theme uses communication in this way, they should be commended as most of the time, communication is the last thing on their minds. Although it doesn&#8217;t fix the problem, just knowing that the developer feels your pain and acknowledges the problem is enough to calm me down and do anything I can to help the developer fix it as soon as possible.</p>
<p>Erick Danzer is not the plugins creator. It&#8217;s listed as <a href=\"http://profiles.wordpress.org/photocrati/\" title=\"http://profiles.wordpress.org/photocrati/\">Photocrati</a> on WordPress.org. Photocrati is a growing digital media company helping photographers improve their web presence while leveraging our premium themes, hosting, and plugins for WordPress.</p>
<img src=\"http://feeds.feedburner.com/~r/WordpressTavern/~4/8prZ5wa1bCw\" height=\"1\" width=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Aug 2013 20:58:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Jeffro\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Matt: WordPress.com Connect\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"http://ma.tt/?p=42952\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"http://ma.tt/2013/08/wordpress-com-connect/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:780:\"<p>I&#8217;m really excited about the <a href=\"http://en.blog.wordpress.com/2013/08/13/introducing-wordpress-com-connect/\">launch of WordPress.com Connect</a>. Yes Facebook et al offer similar APIs and have more users, but there are two key differences. First is Automattic is not an advertising-driven company, so our priorities around users are different than ones who are. Second is that these APIs are the basis for <em>interacting with any element of an entire website hosted on WP.com or not</em>, meaning themes, widgets, posts, content, CSS&#8230; any company that does something that ultimately ends up on a website should be <a href=\"http://developer.wordpress.com/\">looking at the APIs on developer.wordpress.com</a> and pushing us where there isn&#8217;t one yet.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Aug 2013 20:50:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WordPress.tv: Bob Dunn: The Beginner’s Guide to Choosing a Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wordpress.tv/?p=21231\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://wordpress.tv/2013/08/14/bob-dunn-the-beginners-guide-to-choosing-a-theme/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:685:\"<div id=\"v-pmL3izI9-1\" class=\"video-player\">
</div>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wptv.wordpress.com/21231/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wptv.wordpress.com/21231/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=wordpress.tv&blog=5089392&post=21231&subd=wptv&ref=&feed=1\" width=\"1\" height=\"1\" /><div><a href=\"http://wordpress.tv/2013/08/14/bob-dunn-the-beginners-guide-to-choosing-a-theme/\"><img alt=\"Bob Dunn: The Beginner’s Guide to Choosing a Theme\" src=\"http://videos.videopress.com/pmL3izI9/video-b584af2135_scruberthumbnail_0.jpg\" width=\"160\" height=\"120\" /></a></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Aug 2013 20:41:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"WordPress.tv\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"Alex King: From Freelance to Agency – WordCamp SF 2013\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://alexking.org/?p=18001\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://alexking.org/blog/2013/08/14/from-freelance-to-agency-wordcamp-sf-2013\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:305:\"<p>The video from my panel at WordCamp SF is now online. Thanks to <a href=\"http://ma.tt\">Matt</a>, <a href=\"http://tri.be/author/shane/\">Shane</a>, <a href=\"http://10up.com/about/#employee-jake-goldman\">Jake</a> and <a href=\"http://webdevstudios.com/team/brad-williams/\">Brad</a> for a great session.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Aug 2013 16:31:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Alex\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WP iPhone: Version 3.7 is Here: New Native WordPress.com Reader &amp; More Available Today\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"http://ios.wordpress.org/?p=1447\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://ios.wordpress.org/2013/08/14/version-3-7-native-reader/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3491:\"<p><a href=\"http://wpiphone.files.wordpress.com/2013/08/wpios-3-7-reader.jpg\"><img class=\"alignright size-medium wp-image-1461\" alt=\"wpios-3-7-reader\" src=\"http://wpiphone.files.wordpress.com/2013/08/wpios-3-7-reader.jpg?w=240&h=442\" width=\"240\" height=\"442\" /></a><br />
WordPress for iOS 3.7 is out and now available for download from the <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?ls=1&mt=8\">App Store</a>. This release introduces a revamped Reader, some under-the-hood improvements for account management, and lays the groundwork for some neat things to come.</p>
<h3>Native Reader</h3>
<p>We first introduced the Reader in version 2.9 back in September of 2011. The original Reader was a hybrid approach &#8212; some native code wrapping what was essentially a webpage and lots of JavaScript. It served us well, but there were places where embracing a fully native experience offers better performance.  Version 3.7 introduces a new Reader built with 100% native code. It&#8217;s very fast and beautiful to look at. What&#8217;s more, we&#8217;re already working to make it even better!</p>
<p>Access the Reader from the sidebar while signed in with your WordPress.com account.  Read stories from blogs you follow, posts you liked, as well as your favorite topics. Join the conversion by liking, reblogging, and commenting from within the Reader, and follow blogs you enjoy reading.</p>
<h3>Accounts Management</h3>
<p>We&#8217;ve streamlined how the app manages your credentials and handles authentication with a new accounts system. The improvements are all under-the-hood, so visually, there&#8217;s nothing to see there.  You will notice the app doing a better job connecting to multiple services including your blog, Jetpack, the Reader, and notification features.</p>
<h3>Other Improvements</h3>
<p>More goodness in 3.7:</p>
<ul>
<li>Several bug and crash fixes.</li>
<li>View Admin now opens in Safari instead of inside the app for a better experience.</li>
<li>Thai is now a supported language.</li>
</ul>
<h3>What&#8217;s next?</h3>
<p>Apple has announced iOS 7 and we&#8217;re keen to be ready for the launch of the new OS later this year. We&#8217;re already working on improvements to the new native Reader. We&#8217;ve also planned improvements to media and a new themes management feature. Follow our progress at <a href=\"http://make.wordpress.org/mobile\" rel=\"nofollow\">http://make.wordpress.org/mobile</a>.</p>
<p>A huge thanks to the nine contributors who worked on this release: @aarondouglas, @aerych, @daniloercoli @hugobaeta, @irbrad, @isaackeyet, @koke, @sendhil, and <a href=\"https://github.com/danielrsmith\">Daniel Smith</a>. If you would like to get involved with WordPress for iOS development, drop us a line at <a href=\"http://make.wordpress.org/mobile\">http://make.wordpress.org/mobile</a> and grab a copy of the code at <a href=\"https://github.com/wordpress-mobile/WordPress-iOS\">https://github.com/wordpress-mobile/WordPress-iOS</a>.</p>
<p>Have feedback?  Leave a comment below or tweet us at <a href=\"http://twitter.com/wordpressios\">@WordPressiOS</a>.</p>
<br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/wpiphone.wordpress.com/1447/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/wpiphone.wordpress.com/1447/\" /></a> <img alt=\"\" border=\"0\" src=\"http://stats.wordpress.com/b.gif?host=ios.wordpress.org&blog=3882653&post=1447&subd=wpiphone&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 Aug 2013 14:29:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Eric\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 28 Aug 2013 21:47:40 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"153650\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Wed, 28 Aug 2013 21:30:33 GMT\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20130802050543\";}","no");
INSERT INTO `ts968ny_3_options` VALUES("753","_transient_timeout_dash_4077549d03da2e451c8b5f002294ff51","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("754","_transient_dash_4077549d03da2e451c8b5f002294ff51","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wordpress.org/news/2013/08/oscar/\' title=\'The latest and greatest WordPress, version 3.6, is now live to the world and includes a beautiful new blog-centric theme, bullet-proof autosave and post locking, a revamped revision browser, native support for audio and video embeds, and improved integrations with Spotify, Rdio, and SoundCloud. Here’s a video that shows off some of the features using […]\'>WordPress 3.6 “Oscar”</a> <span class=\"rss-date\">August 1, 2013</span><div class=\'rssSummary\'>The latest and greatest WordPress, version 3.6, is now live to the world and includes a beautiful new blog-centric theme, bullet-proof autosave and post locking, a revamped revision browser, native support for audio and video embeds, and improved integrations with Spotify, Rdio, and SoundCloud. Here’s a video that shows off some of the features using […]</div></li><li><a class=\'rsswidget\' href=\'http://wordpress.org/news/2013/07/wordpress-3-6-release-candidate-2/\' title=\'The second release candidate for WordPress 3.6 is now available for download and testing. We’re down to only a few remaining issues, and the final release should be available in a matter of days. In RC2, we’ve tightened up some aspects of revisions, autosave, and the media player, and fixed some bugs that were spotted […]\'>WordPress 3.6 Release Candidate 2</a> <span class=\"rss-date\">July 24, 2013</span><div class=\'rssSummary\'>The second release candidate for WordPress 3.6 is now available for download and testing. We’re down to only a few remaining issues, and the final release should be available in a matter of days. In RC2, we’ve tightened up some aspects of revisions, autosave, and the media player, and fixed some bugs that were spotted […]</div></li></ul></div>","no");
INSERT INTO `ts968ny_3_options` VALUES("755","_transient_timeout_feed_mod_867bd5c64f85878d03a060509cd2f92c","1377769659","no");
INSERT INTO `ts968ny_3_options` VALUES("756","_transient_feed_mod_867bd5c64f85878d03a060509cd2f92c","1377726459","no");
INSERT INTO `ts968ny_3_options` VALUES("757","_transient_timeout_dash_aa95765b5cc111c56d5993d476b1c2f0","1377769660","no");
INSERT INTO `ts968ny_3_options` VALUES("758","_transient_dash_aa95765b5cc111c56d5993d476b1c2f0","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://wordpress.tv/2013/08/28/al-caldarone-create-your-own-member-access-templates-with-custom-sidebar-widgets/\' title=\'     \'>WordPress.tv: Al Caldarone: Create Your Own Member Access Templates with Custom Sidebar Widgets</a></li><li><a class=\'rsswidget\' href=\'http://wordpress.tv/2013/08/28/andrew-nacin-wordpress-in-transition/\' title=\'     \'>WordPress.tv: Andrew Nacin: WordPress in Transition</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressTavern/~3/SeNQaf5t6Yo/mollom-security-breach\' title=\'Over the week-end, I received an email from Mollom notifying me that they had discovered a security breach. According to their official blog post on the matter, the breach was discovered on August 21st. Mollom is a service managed by Acquia, a commercial open source software company providing products, services, and technical support for the open source Drupal social publishing system. The service works in a similar fashion to Akismet in that it scans messages such as comments to determine whether or not they are spam.  This is an important security notice from the Mollom team. On August 21, we identified a breach of one of our Mollom servers. Our subsequent investigation showed that unauthorized users gained access to Mollom servers and were potentially able to access Mollom data. Today we have closed the security loophole used to gain access and taken measures designed to prevent future breaches. Data that may have been compromised includes usernames, account contact information, passwords, Mollom public and private keys, and billing transaction logs. PayPal account information was NOT stored on the affected servers. At this time, we have no evidence that any malicious activity took place with customer data. To help assure this continues to be the case, in addition to the measures described above, we have changed all Mollom user account passwords.  Mollom has automatically reset all user account passwords to access the administrative interface. This means you’ll need to access the following URL in order to reset your password.  The bottom line is if you signed up to use Mollom free or as a paid customer, you should reset your password and keep a close eye on your financial records, especially if you have or had a paid account even though credit card information was not stored on the affected server. The unauthorized access was NOT a direct result of a vulnerability within Drupal. If any additional information is discovered during their investigation, the Mollom team will continue to update the blog post. \'>WPTavern: Mollom Security Breach</a></li><li><a class=\'rsswidget\' href=\'http://ma.tt/2013/08/harder-slower-less-secure/\' title=\'Jay Rosen (and Barry Eisler) on the surveillance state’s efforts to make journalism harder, slower, less secure. The gist: why would they destroy hard drives they know there are copies of, and detain couriers they know they’ll have to release?\'>Matt: Harder, Slower, Less Secure</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressTavern/~3/3luWcT9hGW8/the-full-story-behind-wp-wallpaper\' title=\'If you’ve been scouring the web for WordPress specific images to use as your desktop background, have a look at WP-Wallpaper. The site doesn’t have a huge variety of images to choose from now but over the course of the next few months, I think that will change. I reached out to Alison Barrett who manages the site to find out about its history and what plans if any she has for the site.  WordPress Lights by Alison Barrett Can you provide a brief history of the domain, considering it existed before you purchased it? I don’t know much about the previous owner of the domain. The original site was my main source of desktop wallpapers for a long time, and I had referred dozens of people to it. I was bummed when I learned the site was down. I went searching for the owner, and I didn’t realize the domain had expired until the whois search turned up empty. Do you know of any other sites that have an abundant amount of WordPress desktop wallpapers? I can’t think of any other dedicated WP wallpaper sites off the top of my head, though a Google search might turn up one or two. I didn’t come across any when I was searching for the creators of the wallpapers on the original site. My initial reason for buying the domain was that I felt bad for referring friends to something that wasn’t even live anymore. Now I’m enjoying running the site, and I love seeing all the excitement around it. The community’s response to it is driving me to keep making it even better. I would love to find the creators of the wallpapers from the original site, because there were a lot of gorgeous images up there. I don’t want to republish them without attribution and permission. Any chance of getting this site linked to from the Fan Art section of WordPress.org or having a small dedicated section showing 3-6 wallpapers? I hadn’t thought about getting this site linked under the Fan Art section on .org—that’s a great idea! I’ll see what I can do. Any chance of adding a ratings system, reviews, or any other social aspects to the images similar to DeviantArt? I do plan on implementing a ratings system eventually, though my priority right now is supporting multiple resolutions for each wallpaper (including mobile). I will probably add some sharing tools in the near future as well. How can people submit images to the site and how should the submissions be licensed?  Wallpapers can be submitted through the form on the submit page: http://wp-wallpaper.com/submit/ . Technical requirements are laid out there (and will be updated once I get mobile resolution support in place). Images must be released under the Creative Commons Attribution Share-Alike license, as that is what they are distributed under on the site. Oops: After The Launch After this interview was conducted with Alison, I did some research into the history of the domain since she didn’t know too much about it. I plugged the domain into the Wayback machine and didn’t see any results. For a site that Alison pointed to over the years for WordPress wallpapers, it stands to reason it would have some history behind it. Just for experimentation, I added an S to the end of the domain so it was http://wp-wallpapers.com/ and while that particular domain has expired, it did show up with quite a few results in the Wayback machine. The first record on the internet archive is for October 17th 2011. This entry tells us that WP-Wallpapers.com used the Expose theme from ThemeForest to show off the content of the site. That theme is still available for sale but is not 100% GPL licensed.   The next entry was a WordPress maintenance page. However, On March 31st 2012, the site had a few pages of Wallpapers available. It’s also during this time that we discover the site was owned and operated by the Envato network. The last working entry is on March 23rd, 2013 with at least 5 pages worth of wallpaper images.  Conclusions So not only has Alison pointed people to the wrong domain over the years, she also purchased the wrong domain. She missed it by one letter. I reached out to Envato to find out what their plans are for the domain: We’re always trying to streamline our processes and focus more on the projects that really matter to us, which is why we decided to discontinue WP-Wallpapers.com. But we’re really happy to see WP-Wallpaper spring up to fill the gap! There are definitely some beautiful, creative WordPress wallpapers around. Despite everything that’s happened up to this point with WP-Wallpaper.com, Alison is still excited to see the site grow.  \'>WPTavern: The Full Story Behind WP-Wallpaper</a></li></ul></div>","no");
INSERT INTO `ts968ny_3_options` VALUES("759","_transient_plugins_delete_result_1","1","yes");


DROP TABLE IF EXISTS `ts968ny_3_postmeta`;

CREATE TABLE `ts968ny_3_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=508 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_postmeta` VALUES("1","2","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("2","1","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("3","1","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("4","313","_wp_attached_file","2012/04/1.jpg");
INSERT INTO `ts968ny_3_postmeta` VALUES("5","313","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/1.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"1-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"1-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"1-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"slider_thumb\";a:4:{s:4:\"file\";s:11:\"1-70x50.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"fullsize\";a:4:{s:4:\"file\";s:13:\"1-930x604.jpg\";s:5:\"width\";i:930;s:6:\"height\";i:604;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:13:\"1-990x400.jpg\";s:5:\"width\";i:990;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"1-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"1-241x179.jpg\";s:5:\"width\";i:241;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"logo\";a:4:{s:4:\"file\";s:13:\"1-446x218.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:218;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_1\";a:4:{s:4:\"file\";s:13:\"1-446x150.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_2\";a:4:{s:4:\"file\";s:13:\"1-609x208.jpg\";s:5:\"width\";i:609;s:6:\"height\";i:208;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_3\";a:4:{s:4:\"file\";s:13:\"1-688x150.jpg\";s:5:\"width\";i:688;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("6","314","_wp_attached_file","2012/04/013.jpg");
INSERT INTO `ts968ny_3_postmeta` VALUES("7","314","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/013.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"013-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"013-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"013-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"slider_thumb\";a:4:{s:4:\"file\";s:13:\"013-70x50.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"fullsize\";a:4:{s:4:\"file\";s:15:\"013-930x604.jpg\";s:5:\"width\";i:930;s:6:\"height\";i:604;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:15:\"013-990x400.jpg\";s:5:\"width\";i:990;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"013-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"013-241x179.jpg\";s:5:\"width\";i:241;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"logo\";a:4:{s:4:\"file\";s:15:\"013-446x218.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:218;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_1\";a:4:{s:4:\"file\";s:15:\"013-446x150.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_2\";a:4:{s:4:\"file\";s:15:\"013-609x208.jpg\";s:5:\"width\";i:609;s:6:\"height\";i:208;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_3\";a:4:{s:4:\"file\";s:15:\"013-688x150.jpg\";s:5:\"width\";i:688;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("8","315","_wp_attached_file","2012/04/014.jpg");
INSERT INTO `ts968ny_3_postmeta` VALUES("9","315","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:15:\"2012/04/014.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:13:\"014-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:15:\"014-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:13:\"014-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"slider_thumb\";a:4:{s:4:\"file\";s:13:\"014-70x50.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"fullsize\";a:4:{s:4:\"file\";s:15:\"014-930x604.jpg\";s:5:\"width\";i:930;s:6:\"height\";i:604;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:15:\"014-990x400.jpg\";s:5:\"width\";i:990;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:15:\"014-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:15:\"014-241x179.jpg\";s:5:\"width\";i:241;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"logo\";a:4:{s:4:\"file\";s:15:\"014-446x218.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:218;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_1\";a:4:{s:4:\"file\";s:15:\"014-446x150.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_2\";a:4:{s:4:\"file\";s:15:\"014-609x208.jpg\";s:5:\"width\";i:609;s:6:\"height\";i:208;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_3\";a:4:{s:4:\"file\";s:15:\"014-688x150.jpg\";s:5:\"width\";i:688;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("10","316","_wp_attached_file","2012/04/2.jpg");
INSERT INTO `ts968ny_3_postmeta` VALUES("11","316","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1000;s:6:\"height\";i:650;s:4:\"file\";s:13:\"2012/04/2.jpg\";s:5:\"sizes\";a:12:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:11:\"2-80x80.jpg\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:13:\"2-300x195.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:195;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"widget\";a:4:{s:4:\"file\";s:11:\"2-36x36.jpg\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"slider_thumb\";a:4:{s:4:\"file\";s:11:\"2-70x50.jpg\";s:5:\"width\";i:70;s:6:\"height\";i:50;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"fullsize\";a:4:{s:4:\"file\";s:13:\"2-930x604.jpg\";s:5:\"width\";i:930;s:6:\"height\";i:604;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:8:\"featured\";a:4:{s:4:\"file\";s:13:\"2-990x400.jpg\";s:5:\"width\";i:990;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:13:\"2-495x400.jpg\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:13:\"2-241x179.jpg\";s:5:\"width\";i:241;s:6:\"height\";i:179;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:4:\"logo\";a:4:{s:4:\"file\";s:13:\"2-446x218.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:218;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_1\";a:4:{s:4:\"file\";s:13:\"2-446x150.jpg\";s:5:\"width\";i:446;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_2\";a:4:{s:4:\"file\";s:13:\"2-609x208.jpg\";s:5:\"width\";i:609;s:6:\"height\";i:208;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:9:\"dynamic_3\";a:4:{s:4:\"file\";s:13:\"2-688x150.jpg\";s:5:\"width\";i:688;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("12","593","_wp_attached_file","2011/12/slider11.png");
INSERT INTO `ts968ny_3_postmeta` VALUES("13","593","_wp_attachment_metadata","a:5:{s:5:\"width\";i:990;s:6:\"height\";i:400;s:4:\"file\";s:20:\"2011/12/slider11.png\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"slider11-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"slider11-300x121.png\";s:5:\"width\";i:300;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:18:\"slider11-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"slider_thumb\";a:4:{s:4:\"file\";s:18:\"slider11-70x50.png\";s:5:\"width\";i:70;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"fullsize\";a:4:{s:4:\"file\";s:20:\"slider11-930x375.png\";s:5:\"width\";i:930;s:6:\"height\";i:375;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:20:\"slider11-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:20:\"slider11-241x179.png\";s:5:\"width\";i:241;s:6:\"height\";i:179;s:9:\"mime-type\";s:9:\"image/png\";}s:4:\"logo\";a:4:{s:4:\"file\";s:20:\"slider11-446x218.png\";s:5:\"width\";i:446;s:6:\"height\";i:218;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_1\";a:4:{s:4:\"file\";s:20:\"slider11-446x150.png\";s:5:\"width\";i:446;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_2\";a:4:{s:4:\"file\";s:20:\"slider11-609x208.png\";s:5:\"width\";i:609;s:6:\"height\";i:208;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_3\";a:4:{s:4:\"file\";s:20:\"slider11-688x150.png\";s:5:\"width\";i:688;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("14","594","_wp_attached_file","2011/12/slider2.png");
INSERT INTO `ts968ny_3_postmeta` VALUES("15","594","_wp_attachment_metadata","a:5:{s:5:\"width\";i:990;s:6:\"height\";i:400;s:4:\"file\";s:19:\"2011/12/slider2.png\";s:5:\"sizes\";a:11:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"slider2-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"slider2-300x121.png\";s:5:\"width\";i:300;s:6:\"height\";i:121;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:17:\"slider2-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"slider_thumb\";a:4:{s:4:\"file\";s:17:\"slider2-70x50.png\";s:5:\"width\";i:70;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:8:\"fullsize\";a:4:{s:4:\"file\";s:19:\"slider2-930x375.png\";s:5:\"width\";i:930;s:6:\"height\";i:375;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:19:\"slider2-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:19:\"slider2-241x179.png\";s:5:\"width\";i:241;s:6:\"height\";i:179;s:9:\"mime-type\";s:9:\"image/png\";}s:4:\"logo\";a:4:{s:4:\"file\";s:19:\"slider2-446x218.png\";s:5:\"width\";i:446;s:6:\"height\";i:218;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_1\";a:4:{s:4:\"file\";s:19:\"slider2-446x150.png\";s:5:\"width\";i:446;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_2\";a:4:{s:4:\"file\";s:19:\"slider2-609x208.png\";s:5:\"width\";i:609;s:6:\"height\";i:208;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_3\";a:4:{s:4:\"file\";s:19:\"slider2-688x150.png\";s:5:\"width\";i:688;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("16","601","_wp_attached_file","2011/12/slider_half.png");
INSERT INTO `ts968ny_3_postmeta` VALUES("17","601","_wp_attachment_metadata","a:5:{s:5:\"width\";i:511;s:6:\"height\";i:400;s:4:\"file\";s:23:\"2011/12/slider_half.png\";s:5:\"sizes\";a:10:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"slider_half-80x80.png\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"slider_half-300x234.png\";s:5:\"width\";i:300;s:6:\"height\";i:234;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"widget\";a:4:{s:4:\"file\";s:21:\"slider_half-36x36.png\";s:5:\"width\";i:36;s:6:\"height\";i:36;s:9:\"mime-type\";s:9:\"image/png\";}s:12:\"slider_thumb\";a:4:{s:4:\"file\";s:21:\"slider_half-70x50.png\";s:5:\"width\";i:70;s:6:\"height\";i:50;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"portfolio\";a:4:{s:4:\"file\";s:23:\"slider_half-495x400.png\";s:5:\"width\";i:495;s:6:\"height\";i:400;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio_small\";a:4:{s:4:\"file\";s:23:\"slider_half-241x179.png\";s:5:\"width\";i:241;s:6:\"height\";i:179;s:9:\"mime-type\";s:9:\"image/png\";}s:4:\"logo\";a:4:{s:4:\"file\";s:23:\"slider_half-446x218.png\";s:5:\"width\";i:446;s:6:\"height\";i:218;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_1\";a:4:{s:4:\"file\";s:23:\"slider_half-446x150.png\";s:5:\"width\";i:446;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_2\";a:4:{s:4:\"file\";s:23:\"slider_half-511x208.png\";s:5:\"width\";i:511;s:6:\"height\";i:208;s:9:\"mime-type\";s:9:\"image/png\";}s:9:\"dynamic_3\";a:4:{s:4:\"file\";s:23:\"slider_half-511x150.png\";s:5:\"width\";i:511;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:10:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("18","604","_menu_item_type","custom");
INSERT INTO `ts968ny_3_postmeta` VALUES("19","604","_menu_item_menu_item_parent","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("20","604","_menu_item_object_id","604");
INSERT INTO `ts968ny_3_postmeta` VALUES("21","604","_menu_item_object","custom");
INSERT INTO `ts968ny_3_postmeta` VALUES("22","604","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("23","604","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("24","604","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("25","604","_menu_item_url","http://www.kriesi.at/themes/choices/");
INSERT INTO `ts968ny_3_postmeta` VALUES("26","28","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("27","28","_avia_elements_avia_options_propulsion","a:8:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:14:\"layout|dynamic\";s:17:\"dynamic_templates\";s:9:\"frontpage\";s:15:\"_slideshow_type\";s:9:\"adaptavia\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"7\";s:9:\"slideshow\";a:3:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"35\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:2:\"36\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:105:\"This is an example of a slideshow caption title without text (and also some fancy call to action buttons)\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:12:\"caption_left\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:10:\"Demo Video\";s:21:\"slideshow_button_link\";s:3:\"url\";s:25:\"slideshow_button_link_url\";s:25:\"http://vimeo.com/18439821\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:10:\"Next Slide\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:2:\"37\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:35:\"Example of a caption with some text\";s:17:\"slideshow_caption\";s:167:\"As you can see you have several options when displaying your captions. Left or right, boxed or without background, yyou can also set a different color for each caption\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:34:\"caption_right caption_right_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("28","28","_avia_elements_theme_compatibility_mode","a:8:{s:6:\"layout\";s:26:\"dynamic_template_frontpage\";s:17:\"dynamic_templates\";s:9:\"frontpage\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:3:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"594\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:15:\"Flying Captions\";s:17:\"slideshow_caption\";s:106:\"Let them fly! Captions can fade in, slide in from left to right or slide in from top to bottom. Fancy, eh?\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:36:\"caption_animate caption_animate_side\";s:16:\"caption_position\";s:31:\"caption_right caption_supersize\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:9:\"Read More\";s:21:\"slideshow_button_link\";s:4:\"page\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:2:\"53\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:10:\"Next Slide\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:23:{s:22:\"slideshow_image_layout\";s:29:\"small_image small_image_right\";s:15:\"slideshow_image\";s:3:\"601\";s:15:\"slideshow_video\";s:25:\"http://vimeo.com/18439821\";s:23:\"slideshow_caption_title\";s:17:\"Show fancy Videos\";s:17:\"slideshow_caption\";s:249:\"You can easily embed videos with the help of the slideshow manager and also choose poster images that are displayed before the user clicks the play button...&lt;br/&gt;&lt;br/&gt;The Slideshow supports various video providers like youtube, vimeo etc\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:36:\"caption_animate caption_animate_side\";s:16:\"caption_position\";s:12:\"caption_left\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"move\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"6\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("29","28","_avia_elements_avia_options_coherence","a:12:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:7:\"dynamic\";s:17:\"dynamic_templates\";s:9:\"frontpage\";s:15:\"_slideshow_type\";s:2:\"fx\";s:19:\"_slideshow_position\";s:10:\"big thumbs\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:4:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:25:\"Coherence WordPress Theme\";s:17:\"slideshow_caption\";s:70:\"The next gerneration of Themes. With fullsize captions &#039;n stuff!!\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:69:\"caption_center caption_center_framed caption_framed caption_supersize\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:3;a:21:{s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("30","28","_thumbnail_id","593");
INSERT INTO `ts968ny_3_postmeta` VALUES("31","28","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:85:\"http://www.kriesi.at/themes/flagship/files/2012/05/handsome-african-american-male.jpg\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:9:\"bg_active\";s:6:\"layout\";s:7:\"dynamic\";s:17:\"dynamic_templates\";s:9:\"frontpage\";s:15:\"_slideshow_type\";s:4:\"move\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"4\";s:9:\"slideshow\";a:3:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"425\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:3:\"428\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:3:\"424\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("32","28","_avia_elements_avia_options_choices","a:8:{s:6:\"layout\";s:26:\"dynamic_template_frontpage\";s:17:\"dynamic_templates\";s:9:\"frontpage\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:3:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"594\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:15:\"Flying Captions\";s:17:\"slideshow_caption\";s:106:\"Let them fly! Captions can fade in, slide in from left to right or slide in from top to bottom. Fancy, eh?\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:36:\"caption_animate caption_animate_side\";s:16:\"caption_position\";s:31:\"caption_right caption_supersize\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:9:\"Read More\";s:21:\"slideshow_button_link\";s:4:\"page\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:2:\"53\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:10:\"Next Slide\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:23:{s:22:\"slideshow_image_layout\";s:29:\"small_image small_image_right\";s:15:\"slideshow_image\";s:3:\"601\";s:15:\"slideshow_video\";s:25:\"http://vimeo.com/18439821\";s:23:\"slideshow_caption_title\";s:17:\"Show fancy Videos\";s:17:\"slideshow_caption\";s:249:\"You can easily embed videos with the help of the slideshow manager and also choose poster images that are displayed before the user clicks the play button...&lt;br/&gt;&lt;br/&gt;The Slideshow supports various video providers like youtube, vimeo etc\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:36:\"caption_animate caption_animate_side\";s:16:\"caption_position\";s:12:\"caption_left\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"move\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"6\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("33","28","_oembed_b240dd4bfac5a29c809ce9f82971d75c","<iframe src=\"http://player.vimeo.com/video/18439821\" width=\"500\" height=\"281\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>");
INSERT INTO `ts968ny_3_postmeta` VALUES("34","31","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("35","31","_avia_elements_theme_compatibility_mode","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("36","31","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("37","31","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("38","53","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("39","53","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:56:\"http://www.kriesi.at/themes/flagship/files/2012/04/1.jpg\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:9:\"bg_active\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("40","53","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("41","53","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:56:\"http://www.kriesi.at/themes/flagship/files/2012/04/1.jpg\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:9:\"bg_active\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("42","56","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("43","56","_avia_elements_theme_compatibility_mode","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("44","56","_wp_page_template","template-archives.php");
INSERT INTO `ts968ny_3_postmeta` VALUES("45","41","_avia_elements_avia_options_propulsion","s:1043:\"a:6:{s:4:\"hero\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"35\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("46","41","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:6:\"skills\";s:16:\"portfolio-meta-2\";s:12:\"Bananas Inc.\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("47","41","_avia_elements_avia_options_coherence","s:1358:\"a:13:{s:8:\"subtitle\";s:27:\"A supersleek Portfolio Item\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"move\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:15:\"iOS programming\";s:16:\"portfolio-meta-2\";s:12:\"Bananas Inc.\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("48","41","_thumbnail_id","315");
INSERT INTO `ts968ny_3_postmeta` VALUES("49","41","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"CSS, HTML\";s:16:\"portfolio-meta-2\";s:6:\"Kriesi\";s:16:\"portfolio-meta-3\";s:20:\"http://www.kriesi.at\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("50","41","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("51","41","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("52","41","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:6:\"skills\";s:16:\"portfolio-meta-2\";s:12:\"Bananas Inc.\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("53","44","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("54","44","_avia_elements_avia_options_propulsion","s:1046:\"a:6:{s:4:\"hero\";s:3:\"yes\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"36\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("55","44","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("56","44","_avia_elements_avia_options_coherence","s:1436:\"a:13:{s:8:\"subtitle\";s:45:\"Donec pede justo, fringilla vel, aliquet nec!\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:22:\"Photography, Photoshop\";s:16:\"portfolio-meta-2\";s:10:\"Flashlight\";s:16:\"portfolio-meta-3\";s:91:\"&lt;a href=&quot;http://www.kriesi.at/themes/flashlight/&quot;&gt;Flashlight Demo&lt;/a&gt;\";}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("57","44","_thumbnail_id","314");
INSERT INTO `ts968ny_3_postmeta` VALUES("58","44","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"Photoshop\";s:16:\"portfolio-meta-2\";s:6:\"client\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("59","44","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("60","44","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("61","45","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"PSD, HTML\";s:16:\"portfolio-meta-2\";s:4:\"Nike\";s:16:\"portfolio-meta-3\";s:20:\"http://www.kriesi.at\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("62","45","_avia_elements_avia_options_propulsion","s:1067:\"a:6:{s:4:\"hero\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:0:\"\";s:15:\"slideshow_video\";s:25:\"http://vimeo.com/18439821\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("63","45","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"PSD, HTML\";s:16:\"portfolio-meta-2\";s:4:\"Nike\";s:16:\"portfolio-meta-3\";s:20:\"http://www.kriesi.at\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("64","45","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("65","45","_avia_elements_avia_options_coherence","s:1371:\"a:13:{s:8:\"subtitle\";s:36:\"You can also embed Videos like VImeo\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:25:\"http://vimeo.com/18439821\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:15:\"Php, dreaweaver\";s:16:\"portfolio-meta-2\";s:12:\"Clie. enting\";s:16:\"portfolio-meta-3\";s:14:\"coming soon...\";}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("66","45","_thumbnail_id","316");
INSERT INTO `ts968ny_3_postmeta` VALUES("67","45","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:22:\"Photography, Photoshop\";s:16:\"portfolio-meta-2\";s:12:\"Bananas Inc.\";s:16:\"portfolio-meta-3\";s:36:\"http://www.kriesi.at/themes/angular/\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("68","45","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("69","46","_avia_elements_avia_options_choices","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"CSS, HTML\";s:16:\"portfolio-meta-2\";s:6:\"Kriesi\";s:16:\"portfolio-meta-3\";s:20:\"http://www.kriesi.at\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("70","46","_avia_elements_avia_options_coherence","s:1322:\"a:13:{s:8:\"subtitle\";s:21:\"Add subtitles at will\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"PSD, HTML\";s:16:\"portfolio-meta-2\";s:6:\"Kriesi\";s:16:\"portfolio-meta-3\";s:20:\"http://www.kriesi.at\";}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("71","46","_avia_elements_avia_options_propulsion","s:1043:\"a:6:{s:4:\"hero\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"37\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("72","46","_avia_elements_theme_compatibility_mode","a:8:{s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"3\";s:16:\"portfolio-meta-1\";s:9:\"CSS, HTML\";s:16:\"portfolio-meta-2\";s:6:\"Kriesi\";s:16:\"portfolio-meta-3\";s:20:\"http://www.kriesi.at\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("73","46","_thumbnail_id","313");
INSERT INTO `ts968ny_3_postmeta` VALUES("74","46","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("75","46","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("76","46","_avia_elements_avia_options_flagship","a:12:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:16:\"portfolio-meta-1\";s:9:\"CSS, HTML\";s:16:\"portfolio-meta-2\";s:6:\"Kriesi\";s:16:\"portfolio-meta-3\";s:20:\"http://www.kriesi.at\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("77","59","_avia_elements_avia_options_choices","a:6:{s:6:\"layout\";s:12:\"sidebar_left\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("78","59","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:68:\"sidebar_class|three alpha : content_class|nine : layout|sidebar_left\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("79","59","_avia_elements_theme_compatibility_mode","a:6:{s:6:\"layout\";s:12:\"sidebar_left\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("80","59","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("81","59","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:12:\"sidebar_left\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("82","61","_avia_elements_avia_options_choices","a:6:{s:6:\"layout\";s:13:\"sidebar_right\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("83","61","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:69:\"sidebar_class|three : content_class|nine alpha : layout|sidebar_right\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("84","61","_avia_elements_theme_compatibility_mode","a:6:{s:6:\"layout\";s:13:\"sidebar_right\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("85","61","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("86","63","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:65:\"sidebar_class|zero : content_class|twelve alpha : layout|fullsize\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("87","63","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:8:\"fullsize\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("88","63","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("89","63","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:8:\"fullsize\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("90","67","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:65:\"sidebar_class|zero : content_class|twelve alpha : layout|fullsize\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("91","67","_avia_elements_theme_compatibility_mode","a:6:{s:6:\"layout\";s:8:\"fullsize\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("92","67","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("93","67","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:8:\"fullsize\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("94","67","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:8:\"fullsize\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("95","67","_avia_elements_avia_options_choices","a:6:{s:6:\"layout\";s:8:\"fullsize\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("96","73","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("97","73","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("98","73","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("99","73","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("100","73","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("101","75","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("102","75","_avia_elements_theme_compatibility_mode","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("103","75","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("104","75","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("105","78","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("106","78","_avia_elements_theme_compatibility_mode","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("107","78","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("108","78","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("109","80","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("110","80","_avia_elements_theme_compatibility_mode","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("111","80","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("112","80","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("113","82","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("114","82","_avia_elements_theme_compatibility_mode","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("115","82","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("116","84","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("117","84","_avia_elements_theme_compatibility_mode","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("118","84","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("119","86","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("120","86","_avia_elements_theme_compatibility_mode","a:6:{s:6:\"layout\";s:0:\"\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("121","86","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("122","86","_avia_elements_avia_options_coherence","a:12:{s:8:\"subtitle\";s:13:\"Get in touch!\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:0:\"\";s:15:\"slideshow_video\";s:657:\"&lt;iframe width=&quot;425&quot; height=&quot;150&quot; frameborder=&quot;0&quot; scrolling=&quot;no&quot; marginheight=&quot;0&quot; marginwidth=&quot;0&quot; src=&quot;http://maps.google.at/maps?f=q&amp;amp;source=s_q&amp;amp;hl=de&amp;amp;geocode=&amp;amp;q=Infinite Loop, Cupertino, CA, United States&amp;amp;aq=1&amp;amp;oq=infinity loop&amp;amp;sll=58.204157,46.338215&amp;amp;sspn=0.056804,0.023539&amp;amp;ie=UTF8&amp;amp;hq=&amp;amp;hnear=Infinite Loop, Cupertino, Santa Clara, California 95014, Vereinigte Staaten&amp;amp;ll=37.331698,-122.030751&amp;amp;spn=0.020048,0.023539&amp;amp;t=m&amp;amp;z=14&amp;amp;output=embed&quot;&gt;&lt;/iframe&gt;\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("123","86","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:133:\"http://www.kriesi.at/themes/flagship/files/2012/05/photodune-202599-smart-business-man-with-a-laptop-and-colleagues-at-the-back-s.jpg\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:9:\"bg_active\";s:6:\"layout\";s:7:\"dynamic\";s:17:\"dynamic_templates\";s:14:\"big_top_margin\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:0:\"\";s:15:\"slideshow_video\";s:657:\"&lt;iframe width=&quot;425&quot; height=&quot;150&quot; frameborder=&quot;0&quot; scrolling=&quot;no&quot; marginheight=&quot;0&quot; marginwidth=&quot;0&quot; src=&quot;http://maps.google.at/maps?f=q&amp;amp;source=s_q&amp;amp;hl=de&amp;amp;geocode=&amp;amp;q=Infinite Loop, Cupertino, CA, United States&amp;amp;aq=1&amp;amp;oq=infinity loop&amp;amp;sll=58.204157,46.338215&amp;amp;sspn=0.056804,0.023539&amp;amp;ie=UTF8&amp;amp;hq=&amp;amp;hnear=Infinite Loop, Cupertino, Santa Clara, California 95014, Vereinigte Staaten&amp;amp;ll=37.331698,-122.030751&amp;amp;spn=0.020048,0.023539&amp;amp;t=m&amp;amp;z=14&amp;amp;output=embed&quot;&gt;&lt;/iframe&gt;\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("124","86","_avia_elements_avia_options_choices","a:6:{s:6:\"layout\";s:0:\"\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("125","395","_avia_elements_avia_options_choices","a:8:{s:6:\"layout\";s:29:\"dynamic_template_landing_page\";s:17:\"dynamic_templates\";s:12:\"landing_page\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"4\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("126","395","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:86:\"http://www.kriesi.at/themes/flagship/files/2012/05/photodune-787638-dear-friends-s.jpg\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:9:\"bg_active\";s:6:\"layout\";s:7:\"dynamic\";s:17:\"dynamic_templates\";s:20:\"landing_page_example\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"4\";s:9:\"slideshow\";a:2:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"425\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:3:\"424\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("127","395","_avia_elements_theme_compatibility_mode","a:8:{s:6:\"layout\";s:29:\"dynamic_template_landing_page\";s:17:\"dynamic_templates\";s:12:\"landing_page\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:4:\"true\";s:19:\"_slideshow_duration\";s:1:\"4\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("128","395","_thumbnail_id","593");
INSERT INTO `ts968ny_3_postmeta` VALUES("129","395","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("130","438","_avia_elements_avia_options_choices","a:7:{s:6:\"layout\";s:8:\"fullsize\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:4:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:3;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:2:\"fx\";s:19:\"_slideshow_position\";s:10:\"big thumbs\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("131","438","_thumbnail_id","593");
INSERT INTO `ts968ny_3_postmeta` VALUES("132","438","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:7:\"#696969\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:7:\"dynamic\";s:17:\"dynamic_templates\";s:9:\"frontpage\";s:15:\"_slideshow_type\";s:2:\"fx\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:3:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"415\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:3:\"440\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:32:\"Feel free to add funky captions!\";s:17:\"slideshow_caption\";s:58:\"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. \";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:69:\"caption_center caption_center_framed caption_framed caption_supersize\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:17:\"Buttons included!\";s:21:\"slideshow_button_link\";s:4:\"page\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:2:\"31\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:3:\"439\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("133","438","_avia_elements_theme_compatibility_mode","a:7:{s:6:\"layout\";s:8:\"fullsize\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:4:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:3;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:2:\"fx\";s:19:\"_slideshow_position\";s:10:\"big thumbs\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("134","438","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("135","549","_avia_elements_avia_options_choices","a:6:{s:6:\"layout\";s:0:\"\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("136","549","_avia_elements_theme_compatibility_mode","a:6:{s:6:\"layout\";s:0:\"\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("137","549","_wp_page_template","template-post-timeline.php");
INSERT INTO `ts968ny_3_postmeta` VALUES("138","630","_avia_elements_avia_options_choices","a:8:{s:6:\"layout\";s:41:\"dynamic_template_frontpage_with_portfolio\";s:17:\"dynamic_templates\";s:24:\"frontpage_with_portfolio\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:10:\"big thumbs\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("139","630","_avia_elements_theme_compatibility_mode","a:8:{s:6:\"layout\";s:41:\"dynamic_template_frontpage_with_portfolio\";s:17:\"dynamic_templates\";s:24:\"frontpage_with_portfolio\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:9:\"slideshow\";a:1:{i:0;a:23:{s:22:\"slideshow_image_layout\";s:0:\"\";s:15:\"slideshow_image\";s:3:\"593\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:17:\"caption_animation\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:0:\"\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:10:\"big thumbs\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("140","630","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("141","630","_thumbnail_id","593");
INSERT INTO `ts968ny_3_postmeta` VALUES("142","645","_avia_elements_avia_options_choices","a:7:{s:6:\"layout\";s:21:\"dynamic_template_team\";s:17:\"dynamic_templates\";s:4:\"team\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("143","645","_avia_elements_theme_compatibility_mode","a:7:{s:6:\"layout\";s:21:\"dynamic_template_team\";s:17:\"dynamic_templates\";s:4:\"team\";s:27:\"on_save_layout_dynamic_save\";s:27:\"on_save_layout_dynamic_save\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("144","645","_wp_page_template","default");
INSERT INTO `ts968ny_3_postmeta` VALUES("147","93","_broadscope_avia_options_array","s:4673:\"a:2:{i:1;a:2:{s:7:\"boxinfo\";a:5:{s:5:\"title\";s:17:\"Slideshow Options\";s:2:\"id\";s:14:\"slideshow_meta\";s:4:\"page\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:9:\"portfolio\";}s:7:\"context\";s:6:\"normal\";s:8:\"priority\";s:4:\"high\";}s:7:\"default\";a:8:{i:0;a:6:{s:4:\"name\";s:72:\"Display Image fullsize in featured area or smaller in post content area?\";s:4:\"desc\";s:77:\"Should featured images set bellow shown in full size within the feature area?\";s:2:\"id\";s:13:\"_big_or_small\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:50:\"Use global settings from  Broadscope Theme Options\";s:0:\"\";s:28:\"Display big in featured area\";s:3:\"big\";s:29:\"Display small in content area\";s:5:\"small\";}}i:1;a:6:{s:4:\"name\";s:31:\"Use default slideshow settings?\";s:4:\"desc\";s:108:\"Do you wish to use the default slideshow settings for this entry or do you want to overwrite those settings?\";s:2:\"id\";s:28:\"_overwrite_slideshow_default\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:2:{s:50:\"Use global settings from  Broadscope Theme Options\";s:0:\"\";s:19:\"Use unqiue settings\";s:6:\"unqiue\";}}i:2;a:6:{s:4:\"name\";s:20:\"Autorotation active?\";s:4:\"desc\";s:116:\"Check if the slideshow should rotate by default (You can overwrite this setting for each post and page individually)\";s:2:\"id\";s:19:\"_slideshow_autoplay\";s:3:\"std\";s:6:\"active\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:4:\"type\";s:8:\"checkbox\";}i:3;a:7:{s:4:\"name\";s:34:\"Duration each image gets displayed\";s:4:\"desc\";s:89:\"Each image will be shown X seconds, where X is the number you choose at the dropdown menu\";s:2:\"id\";s:19:\"_slideshow_duration\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:1:\"8\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:7:\"subtype\";a:16:{i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"3\";i:4;s:1:\"4\";i:5;s:1:\"5\";i:6;s:1:\"6\";i:7;s:1:\"7\";i:8;s:1:\"8\";i:9;s:1:\"9\";i:10;s:2:\"10\";i:15;s:2:\"15\";i:20;s:2:\"20\";i:30;s:2:\"30\";i:40;s:2:\"40\";i:60;s:2:\"60\";i:100;s:3:\"100\";}}i:4;a:6:{s:4:\"name\";s:43:\"Show slidecontrolls to the user by default?\";s:4:\"desc\";s:115:\"Check if the slidecontrolls visible by default (You can overwrite this setting for each post and page individually)\";s:2:\"id\";s:20:\"_slideshow_controlls\";s:3:\"std\";s:6:\"active\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:4:\"type\";s:8:\"checkbox\";}i:5;a:2:{s:2:\"id\";s:6:\"dummy1\";s:4:\"type\";s:6:\"dummy1\";}i:6;a:2:{s:2:\"id\";s:6:\"dummy2\";s:4:\"type\";s:6:\"dummy2\";}i:7;a:2:{s:2:\"id\";s:6:\"dummy3\";s:4:\"type\";s:6:\"dummy3\";}}}i:0;a:2:{s:7:\"boxinfo\";a:5:{s:5:\"title\";s:21:\"Add featured Image(s)\";s:2:\"id\";s:9:\"slideshow\";s:4:\"page\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:9:\"portfolio\";}s:7:\"context\";s:6:\"normal\";s:8:\"priority\";s:4:\"high\";}s:7:\"default\";a:1:{i:0;a:7:{s:4:\"type\";s:5:\"group\";s:2:\"id\";s:9:\"slideshow\";s:8:\"linktext\";s:17:\"Add another Slide\";s:10:\"deletetext\";s:12:\"Remove Slide\";s:5:\"blank\";s:1:\"1\";s:13:\"nodescription\";s:1:\"1\";s:7:\"default\";a:1:{i:0;a:8:{i:0;a:6:{s:4:\"name\";s:14:\"Featured Image\";s:4:\"desc\";s:52:\"Upload an image or choose one from the Media Library\";s:2:\"id\";s:15:\"slideshow_image\";s:4:\"type\";s:6:\"upload\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"label\";s:27:\"Use Image as featured Image\";}i:1;a:4:{s:4:\"name\";s:13:\"Caption Title\";s:4:\"desc\";s:50:\"Enter a title to display for your welcome message.\";s:2:\"id\";s:23:\"slideshow_caption_title\";s:4:\"type\";s:4:\"text\";}i:2;a:5:{s:4:\"name\";s:16:\"Background color\";s:4:\"desc\";s:40:\"Choose a background color for this slide\";s:2:\"id\";s:18:\"slideshow_bg_color\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"autodetect\";s:15:\"slideshow_image\";}i:3;a:4:{s:4:\"name\";s:7:\"Caption\";s:4:\"desc\";s:28:\"Image Caption for this Slide\";s:2:\"id\";s:17:\"slideshow_caption\";s:4:\"type\";s:8:\"textarea\";}i:4;a:6:{s:4:\"name\";s:24:\"Apply link to the image?\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:14:\"slideshow_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:6:{s:7:\"No link\";s:0:\"\";s:8:\"Lightbox\";s:8:\"lightbox\";s:17:\"Link to this Post\";s:4:\"self\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";s:13:\"Link manually\";s:3:\"url\";}}i:5;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"url\";}}i:6;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:19:\"slideshow_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:4:\"page\";}}i:7;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"cat\";}}}}}}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("148","93","_slideshow_controlls","_slideshow_controlls");
INSERT INTO `ts968ny_3_postmeta` VALUES("149","93","slideshow","s:301:\"a:1:{i:0;a:8:{s:15:\"slideshow_image\";s:1:\"6\";s:23:\"slideshow_caption_title\";s:0:\"\";s:18:\"slideshow_bg_color\";s:7:\"#000000\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("150","93","_big_or_small","small");
INSERT INTO `ts968ny_3_postmeta` VALUES("151","93","_overwrite_slideshow_default","");
INSERT INTO `ts968ny_3_postmeta` VALUES("152","93","_slideshow_autoplay","_slideshow_autoplay");
INSERT INTO `ts968ny_3_postmeta` VALUES("153","93","_slideshow_duration","8");
INSERT INTO `ts968ny_3_postmeta` VALUES("154","93","_avia_elements_avia_options_brightbox","s:1215:\"a:17:{s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:13:\"small_caption\";s:24:\"_slideshow_welcome_title\";s:0:\"\";s:23:\"_slideshow_welcome_text\";s:0:\"\";s:27:\"_slideshow_welcome_button_1\";s:0:\"\";s:32:\"_slideshow_welcome_button_1_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_1_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_cat\";s:0:\"\";s:27:\"_slideshow_welcome_button_2\";s:0:\"\";s:32:\"_slideshow_welcome_button_2_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_2_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_cat\";s:0:\"\";s:9:\"slideshow\";a:1:{i:0;a:14:{s:15:\"slideshow_image\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:5:\"slide\";s:13:\"element_depth\";s:2:\"10\";s:10:\"flip_depth\";s:3:\"250\";s:14:\"slice_vertical\";s:1:\"1\";s:16:\"slice_horizontal\";s:1:\"1\";s:5:\"order\";s:1:\"0\";s:9:\"direction\";s:5:\"right\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("155","93","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("156","93","_thumbnail_id","539");
INSERT INTO `ts968ny_3_postmeta` VALUES("157","93","_avia_elements_avia_options_corona","s:982:\"a:10:{s:11:\"blog_layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"539\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("158","93","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("159","93","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("160","93","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("161","93","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("162","93","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("165","94","_big_or_small","big");
INSERT INTO `ts968ny_3_postmeta` VALUES("166","94","_overwrite_slideshow_default","");
INSERT INTO `ts968ny_3_postmeta` VALUES("167","94","_slideshow_autoplay","_slideshow_autoplay");
INSERT INTO `ts968ny_3_postmeta` VALUES("168","94","_slideshow_duration","8");
INSERT INTO `ts968ny_3_postmeta` VALUES("169","94","_slideshow_controlls","_slideshow_controlls");
INSERT INTO `ts968ny_3_postmeta` VALUES("170","94","slideshow","s:294:\"a:1:{i:0;a:8:{s:15:\"slideshow_image\";s:2:\"19\";s:23:\"slideshow_caption_title\";s:0:\"\";s:18:\"slideshow_bg_color\";s:7:\"#000000\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("171","94","_broadscope_avia_options_array","s:4673:\"a:2:{i:1;a:2:{s:7:\"boxinfo\";a:5:{s:5:\"title\";s:17:\"Slideshow Options\";s:2:\"id\";s:14:\"slideshow_meta\";s:4:\"page\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:9:\"portfolio\";}s:7:\"context\";s:6:\"normal\";s:8:\"priority\";s:4:\"high\";}s:7:\"default\";a:8:{i:0;a:6:{s:4:\"name\";s:72:\"Display Image fullsize in featured area or smaller in post content area?\";s:4:\"desc\";s:77:\"Should featured images set bellow shown in full size within the feature area?\";s:2:\"id\";s:13:\"_big_or_small\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:50:\"Use global settings from  Broadscope Theme Options\";s:0:\"\";s:28:\"Display big in featured area\";s:3:\"big\";s:29:\"Display small in content area\";s:5:\"small\";}}i:1;a:6:{s:4:\"name\";s:31:\"Use default slideshow settings?\";s:4:\"desc\";s:108:\"Do you wish to use the default slideshow settings for this entry or do you want to overwrite those settings?\";s:2:\"id\";s:28:\"_overwrite_slideshow_default\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:2:{s:50:\"Use global settings from  Broadscope Theme Options\";s:0:\"\";s:19:\"Use unqiue settings\";s:6:\"unqiue\";}}i:2;a:6:{s:4:\"name\";s:20:\"Autorotation active?\";s:4:\"desc\";s:116:\"Check if the slideshow should rotate by default (You can overwrite this setting for each post and page individually)\";s:2:\"id\";s:19:\"_slideshow_autoplay\";s:3:\"std\";s:6:\"active\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:4:\"type\";s:8:\"checkbox\";}i:3;a:7:{s:4:\"name\";s:34:\"Duration each image gets displayed\";s:4:\"desc\";s:89:\"Each image will be shown X seconds, where X is the number you choose at the dropdown menu\";s:2:\"id\";s:19:\"_slideshow_duration\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:1:\"8\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:7:\"subtype\";a:16:{i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"3\";i:4;s:1:\"4\";i:5;s:1:\"5\";i:6;s:1:\"6\";i:7;s:1:\"7\";i:8;s:1:\"8\";i:9;s:1:\"9\";i:10;s:2:\"10\";i:15;s:2:\"15\";i:20;s:2:\"20\";i:30;s:2:\"30\";i:40;s:2:\"40\";i:60;s:2:\"60\";i:100;s:3:\"100\";}}i:4;a:6:{s:4:\"name\";s:43:\"Show slidecontrolls to the user by default?\";s:4:\"desc\";s:115:\"Check if the slidecontrolls visible by default (You can overwrite this setting for each post and page individually)\";s:2:\"id\";s:20:\"_slideshow_controlls\";s:3:\"std\";s:6:\"active\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:4:\"type\";s:8:\"checkbox\";}i:5;a:2:{s:2:\"id\";s:6:\"dummy1\";s:4:\"type\";s:6:\"dummy1\";}i:6;a:2:{s:2:\"id\";s:6:\"dummy2\";s:4:\"type\";s:6:\"dummy2\";}i:7;a:2:{s:2:\"id\";s:6:\"dummy3\";s:4:\"type\";s:6:\"dummy3\";}}}i:0;a:2:{s:7:\"boxinfo\";a:5:{s:5:\"title\";s:21:\"Add featured Image(s)\";s:2:\"id\";s:9:\"slideshow\";s:4:\"page\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:9:\"portfolio\";}s:7:\"context\";s:6:\"normal\";s:8:\"priority\";s:4:\"high\";}s:7:\"default\";a:1:{i:0;a:7:{s:4:\"type\";s:5:\"group\";s:2:\"id\";s:9:\"slideshow\";s:8:\"linktext\";s:17:\"Add another Slide\";s:10:\"deletetext\";s:12:\"Remove Slide\";s:5:\"blank\";s:1:\"1\";s:13:\"nodescription\";s:1:\"1\";s:7:\"default\";a:1:{i:0;a:8:{i:0;a:6:{s:4:\"name\";s:14:\"Featured Image\";s:4:\"desc\";s:52:\"Upload an image or choose one from the Media Library\";s:2:\"id\";s:15:\"slideshow_image\";s:4:\"type\";s:6:\"upload\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"label\";s:27:\"Use Image as featured Image\";}i:1;a:4:{s:4:\"name\";s:13:\"Caption Title\";s:4:\"desc\";s:50:\"Enter a title to display for your welcome message.\";s:2:\"id\";s:23:\"slideshow_caption_title\";s:4:\"type\";s:4:\"text\";}i:2;a:5:{s:4:\"name\";s:16:\"Background color\";s:4:\"desc\";s:40:\"Choose a background color for this slide\";s:2:\"id\";s:18:\"slideshow_bg_color\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"autodetect\";s:15:\"slideshow_image\";}i:3;a:4:{s:4:\"name\";s:7:\"Caption\";s:4:\"desc\";s:28:\"Image Caption for this Slide\";s:2:\"id\";s:17:\"slideshow_caption\";s:4:\"type\";s:8:\"textarea\";}i:4;a:6:{s:4:\"name\";s:24:\"Apply link to the image?\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:14:\"slideshow_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:6:{s:7:\"No link\";s:0:\"\";s:8:\"Lightbox\";s:8:\"lightbox\";s:17:\"Link to this Post\";s:4:\"self\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";s:13:\"Link manually\";s:3:\"url\";}}i:5;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"url\";}}i:6;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:19:\"slideshow_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:4:\"page\";}}i:7;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"cat\";}}}}}}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("172","94","_avia_elements_avia_options_corona","s:979:\"a:10:{s:11:\"blog_layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("173","94","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("174","94","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("175","94","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("176","94","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("179","95","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("180","95","_broadscope_avia_options_array","s:6371:\"a:2:{i:1;a:2:{s:7:\"boxinfo\";a:5:{s:5:\"title\";s:17:\"Slideshow Options\";s:2:\"id\";s:14:\"slideshow_meta\";s:4:\"page\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:9:\"portfolio\";}s:7:\"context\";s:6:\"normal\";s:8:\"priority\";s:4:\"high\";}s:7:\"default\";a:8:{i:0;a:6:{s:4:\"name\";s:72:\"Display Image fullsize in featured area or smaller in post content area?\";s:4:\"desc\";s:77:\"Should featured images set bellow shown in full size within the feature area?\";s:2:\"id\";s:13:\"_big_or_small\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:3:{s:50:\"Use global settings from  Broadscope Theme Options\";s:0:\"\";s:28:\"Display big in featured area\";s:3:\"big\";s:29:\"Display small in content area\";s:5:\"small\";}}i:1;a:6:{s:4:\"name\";s:31:\"Use default slideshow settings?\";s:4:\"desc\";s:108:\"Do you wish to use the default slideshow settings for this entry or do you want to overwrite those settings?\";s:2:\"id\";s:28:\"_overwrite_slideshow_default\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:2:{s:50:\"Use global settings from  Broadscope Theme Options\";s:0:\"\";s:19:\"Use unqiue settings\";s:6:\"unqiue\";}}i:2;a:6:{s:4:\"name\";s:20:\"Autorotation active?\";s:4:\"desc\";s:116:\"Check if the slideshow should rotate by default (You can overwrite this setting for each post and page individually)\";s:2:\"id\";s:19:\"_slideshow_autoplay\";s:3:\"std\";s:6:\"active\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:4:\"type\";s:8:\"checkbox\";}i:3;a:7:{s:4:\"name\";s:34:\"Duration each image gets displayed\";s:4:\"desc\";s:89:\"Each image will be shown X seconds, where X is the number you choose at the dropdown menu\";s:2:\"id\";s:19:\"_slideshow_duration\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:1:\"8\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:7:\"subtype\";a:16:{i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"3\";i:4;s:1:\"4\";i:5;s:1:\"5\";i:6;s:1:\"6\";i:7;s:1:\"7\";i:8;s:1:\"8\";i:9;s:1:\"9\";i:10;s:2:\"10\";i:15;s:2:\"15\";i:20;s:2:\"20\";i:30;s:2:\"30\";i:40;s:2:\"40\";i:60;s:2:\"60\";i:100;s:3:\"100\";}}i:4;a:6:{s:4:\"name\";s:43:\"Show slidecontrolls to the user by default?\";s:4:\"desc\";s:115:\"Check if the slidecontrolls visible by default (You can overwrite this setting for each post and page individually)\";s:2:\"id\";s:20:\"_slideshow_controlls\";s:3:\"std\";s:6:\"active\";s:8:\"required\";a:2:{i:0;s:28:\"_overwrite_slideshow_default\";i:1;s:6:\"unqiue\";}s:4:\"type\";s:8:\"checkbox\";}i:5;a:2:{s:2:\"id\";s:6:\"dummy1\";s:4:\"type\";s:6:\"dummy1\";}i:6;a:2:{s:2:\"id\";s:6:\"dummy2\";s:4:\"type\";s:6:\"dummy2\";}i:7;a:2:{s:2:\"id\";s:6:\"dummy3\";s:4:\"type\";s:6:\"dummy3\";}}}i:0;a:2:{s:7:\"boxinfo\";a:5:{s:5:\"title\";s:21:\"Add featured Image(s)\";s:2:\"id\";s:9:\"slideshow\";s:4:\"page\";a:3:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:9:\"portfolio\";}s:7:\"context\";s:6:\"normal\";s:8:\"priority\";s:4:\"high\";}s:7:\"default\";a:1:{i:0;a:7:{s:4:\"type\";s:5:\"group\";s:2:\"id\";s:9:\"slideshow\";s:8:\"linktext\";s:17:\"Add another Slide\";s:10:\"deletetext\";s:12:\"Remove Slide\";s:5:\"blank\";s:1:\"1\";s:13:\"nodescription\";s:1:\"1\";s:7:\"default\";a:2:{i:0;a:8:{i:0;a:6:{s:4:\"name\";s:14:\"Featured Image\";s:4:\"desc\";s:52:\"Upload an image or choose one from the Media Library\";s:2:\"id\";s:15:\"slideshow_image\";s:4:\"type\";s:6:\"upload\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"label\";s:27:\"Use Image as featured Image\";}i:1;a:4:{s:4:\"name\";s:13:\"Caption Title\";s:4:\"desc\";s:50:\"Enter a title to display for your welcome message.\";s:2:\"id\";s:23:\"slideshow_caption_title\";s:4:\"type\";s:4:\"text\";}i:2;a:5:{s:4:\"name\";s:16:\"Background color\";s:4:\"desc\";s:40:\"Choose a background color for this slide\";s:2:\"id\";s:18:\"slideshow_bg_color\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"autodetect\";s:15:\"slideshow_image\";}i:3;a:4:{s:4:\"name\";s:7:\"Caption\";s:4:\"desc\";s:28:\"Image Caption for this Slide\";s:2:\"id\";s:17:\"slideshow_caption\";s:4:\"type\";s:8:\"textarea\";}i:4;a:6:{s:4:\"name\";s:24:\"Apply link to the image?\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:14:\"slideshow_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:6:{s:7:\"No link\";s:0:\"\";s:8:\"Lightbox\";s:8:\"lightbox\";s:17:\"Link to this Post\";s:4:\"self\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";s:13:\"Link manually\";s:3:\"url\";}}i:5;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"url\";}}i:6;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:19:\"slideshow_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:4:\"page\";}}i:7;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"cat\";}}}i:1;a:8:{i:0;a:6:{s:4:\"name\";s:14:\"Featured Image\";s:4:\"desc\";s:52:\"Upload an image or choose one from the Media Library\";s:2:\"id\";s:15:\"slideshow_image\";s:4:\"type\";s:6:\"upload\";s:7:\"subtype\";s:8:\"advanced\";s:5:\"label\";s:27:\"Use Image as featured Image\";}i:1;a:4:{s:4:\"name\";s:13:\"Caption Title\";s:4:\"desc\";s:50:\"Enter a title to display for your welcome message.\";s:2:\"id\";s:23:\"slideshow_caption_title\";s:4:\"type\";s:4:\"text\";}i:2;a:5:{s:4:\"name\";s:16:\"Background color\";s:4:\"desc\";s:40:\"Choose a background color for this slide\";s:2:\"id\";s:18:\"slideshow_bg_color\";s:4:\"type\";s:11:\"colorpicker\";s:10:\"autodetect\";s:15:\"slideshow_image\";}i:3;a:4:{s:4:\"name\";s:7:\"Caption\";s:4:\"desc\";s:28:\"Image Caption for this Slide\";s:2:\"id\";s:17:\"slideshow_caption\";s:4:\"type\";s:8:\"textarea\";}i:4;a:6:{s:4:\"name\";s:24:\"Apply link to the image?\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:14:\"slideshow_link\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:0:\"\";s:7:\"subtype\";a:6:{s:7:\"No link\";s:0:\"\";s:8:\"Lightbox\";s:8:\"lightbox\";s:17:\"Link to this Post\";s:4:\"self\";s:12:\"Link to Page\";s:4:\"page\";s:16:\"Link to Category\";s:3:\"cat\";s:13:\"Link manually\";s:3:\"url\";}}i:5;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_url\";s:3:\"std\";s:7:\"http://\";s:4:\"type\";s:4:\"text\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"url\";}}i:6;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:19:\"slideshow_link_page\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:4:\"page\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:4:\"page\";}}i:7;a:6:{s:4:\"name\";s:0:\"\";s:4:\"desc\";s:0:\"\";s:2:\"id\";s:18:\"slideshow_link_cat\";s:4:\"type\";s:6:\"select\";s:7:\"subtype\";s:3:\"cat\";s:8:\"required\";a:2:{i:0;s:14:\"slideshow_link\";i:1;s:3:\"cat\";}}}}}}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("181","95","_big_or_small","");
INSERT INTO `ts968ny_3_postmeta` VALUES("182","95","_overwrite_slideshow_default","");
INSERT INTO `ts968ny_3_postmeta` VALUES("183","95","_slideshow_autoplay","_slideshow_autoplay");
INSERT INTO `ts968ny_3_postmeta` VALUES("184","95","_slideshow_duration","8");
INSERT INTO `ts968ny_3_postmeta` VALUES("185","95","_slideshow_controlls","_slideshow_controlls");
INSERT INTO `ts968ny_3_postmeta` VALUES("186","95","slideshow","s:597:\"a:2:{i:0;a:8:{s:15:\"slideshow_image\";s:1:\"6\";s:23:\"slideshow_caption_title\";s:0:\"\";s:18:\"slideshow_bg_color\";s:7:\"#000000\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";}i:1;a:8:{s:15:\"slideshow_image\";s:2:\"19\";s:23:\"slideshow_caption_title\";s:0:\"\";s:18:\"slideshow_bg_color\";s:7:\"#000000\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("187","95","_avia_elements_avia_options_corona","s:1061:\"a:10:{s:11:\"blog_layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"542\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:3:\"url\";s:18:\"slideshow_link_url\";s:93:\"http://www.adobe.com/jp/events/cs3_web_edition_tour/swfs/perform.swf?height=480&amp;width=720\";s:20:\"slideshow_link_video\";s:0:\"\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("188","95","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("189","95","_thumbnail_id","542");
INSERT INTO `ts968ny_3_postmeta` VALUES("190","95","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("191","95","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("192","95","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("193","95","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("196","237","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("197","237","_avia_elements_avia_options_toybox","s:578:\"a:6:{s:13:\"_big_or_small\";s:5:\"small\";s:28:\"_overwrite_slideshow_default\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:19:\"_slideshow_autoplay\";s:19:\"_slideshow_duration\";s:1:\"8\";s:20:\"_slideshow_controlls\";s:20:\"_slideshow_controlls\";s:9:\"slideshow\";a:1:{i:0;a:8:{s:15:\"slideshow_image\";s:3:\"242\";s:23:\"slideshow_caption_title\";s:23:\"This is a caption Title\";s:18:\"slideshow_bg_color\";s:0:\"\";s:17:\"slideshow_caption\";s:22:\"This is a caption text\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("198","237","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("199","237","_avia_elements_avia_options_corona","s:982:\"a:10:{s:11:\"blog_layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"543\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("200","237","_thumbnail_id","543");
INSERT INTO `ts968ny_3_postmeta` VALUES("201","237","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("202","237","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("203","237","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("204","237","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("207","246","_avia_elements_avia_options_toybox","s:531:\"a:6:{s:13:\"_big_or_small\";s:5:\"small\";s:28:\"_overwrite_slideshow_default\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:19:\"_slideshow_autoplay\";s:19:\"_slideshow_duration\";s:1:\"8\";s:20:\"_slideshow_controlls\";s:20:\"_slideshow_controlls\";s:9:\"slideshow\";a:1:{i:0;a:8:{s:15:\"slideshow_image\";s:3:\"247\";s:23:\"slideshow_caption_title\";s:0:\"\";s:18:\"slideshow_bg_color\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("208","246","_avia_elements_theme_compatibility_mode","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:0:\"\";s:15:\"slideshow_video\";s:25:\"http://vimeo.com/18439821\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("209","246","_avia_elements_avia_options_brightbox","s:1241:\"a:17:{s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:13:\"small_caption\";s:24:\"_slideshow_welcome_title\";s:0:\"\";s:23:\"_slideshow_welcome_text\";s:0:\"\";s:27:\"_slideshow_welcome_button_1\";s:0:\"\";s:32:\"_slideshow_welcome_button_1_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_1_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_cat\";s:0:\"\";s:27:\"_slideshow_welcome_button_2\";s:0:\"\";s:32:\"_slideshow_welcome_button_2_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_2_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_cat\";s:0:\"\";s:9:\"slideshow\";a:1:{i:0;a:14:{s:15:\"slideshow_image\";s:25:\"http://vimeo.com/18439821\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:5:\"slide\";s:13:\"element_depth\";s:2:\"10\";s:10:\"flip_depth\";s:3:\"250\";s:14:\"slice_vertical\";s:1:\"1\";s:16:\"slice_horizontal\";s:1:\"1\";s:5:\"order\";s:1:\"0\";s:9:\"direction\";s:5:\"right\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("210","246","_avia_elements_avia_options_velvet","s:796:\"a:11:{s:13:\"heading_style\";s:7:\"default\";s:10:\"subheading\";s:0:\"\";s:11:\"teaser_text\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:0:\"\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"slideshow\";a:1:{i:0;a:13:{s:15:\"slideshow_image\";s:3:\"341\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:9:\"direction\";s:5:\"right\";s:8:\"kb_start\";s:7:\"topleft\";s:6:\"kb_end\";s:11:\"bottomright\";s:16:\"kb_starting_size\";s:2:\"90\";s:14:\"kb_ending_size\";s:3:\"100\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("211","246","_avia_elements_avia_options_corona","s:982:\"a:10:{s:11:\"blog_layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"544\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("212","246","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("213","246","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("214","246","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("215","246","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("216","246","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:0:\"\";s:15:\"slideshow_video\";s:25:\"http://vimeo.com/18439821\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("217","246","_oembed_b240dd4bfac5a29c809ce9f82971d75c","<iframe src=\"http://player.vimeo.com/video/18439821\" width=\"500\" height=\"281\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>");
INSERT INTO `ts968ny_3_postmeta` VALUES("220","250","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("221","250","_avia_elements_avia_options_toybox","s:1200:\"a:16:{s:19:\"_slideshow_autoplay\";s:0:\"\";s:19:\"_slideshow_duration\";s:1:\"8\";s:15:\"_slideshow_type\";s:13:\"small_caption\";s:24:\"_slideshow_welcome_title\";s:0:\"\";s:23:\"_slideshow_welcome_text\";s:0:\"\";s:27:\"_slideshow_welcome_button_1\";s:0:\"\";s:32:\"_slideshow_welcome_button_1_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_1_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_cat\";s:0:\"\";s:27:\"_slideshow_welcome_button_2\";s:0:\"\";s:32:\"_slideshow_welcome_button_2_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_2_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_cat\";s:0:\"\";s:9:\"slideshow\";a:1:{i:0;a:14:{s:15:\"slideshow_image\";s:25:\"http://vimeo.com/21120050\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:5:\"slide\";s:10:\"flip_depth\";s:3:\"250\";s:13:\"element_depth\";s:2:\"10\";s:14:\"slice_vertical\";s:1:\"1\";s:16:\"slice_horizontal\";s:1:\"1\";s:5:\"order\";s:1:\"0\";s:9:\"direction\";s:5:\"right\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("222","250","_avia_elements_theme_compatibility_mode","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("223","250","_avia_elements_avia_options_brightbox","s:1217:\"a:17:{s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:13:\"small_caption\";s:24:\"_slideshow_welcome_title\";s:0:\"\";s:23:\"_slideshow_welcome_text\";s:0:\"\";s:27:\"_slideshow_welcome_button_1\";s:0:\"\";s:32:\"_slideshow_welcome_button_1_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_1_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_cat\";s:0:\"\";s:27:\"_slideshow_welcome_button_2\";s:0:\"\";s:32:\"_slideshow_welcome_button_2_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_2_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_cat\";s:0:\"\";s:9:\"slideshow\";a:1:{i:0;a:14:{s:15:\"slideshow_image\";s:2:\"35\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:5:\"slide\";s:13:\"element_depth\";s:2:\"10\";s:10:\"flip_depth\";s:3:\"250\";s:14:\"slice_vertical\";s:1:\"1\";s:16:\"slice_horizontal\";s:1:\"1\";s:5:\"order\";s:1:\"0\";s:9:\"direction\";s:5:\"right\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("224","250","_avia_elements_avia_options_velvet","s:813:\"a:11:{s:13:\"heading_style\";s:7:\"default\";s:10:\"subheading\";s:0:\"\";s:11:\"teaser_text\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:0:\"\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"slideshow\";a:1:{i:0;a:13:{s:15:\"slideshow_image\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:5:\"video\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:25:\"http://vimeo.com/18439821\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:9:\"direction\";s:5:\"right\";s:8:\"kb_start\";s:7:\"topleft\";s:6:\"kb_end\";s:11:\"bottomright\";s:16:\"kb_starting_size\";s:2:\"90\";s:14:\"kb_ending_size\";s:3:\"100\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("225","250","_avia_elements_avia_options_corona","s:982:\"a:10:{s:11:\"blog_layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"547\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("226","250","_thumbnail_id","315");
INSERT INTO `ts968ny_3_postmeta` VALUES("227","250","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("228","250","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("229","250","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("230","250","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("233","252","_avia_elements_avia_options_toybox","");
INSERT INTO `ts968ny_3_postmeta` VALUES("234","252","_avia_elements_theme_compatibility_mode","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:4:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:3;a:21:{s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("235","252","_avia_elements_avia_options_brightbox","s:1217:\"a:17:{s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:13:\"small_caption\";s:24:\"_slideshow_welcome_title\";s:0:\"\";s:23:\"_slideshow_welcome_text\";s:0:\"\";s:27:\"_slideshow_welcome_button_1\";s:0:\"\";s:32:\"_slideshow_welcome_button_1_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_1_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_cat\";s:0:\"\";s:27:\"_slideshow_welcome_button_2\";s:0:\"\";s:32:\"_slideshow_welcome_button_2_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_2_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_cat\";s:0:\"\";s:9:\"slideshow\";a:1:{i:0;a:14:{s:15:\"slideshow_image\";s:2:\"41\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:5:\"slide\";s:13:\"element_depth\";s:2:\"10\";s:10:\"flip_depth\";s:3:\"250\";s:14:\"slice_vertical\";s:1:\"1\";s:16:\"slice_horizontal\";s:1:\"1\";s:5:\"order\";s:1:\"0\";s:9:\"direction\";s:5:\"right\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("236","252","_avia_elements_avia_options_velvet","s:796:\"a:11:{s:13:\"heading_style\";s:7:\"default\";s:10:\"subheading\";s:0:\"\";s:11:\"teaser_text\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:0:\"\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"slideshow\";a:1:{i:0;a:13:{s:15:\"slideshow_image\";s:3:\"342\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:9:\"direction\";s:5:\"right\";s:8:\"kb_start\";s:7:\"topleft\";s:6:\"kb_end\";s:11:\"bottomright\";s:16:\"kb_starting_size\";s:2:\"90\";s:14:\"kb_ending_size\";s:3:\"100\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("237","252","_avia_elements_avia_options_corona","s:1021:\"a:10:{s:11:\"blog_layout\";s:38:\"big_image sidebar_right single_sidebar\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"548\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("238","252","_avia_elements_avia_options_propulsion","a:8:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:3:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"37\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:2:\"36\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:2:\"35\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("239","252","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("240","252","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("241","252","_avia_elements_avia_options_coherence","a:12:{s:8:\"subtitle\";s:103:\"If you define a &quot;subtitle&quot; field for posts, it will be converted to a short introduction text\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:2:\"fx\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:4:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:3;a:21:{s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("242","252","_thumbnail_id","316");
INSERT INTO `ts968ny_3_postmeta` VALUES("243","252","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:4:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:1;a:21:{s:15:\"slideshow_image\";s:3:\"315\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:2;a:21:{s:15:\"slideshow_image\";s:3:\"314\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}i:3;a:21:{s:15:\"slideshow_image\";s:3:\"313\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("246","254","_avia_elements_avia_options_flagship","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("247","254","_avia_elements_avia_options_toybox","s:526:\"a:6:{s:13:\"_big_or_small\";s:0:\"\";s:28:\"_overwrite_slideshow_default\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:19:\"_slideshow_autoplay\";s:19:\"_slideshow_duration\";s:1:\"8\";s:20:\"_slideshow_controlls\";s:20:\"_slideshow_controlls\";s:9:\"slideshow\";a:1:{i:0;a:8:{s:15:\"slideshow_image\";s:3:\"255\";s:23:\"slideshow_caption_title\";s:0:\"\";s:18:\"slideshow_bg_color\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:0:\"\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("248","254","_avia_elements_theme_compatibility_mode","a:10:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("249","254","_avia_elements_avia_options_brightbox","s:1217:\"a:17:{s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:13:\"small_caption\";s:24:\"_slideshow_welcome_title\";s:0:\"\";s:23:\"_slideshow_welcome_text\";s:0:\"\";s:27:\"_slideshow_welcome_button_1\";s:0:\"\";s:32:\"_slideshow_welcome_button_1_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_1_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_cat\";s:0:\"\";s:27:\"_slideshow_welcome_button_2\";s:0:\"\";s:32:\"_slideshow_welcome_button_2_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_2_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_cat\";s:0:\"\";s:9:\"slideshow\";a:1:{i:0;a:14:{s:15:\"slideshow_image\";s:2:\"37\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:5:\"slide\";s:13:\"element_depth\";s:2:\"10\";s:10:\"flip_depth\";s:3:\"250\";s:14:\"slice_vertical\";s:1:\"1\";s:16:\"slice_horizontal\";s:1:\"1\";s:5:\"order\";s:1:\"0\";s:9:\"direction\";s:5:\"right\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("250","254","_thumbnail_id","549");
INSERT INTO `ts968ny_3_postmeta` VALUES("251","254","_avia_elements_avia_options_corona","s:1098:\"a:10:{s:11:\"blog_layout\";s:41:\"medium_image sidebar_right single_sidebar\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"549\";s:23:\"slideshow_caption_title\";s:23:\"This is a caption title\";s:17:\"slideshow_caption\";s:45:\"This is caption text. use it whenever needed!\";s:14:\"slideshow_link\";s:8:\"lightbox\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("252","254","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("253","254","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("254","254","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("255","254","_avia_elements_avia_options_coherence","a:11:{s:8:\"subtitle\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_image\";s:0:\"\";s:17:\"bg_image_settings\";s:7:\" center\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("258","282","_avia_elements_avia_options_toybox","");
INSERT INTO `ts968ny_3_postmeta` VALUES("259","282","_avia_elements_theme_compatibility_mode","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("260","282","_avia_elements_avia_options_brightbox","s:1217:\"a:17:{s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:13:\"small_caption\";s:24:\"_slideshow_welcome_title\";s:0:\"\";s:23:\"_slideshow_welcome_text\";s:0:\"\";s:27:\"_slideshow_welcome_button_1\";s:0:\"\";s:32:\"_slideshow_welcome_button_1_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_1_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_1_link_cat\";s:0:\"\";s:27:\"_slideshow_welcome_button_2\";s:0:\"\";s:32:\"_slideshow_welcome_button_2_link\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_url\";s:7:\"http://\";s:37:\"_slideshow_welcome_button_2_link_page\";s:0:\"\";s:36:\"_slideshow_welcome_button_2_link_cat\";s:0:\"\";s:9:\"slideshow\";a:1:{i:0;a:14:{s:15:\"slideshow_image\";s:2:\"37\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:5:\"slide\";s:13:\"element_depth\";s:2:\"10\";s:10:\"flip_depth\";s:3:\"250\";s:14:\"slice_vertical\";s:1:\"1\";s:16:\"slice_horizontal\";s:1:\"1\";s:5:\"order\";s:1:\"0\";s:9:\"direction\";s:5:\"right\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("261","282","_avia_elements_avia_options_velvet","s:796:\"a:11:{s:13:\"heading_style\";s:7:\"default\";s:10:\"subheading\";s:0:\"\";s:11:\"teaser_text\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:15:\"_slideshow_type\";s:0:\"\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"slideshow\";a:1:{i:0;a:13:{s:15:\"slideshow_image\";s:3:\"343\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:9:\"direction\";s:5:\"right\";s:8:\"kb_start\";s:7:\"topleft\";s:6:\"kb_end\";s:11:\"bottomright\";s:16:\"kb_starting_size\";s:2:\"90\";s:14:\"kb_ending_size\";s:3:\"100\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("262","282","_avia_elements_avia_options_corona","s:1023:\"a:10:{s:11:\"blog_layout\";s:40:\"small_image sidebar_right single_sidebar\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:11:\"slice_width\";s:4:\"full\";s:12:\"slice_height\";s:4:\"full\";s:15:\"transition_type\";s:4:\"fade\";s:9:\"direction\";s:3:\"all\";s:9:\"slideshow\";a:1:{i:0;a:18:{s:15:\"slideshow_image\";s:3:\"550\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:20:\"slideshow_link_video\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:6:\"easing\";s:6:\"linear\";s:10:\"flip_depth\";s:3:\"250\";s:8:\"sideward\";s:1:\"1\";s:14:\"slice_vertical\";s:1:\"3\";s:16:\"caption_position\";s:13:\"caption_right\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:9:\"nextSlide\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";}}}\";");
INSERT INTO `ts968ny_3_postmeta` VALUES("263","282","_avia_elements_avia_options_propulsion","a:8:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:2:\"35\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:32:\"caption_left caption_left_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("264","282","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("265","282","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("266","282","_avia_elements_avia_options_flagship","a:11:{s:15:\"bg_image_custom\";s:0:\"\";s:8:\"bg_color\";s:0:\"\";s:17:\"bg_image_settings\";s:10:\"fullscreen\";s:13:\"bg_menu_color\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:4:\"fade\";s:19:\"_slideshow_position\";s:3:\"big\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";s:9:\"slideshow\";a:1:{i:0;a:21:{s:15:\"slideshow_image\";s:3:\"316\";s:15:\"slideshow_video\";s:0:\"\";s:23:\"slideshow_caption_title\";s:0:\"\";s:17:\"slideshow_caption\";s:0:\"\";s:14:\"slideshow_link\";s:4:\"self\";s:18:\"slideshow_link_url\";s:7:\"http://\";s:19:\"slideshow_link_page\";s:0:\"\";s:18:\"slideshow_link_cat\";s:0:\"\";s:16:\"caption_position\";s:49:\"caption_right caption_right_framed caption_framed\";s:12:\"caption_font\";s:7:\"#ffffff\";s:22:\"slideshow_button_title\";s:0:\"\";s:21:\"slideshow_button_link\";s:4:\"self\";s:25:\"slideshow_button_link_url\";s:7:\"http://\";s:26:\"slideshow_button_link_page\";s:0:\"\";s:25:\"slideshow_button_link_cat\";s:0:\"\";s:23:\"slideshow_button2_title\";s:0:\"\";s:22:\"slideshow_button2_link\";s:9:\"nextSlide\";s:26:\"slideshow_button2_link_url\";s:7:\"http://\";s:27:\"slideshow_button2_link_page\";s:0:\"\";s:26:\"slideshow_button2_link_cat\";s:0:\"\";s:20:\"slideshow_transition\";s:6:\"random\";}}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("267","282","_thumbnail_id","316");
INSERT INTO `ts968ny_3_postmeta` VALUES("270","296","_oembed_834756b50a80a07dca8556336ddfa2f1","<iframe width=\"500\" height=\"281\" src=\"http://www.youtube.com/embed/G0k3kHtyoqc?fs=1&feature=oembed\" frameborder=\"0\" allowfullscreen></iframe>");
INSERT INTO `ts968ny_3_postmeta` VALUES("271","296","_oembed_b240dd4bfac5a29c809ce9f82971d75c","<iframe src=\"http://player.vimeo.com/video/18439821\" width=\"500\" height=\"281\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>");
INSERT INTO `ts968ny_3_postmeta` VALUES("272","296","_avia_elements_theme_compatibility_mode","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("273","296","_avia_elements_avia_options_propulsion","a:7:{s:4:\"hero\";s:0:\"\";s:6:\"layout\";s:0:\"\";s:17:\"dynamic_templates\";s:0:\"\";s:15:\"_slideshow_type\";s:11:\"fade_slider\";s:19:\"_slideshow_position\";s:5:\"small\";s:19:\"_slideshow_autoplay\";s:5:\"false\";s:19:\"_slideshow_duration\";s:1:\"5\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("274","296","_wp_old_slug","httpwww-kriesi-at");
INSERT INTO `ts968ny_3_postmeta` VALUES("275","296","_facebookcount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("276","296","_twittercount-cache","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("277","296","_oembed_026d3cdd0a71f3a39d8f175d596348a9","{{unknown}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("278","646","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("279","646","_menu_item_menu_item_parent","663");
INSERT INTO `ts968ny_3_postmeta` VALUES("280","646","_menu_item_object_id","80");
INSERT INTO `ts968ny_3_postmeta` VALUES("281","646","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("282","646","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("283","646","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("284","646","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("285","646","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("286","647","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("287","647","_menu_item_menu_item_parent","663");
INSERT INTO `ts968ny_3_postmeta` VALUES("288","647","_menu_item_object_id","78");
INSERT INTO `ts968ny_3_postmeta` VALUES("289","647","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("290","647","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("291","647","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("292","647","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("293","647","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("294","648","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("295","648","_menu_item_menu_item_parent","663");
INSERT INTO `ts968ny_3_postmeta` VALUES("296","648","_menu_item_object_id","75");
INSERT INTO `ts968ny_3_postmeta` VALUES("297","648","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("298","648","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("299","648","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("300","648","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("301","648","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("302","649","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("303","649","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("304","649","_menu_item_object_id","61");
INSERT INTO `ts968ny_3_postmeta` VALUES("305","649","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("306","649","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("307","649","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("308","649","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("309","649","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("310","650","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("311","650","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("312","650","_menu_item_object_id","67");
INSERT INTO `ts968ny_3_postmeta` VALUES("313","650","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("314","650","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("315","650","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("316","650","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("317","650","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("318","651","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("319","651","_menu_item_menu_item_parent","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("320","651","_menu_item_object_id","31");
INSERT INTO `ts968ny_3_postmeta` VALUES("321","651","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("322","651","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("323","651","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("324","651","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("325","651","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("326","652","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("327","652","_menu_item_menu_item_parent","671");
INSERT INTO `ts968ny_3_postmeta` VALUES("328","652","_menu_item_object_id","86");
INSERT INTO `ts968ny_3_postmeta` VALUES("329","652","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("330","652","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("331","652","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("332","652","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("333","652","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("334","653","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("335","653","_menu_item_menu_item_parent","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("336","653","_menu_item_object_id","53");
INSERT INTO `ts968ny_3_postmeta` VALUES("337","653","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("338","653","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("339","653","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("340","653","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("341","653","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("342","654","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("343","654","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("344","654","_menu_item_object_id","56");
INSERT INTO `ts968ny_3_postmeta` VALUES("345","654","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("346","654","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("347","654","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("348","654","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("349","654","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("350","655","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("351","655","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("352","655","_menu_item_object_id","73");
INSERT INTO `ts968ny_3_postmeta` VALUES("353","655","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("354","655","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("355","655","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("356","655","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("357","655","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("358","656","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("359","656","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("360","656","_menu_item_object_id","63");
INSERT INTO `ts968ny_3_postmeta` VALUES("361","656","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("362","656","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("363","656","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("364","656","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("365","656","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("366","657","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("367","657","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("368","657","_menu_item_object_id","59");
INSERT INTO `ts968ny_3_postmeta` VALUES("369","657","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("370","657","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("371","657","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("372","657","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("373","657","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("374","658","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("375","658","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("376","658","_menu_item_object_id","84");
INSERT INTO `ts968ny_3_postmeta` VALUES("377","658","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("378","658","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("379","658","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("380","658","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("381","658","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("382","659","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("383","659","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("384","659","_menu_item_object_id","82");
INSERT INTO `ts968ny_3_postmeta` VALUES("385","659","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("386","659","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("387","659","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("388","659","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("389","659","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("390","660","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("391","660","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("392","660","_menu_item_object_id","80");
INSERT INTO `ts968ny_3_postmeta` VALUES("393","660","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("394","660","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("395","660","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("396","660","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("397","660","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("398","661","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("399","661","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("400","661","_menu_item_object_id","78");
INSERT INTO `ts968ny_3_postmeta` VALUES("401","661","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("402","661","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("403","661","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("404","661","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("405","661","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("406","662","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("407","662","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("408","662","_menu_item_object_id","75");
INSERT INTO `ts968ny_3_postmeta` VALUES("409","662","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("410","662","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("411","662","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("412","662","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("413","662","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("414","663","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("415","663","_menu_item_menu_item_parent","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("416","663","_menu_item_object_id","75");
INSERT INTO `ts968ny_3_postmeta` VALUES("417","663","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("418","663","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("419","663","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("420","663","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("421","663","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("422","664","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("423","664","_menu_item_menu_item_parent","663");
INSERT INTO `ts968ny_3_postmeta` VALUES("424","664","_menu_item_object_id","84");
INSERT INTO `ts968ny_3_postmeta` VALUES("425","664","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("426","664","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("427","664","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("428","664","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("429","664","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("430","665","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("431","665","_menu_item_menu_item_parent","663");
INSERT INTO `ts968ny_3_postmeta` VALUES("432","665","_menu_item_object_id","82");
INSERT INTO `ts968ny_3_postmeta` VALUES("433","665","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("434","665","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("435","665","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("436","665","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("437","665","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("438","666","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("439","666","_menu_item_menu_item_parent","604");
INSERT INTO `ts968ny_3_postmeta` VALUES("440","666","_menu_item_object_id","395");
INSERT INTO `ts968ny_3_postmeta` VALUES("441","666","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("442","666","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("443","666","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("444","666","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("445","666","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("446","667","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("447","667","_menu_item_menu_item_parent","604");
INSERT INTO `ts968ny_3_postmeta` VALUES("448","667","_menu_item_object_id","438");
INSERT INTO `ts968ny_3_postmeta` VALUES("449","667","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("450","667","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("451","667","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("452","667","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("453","667","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("454","668","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("455","668","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("456","668","_menu_item_object_id","549");
INSERT INTO `ts968ny_3_postmeta` VALUES("457","668","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("458","668","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("459","668","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("460","668","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("461","668","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("462","669","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("463","669","_menu_item_menu_item_parent","604");
INSERT INTO `ts968ny_3_postmeta` VALUES("464","669","_menu_item_object_id","630");
INSERT INTO `ts968ny_3_postmeta` VALUES("465","669","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("466","669","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("467","669","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("468","669","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("469","669","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("470","670","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("471","670","_menu_item_menu_item_parent","671");
INSERT INTO `ts968ny_3_postmeta` VALUES("472","670","_menu_item_object_id","645");
INSERT INTO `ts968ny_3_postmeta` VALUES("473","670","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("474","670","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("475","670","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("476","670","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("477","670","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("478","671","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("479","671","_menu_item_menu_item_parent","0");
INSERT INTO `ts968ny_3_postmeta` VALUES("480","671","_menu_item_object_id","645");
INSERT INTO `ts968ny_3_postmeta` VALUES("481","671","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("482","671","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("483","671","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("484","671","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("485","671","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("486","672","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("487","672","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("488","672","_menu_item_object_id","645");
INSERT INTO `ts968ny_3_postmeta` VALUES("489","672","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("490","672","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("491","672","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("492","672","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("493","672","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("494","673","_menu_item_type","post_type");
INSERT INTO `ts968ny_3_postmeta` VALUES("495","673","_menu_item_menu_item_parent","653");
INSERT INTO `ts968ny_3_postmeta` VALUES("496","673","_menu_item_object_id","395");
INSERT INTO `ts968ny_3_postmeta` VALUES("497","673","_menu_item_object","page");
INSERT INTO `ts968ny_3_postmeta` VALUES("498","673","_menu_item_target","");
INSERT INTO `ts968ny_3_postmeta` VALUES("499","673","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO `ts968ny_3_postmeta` VALUES("500","673","_menu_item_xfn","");
INSERT INTO `ts968ny_3_postmeta` VALUES("501","673","_menu_item_url","");
INSERT INTO `ts968ny_3_postmeta` VALUES("502","1","_oembed_158e9219ccca6ed1d9a56fd83a862ee3","<iframe src=\"http://player.vimeo.com/video/18439821\" width=\"500\" height=\"281\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>");
INSERT INTO `ts968ny_3_postmeta` VALUES("503","296","_oembed_0c5e2041bf4ccbde46eb4a004e746468","{{unknown}}");
INSERT INTO `ts968ny_3_postmeta` VALUES("504","246","_oembed_158e9219ccca6ed1d9a56fd83a862ee3","<iframe src=\"http://player.vimeo.com/video/18439821\" width=\"500\" height=\"281\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>");
INSERT INTO `ts968ny_3_postmeta` VALUES("505","31","_edit_lock","1358469422:1");
INSERT INTO `ts968ny_3_postmeta` VALUES("506","78","_edit_lock","1359430872:1");
INSERT INTO `ts968ny_3_postmeta` VALUES("507","93","_oembed_158e9219ccca6ed1d9a56fd83a862ee3","<iframe src=\"http://player.vimeo.com/video/18439821\" width=\"500\" height=\"281\" frameborder=\"0\" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>");


DROP TABLE IF EXISTS `ts968ny_3_posts`;

CREATE TABLE `ts968ny_3_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=681 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_posts` VALUES("1","1","2013-01-04 22:34:52","2013-01-04 22:34:52","Welcome to <a href=\"http://rubensteinarchitects.com/\">Rubenstein Architects</a>. This is your first post. Edit or delete it, then start blogging!","Hello world!","","publish","open","open","","hello-world","","","2013-01-04 22:34:52","2013-01-04 22:34:52","","0","http://rubensteinarchitects.com/choices/?p=1","0","post","","1");
INSERT INTO `ts968ny_3_posts` VALUES("2","1","2013-01-04 22:34:52","2013-01-04 22:34:52","This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:

<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my blog. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>

...or something like this:

<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>

As a new WordPress user, you should go to <a href=\"http://rubensteinarchitects.com/choices/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!","Sample Page","","publish","open","open","","sample-page","","","2013-01-04 22:34:52","2013-01-04 22:34:52","","0","http://rubensteinarchitects.com/choices/?page_id=2","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("4","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Header Favicon","","draft","closed","closed","","of-header_favicon","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=4","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("5","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Header Logo","","draft","closed","closed","","of-header_logo","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=5","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("6","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Portfolio Image Icons Link","","draft","closed","closed","","of-portfolio_image_icons_link","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=6","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("7","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Portfolio Image Icons Zoom","","draft","closed","closed","","of-portfolio_image_icons_zoom","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=7","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("8","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Blog Image Icons Link","","draft","closed","closed","","of-blog_image_icons_link","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=8","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("9","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Blog Image Icons Zoom","","draft","closed","closed","","of-blog_image_icons_zoom","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=9","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("10","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Blog Post Show Author Avatar","","draft","closed","closed","","of-blog_post_show_author_avatar","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=10","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("11","1","2013-01-04 22:47:10","0000-00-00 00:00:00","","Footer Logo","","draft","closed","closed","","of-footer_logo","","","2013-01-04 22:47:10","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=options&p=11","0","options","","0");
INSERT INTO `ts968ny_3_posts` VALUES("12","1","2013-01-04 22:47:19","0000-00-00 00:00:00","","avia_logo","","draft","closed","closed","","","","","2013-01-04 22:47:19","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=avia_framework_post&p=12","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("13","1","2013-01-04 22:47:19","0000-00-00 00:00:00","","avia_favicon","","draft","closed","closed","","","","","2013-01-04 22:47:19","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=avia_framework_post&p=13","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("14","1","2013-01-04 22:47:19","0000-00-00 00:00:00","","avia_custom_background_image","","draft","closed","closed","","","","","2013-01-04 22:47:19","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?post_type=avia_framework_post&p=14","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("15","1","2012-06-16 15:13:05","0000-00-00 00:00:00","","avia_logo","","draft","closed","closed","","","","","2012-06-16 15:13:05","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=4","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("16","1","2012-04-29 20:10:10","0000-00-00 00:00:00","","avia_logo","","draft","closed","closed","","","","","2012-04-29 20:10:10","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/coherence/?post_type=avia_framework_post&amp;p=4","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("17","1","2012-04-29 20:10:10","0000-00-00 00:00:00","","avia_favicon","","draft","closed","closed","","","","","2012-04-29 20:10:10","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/coherence/?post_type=avia_framework_post&amp;p=5","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("18","1","2012-04-29 20:10:10","0000-00-00 00:00:00","","avia_custom_background_image","","draft","closed","closed","","","","","2012-04-29 20:10:10","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/coherence/?post_type=avia_framework_post&amp;p=6","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("19","1","2011-12-15 21:44:52","0000-00-00 00:00:00","","avia_logo","","draft","closed","closed","","","","","2011-12-15 21:44:52","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/propulsion/?post_type=avia_framework_post&amp;p=4","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("20","1","2011-12-15 21:44:52","0000-00-00 00:00:00","","avia_favicon","","draft","closed","closed","","","","","2011-12-15 21:44:52","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/propulsion/?post_type=avia_framework_post&amp;p=5","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("21","1","2011-12-15 21:44:52","0000-00-00 00:00:00","","avia_custom_background_image","","draft","closed","closed","","","","","2011-12-15 21:44:52","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/propulsion/?post_type=avia_framework_post&amp;p=6","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("28","1","2011-12-15 21:52:11","2011-12-15 21:52:11","[one_third first]

[iconbox_top title=\"Build your own Skins\" icon=\"Frames.png\"]Right out of your backend. No coding needed...

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third] [iconbox_top title=\"Mobile Optimized\" icon=\"iPhone_4.png\"]Responsive Design and Slideshows with touchcontrol

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third]

[iconbox_top title=\"Premium Support\" icon=\"Speech_Bubble.png\"]A Support Forum with thousands of users and posts

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/support/\">Show Forum</a>

[/iconbox_top]

[/one_third]

[hr_invisible]

[one_fourth first]
<h3>Flexibly Templates</h3>
[dropcap2]1[/dropcap2]The theme uses a flexible template system that enables you to create stunning pages out of the box with no coding knowledge at all

[/one_fourth]

[one_fourth]
<h3>Unlimited Skins</h3>
[dropcap3]2[/dropcap3]The theme comes with several predefined skin options but also utilizes a color and background image switcher, a font-switch for headings and several other layout options.

[/one_fourth]

[one_fourth]
<h3>Content Importing</h3>
[dropcap3]3[/dropcap3]You can now setup a wordpress installation that looks like this demo with just a single click of your mouse. Amazing to get started and accustomed to the theme.

[/one_fourth]

[one_fourth]
<h3>Shortcodes</h3>
[dropcap3]4[/dropcap3]To get your content displayed properly the theme uses wordpress shortcodes. Visual previews help you while creating those shortcodes so you don\'t need to memorize the codes...

[/one_fourth]

[hr]

[three_fourth first]

[sidebar_tab_container initial_open=\"1\" boxed=\'false\' ]

[sidebar_tab icon=\'Paint_Brush.png\' title=\"Colors and Fonts\"]
<h3>Colors and Fonts</h3>
The theme comes with a <strong>built in font and color selectors</strong> in case you want to change the tone of your website by changing the font and colors.

You can also use choose between a <strong>ton of predefined skins</strong> as a starting point for your customization and with the help of color selectors for links, background image and color create a unique layout in a matter of seconds.

Its as easy as can be!

[/sidebar_tab]

[sidebar_tab icon=\'Graph.png\' title=\"SEO\"]
<h3>SEO (Search engine optimization)</h3>
The theme is built with <strong>SEO best practices</strong> in mind. It uses semantical valid HTML code and CSS so search engines can index the content of your site with ease.

Important content is always placed before unimportent in your source code (eg: Blog Post content before Sidebar), Headlines are wrapped in heading tags (h1, h2, h3 etc) to signalise their importance to search engines. The site also uses <strong>heavy internal site linking</strong>, which is also of vital for search engines (related posts, breadcrumb navigation, primary and secondary navigation menus, footer navigation)

With this Wordpress Template you are well equipped to get a high google ranking and attract visitors

[/sidebar_tab]

[sidebar_tab icon=\'Blocks_Images.png\' title=\"Dynamic Templates\"]
<h3>Dynamic Templates</h3>
Build templates in a matter of seconds with a drag and drop interface that allows for almost any combination of posts and page content possible.

Want to build a 2 column page without slidehsow? easy. A landing Page with a 1-2-3 Step slider? <strong>Done in seconds.</strong>

[/sidebar_tab]

[sidebar_tab icon=\'Help.png\' title=\"Support\"]
<h3>Support</h3>
The theme comes with an <strong>extensive help file</strong> to help you understand how it works. If you encounter any problems or have questions once you purchased the theme feel free to drop us a notice at <a href=\"http://www.kriesi.at/support\" rel=\"nofollow\">http://www.kriesi.at/support</a>

We have <strong>8000 registered members</strong> that often help out faster than we can. Nevertheless you will always recieve a response from me or my support team. More than <strong>60000 Posts</strong> show that we do care that your site works fine

[/sidebar_tab]

[/sidebar_tab_container]

[/three_fourth]

[one_fourth]

[big_box left=\"%\" bellow=\"effort for every customer we get. Thats how we roll!\"]120[/big_box]

[/one_fourth] ","Welcome!","","publish","open","open","","welcome","","","2011-12-15 21:52:11","2011-12-15 21:52:11","","0","http://www.kriesi.at/themes/propulsion/?page_id=28","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("31","1","2011-12-15 21:57:39","2011-12-15 21:57:39","","Blog","","publish","open","open","","blog","","","2011-12-15 21:57:39","2011-12-15 21:57:39","","0","http://www.kriesi.at/themes/propulsion/?page_id=31","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("41","1","2011-12-16 00:59:46","2011-12-16 00:59:46","The attributes listed above (Skills, Copyright, URL) can be <strong>modified at will</strong>. You can add additional ones, remove existing or add another dozen if you want to. All of that can be done directly from your WordPress backend, no need to edit any code whatsoever.

<!--more-->

Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.","A nice Portfolio Entry","fire/water","publish","open","open","","a-nice-portfolio-entry","","","2011-12-16 00:59:46","2011-12-16 00:59:46","","0","http://www.kriesi.at/themes/propulsion/?post_type=portfolio&amp;p=41","0","portfolio","","0");
INSERT INTO `ts968ny_3_posts` VALUES("44","1","2011-12-16 01:06:03","2011-12-16 01:06:03","The attributes listed above (Skills, Copyright, URL) can be <strong>modified at will</strong>. You can add additional ones, remove existing or add another dozen if you want to. All of that can be done directly from your WordPress backend, no need to edit any code whatsoever.

<!--more-->

Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.","Lorem Ipsum","wind/earth","publish","open","open","","lorem-ipsum","","","2011-12-16 01:06:03","2011-12-16 01:06:03","","0","http://www.kriesi.at/themes/propulsion/?post_type=portfolio&amp;p=44","0","portfolio","","0");
INSERT INTO `ts968ny_3_posts` VALUES("45","1","2011-01-16 01:06:46","2011-01-16 01:06:46","The attributes listed above (Skills, Copyright, URL) can be <strong>modified at will</strong>. You can add additional ones, remove existing or add another dozen if you want to. All of that can be done directly from your WordPress backend, no need to edit any code whatsoever.

<!--more-->

Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.","Vimeo Video","Add what you want!","publish","open","closed","","vimeo-video","","","2011-01-16 01:06:46","2011-01-16 01:06:46","","0","http://www.kriesi.at/themes/propulsion/?post_type=portfolio&amp;p=45","0","portfolio","","0");
INSERT INTO `ts968ny_3_posts` VALUES("46","1","2011-12-16 01:07:21","2011-12-16 01:07:21","The attributes listed above (Skills, Copyright, URL) can be <strong>modified at will</strong>. You can add additional ones, remove existing or add another dozen if you want to. All of that can be done directly from your WordPress backend, no need to edit any code whatsoever.

<!--more-->

Nulla <strong>consequat</strong> massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu <strong>pede</strong> mollis pretium. Integer tincidunt. Cras dapibus.","Nice Image","Excerpt goes here!","publish","open","open","","nice-image","","","2011-12-16 01:07:21","2011-12-16 01:07:21","","0","http://www.kriesi.at/themes/propulsion/?post_type=portfolio&amp;p=46","0","portfolio","","0");
INSERT INTO `ts968ny_3_posts` VALUES("53","1","2011-12-16 01:51:30","2011-12-16 01:51:30","This premium WordPress theme comes with quite a few templates, so you have full layout options right from the start without editing. Each of those templates is build with SEO best practices in mind.

The theme uses meaningful markup like h1, h2 and h3 tags, unordered lists for navigations and put the content in front of the sidebar navigations.

The theme also uses a lot of internal linking like breadcrumb navigation, related posts and archive templates to name a few, so search engines are able to crawl your page without problems.

<!--more-->
<h2>Dropcap</h2>
[one_third first]
<h3>Dropcap 1</h3>
[dropcap1]L[/dropcap1]orem, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla.
[/one_third]

[one_third]
<h3>Dropcap 2</h3>
[dropcap2]A[/dropcap2]enean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturients mus.
[/one_third]

[one_third last]
<h3>Dropcap 3</h3>
[dropcap3]S[/dropcap3]it amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoques.
[/one_third]

[hr top]
<h2>This is a quote</h2>
<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</blockquote>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","Template Files","","publish","open","open","","template-files","","","2011-12-16 01:51:30","2011-12-16 01:51:30","","0","http://www.kriesi.at/themes/propulsion/?page_id=53","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("56","1","2011-12-16 01:53:23","2011-12-16 01:53:23","","Archive/Sitemap","","publish","open","open","","archivesitemap","","","2011-12-16 01:53:23","2011-12-16 01:53:23","","53","http://www.kriesi.at/themes/propulsion/?page_id=56","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("59","1","2011-12-16 01:54:13","2011-12-16 01:54:13","This is an example of a page with left aligned sidebar. You can set a default layout in your themes backend.
You can then overwrite this default setting for each post and page individually ;)

Since this Page is a subpage, nested to the Templates page, a sidebar with all siblings appears by default.

<!--more-->
<h2>Dropcap</h2>
[one_third first]
<h3>Dropcap 1</h3>
[dropcap1]L[/dropcap1]orem, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla.
[/one_third]

[one_third]
<h3>Dropcap 2</h3>
[dropcap2]A[/dropcap2]enean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturients mus.
[/one_third]

[one_third last]
<h3>Dropcap 3</h3>
[dropcap3]S[/dropcap3]it amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoques.
[/one_third]

[hr top]
<h2>This is a quote</h2>
<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</blockquote>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","Page: Sidebar Left","","publish","open","closed","","page-sidebar-left","","","2011-12-16 01:54:13","2011-12-16 01:54:13","","53","http://www.kriesi.at/themes/propulsion/?page_id=59","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("61","1","2011-12-16 01:54:30","2011-12-16 01:54:30","This is an example of a page with left aligned sidebar. You can set a default layout in your themes backend.
You can then overwrite this default setting for each post and page individually ;)

Since this Page is a subpage, nested to the Templates page, a sidebar with all siblings appears by default.

<!--more-->
<h2>Dropcap</h2>
[one_third first]
<h3>Dropcap 1</h3>
[dropcap1]L[/dropcap1]orem, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla.
[/one_third]

[one_third]
<h3>Dropcap 2</h3>
[dropcap2]A[/dropcap2]enean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturients mus.
[/one_third]

[one_third last]
<h3>Dropcap 3</h3>
[dropcap3]S[/dropcap3]it amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoques.
[/one_third]

[hr top]
<h2>This is a quote</h2>
<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</blockquote>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","Page: Sidebar Right","","publish","open","closed","","page-sidebar-right","","","2011-12-16 01:54:30","2011-12-16 01:54:30","","53","http://www.kriesi.at/themes/propulsion/?page_id=61","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("63","1","2011-12-16 01:54:58","2011-12-16 01:54:58","<h2>Columns</h2>
[one_half first] [dropcap3]1[/dropcap3]agna consequat consequat  consectetur, arcu seat  ligula elit sed meseqcipit lorem,  pulvinar  consequaagna consequat  consequat consectetur,  arcu sem suscipit  lorem,  pulvinar consequat  liguat consequat  consectetur, arcu sem  suscipit lorem,  pulvinar  consequat ligula elit  sed metus. consequat  consequat consetus.[/one_half]

[one_half] [dropcap3]2[/dropcap3]agna consequat consequat  consectetur, arcu seat  ligula elit sed meseqcipit lorem,  pulvinar  consequaagna consequat  consequat consectetur,  arcu sem suscipit  lorem,  pulvinar consequat  liguat consequat  consectetur, arcu sem  suscipit lorem,  pulvinar  consequat ligula elit  sed metus. consequat  consequat consetus.[/one_half]

[hr]

[one_third first] [dropcap3]1[/dropcap3]agna consequat consequat  consectetur, arcu seat  ligula elit sed meseqcipit lorem,  pulvinar  consequaagna consequat  consequat consectetur,  arcu sem suscipit  lorem,  pulvinar consequat  liguat consequat  consectetur, arcu sem  suscipit lorem,  pulvinar  consequat ligula elit  sed metus. consequat  consequat consetus.[/one_third]

[two_third] [dropcap3]2[/dropcap3]agna consequat consequat  consectetur, arcu seat  ligula elit sed meseqcipit lorem,  pulvinar  consequaagna consequat  consequat consectetur,  arcu sem suscipit  lorem,  pulvinar consequat  liguat consequat  consectetur, arcu sem  suscipit lorem,  pulvinar  consequat ligula elit  sed metus. consequat  consequat consetus.[/two_third]

[hr]

[one_fourth first][dropcap3]1[/dropcap3]Cogna consequat consequat   consectetur, arcu seat  ligula elit sed  meseqcipit lorem,  pulvinar   consequaagna consequat  consequat  consectetur,  arcu sem suscipit   lorem[/one_fourth]

[three_fourth][dropcap3]2[/dropcap3]Consequat consequat consectetur,   arcu seat  ligula elit sed  meseqcipit  lorem,  pulvinar consequaagna   consequat  consequat  consectetur,  arcu  sem suscipit lorem

Consequat consequat consectetur,  arcu seat  ligula elit sed   meseqcipit  lorem,  pulvinar consequaagna  consequat  consequat   consectetur,  arcu  sem suscipit lorem[/three_fourth]

[hr]

[one_fourth first][dropcap3]1[/dropcap3]Cogna consequat consequat  consectetur, arcu seat  ligula elit sed  meseqcipit lorem,  pulvinar  consequaagna consequat  consequat  consectetur,  arcu sem suscipit  lorem[/one_fourth]

[one_fourth][dropcap3]2[/dropcap3]Consequat consequat consectetur,   arcu seat  ligula elit sed  meseqcipit lorem,  pulvinar consequaagna   consequat  consequat  consectetur,  arcu sem suscipit lorem[/one_fourth]

[one_fourth][dropcap3]3[/dropcap3]Consequat consequat consectetur,   arcu seat  ligula elit sed  meseqcipit lorem,  pulvinar consequaagna   consequat  consequat  consectetur,  arcu sem suscipit lorem[/one_fourth]

[one_fourth][dropcap3]4[/dropcap3]Consequat consequat consectetur,   arcu seat  ligula elit sed  meseqcipit lorem,  pulvinar consequaagna   consequat  consequat  consectetur,  arcu sem suscipit lorem[/one_fourth]

[hr]

[one_fifth first] [box type=\"info\"]This is some infotext[/box]  Content for 1/5 Column ulvinar consequaagna consequat  consequat   consectetur,  arcu se[/one_fifth]

[one_fifth][box type=\"alert\"]This is some infotext[/box] Content for  1/5 Column quat  consectetur,  arcu sem suscipit loremagna consequat  conseq[/one_fifth]

[one_fifth][box type=\"tick\"]This is some infotext[/box] Content for  1/5 Column quaagna consequat  consequat  consectetur,  arcu sem suscipit  loremagna  consequat consequat consectetur, arcu seat  ligula elit sed   meseq[/one_fifth]

[one_fifth][box type=\"help\"]This is some infotext[/box]Content for  1/5 Column equat consequat consectetur, arcu seat  ligula elit sed   meseqcipit  lorem,  pulvinar consequaagna consequat  consequat   consectetur.[/one_fifth]

[one_fifth][box type=\"error\"]This is some infotext[/box] Content for  1/5 Column equat consectetur, arcu seat  ligula elit sed  meseqcipit  lorem,  pulvinar consequaagna consequat  consequat   consectet[/one_fifth]

[hr top]

[one_third first]
<h3>Tabs</h3>
[tab_container  initial_open=\'1\']

[tab title=\'Tab1\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod       tempor incididunt ut labore et dolore magna aliqua. Ut enim ad   minim     veniam, quis nostrud exercitation ullamco laboris nisi ut   aliquip ex   ea   commodo consequat. Duis aute irure dolor in   reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla   pariatur.
[/tab]

[tab title=\'Tab2\']
Ur adipisicing elit, sed do eiusmod    tempor incididunt ut labore et     dolore magna aliqua. Ut enim ad minim    veniam, quis nostrud     exercitation ullamco laboris nisi ut aliquip ex  ea   commour    adipisicing elit, sed do eiusmod    tempor incididunt ut labore et     dolore magna aliqua. Ut enim ad minim    veniam, quis nostrud     exercitation ullamco laboris nisi ut aliquip ex  ea   commoLorem ipsum    dolor sit amet.

Consectetur adipisicing elit, sed do eiusmod    tempor  incididunt ut   labore et dolore magna aliqua. Ut enim ad minim    veniam,  quis   nostrud exercitation ullamco laboris nisi ut aliquip ex  ea    commodo   consequat. Duis aute irure dolor in reprehenderit in  voluptate    velit   esse cillum dolore eu fugiat nulla pariatur.
[/tab]

[tab title=\'Tab3\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod        tempor incididunt ut labore et dolore magna aliqua. Ut enim ad    minim     veniam, quis nostrud exercitation ullamco laboris nisi ut    aliquip ex   ea   commor sit amet, consectetur adipisicing elit, sed do   eiusmod      tempor incididunt ut labore et Duis aute irure dolor in    reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla    pariatur.
[/tab]

[/tab_container]

[/one_third]

[one_third]
<h3>Toggles</h3>
[toggle_container keep_open=\'true\' ]

[toggle title=\'Click here to show/hide a small content box\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod      tempor incididunt ut labore et dolore magna aliqua. Ut enim ad  minim     veniam, quis nostrud exercitation ullamco laboris nisi ut  aliquip ex   ea   commodo consequat. Duis aute irure dolor in  reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla  pariatur.
[/toggle]

[toggle title=\'Click here\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod       tempor incididunt ut labore et dolore magna aliqua. Ut enim ad   minim     veniam, quis nostrud exercitation ullamco laboris nisi ut   aliquip ex   ea   commodo consequat. Duis aute irure dolor in   reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla   pariatur.
[/toggle]

[toggle title=\'Yes i am the next box\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod       tempor incididunt ut labore et dolore magna aliqua. Ut enim ad   minim     veniam, quis nostrud exercitation ullamco laboris nisi ut   aliquip ex   ea   commodo consequat. Duis aute irure dolor in   reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla   pariatur.
[/toggle]

[toggle title=\'Use as many as you wish\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod       tempor incididunt ut labore et dolore magna aliqua. Ut enim ad   minim     veniam, quis nostrud exercitation ullamco laboris nisi ut   aliquip ex   ea   commodo consequat. Duis aute irure dolor in   reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla   pariatur.
[/toggle]

[toggle title=\'Last click\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod       tempor incididunt ut labore et dolore magna aliqua. Ut enim ad   minim     veniam, quis nostrud exercitation ullamco laboris nisi ut   aliquip ex   ea   commodo consequat. Duis aute irure dolor in   reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla   pariatur.
[/toggle]

[/toggle_container]

[/one_third]

[one_third]
<h3>Toggles (one visible allowed)</h3>
[toggle_container keep_open=\'false\' initial_open=\'1\']

[toggle title=\'Click here to show/hide a small content box\']
Duis aute irure dolor in reprehenderit in  voluptate   velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'Click for another Box\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod      tempor incididunt ut labore et dolore magna aliqua. Ut enim ad  minim     veniam, quis nostrud exercitation ullamco laboris nisi ut  aliquip ex   ea   commodo consequat. Duis aute irure dolor in  reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla  pariatur.
[/toggle]

[toggle title=\'This is title #3\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod       tempor incididunt ut labore et dolore magna aliqua. Ut enim ad   minim     veniam, quis nostrud exercitation ullamco laboris nisi ut   aliquip ex   ea   commodo consequat. Duis aute irure dolor in   reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla   pariatur.
[/toggle]

[toggle title=\'I am number four!\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod       tempor incididunt ut labore et dolore magna aliqua. Ut enim ad   minim     veniam, quis nostrud exercitation ullamco laboris nisi ut   aliquip ex   ea   commodo consequat. Duis aute irure dolor in   reprehenderit in   voluptate   velit esse cillum dolore eu fugiat nulla   pariatur.
[/toggle]

[/toggle_container]

[/one_third] ","Page: Fullwidth","","publish","open","open","","page-fullwidth","","","2011-12-16 01:54:58","2011-12-16 01:54:58","","53","http://www.kriesi.at/themes/propulsion/?page_id=63","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("67","1","2011-12-16 01:56:08","2011-12-16 01:56:08","<h2>Table</h2>
[avia_table]
<table class=\"description_row description_column\">
<tbody>
<tr class=\"description_row\">
<td class=\"description_column\"></td>
<td>Basic</td>
<td class=\"highlighted\">Advanced</td>
<td>SuperStar</td>
</tr>
<tr class=\"pricing-row\">
<td class=\"description_column\">Plans</td>
<td>10$
<small>per month</small></td>
<td class=\"highlighted\">30$
<small>per month</small></td>
<td>60$
<small>per month</small></td>
</tr>
<tr>
<td class=\"description_column\">Team Members</td>
<td>3</td>
<td class=\"highlighted\">10</td>
<td>Unlimited</td>
</tr>
<tr>
<td class=\"description_column\">Active Goals</td>
<td>10</td>
<td class=\"highlighted\">15</td>
<td>Unlimited</td>
</tr>
<tr>
<td class=\"description_column\">Reports</td>
<td>[table_icon minus]</td>
<td class=\"highlighted\">[table_icon tick]</td>
<td>[table_icon tick]</td>
</tr>
<tr>
<td class=\"description_column\">User Limit</td>
<td>1000</td>
<td class=\"highlighted\">10000</td>
<td>Unlimited</td>
</tr>
<tr>
<td class=\"description_column\">Support</td>
<td>[table_icon minus]</td>
<td class=\"highlighted\">[table_icon minus]</td>
<td>[table_icon tick]</td>
</tr>
<tr>
<td class=\"description_column\">Notifications</td>
<td>[table_icon tick]</td>
<td class=\"highlighted\">[table_icon tick]</td>
<td>[table_icon tick]</td>
</tr>
<tr class=\"button-row\">
<td class=\"description_column\"></td>
<td>[button link=\"http://kriesi.at\"]Purchase[/button]</td>
<td class=\"highlighted\">[button link=\"http://kriesi.at\"]Purchase[/button]</td>
<td>[button link=\"http://kriesi.at\"]Purchase[/button]</td>
</tr>
</tbody>
</table>
[/avia_table]
<h2>Columns</h2>
[one_half first] [dropcap3]1[/dropcap3]agna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat consetus.[/one_half]

[one_half] [dropcap3]2[/dropcap3]agna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat consetus.[/one_half]

[hr]

[one_third first] [dropcap3]1[/dropcap3]agna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat consetus.[/one_third]

[two_third] [dropcap3]2[/dropcap3]agna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat consetus.[/two_third]

[hr]

[one_fourth first][dropcap3]1[/dropcap3]Cogna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem[/one_fourth]

[three_fourth][dropcap3]2[/dropcap3]Consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem

Consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem[/three_fourth]

[hr]

[one_fourth first][dropcap3]1[/dropcap3]Cogna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem[/one_fourth]

[one_fourth][dropcap3]2[/dropcap3]Consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem[/one_fourth]

[one_fourth][dropcap3]3[/dropcap3]Consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem[/one_fourth]

[one_fourth][dropcap3]4[/dropcap3]Consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem[/one_fourth]

[hr]

[one_fifth first] [box type=\"info\"]This is some infotext[/box] Content for 1/5 Column ulvinar consequaagna consequat consequat consectetur, arcu se[/one_fifth]

[one_fifth][box type=\"alert\"]This is some infotext[/box] Content for 1/5 Column quat consectetur, arcu sem suscipit loremagna consequat conseq[/one_fifth]

[one_fifth][box type=\"tick\"]This is some infotext[/box] Content for 1/5 Column quaagna consequat consequat consectetur, arcu sem suscipit loremagna consequat consequat consectetur, arcu seat ligula elit sed meseq[/one_fifth]

[one_fifth][box type=\"help\"]This is some infotext[/box]Content for 1/5 Column equat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur.[/one_fifth]

[one_fifth][box type=\"error\"]This is some infotext[/box] Content for 1/5 Column equat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectet[/one_fifth]

[hr top]

[one_third first]
<h3>Tabs</h3>
[tab_container  initial_open=\'1\']

[tab title=\'Tab1\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/tab]

[tab title=\'Tab2\']
Ur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commour adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commoLorem ipsum dolor sit amet.

Consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/tab]

[tab title=\'Tab3\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/tab]

[/tab_container]

[/one_third]

[one_third]
<h3>Toggles</h3>
[toggle_container keep_open=\'true\' ]

[toggle title=\'Click here to show/hide a small content box\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'Click here\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'Yes i am the next box\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'Use as many as you wish\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'Last click\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[/toggle_container]

[/one_third]

[one_third]
<h3>Toggles (one visible allowed)</h3>
[toggle_container keep_open=\'false\' initial_open=\'1\']

[toggle title=\'Click here to show/hide a small content box\']
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'Click for another Box\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'This is title #3\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[toggle title=\'I am number four!\']
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
[/toggle]

[/toggle_container]

[/one_third]

[hr]
<h3>Just a few possible buttons:</h3>
[one_third first]
<h3>Small Buttons</h3>
[button color=\"red\" text=\"light\"]red[/button] [button color=\"orange\" text=\"light\"]orange[/button] [button color=\"green\" text=\"light\"]green[/button] [button color=\"blue\" text=\"light\"]blue[/button] [button color=\"aqua\" text=\"light\"]aqua[/button] [button color=\"teal\" text=\"light\"]teal[/button] [button color=\"purple\" text=\"light\"]purple[/button] [button color=\"pink\" text=\"light\"]pink[/button] [button color=\"silver\" text=\"light\"]silver[/button] [button color=\"grey\" text=\"light\"]grey[/button] [button color=\"black\" text=\"light\"]black[/button]

[/one_third]

[one_third]
<h3>Medium sized Buttons</h3>
[button size=\"large\" color=\"red\" text=\"light\"]Custom Button[/button] [button size=\"large\" color=\"orange\" text=\"light\"]Custom Button[/button]

[button size=\"large\" color=\"green\" text=\"light\"]Custom Button[/button] [button size=\"large\" color=\"blue\" text=\"light\"]Custom Button[/button]

[button size=\"large\" color=\"aqua\" text=\"light\"]Custom Button[/button] [button size=\"large\" color=\"teal\" text=\"light\"]Custom Button[/button]

[button size=\"large\" color=\"purple\" text=\"light\"]Custom Button[/button] [button size=\"large\" color=\"pink\" text=\"light\"]Custom Button[/button]

[button size=\"large\" color=\"silver\" text=\"light\"]Custom Button[/button] [button size=\"large\" color=\"grey\" text=\"light\"]Custom Button[/button]

[/one_third]

[one_third]
<h3>Big Buttons</h3>
[button size=\"xl\" color=\"red\" text=\"light\"]Custom Button[/button] [button size=\"xl\" color=\"orange\" text=\"light\"]Custom Button[/button]

[button size=\"xl\" color=\"green\" text=\"light\"]Custom Button[/button] [button size=\"xl\" color=\"blue\" text=\"light\"]Custom Button[/button]

[button size=\"xl\" color=\"aqua\" text=\"light\"]Custom Button[/button] [button size=\"xl\" color=\"teal\" text=\"light\"]Custom Button[/button]

[button size=\"xl\" color=\"purple\" text=\"light\"]Custom Button[/button] [button size=\"xl\" color=\"pink\" text=\"light\"]Custom Button[/button]

[button size=\"xl\" color=\"silver\" text=\"light\"]Custom Button[/button] [button size=\"xl\" color=\"grey\" text=\"light\"]Custom Button[/button]

[/one_third]

&nbsp;

[hr]
<h3>Widgets</h3>
[one_third first]

[widget widget_name=\"avia_portfoliobox\" widget_class_name=\"newsbox\" title=\"Latest Portfolio Entries\" count=\"3\" excerpt=\"show title only\"]

[/one_third]

[one_third]

[widget widget_name=\"avia_newsbox\" widget_class_name=\"newsbox\" title=\"Latest Posts\" count=\"3\" excerpt=\"show title only\"]

[/one_third]

[one_third]

[widget widget_name=\"avia_tweetbox\" widget_class_name=\"tweetbox\" username=\"Kriesi\" title=\"Latest Tweets\" count=\"3\" exclude_replies=\"yes\" time=\"no\" display_image=\"yes\"]

[/one_third]

[hr]

[quote style=\"boxed\" float=\"left\"]A left floating quote[/quote]

[quote style=\"boxed\" float=\"right\"]A right floating quote[/quote]

[hr]
<h3>Icon Boxes</h3>
The theme comes with an Icon Box shortcode that makes use of more than 200 cool icons from a popular Icon sets that are ready to use instantly. And on top of that you can just add your own icon sets to the shortcode as well, simply by adding your icons to the themes icon folder ;)

[one_half first]
[iconbox title=\"Shortcodes\" icon=\"Radio.png\"]Select one of the icons. You can add icons to this list by simply uploading new ones to your themes image folder .[/iconbox]

[/one_half]

[one_half]

[iconbox title=\"Smart Ideas\" icon=\"Record.png\"]Folder (images/icons/iconbox). They will be displayed here automatically

[/iconbox]

[/one_half]

[one_half first]

[iconbox title=\"Copy Paste Work\" icon=\"Power.png\"]Select one of the icons. You can add icons to this list by simply uploading new ones to your themes image folder .[/iconbox]

[/one_half]

[one_half]

[iconbox title=\"Reviews\" icon=\"Settings.png\"]Folder (images/icons/iconbox). They will be displayed here automatically

[/iconbox]

[/one_half]

[hr]

[one_third first]
[iconbox title=\"Shortcodes\" icon=\"Speech_Bubbles_2.png\"]Select one of the icons. You can add icons to this list by simply uploading new ones to your themes image folder .[/iconbox]

[/one_third]

[one_third]

[iconbox title=\"Smart Ideas\" icon=\"Users.png\"]Folder (images/icons/iconbox). They will be displayed here automatically

[/iconbox]

[/one_third]

[one_third]

[iconbox title=\"Copy Paste Work\" icon=\"Chart_7.png\"]Select one of the icons. You can add icons to this list by simply uploading new ones to your themes image folder .[/iconbox]

[/one_third]

[one_third first]
[iconbox title=\"Shortcodes\" icon=\"Camera.png\"]Select one of the icons. You can add icons to this list by simply uploading new ones to your themes image folder .[/iconbox]

[/one_third]

[one_third]

[iconbox title=\"Smart Ideas\" icon=\"Documents.png\"]Folder (images/icons/iconbox). They will be displayed here automatically

[/iconbox]

[/one_third]

[one_third]

[iconbox title=\"Copy Paste Work\" icon=\"Film_Strip.png\"]Select one of the icons. You can add icons to this list by simply uploading new ones to your themes image folder .[/iconbox]

[/one_third]

[hr]

[one_third first]

[iconbox_top title=\"Build your own Skins\" icon=\"Frames.png\"]Right out of your backend. No coding needed...

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third] [iconbox_top title=\"Mobile Optimized\" icon=\"iPhone_4.png\"]Responsive Design and Slideshows with touchcontrol

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third]

[iconbox_top title=\"Premium Support\" icon=\"Speech_Bubble.png\"]A Support Forum with thousands of users and posts

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/support/\">Show Forum</a>

[/iconbox_top]

[/one_third]

[hr]

[one_third first]
<h3>Content Slider</h3>
The content slider can be placed anywhere and will adjust its width to the parent column. The height will automatically be modified for each conten slide[/one_third]

[two_third]

[slideshow 6]

[slide title=\"Slide1\"]Sliagna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat consetu.[/slide]

[slide title=\"Slide2\"]Sliagna conliem,  pulctetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinareqguat consconsequat conseuat consequat consequat consequat ligula elit sed metus. consequat consequat consetuagna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna conseqequat consectetur, arcu sem suscipit loruat consecqvinar contetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat consetuagna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consesequat sectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat cuat consonsetuere.[/slide]

[slide title=\"Slide3\"]Slideagna consequat consequat consectetur, arcu seat ligula elit sed meseqcipit lorem,  pulvinar consequaagna consequat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat liguat consequat consectetur, arcu sem suscipit lorem,  pulvinar consequat ligula elit sed metus. consequat consequat consetuere.[/slide]

[/slideshow]

[/two_third] ","Shortcodes","","publish","open","open","","shortcodes","","","2011-12-16 01:56:08","2011-12-16 01:56:08","","53","http://www.kriesi.at/themes/propulsion/?page_id=67","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("73","1","2011-12-16 02:14:08","2011-12-16 02:14:08","This is a gallery, created with the default <a href=\"http://codex.wordpress.org/Gallery_Shortcode\">WordPress Gallery Option</a>. The Image size of gallery pics is set automatically when the theme is activated, all you have to do then is to insert a gallery with a max of 7 columns to make it look like the one bellow…

Since this Page is a subpage, nested to the Templates page, a sidebar with all siblings appears by default.

[gallery link=\"file\" columns=\"7\"] ","Gallery","","publish","open","open","","gallery","","","2011-12-16 02:14:08","2011-12-16 02:14:08","","53","http://www.kriesi.at/themes/propulsion/?page_id=73","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("75","1","2011-12-16 02:16:00","2011-12-16 02:16:00","This is an example of a sortable, ajaxed 4 Column Portfolio.
For each Portfolio Page you create (any number possible) you can set column count,  pagination and item count, as well if its sortable or not.
You also got the option to open entries on the same page (via ajax) or on the default single page + Excerpt. <strong>Enjoy!</strong>","Portfolio 4 Columns","","publish","open","open","","portfolio-4-columns","","","2011-12-16 02:16:00","2011-12-16 02:16:00","","53","http://www.kriesi.at/themes/propulsion/?page_id=75","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("78","1","2011-12-16 02:16:17","2011-12-16 02:16:17","This is an example of a sortable, non-ajaxed 3 Column Portfolio.
For each Portfolio Page you create (any number possible) you can set column count,  pagination and item count, as well if its sortable or not.
You also got the option to open entries on the same page (via ajax) or on the default single page + Excerpt. <strong>Enjoy!</strong>","Portfolio 3 Columns (example: no ajax)","","publish","open","open","","portfolio-3-columns","","","2011-12-16 02:16:17","2011-12-16 02:16:17","","53","http://www.kriesi.at/themes/propulsion/?page_id=78","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("80","1","2011-12-16 02:16:30","2011-12-16 02:16:30","This is an example of a sortable, ajaxed 2 Column Portfolio.
For each Portfolio Page you create (any number possible) you can set column count,  pagination and item count, as well if its sortable or not.
You also got the option to open entries on the same page (via ajax) or on the default single page + Excerpt. <strong>Enjoy!</strong>","Portfolio 2 Columns","","publish","open","open","","portfolio-2-columns","","","2011-12-16 02:16:30","2011-12-16 02:16:30","","53","http://www.kriesi.at/themes/propulsion/?page_id=80","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("82","1","2011-12-16 02:16:41","2011-12-16 02:16:41","","Portfolio 1 Column","","publish","open","open","","portfolio-1-column","","","2011-12-16 02:16:41","2011-12-16 02:16:41","","53","http://www.kriesi.at/themes/propulsion/?page_id=82","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("84","1","2011-12-16 02:16:59","2011-12-16 02:16:59","","Portfolio + Sidebar","","publish","open","open","","portfolio-sidebar","","","2011-12-16 02:16:59","2011-12-16 02:16:59","","53","http://www.kriesi.at/themes/propulsion/?page_id=84","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("86","1","2011-12-16 03:12:37","2011-12-16 03:12:37","[box type=\"info\" size=\"large\" style=\"rounded\" border=\"full\"]You can add, remove and modify the input fields, text areas, dropdowns and checkboxes from your contact page within your WordPress Admin Panel. [/box]

<a href=\"http://#\">Nulla</a> consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a.","Contact","","publish","open","open","","contact","","","2011-12-16 03:12:37","2011-12-16 03:12:37","","0","http://www.kriesi.at/themes/propulsion/?page_id=86","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("93","1","2009-03-07 15:42:01","2009-03-07 15:42:01","<h2>Image aligned left &amp; right</h2>
<a href=\"http://dl.dropbox.com/u/2025095/alwaysonline/avisio/small1.jpg\"><img class=\"alignleft\" src=\"http://dl.dropbox.com/u/2025095/alwaysonline/avisio/small1.jpg\" alt=\"\" width=\"200\" height=\"130\" /></a>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.rum.

Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
<blockquote>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</blockquote>
<img class=\"alignright\" src=\"http://dl.dropbox.com/u/2025095/alwaysonline/avisio/small1.jpg\" alt=\"\" width=\"200\" height=\"130\" />Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

<!--more-->
<h2>Image aligned left with caption</h2>
[caption id=\"\" align=\"alignleft\" width=\"200\" caption=\"This is a caption\"]<img src=\"http://dl.dropbox.com/u/2025095/alwaysonline/avisio/small1.jpg\" alt=\"\" width=\"200\" height=\"130\" />[/caption]

Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

[hr top]
<h2>UL &amp; OL</h2>
From graphics to web development, audio to video and more.
get the skills you want from our family of tutorial and resource sites. Need more? We also offer a Plus program where you can access source files and bonus tutorials.
<ul>
	<li><a href=\"#\">Home</a> - From graphics to web development, audio to video and more</li>
	<li><a href=\"#\">Portfolio</a> - From our family of tutorial and resource sites</li>
	<li><a href=\"#\">About</a> - We also offer a Plus program where you can access source files and bonus tutorials</li>
	<li>Audio to video and more, get the skills</li>
	<li>This is an example of a static page</li>
	<li>some small punchline goes here</li>
</ul>
Need more? We also offer a Plus program where you can access source files and bonus tutorials .From graphics to web development, audio to video and more.
<ol>
	<li><a href=\"#\">Home</a> - From graphics to web development, audio to video and more</li>
	<li><a href=\"#\">Portfolio</a> - From our family of tutorial and resource sites</li>
	<li><a href=\"#\">About</a> - We also offer a Plus program where you can access source files and bonus tutorials</li>
	<li>Audio to video and more, get the skills</li>
	<li>This is an example of a static page</li>
	<li>some small punchline goes here</li>
</ol>
[hr top]
<h2>Table Styling</h2>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
<table id=\"mytable\" summary=\"The technical specifications of the Apple PowerMac G5 series\" cellspacing=\"0\"><caption>Table 1: Apple Product specs</caption>
<tbody>
<tr>
<th class=\"nobg\" scope=\"col\">Product:</th>
<th scope=\"col\">iPhone 3GS</th>
<th scope=\"col\">iPad</th>
<th scope=\"col\">iPod Nano</th>
</tr>
<tr>
<th class=\"spec\" scope=\"row\">Version</th>
<td>3rd Generation build</td>
<td>1st Generation build</td>
<td>27th Generation build</td>
</tr>
<tr>
<th class=\"specalt\" scope=\"row\">Multitouch</th>
<td class=\"alt\">Yes</td>
<td class=\"alt\">Yes</td>
<td class=\"alt\">No</td>
</tr>
<tr>
<th class=\"spec\" scope=\"row\">Video</th>
<td>Yes - doesnt play flash content</td>
<td>Yes - doesnt play content</td>
<td>Yes - does play any content</td>
</tr>
<tr>
<th class=\"specalt\" scope=\"row\">Release Date</th>
<td class=\"alt\">Nov. 2009</td>
<td class=\"alt\">Mai. 2010</td>
<td class=\"alt\">Jun. 2010</td>
</tr>
</tbody>
</table>
[hr top]
<h2>Page Headings</h2>
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea co
<h1>This is a H1 Heading</h1>
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.
<h2>This is a H2 Heading</h2>
Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
<h3>This is a H3 Heading</h3>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
<h4>This is a H4 Heading</h4>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.
<h5>This is a H5 Heading</h5>
Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.
<h6>This is a H6 Heading</h6>
Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.

[hr top] ","HTML Styles","","publish","open","open","","html-styles","","","2009-03-07 15:42:01","2009-03-07 15:42:01","","0","http://docs.kriesi.at/wp/?p=36","0","post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("94","1","2010-05-07 15:43:44","2010-05-07 15:43:44","Ut enim ad minim veniam, quis nostrud <a href=\"http://www.kriesi.at\">exercitation ullamco</a> laboris nisi ut aliquip ex ea commodo consequat.

Lorem ipsum dolor sit amet, <strong><strong>consectetur</strong></strong> adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore <strong>magna aliqua</strong>.

<!--more-->

Duis aute irure dolor in reprehenderit in <strong>voluptate</strong> velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

<img src=\"http://wordpress3/wp-includes/js/tinymce/plugins/wordpress/img/trans.gif\" alt=\"\" />

Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi","A Post without Image","","publish","open","open","","advanced-jquery-functions","","","2010-05-07 15:43:44","2010-05-07 15:43:44","","0","http://docs.kriesi.at/wp/?p=38","0","post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("95","1","2010-08-09 15:45:27","2010-08-09 15:45:27","Ut enim ad minim veniam, quis nostrud <a href=\"http://www.kriesi.at\">exercitation ullamco</a> laboris nisi ut aliquip ex ea commodo consequat. Lorem ipsum dolor sit amet, <strong><strong>consectetur</strong></strong> adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore <strong>magna aliqua</strong>.

<!--more-->

Duis aute irure dolor in reprehenderit in <strong>voluptate</strong> velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi","Custom Lightbox!","","publish","open","open","","custom-lightbox-click-the-image","","","2010-08-09 15:45:27","2010-08-09 15:45:27","","0","http://docs.kriesi.at/wp/?p=40","0","post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("237","1","2010-12-28 13:24:30","2010-12-28 13:24:30","Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.

<!--more-->Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.","This is a test","","publish","open","open","","this-is-a-test","","","2010-12-28 13:24:30","2010-12-28 13:24:30","","0","http://wordpress3/?p=237","0","post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("246","1","2011-01-28 15:35:38","2011-01-28 15:35:38","Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.

<!--more-->Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.","Another title for our pretty cool blog","","publish","open","open","","another-title-for-our-pretty-cool-blog","","","2011-01-28 15:35:38","2011-01-28 15:35:38","","0","http://wordpress3/?p=246","0","post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("250","1","2011-02-12 21:11:13","2011-02-12 21:11:13","Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.

<!--more-->Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.

[quote float=\"left\"]Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massculus mus.[/quote] Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.

Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.

[caption id=\"attachment_35\" align=\"alignleft\" width=\"930\" caption=\"Use image size large and align left to show an image that ignores the textbock boundaries\"]<a href=\"http://www.kriesi.at/themes/coherence/files/2011/12/prev1.jpg\"><img class=\"size-large wp-image-35 \" title=\"Undented image\" src=\"http://www.kriesi.at/themes/coherence/files/2011/12/prev1.jpg\" alt=\"\" width=\"930\" height=\"340\" /></a>[/caption]

Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus.","Indented Quotes and Images -  beautiful","","publish","open","open","","lorem-ipsum-dolor-sit-amet-consectetuer-adipiscing-elit-aenean-commodo-ligula-eget-dolor-aenean-massa","","","2011-02-12 21:11:13","2011-02-12 21:11:13","","0","http://wordpress3/?p=250","0","post","","3");
INSERT INTO `ts968ny_3_posts` VALUES("252","1","2011-02-17 21:11:58","2011-02-17 21:11:58","Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi. Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lor

Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.

<!--more-->Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo.

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.","Post with post format Gallery: Multiple preview image that can have different sizes","","publish","open","open","","aenean-vulputate-eleifend-tellus-aenean-leo-ligula","","","2011-02-17 21:11:58","2011-02-17 21:11:58","","0","http://wordpress3/?p=252","0","post","","1");
INSERT INTO `ts968ny_3_posts` VALUES("254","1","2011-03-28 21:13:11","2011-03-28 21:13:11","- more on <a href=\"http://codex.wordpress.org/Post_Formats\">Wordpress.org: Post Formats</a>","Post Formats is a theme feature introduced with Version 3.1. Post Formats can be used by a theme to customize its presentation of a post.","","publish","open","open","","nullam-dictum-felis-eu-pede-mollis-pretium-integer-tincidunt-cras-dapibus-vivamus-elementum-semper-nisi-aenean-vulputate-eleifend-tellus","","","2011-03-28 21:13:11","2011-03-28 21:13:11","","0","http://wordpress3/?p=254","0","post","","10");
INSERT INTO `ts968ny_3_posts` VALUES("282","1","2012-01-14 13:13:53","2012-01-14 13:13:53","Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.

Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi.

<!--more-->

Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet.
<ul>
	<li>Quisque rutrum. Aenean imperdiet.</li>
	<li>Etiam ultricies nisi vel augue.</li>
	<li>Curabitur ullamcorper ultricies nisi.</li>
	<li>Nam eget dui. Etiam rhoncus.</li>
</ul>
[quote float=\"left\"]Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim.[/quote] Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi.","This is a standard post format with preview Picture","","publish","open","open","","this-is-a-nice-post","","","2012-01-14 13:13:53","2012-01-14 13:13:53","","0","http://wordpress3/?p=282","0","post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("296","1","2012-01-17 20:00:25","2012-01-17 20:00:25","http://www.kriesi.at

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim.

Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus.","This is a post  with post format of type Link","","publish","open","open","","kriesi-at","","","2012-01-17 20:00:25","2012-01-17 20:00:25","","0","http://www.kriesi.at/themes/propulsion/?p=296","0","post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("310","1","2012-04-30 14:29:31","0000-00-00 00:00:00","","avia_fullsize_background_image_for_this_entry","","draft","closed","closed","","","","","2012-04-30 14:29:31","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/coherence/?post_type=avia_framework_post&amp;p=310","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("313","1","2012-04-30 14:37:00","2012-04-30 14:37:00","","1","","inherit","open","open","","1","","","2012-04-30 14:37:00","2012-04-30 14:37:00","","73","http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/2012/04/1.jpg","0","attachment","image/jpeg","0");
INSERT INTO `ts968ny_3_posts` VALUES("314","1","2012-04-30 14:37:02","2012-04-30 14:37:02","","013","","inherit","open","open","","013","","","2012-04-30 14:37:02","2012-04-30 14:37:02","","73","http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/2012/04/013.jpg","0","attachment","image/jpeg","0");
INSERT INTO `ts968ny_3_posts` VALUES("315","1","2012-04-30 14:37:04","2012-04-30 14:37:04","","014","","inherit","open","open","","014","","","2012-04-30 14:37:04","2012-04-30 14:37:04","","73","http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/2012/04/014.jpg","0","attachment","image/jpeg","0");
INSERT INTO `ts968ny_3_posts` VALUES("316","1","2012-04-30 14:37:10","2012-04-30 14:37:10","","2","","inherit","open","open","","2","","","2012-04-30 14:37:10","2012-04-30 14:37:10","","73","http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/2012/04/2.jpg","0","attachment","image/jpeg","0");
INSERT INTO `ts968ny_3_posts` VALUES("341","1","2012-05-21 03:04:00","0000-00-00 00:00:00","","avia_header_background_image_for_this_entry","","draft","closed","closed","","","","","2012-05-21 03:04:00","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/flagship/?post_type=avia_framework_post&amp;p=341","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("395","1","2012-05-21 13:08:35","2012-05-21 13:08:35","[one_third first]

[big_box left=\"%\" bellow=\"Satisfaction guaranteed\"]100[/big_box]

[/one_third]

[one_third]

[big_box  bellow=\"Super Happy Customers\"]35489[/big_box]

[/one_third]

[one_third]

[big_box bellow=\"Successfull Products launched\"]30[/big_box]

[/one_third]

[hr]

[one_half first]

[iconbox title=\"Build your own Skins\" icon=\"Frames.png\"]Modify one of 21 Predefined Theme skins or build your own, right out from the Wordpress Admin Panel[/iconbox]

[/one_half]

[one_half]

[iconbox title=\"Mobile Optimized\" icon=\"iPhone_4.png\"]Responsive Design and Slideshows with touchcontrol for a super sweet mobile and tablet experience.[/iconbox]

[/one_half]

[one_half first]

[iconbox title=\"Theme Support\" icon=\"Speech_Bubble.png\"]Don\'t be shy and get in touch, let us know if you likte the theme, tell us if you got any problems in out support forum![/iconbox]

[/one_half]

[one_half]

[iconbox title=\"Translation Ready\" icon=\"User_Comment.png\"]Translation ready with mo/po files (Already comes with english, german, spanish and romanian language files)[/iconbox]

[/one_half]

[one_half first]

[iconbox title=\"Avia Framework\" icon=\"Power.png\"]Powered by our very own supper flexible Avia Framework! Lots of easy to customize options that help you instead of overwhelm[/iconbox]

[/one_half]

[one_half]

[iconbox title=\"Shortcodes Builder\" icon=\"Info_About.png\"]A visual shortcode editor with live preview function helps to create interesting layouts, such as this one ![/iconbox]

[/one_half]

[hr]

[avia_table]
<table class=\"description_row description_column\">
<tbody>
<tr class=\"description_row\">
<td class=\"description_column\"></td>
<td>Basic</td>
<td class=\"highlighted\">Advanced</td>
<td>SuperStar</td>
</tr>
<tr class=\"pricing-row\">
<td class=\"description_column\">Plans</td>
<td>10$
<small>per month</small></td>
<td class=\"highlighted\">30$
<small>per month</small></td>
<td>60$
<small>per month</small></td>
</tr>
<tr>
<td class=\"description_column\">Team Members</td>
<td>3</td>
<td class=\"highlighted\">10</td>
<td>Unlimited</td>
</tr>
<tr>
<td class=\"description_column\">Active Goals</td>
<td>10</td>
<td class=\"highlighted\">15</td>
<td>Unlimited</td>
</tr>
<tr>
<td class=\"description_column\">Reports</td>
<td>[table_icon minus]</td>
<td class=\"highlighted\">[table_icon tick]</td>
<td>[table_icon tick]</td>
</tr>
<tr>
<td class=\"description_column\">User Limit</td>
<td>1000</td>
<td class=\"highlighted\">10000</td>
<td>Unlimited</td>
</tr>
<tr>
<td class=\"description_column\">Support</td>
<td>[table_icon minus]</td>
<td class=\"highlighted\">[table_icon minus]</td>
<td>[table_icon tick]</td>
</tr>
<tr>
<td class=\"description_column\">Notifications</td>
<td>[table_icon tick]</td>
<td class=\"highlighted\">[table_icon tick]</td>
<td>[table_icon tick]</td>
</tr>
<tr class=\"button-row\">
<td class=\"description_column\"></td>
<td>[button link=\"http://kriesi.at\"]Purchase[/button]</td>
<td class=\"highlighted\">[button link=\"http://kriesi.at\"]Purchase[/button]</td>
<td>[button link=\"http://kriesi.at\"]Purchase[/button]</td>
</tr>
</tbody>
</table>
[/avia_table]

&nbsp;","Landing Page Example","","publish","open","closed","","landing-page-example","","","2012-05-21 13:08:35","2012-05-21 13:08:35","","28","http://www.kriesi.at/themes/flagship/?page_id=395","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("407","1","2012-05-21 13:25:42","0000-00-00 00:00:00","","avia_image_above_text","","draft","closed","closed","","","","","2012-05-21 13:25:42","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/flagship/?post_type=avia_framework_post&amp;p=407","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("438","1","2012-05-21 14:11:26","2012-05-21 14:11:26","[one_third first]

[iconbox_top title=\"Build your own Skins\" icon=\"Frames.png\"]Right out of your backend. No coding needed...

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third] [iconbox_top title=\"Mobile Optimized\" icon=\"iPhone_4.png\"]Responsive Design and Slideshows with touchcontrol

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third]

[iconbox_top title=\"Premium Support\" icon=\"Speech_Bubble.png\"]A Support Forum with thousands of users and posts

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/support/\">Show Forum</a>

[/iconbox_top]

[/one_third]

[hr_invisible]

[one_fourth first]
<h3>Flexibly Templates</h3>
[dropcap2]1[/dropcap2]The theme uses a flexible template system that enables you to create stunning pages out of the box with no coding knowledge at all

[/one_fourth]

[one_fourth]
<h3>Unlimited Skins</h3>
[dropcap3]2[/dropcap3]The theme comes with several predefined skin options but also utilizes a color and background image switcher, a font-switch for headings and several other layout options.

[/one_fourth]

[one_fourth]
<h3>Content Importing</h3>
[dropcap3]3[/dropcap3]You can now setup a wordpress installation that looks like this demo with just a single click of your mouse. Amazing to get started and accustomed to the theme.

[/one_fourth]

[one_fourth]
<h3>Shortcodes</h3>
[dropcap3]4[/dropcap3]To get your content displayed properly the theme uses wordpress shortcodes. Visual previews help you while creating those shortcodes so you don\'t need to memorize the codes...

[/one_fourth]

[hr]

[three_fourth first]

[sidebar_tab_container initial_open=\"1\" boxed=\'false\' ]

[sidebar_tab icon=\'Paint_Brush.png\' title=\"Colors and Fonts\"]
<h3>Colors and Fonts</h3>
The theme comes with a <strong>built in font and color selectors</strong> in case you want to change the tone of your website by changing the font and colors.

You can also use choose between a <strong>ton of predefined skins</strong> as a starting point for your customization and with the help of color selectors for links, background image and color create a unique layout in a matter of seconds.

Its as easy as can be!

[/sidebar_tab]

[sidebar_tab icon=\'Graph.png\' title=\"SEO\"]
<h3>SEO (Search engine optimization)</h3>
The theme is built with <strong>SEO best practices</strong> in mind. It uses semantical valid HTML code and CSS so search engines can index the content of your site with ease.

Important content is always placed before unimportent in your source code (eg: Blog Post content before Sidebar), Headlines are wrapped in heading tags (h1, h2, h3 etc) to signalise their importance to search engines. The site also uses <strong>heavy internal site linking</strong>, which is also of vital for search engines (related posts, breadcrumb navigation, primary and secondary navigation menus, footer navigation)

With this Wordpress Template you are well equipped to get a high google ranking and attract visitors

[/sidebar_tab]

[sidebar_tab icon=\'Blocks_Images.png\' title=\"Dynamic Templates\"]
<h3>Dynamic Templates</h3>
Build templates in a matter of seconds with a drag and drop interface that allows for almost any combination of posts and page content possible.

Want to build a 2 column page without slidehsow? easy. A landing Page with a 1-2-3 Step slider? <strong>Done in seconds.</strong>

[/sidebar_tab]

[sidebar_tab icon=\'Help.png\' title=\"Support\"]
<h3>Support</h3>
The theme comes with an <strong>extensive help file</strong> to help you understand how it works. If you encounter any problems or have questions once you purchased the theme feel free to drop us a notice at <a href=\"http://www.kriesi.at/support\" rel=\"nofollow\">http://www.kriesi.at/support</a>

We have <strong>8000 registered members</strong> that often help out faster than we can. Nevertheless you will always recieve a response from me or my support team. More than <strong>60000 Posts</strong> show that we do care that your site works fine

[/sidebar_tab]

[/sidebar_tab_container]

[/three_fourth]

[one_fourth]

[big_box left=\"%\" bellow=\"effort for every customer we get. Thats how we roll!\"]120[/big_box]

[/one_fourth] ","Aviapoly Slider Example","","publish","open","closed","","aviapoly-slider-example","","","2012-05-21 14:11:26","2012-05-21 14:11:26","","28","http://www.kriesi.at/themes/flagship/?page_id=438","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("506","1","2012-05-21 03:00:50","0000-00-00 00:00:00","","avia_logo","","draft","closed","closed","","","","","2012-05-21 03:00:50","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/flagship/?post_type=avia_framework_post&amp;p=4","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("507","1","2012-05-21 03:00:50","0000-00-00 00:00:00","","avia_favicon","","draft","closed","closed","","","","","2012-05-21 03:00:50","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/flagship/?post_type=avia_framework_post&amp;p=5","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("508","1","2012-05-21 03:00:50","0000-00-00 00:00:00","","avia_custom_background_image","","draft","closed","closed","","","","","2012-05-21 03:00:50","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/flagship/?post_type=avia_framework_post&amp;p=6","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("549","1","2012-06-16 18:39:03","2012-06-16 18:39:03","","Archive Timeline","","publish","open","open","","archive-timeline","","","2012-06-16 18:39:03","2012-06-16 18:39:03","","53","http://www.kriesi.at/themes/choices/?page_id=549","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("593","1","2012-06-16 20:22:13","2012-06-16 20:22:13","","slider1","","inherit","open","open","","slider1-2","","","2012-06-16 20:22:13","2012-06-16 20:22:13","","28","http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/2011/12/slider11.png","0","attachment","image/png","0");
INSERT INTO `ts968ny_3_posts` VALUES("594","1","2012-06-16 20:22:16","2012-06-16 20:22:16","","slider2","","inherit","open","open","","slider2","","","2012-06-16 20:22:16","2012-06-16 20:22:16","","28","http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/2011/12/slider2.png","0","attachment","image/png","0");
INSERT INTO `ts968ny_3_posts` VALUES("601","1","2012-06-16 21:02:15","2012-06-16 21:02:15","","slider_half","","inherit","open","open","","slider_half","","","2012-06-16 21:02:15","2012-06-16 21:02:15","","28","http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/2011/12/slider_half.png","0","attachment","image/png","0");
INSERT INTO `ts968ny_3_posts` VALUES("602","1","2012-06-16 15:13:05","0000-00-00 00:00:00","","avia_favicon","","draft","closed","closed","","","","","2012-06-16 15:13:05","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=5","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("603","1","2012-06-16 15:13:05","0000-00-00 00:00:00","","avia_custom_background_image","","draft","closed","closed","","","","","2012-06-16 15:13:05","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=6","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("604","1","2013-01-04 23:47:23","2013-01-04 23:47:23","","Home","","publish","open","open","","home","","","2013-01-04 23:47:23","2013-01-04 23:47:23","","0","http://rubensteinarchitects.com/choices/2013/01/04/home/","1","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("608","1","2012-06-16 22:40:06","0000-00-00 00:00:00","","avia_logo_1","","draft","closed","closed","","","","","2012-06-16 22:40:06","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=608","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("609","1","2012-06-16 22:40:06","0000-00-00 00:00:00","","avia_logo_2","","draft","closed","closed","","","","","2012-06-16 22:40:06","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=609","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("610","1","2012-06-16 22:40:06","0000-00-00 00:00:00","","avia_logo_3","","draft","closed","closed","","","","","2012-06-16 22:40:06","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=610","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("611","1","2012-06-16 22:40:06","0000-00-00 00:00:00","","avia_logo_4","","draft","closed","closed","","","","","2012-06-16 22:40:06","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=611","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("612","1","2012-06-16 22:40:06","0000-00-00 00:00:00","","avia_logo_5","","draft","closed","closed","","","","","2012-06-16 22:40:06","0000-00-00 00:00:00","","0","http://www.kriesi.at/themes/choices/?post_type=avia_framework_post&amp;p=612","0","avia_framework_post","","0");
INSERT INTO `ts968ny_3_posts` VALUES("630","1","2012-06-17 00:09:07","2012-06-17 00:09:07","[one_third first]

[iconbox_top title=\"Build your own Skins\" icon=\"Frames.png\"]Right out of your backend. No coding needed...

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third] [iconbox_top title=\"Mobile Optimized\" icon=\"iPhone_4.png\"]Responsive Design and Slideshows with touchcontrol

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/themes/choices/template-files/shortcodes/\">Learn More</a>

[/iconbox_top]

[/one_third]

[one_third]

[iconbox_top title=\"Premium Support\" icon=\"Speech_Bubble.png\"]A Support Forum with thousands of users and posts

<a title=\"Shortcodes\" href=\"http://www.kriesi.at/support/\">Show Forum</a>

[/iconbox_top]

[/one_third]

[hr_invisible] ","Home page with Portfolio","","publish","open","open","","home-page-with-portfolio","","","2012-06-17 00:09:07","2012-06-17 00:09:07","","28","http://www.kriesi.at/themes/choices/?page_id=630","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("645","1","2012-06-17 08:08:49","2012-06-17 08:08:49","[one_half first]

[iconbox_top title=\"Christian Kriesi Budschedl - Co-Founder\" icon=\"User.png\"]<img title=\"\" src=\"http://lorempixel.com/406/300/people/\" alt=\"\" />Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.
<ul>
	<li><a href=\"http://twitter.com/kriesi\">Kriesi on Twitter</a></li>
	<li><a href=\"http://dribbble.com/kriesi\">Kriesi on Dribbble</a></li>
</ul>
[/iconbox_top]

[/one_half]

[one_half]

[iconbox_top title=\"John Doe, PhD - Co-Founder\" icon=\"User_2.png\"]<img title=\"\" src=\"http://lorempixel.com/406/300/people/\" alt=\"\" />Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem.
<ul>
	<li><a href=\"http://twitter.com/kriesi\">John on Twitter</a></li>
	<li><a href=\"http://dribbble.com/kriesi\">John on Dribbble</a></li>
</ul>
[/iconbox_top]

[/one_half]

[one_third first]

[iconbox_top title=\"Tyler Burden - Support\" icon=\"Help.png\"]<img title=\"\" src=\"http://lorempixel.com/243/150/people/\" alt=\"\" />Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa.
<ul>
	<li><a href=\"http://twitter.com/kriesi\">Tyler on Twitter</a></li>
	<li><a href=\"http://dribbble.com/kriesi\">Tyler on Dribbble</a></li>
</ul>
[/iconbox_top]

[/one_third]

[one_third] [iconbox_top title=\"Marcus Man - Designer\" icon=\"Big_Brush.png\"]<img title=\"\" src=\"http://lorempixel.com/243/150/people/\" alt=\"\" />Aenean massa. Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor.
<ul>
	<li><a href=\"http://twitter.com/kriesi\">Marcus on Twitter</a></li>
	<li><a href=\"http://linkedin.com/\">Marcus on Linkedin</a></li>
</ul>
[/iconbox_top]

[/one_third]

[one_third]

[iconbox_top title=\"Andy Cole - Developer\" icon=\"Cog_4.png\"]<img title=\"\" src=\"http://lorempixel.com/243/150/people/\" alt=\"\" /> Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultrsem.
<ul>
	<li><a href=\"http://twitter.com/kriesi\">Andy on Twitter</a></li>
	<li><a href=\"http://dribbble.com/kriesi\">Andy on Dribbble</a></li>
</ul>
[/iconbox_top]

[/one_third]

[hr_invisible]

&nbsp;","Team","","publish","open","open","","team","","","2012-06-17 08:08:49","2012-06-17 08:08:49","","0","http://www.kriesi.at/themes/choices/?page_id=645","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("646","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","646","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/646/","9","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("647","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","647","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/647/","8","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("648","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","648","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/648/","7","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("649","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","649","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/649/","19","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("650","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","650","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/650/","25","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("651","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","651","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","0","http://rubensteinarchitects.com/choices/2013/01/04/651/","5","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("652","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","652","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","0","http://rubensteinarchitects.com/choices/2013/01/04/652/","29","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("653","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","653","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","0","http://rubensteinarchitects.com/choices/2013/01/04/653/","12","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("654","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","654","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/654/","13","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("655","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","655","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/655/","15","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("656","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","656","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/656/","17","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("657","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","657","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/657/","18","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("658","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","658","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/658/","20","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("659","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","659","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/659/","21","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("660","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","660","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/660/","22","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("661","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","661","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/661/","23","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("662","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","662","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/662/","24","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("663","1","2013-01-04 23:47:24","2013-01-04 23:47:24","","Portfolio","","publish","open","open","","portfolio","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/portfolio/","6","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("664","1","2013-01-04 23:47:24","2013-01-04 23:47:24"," ","","","publish","open","open","","664","","","2013-01-04 23:47:24","2013-01-04 23:47:24","","53","http://rubensteinarchitects.com/choices/2013/01/04/664/","11","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("665","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","665","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","53","http://rubensteinarchitects.com/choices/2013/01/04/665/","10","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("666","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","666","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","28","http://rubensteinarchitects.com/choices/2013/01/04/666/","3","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("667","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","667","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","28","http://rubensteinarchitects.com/choices/2013/01/04/667/","4","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("668","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","668","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","53","http://rubensteinarchitects.com/choices/2013/01/04/668/","14","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("669","1","2013-01-04 23:47:25","2013-01-04 23:47:25","","Homepage with Portfolio","","publish","open","open","","homepage-with-portfolio","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","28","http://rubensteinarchitects.com/choices/2013/01/04/homepage-with-portfolio/","2","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("670","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","670","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","0","http://rubensteinarchitects.com/choices/2013/01/04/670/","28","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("671","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","671","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","0","http://rubensteinarchitects.com/choices/2013/01/04/671/","27","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("672","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","672","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","0","http://rubensteinarchitects.com/choices/2013/01/04/672/","26","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("673","1","2013-01-04 23:47:25","2013-01-04 23:47:25"," ","","","publish","open","open","","673","","","2013-01-04 23:47:25","2013-01-04 23:47:25","","28","http://rubensteinarchitects.com/choices/2013/01/04/673/","16","nav_menu_item","","0");
INSERT INTO `ts968ny_3_posts` VALUES("674","1","2013-01-29 02:41:15","2013-01-29 02:41:15","[wysija_page]","Subscription confirmation","","publish","open","open","","subscriptions","","","2013-01-29 02:41:15","2013-01-29 02:41:15","","0","http://rubensteinarchitects.com/choices/?wysijap=subscriptions","0","wysijap","","0");
INSERT INTO `ts968ny_3_posts` VALUES("676","1","2013-02-21 18:42:52","2013-02-21 18:42:52","Hi! This page is used by your Job Manager plugin as a base. Feel free to change settings here, but please do not delete this page. Also note that any content you enter here will not show up when this page is displayed on your site.","Jobs Listing","","publish","closed","closed","","jobs","","","2013-02-21 18:42:52","2013-02-21 18:42:52","","0","http://rubensteinarchitects.com/choices/jobs/","0","page","","0");
INSERT INTO `ts968ny_3_posts` VALUES("677","1","2013-02-21 18:42:52","2013-02-21 18:42:52","","Job Application","","publish","closed","closed","","apply","","","2013-02-21 18:42:52","2013-02-21 18:42:52","","676","http://rubensteinarchitects.com/choices/jobs/apply/","0","jobman_app_form","","0");
INSERT INTO `ts968ny_3_posts` VALUES("678","1","2013-02-21 18:42:52","2013-02-21 18:42:52","","Register","","publish","closed","closed","","register","","","2013-02-21 18:42:52","2013-02-21 18:42:52","","676","http://rubensteinarchitects.com/choices/blog/jobman_register/register/","0","jobman_register","","0");
INSERT INTO `ts968ny_3_posts` VALUES("680","1","2013-08-28 21:47:29","0000-00-00 00:00:00","","Auto Draft","","auto-draft","open","open","","","","","2013-08-28 21:47:29","0000-00-00 00:00:00","","0","http://rubensteinarchitects.com/choices/?p=680","0","post","","0");


DROP TABLE IF EXISTS `ts968ny_3_term_relationships`;

CREATE TABLE `ts968ny_3_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_term_relationships` VALUES("1","1","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("41","9","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("41","10","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("44","9","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("44","12","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("45","10","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("45","11","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("45","13","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("46","9","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("46","10","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("46","12","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("93","2","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("93","3","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("93","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("93","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("93","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("93","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("93","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("94","1","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("94","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("94","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("94","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("94","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("94","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("95","2","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("95","3","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("95","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("95","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("95","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("95","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("95","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("237","1","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("237","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("237","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("237","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("237","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("237","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("246","3","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("246","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("246","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("246","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("246","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("246","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("246","15","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("250","2","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("250","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("250","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("250","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("250","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("250","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","2","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","3","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("252","16","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("254","1","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("254","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("254","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("254","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("254","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("254","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("254","17","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("282","3","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("282","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("282","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("282","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("282","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("282","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("296","3","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("296","4","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("296","5","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("296","6","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("296","7","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("296","8","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("296","18","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("604","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("646","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("647","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("648","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("649","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("650","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("651","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("652","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("653","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("654","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("655","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("656","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("657","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("658","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("659","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("660","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("661","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("662","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("663","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("664","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("665","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("666","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("667","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("668","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("669","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("670","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("671","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("672","14","0");
INSERT INTO `ts968ny_3_term_relationships` VALUES("673","14","0");


DROP TABLE IF EXISTS `ts968ny_3_term_taxonomy`;

CREATE TABLE `ts968ny_3_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_term_taxonomy` VALUES("1","1","category","","0","4");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("2","2","category","","0","4");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("3","3","category","","0","6");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("4","4","post_tag","","0","10");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("5","5","post_tag","","0","10");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("6","6","post_tag","","0","10");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("7","7","post_tag","","0","10");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("8","8","post_tag","","0","10");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("9","9","portfolio_entries","","0","3");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("10","10","portfolio_entries","","0","3");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("11","11","portfolio_entries","","0","1");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("12","12","portfolio_entries","","0","2");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("13","13","portfolio_entries","","0","1");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("14","14","nav_menu","","0","29");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("15","15","post_format","","0","1");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("16","16","post_format","","0","1");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("17","17","post_format","","0","1");
INSERT INTO `ts968ny_3_term_taxonomy` VALUES("18","18","post_format","","0","1");


DROP TABLE IF EXISTS `ts968ny_3_terms`;

CREATE TABLE `ts968ny_3_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_terms` VALUES("1","Uncategorized","uncategorized","0");
INSERT INTO `ts968ny_3_terms` VALUES("2","Images","images","0");
INSERT INTO `ts968ny_3_terms` VALUES("3","News","news","0");
INSERT INTO `ts968ny_3_terms` VALUES("4","are","are","0");
INSERT INTO `ts968ny_3_terms` VALUES("5","nice","nice","0");
INSERT INTO `ts968ny_3_terms` VALUES("6","some","some","0");
INSERT INTO `ts968ny_3_terms` VALUES("7","tags","tags","0");
INSERT INTO `ts968ny_3_terms` VALUES("8","these","these","0");
INSERT INTO `ts968ny_3_terms` VALUES("9","CSS","css","0");
INSERT INTO `ts968ny_3_terms` VALUES("10","HTML","html","0");
INSERT INTO `ts968ny_3_terms` VALUES("11","Photography","photography","0");
INSERT INTO `ts968ny_3_terms` VALUES("12","PSD","psd","0");
INSERT INTO `ts968ny_3_terms` VALUES("13","VIDEO","video","0");
INSERT INTO `ts968ny_3_terms` VALUES("14","Main Menu","main-menu","0");
INSERT INTO `ts968ny_3_terms` VALUES("15","Video","post-format-video","0");
INSERT INTO `ts968ny_3_terms` VALUES("16","Gallery","post-format-gallery","0");
INSERT INTO `ts968ny_3_terms` VALUES("17","Quote","post-format-quote","0");
INSERT INTO `ts968ny_3_terms` VALUES("18","Link","post-format-link","0");


DROP TABLE IF EXISTS `ts968ny_3_wpeditor_settings`;

CREATE TABLE `ts968ny_3_wpeditor_settings` (
  `key` varchar(50) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("admin_page_roles","a:3:{s:8:\"settings\";s:14:\"manage_options\";s:12:\"theme-editor\";s:11:\"edit_themes\";s:13:\"plugin-editor\";s:12:\"edit_plugins\";}");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_plugin_active_line","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_plugin_line_numbers","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_plugin_line_wrapping","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_post_active_line","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_post_editor","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_post_line_numbers","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_post_line_wrapping","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_theme_active_line","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_theme_line_numbers","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("enable_theme_line_wrapping","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("hide_default_plugin_editor","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("hide_default_theme_editor","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("plugin_editor_allowed_extensions","php~js~css~txt~htm~html~jpg~jpeg~png~gif~sql~po~less");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("plugin_file_upload","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("replace_plugin_edit_links","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("theme_editor_allowed_extensions","php~js~css~txt~htm~html~jpg~jpeg~png~gif~sql~po~less");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("theme_file_upload","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("upgrade","1");
INSERT INTO `ts968ny_3_wpeditor_settings` VALUES("version","1.2.2");


DROP TABLE IF EXISTS `ts968ny_3_wysija_campaign`;

CREATE TABLE `ts968ny_3_wysija_campaign` (
  `campaign_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`campaign_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_wysija_campaign` VALUES("1","5 Minute User Guide","Default newsletter created automatically during installation.");


DROP TABLE IF EXISTS `ts968ny_3_wysija_campaign_list`;

CREATE TABLE `ts968ny_3_wysija_campaign_list` (
  `list_id` int(10) unsigned NOT NULL,
  `campaign_id` int(10) unsigned NOT NULL,
  `filter` text,
  PRIMARY KEY (`list_id`,`campaign_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_wysija_email`;

CREATE TABLE `ts968ny_3_wysija_email` (
  `email_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(250) NOT NULL DEFAULT '',
  `body` longtext,
  `created_at` int(10) unsigned DEFAULT NULL,
  `modified_at` int(10) unsigned DEFAULT NULL,
  `sent_at` int(10) unsigned DEFAULT NULL,
  `from_email` varchar(250) DEFAULT NULL,
  `from_name` varchar(250) DEFAULT NULL,
  `replyto_email` varchar(250) DEFAULT NULL,
  `replyto_name` varchar(250) DEFAULT NULL,
  `attachments` text,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `type` tinyint(4) NOT NULL DEFAULT '1',
  `number_sent` int(10) unsigned NOT NULL DEFAULT '0',
  `number_opened` int(10) unsigned NOT NULL DEFAULT '0',
  `number_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  `number_unsub` int(10) unsigned NOT NULL DEFAULT '0',
  `number_bounce` int(10) unsigned NOT NULL DEFAULT '0',
  `number_forward` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text,
  `wj_data` longtext,
  `wj_styles` longtext,
  PRIMARY KEY (`email_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_wysija_email` VALUES("1","1","5 Minute User Guide","<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\" /><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\"/><title>5 Minute User Guide</title><style type=\"text/css\">    .ReadMsgBody { width:100%; }.ExternalClass { width:100%; }.ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {line-height: 100%;}h1, h1 a { font-family:\"Trebuchet MS\"; font-size:40px; color:#000000 !important; font-weight:normal; margin:0; padding:0; font-style:normal; }h2, h2 a { font-family:\"Trebuchet MS\"; font-size:30px; color:#424242 !important; font-weight:normal; margin:0; padding:0; font-style:normal; }h3, h3 a { font-family:\"Trebuchet MS\"; font-size:24px; color:#424242 !important; font-weight:normal; margin:0; padding:0; font-style:normal; }.yshortcuts { color:#0000FF; }p { font-family:\"Arial\"; margin: 1em 0; word-wrap: break-word;}a { color:#0000FF; }a:link { color:#0000FF; }a:visited { color:#0000FF; }img {outline:none; text-decoration:none; -ms-interpolation-mode: bicubic;}a img {border:none;}#outlook a {padding:0;}body, #wysija_wrapper {    background:#e8e8e8;    color:#000000;    font-family:\"Arial\";    font-size:16px;    -webkit-text-size-adjust:100%;    -ms-text-size-adjust:100%;    }table { border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; }table td { border-collapse: collapse; }div, p, a, li, td { -webkit-text-size-adjust:none; }    </style></head><body bgcolor=\"#e8e8e8\" style=\"background:#e8e8e8;color:#000000; font-family:\'Arial\';font-size:16px;\" alink=\"#0000FF\" link=\"#0000FF\" text=\"#000000\"><span id=\"wysija_wrapper\" style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0; display:block;background:#e8e8e8;\"><table cellspacing=\"0\" id=\"wysija_container\" align=\"center\" style=\"background:none; border:none; border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-color:none; border-spacing:0; margin-bottom:0; margin-left:auto; margin-right:auto; margin-top:0; width:600px;\" width=\"600\" cellpadding=\"0\"><tr><td style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0;\">                    <table cellspacing=\"0\" id=\"wysija_viewbrowser\" align=\"center\" style=\"background:none; background-color:#e8e8e8; border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0; width: 600px;\" width=\"600\" cellpadding=\"0\"><tr valign=\"top\"><td id=\"wysija_viewbrowser_content\" style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0;\" width=\"600\"><p style=\"background-color:#e8e8e8;color:#000000;font-family:\'Arial\'; font-size:12px; height:auto; padding:8px; text-align:center;\">Display problems? <a style=\"font-family:\'Arial\';font-size:12px;color:#000000 !important;border:0;\" href=\"[view_in_browser_link]\" target=\"_blank\">View this newsletter in your browser.</a></p></td></tr></table>                    <table cellspacing=\"0\" id=\"wysija_header\" align=\"center\" style=\"background: none; background-color:#e8e8e8; border-collapse: collapse; border-spacing: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0; width:600px;\" width=\"600\" cellpadding=\"0\"><tr valign=\"top\"><td id=\"wysija_header_content\" style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0;\" width=\"600\"><div style=\"clear: both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\"><table style=\"border-collapse: collapse; border-spacing: 0; margin: auto;\" width=\"600\"><tr>                        <td style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\" width=\"600\"><div   style=\"height:72px; max-height:72px;overflow:hidden;border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">                    <img class=\"wysija-image-center\" src=\"http://rubensteinarchitects.com/choices/wp-content/plugins/wysija-newsletters/img/default-newsletter/newsletter/header.png\" height=\"72\" alt=\"\" width=\"600\" hspace=\"0\" vspace=\"0\" style=\"border:0;\">                </div></td>                    </tr></table></div></td></tr></table>                    <table cellspacing=\"0\" id=\"wysija_body\" align=\"center\" style=\"background: none; background-color:#ffffff; border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0; width: 600px;\" width=\"600\" cellpadding=\"0\"><tr valign=\"top\"><td id=\"wysija_body_content\" style=\"margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-bottom:0;padding-left:0;padding-right:0;padding-top:0;width:600px;\" width=\"600\">
<div style=\"background-color:#ffffff;clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr style=\"background-color:#ffffff;\">
            <td style=\"background-color:#ffffff;clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div style=\"width:564px;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding:0;\">
                
                <h2 style=\"font-family:\'Trebuchet MS\';font-size:30px;color:#424242 !important;border:0;font-weight:normal;line-height:1.2em;margin-top:0;margin-right:0;margin-bottom:10px;margin-left:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;word-wrap:break-word;\"><strong>Step 1:</strong> hey, click on this text!</h2><p style=\"font-family:\'Arial\';font-size:16px;color:#000000 !important;background-color:#ffffff;border:0;line-height:1.5em;margin-top:0;margin-right:0;margin-bottom:1em;margin-left:0;padding-top:3px;padding-right:0;padding-bottom:0;padding-left:0;vertical-align:top;word-wrap:break-word;\">To edit, simply click on this block of text.</p>
                </div>
            </td>
        </tr>
    </table>
</div>
<div style=\"clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr>
            <td style=\"clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div  style=\"border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">
                    <img src=\"http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/wysija/dividers/solid.jpg\" height=\"1\" width=\"564\" alt=\"\" style=\"border:0;\" />
                </div>
            </td>
        </tr>
    </table>
</div>

<div style=\"background-color:#ffffff;clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr style=\"background-color:#ffffff;\">
            <td style=\"background-color:#ffffff;clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div style=\"width:564px;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding:0;\">
                
                <h2 style=\"font-family:\'Trebuchet MS\';font-size:30px;color:#424242 !important;border:0;font-weight:normal;line-height:1.2em;margin-top:0;margin-right:0;margin-bottom:10px;margin-left:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;word-wrap:break-word;\"><strong>Step 2:</strong> play with this image</h2>
                </div>
            </td>
        </tr>
    </table>
</div>
<div style=\"background-color:#ffffff;clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr style=\"background-color:#ffffff;\">
            <td style=\"background-color:#ffffff;clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div style=\"width:564px;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding:0;\">
                
                    
                    
                    
                    
                        
                            
                            
                        
                        
                    
                    <div   style=\"width:294px;height:193px;max-height:193px;overflow:hidden;border:0;margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;float:left;\">
                        <table align=\"left\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" style=\"border:1px solid #ffffff;border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0;\">
                            <tr style=\"background-color:#ffffff;\">
                                <td style=\"background-color:#ffffff;mso-table-lspace:0;mso-table-rspace:0;clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:0;padding-bottom:0;padding-left:0;padding-right:0;\" height=\"193\" width=\"294\" valign=\"top\" align=\"left\">
                                    
                                    <img src=\"http://rubensteinarchitects.com/choices/wp-content/plugins/wysija-newsletters/img/default-newsletter/newsletter/pigeon.png\" height=\"190\" alt=\"\" width=\"281\" style=\"border:0;line-height:0.1em;margin:0;padding:0;\" />
                                    
                                </td>
                            </tr>
                        </table>
                    </div>
                
                <p style=\"font-family:\'Arial\';font-size:16px;color:#000000 !important;background-color:#ffffff;border:0;line-height:1.5em;margin-top:0;margin-right:0;margin-bottom:1em;margin-left:0;padding-top:3px;padding-right:0;padding-bottom:0;padding-left:0;vertical-align:top;word-wrap:break-word;\">Position your mouse over the image to the left.</p>
                </div>
            </td>
        </tr>
    </table>
</div>
<div style=\"clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr>
            <td style=\"clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div  style=\"border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">
                    <img src=\"http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/wysija/dividers/solid.jpg\" height=\"1\" width=\"564\" alt=\"\" style=\"border:0;\" />
                </div>
            </td>
        </tr>
    </table>
</div>

<div style=\"background-color:#ffffff;clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr style=\"background-color:#ffffff;\">
            <td style=\"background-color:#ffffff;clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div style=\"width:564px;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding:0;\">
                
                <h2 style=\"font-family:\'Trebuchet MS\';font-size:30px;color:#424242 !important;border:0;font-weight:normal;line-height:1.2em;margin-top:0;margin-right:0;margin-bottom:10px;margin-left:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;word-wrap:break-word;\"><strong>Step 3:</strong> drop content here</h2><p style=\"font-family:\'Arial\';font-size:16px;color:#000000 !important;background-color:#ffffff;border:0;line-height:1.5em;margin-top:0;margin-right:0;margin-bottom:1em;margin-left:0;padding-top:3px;padding-right:0;padding-bottom:0;padding-left:0;vertical-align:top;word-wrap:break-word;\">Drag and drop <strong>text, posts, dividers.</strong> Look on the right!</p><p style=\"font-family:\'Arial\';font-size:16px;color:#000000 !important;background-color:#ffffff;border:0;line-height:1.5em;margin-top:0;margin-right:0;margin-bottom:1em;margin-left:0;padding-top:3px;padding-right:0;padding-bottom:0;padding-left:0;vertical-align:top;word-wrap:break-word;\">You can even <strong>social bookmarks</strong> like these:</p>
                </div>
            </td>
        </tr>
    </table>
</div><div style=\"clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
<table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\"><tr><td style=\"clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
    <table align=\"center\" width=\"184\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse: collapse; border-spacing: 0;\">
        <tr valign=\"top\">
            
<td width=\"61\" height=\"32\">
    <div   style=\"height:32px; max-height:32px;overflow:hidden;border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">
        <a style=\"font-family:\'Arial\';font-size:16px;color:#0000FF !important;background-color:#ffffff;border:0;\" href=\"http://www.facebook.com/wysija\">
            <img src=\"http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/wysija/bookmarks/medium/02/facebook.png\" height=\"32\" alt=\"Facebook\" width=\"32\" style=\"border:0;line-height:0.1em;\" />
        </a>
    </div>
</td>
<td width=\"61\" height=\"32\">
    <div   style=\"height:32px; max-height:32px;overflow:hidden;border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">
        <a style=\"font-family:\'Arial\';font-size:16px;color:#0000FF !important;background-color:#ffffff;border:0;\" href=\"http://www.twitter.com/wysija\">
            <img src=\"http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/wysija/bookmarks/medium/02/twitter.png\" height=\"32\" alt=\"Twitter\" width=\"32\" style=\"border:0;line-height:0.1em;\" />
        </a>
    </div>
</td>
<td width=\"61\" height=\"32\">
    <div   style=\"height:32px; max-height:32px;overflow:hidden;border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">
        <a style=\"font-family:\'Arial\';font-size:16px;color:#0000FF !important;background-color:#ffffff;border:0;\" href=\"https://plus.google.com/104749849451537343615\">
            <img src=\"http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/wysija/bookmarks/medium/02/google.png\" height=\"32\" alt=\"Google\" width=\"32\" style=\"border:0;line-height:0.1em;\" />
        </a>
    </div>
</td>
        </tr>
    </table>
</td></tr></table></div>
<div style=\"clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr>
            <td style=\"clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div  style=\"border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">
                    <img src=\"http://rubensteinarchitects.com/choices/wp-content/uploads/sites/3/wysija/dividers/solid.jpg\" height=\"1\" width=\"564\" alt=\"\" style=\"border:0;\" />
                </div>
            </td>
        </tr>
    </table>
</div>

<div style=\"background-color:#ffffff;clear:both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\">
    <table style=\"border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin: auto;\" width=\"600\">
        <tr style=\"background-color:#ffffff;\">
            <td style=\"background-color:#ffffff;clear:both;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding-top:10px;padding-bottom:10px;padding-left:18px;padding-right:18px;\" width=\"600\">
                <div style=\"width:564px;margin-bottom:0;margin-left:0;margin-right:0;margin-top:0;padding:0;\">
                
                <h2 style=\"font-family:\'Trebuchet MS\';font-size:30px;color:#424242 !important;border:0;font-weight:normal;line-height:1.2em;margin-top:0;margin-right:0;margin-bottom:10px;margin-left:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;word-wrap:break-word;\"><strong>Step 4:</strong> and the footer?</h2><p style=\"font-family:\'Arial\';font-size:16px;color:#000000 !important;background-color:#ffffff;border:0;line-height:1.5em;margin-top:0;margin-right:0;margin-bottom:1em;margin-left:0;padding-top:3px;padding-right:0;padding-bottom:0;padding-left:0;vertical-align:top;word-wrap:break-word;\">Change the footer\'s content in Wysija\'s <strong>Settings</strong> page.</p>
                </div>
            </td>
        </tr>
    </table>
</div></td></tr></table>                    <table cellspacing=\"0\" id=\"wysija_footer\" align=\"center\" style=\"background: none; background-color:#e8e8e8; border-collapse: collapse; border-spacing: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0; width:600px;\" width=\"600\" cellpadding=\"0\"><tr valign=\"top\"><td id=\"wysija_header_content\" style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0;\" width=\"600\"><div style=\"clear: both; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\"><table style=\"border-collapse: collapse; border-spacing: 0; margin: auto;\" width=\"600\"><tr>                        <td style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding: 0;\" width=\"600\"><div   style=\"height:46px; max-height:46px;overflow:hidden;border:0;text-align:center;margin-top:0;margin-right:auto;margin-bottom:0;margin-left:auto;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0;\">                    <img class=\"wysija-image-center\" src=\"http://rubensteinarchitects.com/choices/wp-content/plugins/wysija-newsletters/img/default-newsletter/newsletter/footer.png\" height=\"46\" alt=\"\" width=\"600\" hspace=\"0\" vspace=\"0\" style=\"border:0;\">                </div></td>                    </tr></table></div></td></tr></table>                    <table cellspacing=\"0\" id=\"wysija_unsubscribe\" align=\"center\" style=\"background:none; background-color:#e8e8e8; border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; border-spacing: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0; width: 600px;\" width=\"600\" cellpadding=\"0\"><tr valign=\"top\"><td id=\"wysija_unsubscribe_content\" style=\"margin-bottom: 0; margin-left: 0; margin-right: 0; margin-top: 0; padding-bottom: 0; padding-left: 0; padding-right: 0; padding-top: 0;\" width=\"600\"><p style=\"background-color:#e8e8e8; color:#000000; font-family:Verdana; font-size:12px; height:auto; padding:8px; text-align:center;\"><a style=\"color:#000000 !important;border:0;\" href=\"[unsubscribe_link]\" target=\"_blank\">Unsubscribe</a><br /><br /></p></td></tr></table>                </td></tr></table></span></body></html>","1359427275","1359427275","","neil@rubensteinarchitects.com","neil","neil@rubensteinarchitects.com","neil","","0","1","0","0","0","0","0","0","YToxOntzOjE0OiJxdWlja3NlbGVjdGlvbiI7YToxOntzOjY6IndwLTMwMSI7YTo1OntzOjEwOiJpZGVudGlmaWVyIjtzOjY6IndwLTMwMSI7czo1OiJ3aWR0aCI7aToyODE7czo2OiJoZWlnaHQiO2k6MTkwO3M6MzoidXJsIjtzOjEyMjoiaHR0cDovL3J1YmVuc3RlaW5hcmNoaXRlY3RzLmNvbS9jaG9pY2VzL3dwLWNvbnRlbnQvcGx1Z2lucy93eXNpamEtbmV3c2xldHRlcnMvaW1nL2RlZmF1bHQtbmV3c2xldHRlci9uZXdzbGV0dGVyL3BpZ2Vvbi5wbmciO3M6OToidGh1bWJfdXJsIjtzOjEzMDoiaHR0cDovL3J1YmVuc3RlaW5hcmNoaXRlY3RzLmNvbS9jaG9pY2VzL3dwLWNvbnRlbnQvcGx1Z2lucy93eXNpamEtbmV3c2xldHRlcnMvaW1nL2RlZmF1bHQtbmV3c2xldHRlci9uZXdzbGV0dGVyL3BpZ2Vvbi0xNTB4MTUwLnBuZyI7fX19","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","YToxMDp7czo0OiJodG1sIjthOjE6e3M6MTA6ImJhY2tncm91bmQiO3M6NjoiZThlOGU4Ijt9czo2OiJoZWFkZXIiO2E6MTp7czoxMDoiYmFja2dyb3VuZCI7czo2OiJlOGU4ZTgiO31zOjQ6ImJvZHkiO2E6NDp7czo1OiJjb2xvciI7czo2OiIwMDAwMDAiO3M6NjoiZmFtaWx5IjtzOjU6IkFyaWFsIjtzOjQ6InNpemUiO2k6MTY7czoxMDoiYmFja2dyb3VuZCI7czo2OiJmZmZmZmYiO31zOjY6ImZvb3RlciI7YToxOntzOjEwOiJiYWNrZ3JvdW5kIjtzOjY6ImU4ZThlOCI7fXM6MjoiaDEiO2E6Mzp7czo1OiJjb2xvciI7czo2OiIwMDAwMDAiO3M6NjoiZmFtaWx5IjtzOjEyOiJUcmVidWNoZXQgTVMiO3M6NDoic2l6ZSI7aTo0MDt9czoyOiJoMiI7YTozOntzOjU6ImNvbG9yIjtzOjY6IjQyNDI0MiI7czo2OiJmYW1pbHkiO3M6MTI6IlRyZWJ1Y2hldCBNUyI7czo0OiJzaXplIjtpOjMwO31zOjI6ImgzIjthOjM6e3M6NToiY29sb3IiO3M6NjoiNDI0MjQyIjtzOjY6ImZhbWlseSI7czoxMjoiVHJlYnVjaGV0IE1TIjtzOjQ6InNpemUiO2k6MjQ7fXM6MToiYSI7YToyOntzOjU6ImNvbG9yIjtzOjY6IjAwMDBGRiI7czo5OiJ1bmRlcmxpbmUiO2I6MDt9czoxMToidW5zdWJzY3JpYmUiO2E6MTp7czo1OiJjb2xvciI7czo2OiIwMDAwMDAiO31zOjExOiJ2aWV3YnJvd3NlciI7YTozOntzOjU6ImNvbG9yIjtzOjY6IjAwMDAwMCI7czo2OiJmYW1pbHkiO3M6NToiQXJpYWwiO3M6NDoic2l6ZSI7aToxMjt9fQ==");
INSERT INTO `ts968ny_3_wysija_email` VALUES("2","0","Confirm your subscription to RA Choices","Hello!

Hurray! You\'ve subscribed to our site.
We need you to activate your subscription to the list(s): [lists_to_confirm] by clicking the link below: 

[activation_link]Click here to confirm your subscription.[/activation_link]

Thank you,

 The team!
","1359427276","1359427276","","neil@rubensteinarchitects.com","neil","neil@rubensteinarchitects.com","neil","","99","0","0","0","0","0","0","0","","","");


DROP TABLE IF EXISTS `ts968ny_3_wysija_email_user_stat`;

CREATE TABLE `ts968ny_3_wysija_email_user_stat` (
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned NOT NULL,
  `sent_at` int(10) unsigned NOT NULL,
  `opened_at` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_wysija_email_user_url`;

CREATE TABLE `ts968ny_3_wysija_email_user_url` (
  `email_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `url_id` int(10) unsigned NOT NULL,
  `clicked_at` int(10) unsigned DEFAULT NULL,
  `number_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`,`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_wysija_list`;

CREATE TABLE `ts968ny_3_wysija_list` (
  `list_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `namekey` varchar(255) DEFAULT NULL,
  `description` text,
  `unsub_mail_id` int(10) unsigned NOT NULL DEFAULT '0',
  `welcome_mail_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_enabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_public` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_at` int(10) unsigned DEFAULT NULL,
  `ordering` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`list_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_wysija_list` VALUES("1","My first list","my-first-list","The list created automatically on install of the Wysija.","0","0","1","1","1359427275","0");
INSERT INTO `ts968ny_3_wysija_list` VALUES("2","WordPress Users","users","The list created automatically on import of the plugin\'s subscribers : \"WordPress","0","0","0","0","1359427275","0");


DROP TABLE IF EXISTS `ts968ny_3_wysija_queue`;

CREATE TABLE `ts968ny_3_wysija_queue` (
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned NOT NULL,
  `send_at` int(10) unsigned NOT NULL DEFAULT '0',
  `priority` tinyint(4) NOT NULL DEFAULT '0',
  `number_try` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`,`email_id`),
  KEY `SENT_AT_INDEX` (`send_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_wysija_url`;

CREATE TABLE `ts968ny_3_wysija_url` (
  `url_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `url` text,
  PRIMARY KEY (`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_wysija_url_mail`;

CREATE TABLE `ts968ny_3_wysija_url_mail` (
  `email_id` int(11) NOT NULL AUTO_INCREMENT,
  `url_id` int(10) unsigned NOT NULL,
  `unique_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  `total_clicked` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`email_id`,`url_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_wysija_user`;

CREATE TABLE `ts968ny_3_wysija_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wpuser_id` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL,
  `firstname` varchar(255) NOT NULL DEFAULT '',
  `lastname` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(100) NOT NULL,
  `keyuser` varchar(255) NOT NULL DEFAULT '',
  `created_at` int(10) unsigned DEFAULT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `EMAIL_UNIQUE` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_wysija_user` VALUES("1","1","neil@rubensteinarchitects.com","","","","","1359427276","1");
INSERT INTO `ts968ny_3_wysija_user` VALUES("2","2","info@rubensteinarchitects.com","","","","","1359427276","1");


DROP TABLE IF EXISTS `ts968ny_3_wysija_user_field`;

CREATE TABLE `ts968ny_3_wysija_user_field` (
  `field_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) DEFAULT NULL,
  `column_name` varchar(250) NOT NULL DEFAULT '',
  `type` tinyint(3) unsigned DEFAULT '0',
  `values` text,
  `default` varchar(250) NOT NULL DEFAULT '',
  `is_required` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `error_message` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_3_wysija_user_field` VALUES("1","First name","firstname","0","","","0","Please enter first name");
INSERT INTO `ts968ny_3_wysija_user_field` VALUES("2","Last name","lastname","0","","","0","Please enter last name");


DROP TABLE IF EXISTS `ts968ny_3_wysija_user_history`;

CREATE TABLE `ts968ny_3_wysija_user_history` (
  `history_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `email_id` int(10) unsigned DEFAULT '0',
  `type` varchar(250) NOT NULL DEFAULT '',
  `details` text,
  `executed_at` int(10) unsigned DEFAULT NULL,
  `executed_by` int(10) unsigned DEFAULT NULL,
  `source` text,
  PRIMARY KEY (`history_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_3_wysija_user_list`;

CREATE TABLE `ts968ny_3_wysija_user_list` (
  `list_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `sub_date` int(10) unsigned DEFAULT '0',
  `unsub_date` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`list_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `ts968ny_3_wysija_user_list` VALUES("1","1","1359427275","0");
INSERT INTO `ts968ny_3_wysija_user_list` VALUES("2","1","1359427275","0");
INSERT INTO `ts968ny_3_wysija_user_list` VALUES("2","2","1359427275","0");


DROP TABLE IF EXISTS `ts968ny_5_ngg_album`;

CREATE TABLE `ts968ny_5_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `albumdesc` mediumtext,
  `sortorder` longtext NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_5_ngg_gallery`;

CREATE TABLE `ts968ny_5_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `path` mediumtext,
  `title` mediumtext,
  `galdesc` mediumtext,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `author` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_5_ngg_pictures`;

CREATE TABLE `ts968ny_5_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT '0',
  `galleryid` bigint(20) NOT NULL DEFAULT '0',
  `filename` varchar(255) NOT NULL,
  `description` mediumtext,
  `alttext` mediumtext,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT '0',
  `sortorder` bigint(20) NOT NULL DEFAULT '0',
  `meta_data` longtext,
  PRIMARY KEY (`pid`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `ts968ny_5_osaka_dc_menu`;

CREATE TABLE `ts968ny_5_osaka_dc_menu` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `meta` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_5_osaka_dc_menu` VALUES("3","Main menu","");


DROP TABLE IF EXISTS `ts968ny_5_osaka_dc_menu_items`;

CREATE TABLE `ts968ny_5_osaka_dc_menu_items` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL DEFAULT 'draft',
  `type` varchar(20) NOT NULL DEFAULT 'custom',
  `pos` int(11) NOT NULL DEFAULT '0',
  `parent` bigint(20) NOT NULL DEFAULT '0',
  `wpid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `label` text NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `target` varchar(20) NOT NULL DEFAULT '_self',
  `rel` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `meta` longtext NOT NULL,
  `content` longtext NOT NULL,
  `current` tinyint(4) NOT NULL DEFAULT '0',
  `current_child` tinyint(4) NOT NULL DEFAULT '0',
  `count` tinyint(4) NOT NULL DEFAULT '0',
  `childs` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8;

INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("114","3","publish","page","0","0","5","Home","http://rubensteinarchitects.com/sosaka/forums/reply/re-hello-world/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"270\";s:9:\"width-use\";b:1;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:0:\"\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("115","3","publish","page","3","114","84","Basic Image Slider (sidebar)","http://rubensteinarchitects.com/sosaka/homepage/homepage-basic-image-slider/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:0:\"\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("116","3","publish","page","2","114","85","Basic Image Slider","http://rubensteinarchitects.com/sosaka/homepage/homepage-basic-image-slider-2/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:0:\"\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("117","3","publish","page","4","114","103","Basic Image Slider (sidebar and full)","http://rubensteinarchitects.com/sosaka/homepage/homepage-basic-image-slider-sidebar-and-full/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:0:\"\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("118","3","publish","page","5","114","116","Board Slider (5 rows)","http://rubensteinarchitects.com/sosaka/homepage/homepage-board-slider-5-rows/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:0:\"\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("119","3","publish","page","7","114","186","Basic and Board mix","http://rubensteinarchitects.com/sosaka/homepage/homepage-basic-and-board-mix/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("120","3","publish","page","8","114","187","Single Video","http://rubensteinarchitects.com/sosaka/homepage/homepage-single-video/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("121","3","publish","page","6","114","191","Board Slider (single row)","http://rubensteinarchitects.com/sosaka/homepage/homepage-board-slider-single-row/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("122","3","publish","page","9","114","188","Big Slogan (Single Image)","http://rubensteinarchitects.com/sosaka/homepage/homepage-big-slogan/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("123","3","publish","page","10","114","193","Basic Image Slider (2 right sidebars)","http://rubensteinarchitects.com/sosaka/homepage/homepage-two-right-sidebars/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("124","3","publish","custom","1","114","0","Page Layout Examples","http://#","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:1;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"15\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("125","3","publish","custom","14","114","0","EMPTY SPACE","","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:1;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("126","3","publish","custom","16","114","0","NOTE","","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:1;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#999999\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","Plus of course there are much more possibilities of creating layouts in the theme - thanks to Content Builder and various elements you can build your completely unique page layout.","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("127","3","publish","page","11","114","261","Both Sidebars","http://rubensteinarchitects.com/sosaka/homepage/homepage-both-sidebars/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("128","3","publish","page","12","114","269","Single Image (full width)","http://rubensteinarchitects.com/sosaka/homepage/single-image-full-width/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("129","3","publish","custom","15","114","0","Additional Information","","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:1;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("130","3","publish","page","13","114","5","Homepage","http://rubensteinarchitects.com/sosaka/forums/reply/re-hello-world/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("131","3","publish","custom","0","114","0","NOTE","","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:1;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#999999\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:1;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","Some more examples of page layouts - these can work as your alternative homepage, but also as some other standard page on your site to present any type of content. ","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("132","3","publish","custom","1","0","0","Features","http://digitalcavalry.com/themeforest/live/wp/osaka/features/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:1;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:107:\"http://digitalcavalry.com/themeforest/live/wp/osaka/wp-content/uploads/2012/11/Banner_OsakaCMS_1-C77723.jpg\";s:16:\"image-margin-top\";s:2:\"10\";s:12:\"image-height\";s:2:\"85\";s:11:\"image-width\";s:3:\"260\";s:9:\"image-use\";b:1;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:1;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#FFFFFF\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:0:\"\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("133","3","publish","custom","0","132","0","Shortcodes and Typo","","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"180\";s:9:\"width-use\";b:1;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("134","3","publish","page","1","133","197","Basic Typography","http://rubensteinarchitects.com/sosaka/features/basic-typography/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("135","3","publish","page","2","133","198","Column Shortcodes","http://rubensteinarchitects.com/sosaka/features/column-shortcodes/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("136","3","publish","page","3","133","199","Basic Shortcodes","http://rubensteinarchitects.com/sosaka/features/basic-shortcodes/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("137","3","publish","page","5","133","201","Advanced Shortcodes","http://rubensteinarchitects.com/sosaka/features/advanced-shortcodes/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("138","3","publish","page","4","133","200","Medium Shortcodes","http://rubensteinarchitects.com/sosaka/features/medium-shortcodes/","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("139","3","publish","custom","0","133","0","Shortcodes and more","","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:1;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"168\";s:9:\"width-use\";b:0;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11:\"align-right\";b:0;s:16:\"padding-left-use\";b:0;s:15:\"padding-top-use\";b:0;s:17:\"padding-right-use\";b:0;s:18:\"padding-bottom-use\";b:0;s:8:\"f-family\";s:5:\"Arial\";s:12:\"f-family-use\";b:0;s:6:\"f-size\";s:2:\"11\";s:10:\"f-size-use\";b:1;s:13:\"f-line-height\";s:2:\"14\";s:17:\"f-line-height-use\";b:1;}s:4:\"link\";a:4:{s:4:\"page\";s:2:\"-1\";s:8:\"page-use\";b:0;s:3:\"url\";s:0:\"\";s:7:\"url-use\";b:0;}s:4:\"misc\";a:1:{s:7:\"empty_h\";s:1:\"8\";}}","","0","0","0","0");
INSERT INTO `ts968ny_5_osaka_dc_menu_items` VALUES("143","3","publish","custom","1","132","0","Selected Features","","_self","","","O:29:\"DCC_MenuItemStdMetaObjectData\":6:{s:4:\"core\";a:14:{s:4:\"hide\";b:0;s:18:\"hide-in-responsive\";b:0;s:11:\"hide-childs\";b:0;s:18:\"hide-sub-indicator\";b:0;s:7:\"as-mega\";b:0;s:5:\"as-nl\";b:0;s:7:\"as-head\";b:0;s:10:\"as-head-nl\";b:0;s:13:\"as-head-fancy\";b:0;s:8:\"as-empty\";b:0;s:9:\"as-custom\";b:0;s:7:\"as-text\";b:0;s:10:\"mega-fancy\";b:0;s:16:\"mega-align-right\";b:0;}s:7:\"subtext\";a:5:{s:7:\"display\";b:0;s:4:\"text\";s:0:\"\";s:5:\"color\";s:7:\"#5F69E3\";s:6:\"weight\";s:6:\"normal\";s:5:\"style\";s:6:\"normal\";}s:2:\"ul\";a:16:{s:5:\"image\";s:0:\"\";s:16:\"image-margin-top\";s:2:\"50\";s:12:\"image-height\";s:3:\"124\";s:11:\"image-width\";s:3:\"168\";s:9:\"image-use\";b:0;s:9:\"image-abs\";b:0;s:9:\"image-fit\";b:0;s:10:\"image-link\";s:0:\"\";s:14:\"image-link-use\";b:0;s:14:\"image-noborder\";b:0;s:15:\"image-nopadding\";b:0;s:6:\"height\";s:3:\"200\";s:10:\"height-use\";b:0;s:5:\"width\";s:3:\"190\";s:9:\"width-use\";b:1;s:11:\"align-right\";b:0;}s:6:\"custom\";a:20:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"200\";s:9:\"width-use\";b:0;s:10:\"height-use\";b:0;s:12:\"padding-left\";s:2:\"10\";s:11:\"padding-top\";s:2:\"10\";s:13:\"padding-right\";s:2:\"10\";s:14:\"padding-bottom\";s:2:\"10\";s:5:\"color\";s:7:\"#393939\";s:11: